/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class MetaViewImporter {
    private static Logger logger = Logger.getLogger(MetaViewImporter.class);
    private IMetaDataDefMgr m_oMetaDataDefMgr = null;
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = null;
    private MetaView m_oView = null;
    private User m_oCurrUser = null;
    private MetaDBTable m_oMainDBTable = null;

    public MetaViewImporter(User user, MetaView metaView) {
        this.m_oView = metaView;
        this.m_oCurrUser = user;
        this.m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        this.m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    }

    public MetaView importFromXML(String string) throws Exception {
        Document document = DocumentHelper.parseText((String)string);
        Element element = document.getRootElement();
        this.saveCurrView(element);
        MetaViewFields metaViewFields = new MetaViewFields(this.m_oCurrUser, element.nodeCount() / 3, 1);
        int n = element.nodeCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = element.nodeCount();
        while (n3 < n4) {
            Node node = element.node(n3);
            if (node != null && node instanceof Element) {
                try {
                    ++n2;
                    MetaViewField metaViewField = this.saveMetaViewField((Element)node, n);
                    if (metaViewField != null) {
                        metaViewFields.addElement(metaViewField);
                    }
                }
                catch (Throwable throwable) {
                    logger.error((Object)(I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label1", "\u4ea7\u751f\u7b2c[") + n2 + I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label2", "]\u4e2a\u89c6\u56fe\u5b57\u6bb5\u53d1\u751f\u5f02\u5e38\uff01")), throwable);
                    logger.error((Object)node.asXML());
                }
            }
            ++n3;
            --n;
        }
        String string2 = metaViewFields.getIdListAsString();
        String string3 = null;
        string3 = CMyString.isEmpty(string2) ? "delete from XWCMVIEWFIELDINFO where ViewId=" + this.m_oView.getId() : "delete from XWCMVIEWFIELDINFO where ViewId=" + this.m_oView.getId() + " and VIEWFIELDINFOID not in(" + string2 + ")";
        DBManager.getDBManager().sqlExecuteUpdate(string3);
        this.m_oDataDefCacheMgr.reloadViewCache(this.m_oView.getId());
        this.m_oMetaDataDefMgr.createViewRelations(this.m_oCurrUser, this.m_oView);
        return this.m_oView;
    }

    private void saveCurrView(Element element) throws WCMException {
        int n = 0;
        String string = element.attributeValue("id");
        if (!CMyString.isEmpty(string)) {
            n = Integer.parseInt(string);
        }
        String string2 = element.attributeValue("ename");
        String string3 = element.attributeValue("cname");
        this.makeMainTable(element, string2, string3);
        if (n <= 0) {
            this.saveMetaView(element, string3);
        } else {
            if (this.m_oView == null) {
                this.m_oView = MetaView.findById(n);
                if (this.m_oView == null) {
                    throw new WCMException(I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label3", "\u6307\u5b9a\u7684\u89c6\u56fe\u6ca1\u6709\u83b7\u53d6\u5230\uff01[Id=") + n + "]");
                }
            }
            this.saveMetaView(element, string3);
        }
    }

    private MetaViewField saveMetaViewField(Element element, int n) throws WCMException {
        Element element2;
        int n2;
        Object object;
        Object object2;
        int n3 = 0;
        String string = element.attributeValue("id");
        if (!CMyString.isEmpty(string)) {
            n3 = Integer.parseInt(string);
        }
        if (n3 == 0 && this.m_oView != null && (object2 = element.elements("DBField")).size() > 0 && (object = this.m_oMetaDataDefMgr.getMetaViewField(this.m_oView, n2 = Integer.parseInt((element2 = (Element)object2.get(0)).getTextTrim()))) != null) {
            n3 = ((BaseObj)object).getId();
        }
        object2 = null;
        if (n3 == 0) {
            object2 = MetaViewField.createNewInstance();
        } else {
            object2 = MetaViewField.findById(n3);
            if (object2 == null) {
                logger.error((Object)(I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label4", "\u6307\u5b9a\u7684\u89c6\u56fe\u5b57\u6bb5\u6ca1\u6709\u83b7\u53d6\u5230\uff01[Id=") + n3 + "]"));
                return null;
            }
            ((CMSObj)object2).validCanEditAndLock(this.m_oCurrUser);
        }
        n2 = element.nodeCount();
        for (int i = 0; i < n2; ++i) {
            object = element.node(i);
            if (object == null || !(object instanceof Element)) continue;
            ((BaseObj)object2).setPropertyWithString(object.getName(), object.getText());
        }
        ((MetaViewField)object2).setOrder(n);
        return this.m_oMetaDataDefMgr.save(this.m_oCurrUser, this.m_oView, (MetaViewField)object2);
    }

    private void saveMetaView(Element element, String string) throws WCMException {
        if (this.m_oView == null) {
            this.m_oView = MetaView.createNewInstance();
        } else {
            this.m_oView.validCanEditAndLock(this.m_oCurrUser);
        }
        this.m_oView.setDesc(string);
        this.m_oView.setMainTable(this.m_oMainDBTable);
        this.m_oView.setOtherTableIds(element.attributeValue("other-table-ids"));
        this.m_oView.setPropertyWithString("hiddenFileAppendix", element.attributeValue("hiddenFileAppendix"));
        this.m_oView.setPropertyWithString("hiddenImgAppendix", element.attributeValue("hiddenImgAppendix"));
        this.m_oView.setPropertyWithString("hiddenLinkAppendix", element.attributeValue("hiddenLinkAppendix"));
        this.m_oView = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, this.m_oView);
    }

    private void makeMainTable(Element element, String string, String string2) throws WCMException {
        int n = 0;
        String string3 = element.attributeValue("main-table-id");
        if (!CMyString.isEmpty(string3)) {
            n = Integer.parseInt(string3);
        }
        if (n == 0) {
            MetaDBTable metaDBTable = MetaDBTable.createNewInstance();
            metaDBTable.setName(string);
            metaDBTable.setAnotherName(string2);
            this.m_oMainDBTable = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaDBTable);
        } else {
            this.m_oMainDBTable = MetaDBTable.findById(n);
            if (this.m_oMainDBTable == null) {
                throw new WCMException(I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label5", "\u6307\u5b9a\u7684\u8868\u6ca1\u6709\u83b7\u53d6\u5230\uff01[Id=") + n + "]");
            }
        }
    }
}

