/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.cms.process.xml.FlowImporter;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfoUtil;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaDBFields;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.definition.xml.MetaDataDDLImporter;
import com.trs.components.metadata.definition.xml.MetaViewExporter;
import com.trs.components.metadata.service.ClassInfoToChannelHelper;
import com.trs.components.metadata.service.ClassInfoToGroupCreator;
import com.trs.components.metadata.service.MetaViewImporter;
import com.trs.components.metadata.service.SynChildrenExecutorForViewEmploy;
import com.trs.components.metadata.service.ViewRangeConstants;
import com.trs.components.metadata.service.WCMFilterMakerForContainsChildren;
import com.trs.components.metadata.service.util.WCMJSPChecker;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class MetaDataDefServiceProvider
implements ISelfDefinedServiceProvider {
    public static final int POSITION_BEFORE = 1;
    public static final int POSITION_AFTER = 0;
    private IMetaDataDefMgr m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    private static Logger m_oLogger = Logger.getLogger(MetaDataDefServiceProvider.class);

    public MetaDBTable saveDBTableInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("OwnerType", 1);
        int n2 = methodContext.getValue("OwnerId", 1);
        MetaDBTable metaDBTable = null;
        int n3 = methodContext.getObjectId();
        if (n3 == 0) {
            metaDBTable = MetaDBTable.createNewInstance();
            int n4 = methodContext.getValue("ChannelId", 0);
            if (n4 > 0) {
                n = 101;
                n2 = n4;
            }
            CMSObj cMSObj = this.findOwner(n, n2);
            this.validateRight(user, cMSObj);
            metaDBTable.setOwner(n, n2);
        } else {
            metaDBTable = this.findDBTableInfo(n3);
            this.validateRight(user, metaDBTable);
            metaDBTable.validCanEditAndLock(user);
        }
        String[] stringArray = new String[]{"ObjectId"};
        metaDBTable = (MetaDBTable)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, metaDBTable, stringArray);
        return this.m_oMetaDataDefMgr.save(user, metaDBTable);
    }

    public MetaDBField saveDBFieldInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaDBTable metaDBTable = null;
        MetaDBField metaDBField = null;
        int n = methodContext.getObjectId();
        if (n == 0) {
            metaDBTable = this.findDBTableInfo(methodContext.getValue("TableInfoId", 0));
            metaDBField = MetaDBField.createNewInstance();
        } else {
            metaDBField = MetaDBField.findById(n);
            if (metaDBField == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u6570\u636e\u5b57\u6bb5\uff01[Id=") + n + "]");
            }
            metaDBTable = this.findDBTableInfo(metaDBField.getTableId());
            metaDBField.validCanEditAndLock(user);
        }
        this.validateRight(user, metaDBTable);
        String[] stringArray = new String[]{"ObjectId"};
        metaDBField = (MetaDBField)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, metaDBField, stringArray);
        return this.m_oMetaDataDefMgr.save(user, metaDBTable, metaDBField);
    }

    public MetaDBTables queryDBTableInfos(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        int n = methodContext.getValue("viewId", 0);
        int n2 = methodContext.getValue("channelId", 0);
        MetaView metaView = null;
        if (n != 0) {
            metaView = MetaView.findById(n);
        } else if (n2 != 0) {
            metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(Channel.findById(n2));
        }
        if (metaView != null) {
            MetaDBTables metaDBTables = metaView.getOtherTables(user, null);
            metaDBTables.addElement(metaView.getMainTable());
            return metaDBTables;
        }
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        return MetaDBTables.openWCMObjs(user, wCMFilter);
    }

    public MetaDBFields queryDBFieldInfos(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaDBTable metaDBTable = this.findDBTableInfo(methodContext.getValue("TableInfoId", 0));
        return this.m_oMetaDataDefMgr.getDFieldInfos(user, metaDBTable, methodContext.getExtraWCMFilter());
    }

    public MetaViewFields queryViewFieldInfos(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ViewId", 0);
        int n2 = methodContext.getValue("ChannelId", 0);
        MetaView metaView = null;
        if (n > 0) {
            metaView = this.findViewById(n);
        } else if (n2 > 0 && (metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(this.findChannelById(n2))) == null) {
            return null;
        }
        methodContext.setValue("View", metaView);
        return this.m_oMetaDataDefMgr.getViewFields(user, metaView, methodContext.getExtraWCMFilter());
    }

    public MetaView getViewFromChannel(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("channelId", 0);
        MetaView metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(this.findChannelById(n));
        return metaView;
    }

    public MetaViews queryViews(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        return MetaViews.openWCMObjs(user, methodContext.getExtraWCMFilter());
    }

    public MetaViews queryViewsUsingClassInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        ClassInfo classInfo = null;
        int n = methodContext.getValue("ClassInfoId", 0);
        if (n != 0) {
            classInfo = ClassInfo.findById(n);
        }
        return this.m_oMetaDataDefMgr.getMetaViewsUsingClassInfo(user, classInfo);
    }

    public ClassInfos queryClassInfosUsingMetaView(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaView metaView = null;
        int n = methodContext.getValue("ViewId", 0);
        if (n != 0) {
            metaView = MetaView.findById(n);
        }
        return this.m_oMetaDataDefMgr.getClassInfosUsingMetaView(user, metaView);
    }

    public MetaViews queryViewsUsintTable(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label2", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u5143\u6570\u636e\u7ed3\u6784\uff01"));
        }
        MetaDBTable metaDBTable = this.findDBTableInfo(methodContext.getValue("TableInfoId", 0));
        return this.m_oMetaDataDefMgr.getViewsUsingTable(metaDBTable);
    }

    public boolean testCanDeleteDBTable(MetaDBTable metaDBTable) throws WCMException {
        String string = MetaDataConstants.makeTrueTableName(metaDBTable.getName());
        String string2 = "select count(MetaDataId) from " + string;
        int n = DBManager.getDBManager().sqlExecuteIntQuery(string2);
        return n <= 0;
    }

    public Reports deleteDBTableInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        MetaDBTables metaDBTables = MetaDBTables.findByIds(user, string);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label3", "\u5220\u9664\u5143\u6570\u636e\u7ed3\u6784"));
        int n = metaDBTables.size();
        for (int i = 0; i < n; ++i) {
            MetaDBTable metaDBTable = (MetaDBTable)metaDBTables.getAt(i);
            if (metaDBTable == null) continue;
            this.validateRight(user, metaDBTable);
            try {
                if (!this.testCanDeleteDBTable(metaDBTable)) {
                    String string2 = CMyString.format(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u4e0d\u80fd\u5220\u9664\u5143\u6570\u636e[{0}],\u56e0\u4e3a\u8be5\u7ed3\u6784\u4e0b\u6570\u636e\u4e0d\u4e3a\u7a7a"), new String[]{metaDBTable.getAnotherName()});
                    reports.addFailedReport(string2, new WCMException(string2));
                    continue;
                }
                this.m_oMetaDataDefMgr.delete(user, metaDBTable);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u5220\u9664\u5143\u6570\u636e\u7ed3\u6784[") + metaDBTable.getName() + "][" + metaDBTable.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u5220\u9664\u5143\u6570\u636e\u7ed3\u6784[") + metaDBTable.getName() + "][" + metaDBTable.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), exception);
            }
        }
        return reports;
    }

    public Reports deleteDBFieldInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label7", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5220\u9664\u5143\u6570\u636e\u5b57\u6bb5\uff01"));
        }
        String string = methodContext.getObjectIds();
        MetaDBFields metaDBFields = MetaDBFields.findByIds(user, string);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label8", "\u5220\u9664\u5143\u6570\u636e\u5b57\u6bb5"));
        int n = metaDBFields.size();
        for (int i = 0; i < n; ++i) {
            MetaDBField metaDBField = (MetaDBField)metaDBFields.getAt(i);
            if (metaDBField == null) continue;
            MetaDBTable metaDBTable = this.findDBTableInfo(metaDBField.getTableId());
            this.validateRight(user, metaDBTable);
            try {
                this.m_oMetaDataDefMgr.delete(user, metaDBField);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label9", "\u5220\u9664\u5143\u6570\u636e\u5b57\u6bb5[") + metaDBField.getName() + "][" + metaDBField.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label9", "\u5220\u9664\u5143\u6570\u636e\u5b57\u6bb5[") + metaDBField.getName() + "][" + metaDBField.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), exception);
            }
        }
        return reports;
    }

    public MetaDBField findDBFieldInfoById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        MetaDBField metaDBField = null;
        if (n == 0) {
            metaDBField = MetaDBField.createNewInstance();
        } else {
            metaDBField = MetaDBField.findById(n);
            if (metaDBField == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label10", "\u6307\u5b9a\u7684\u5143\u6570\u636e\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=") + n + "]");
            }
        }
        return metaDBField;
    }

    public MetaDBTable findDBTableInfoById(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        MetaDBTable metaDBTable = null;
        if (n == 0) {
            metaDBTable = MetaDBTable.createNewInstance();
        } else {
            metaDBTable = MetaDBTable.findById(n);
            if (metaDBTable == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label11", "\u6307\u5b9a\u7684\u5143\u6570\u636e\u7ed3\u6784\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=") + n + "]");
            }
        }
        return metaDBTable;
    }

    public MetaDBTables findDBTableInfosByIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label12", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u5143\u6570\u636e\u7ed3\u6784\u7ed3\u6784\uff01"));
        }
        return MetaDBTables.findByIds(user, methodContext.getObjectIds());
    }

    public MetaView saveView(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaView metaView = null;
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("ChannelId", 0);
        if (n == 0) {
            int n3 = methodContext.getValue("OwnerType", 1);
            int n4 = methodContext.getValue("OwnerId", 1);
            if (n2 > 0) {
                n3 = 101;
                n4 = n2;
            }
            CMSObj cMSObj = this.findOwner(n3, n4);
            this.validateRight(user, cMSObj);
            int n5 = methodContext.getValue("MainTableId", 0);
            String string = methodContext.getValue("ViewDesc");
            MetaDBTable metaDBTable = null;
            if (n5 == 0) {
                String string2 = methodContext.getValue("TableName");
                metaDBTable = MetaDBTable.createNewInstance();
                metaDBTable.setAnotherName(string);
                metaDBTable.setName(string2);
                metaDBTable.setOwner(n3, n4);
                metaDBTable = this.m_oMetaDataDefMgr.save(user, metaDBTable);
                n5 = metaDBTable.getId();
            } else {
                metaDBTable = this.findDBTableInfo(n5);
            }
            metaView = MetaView.createNewInstance();
            metaView.setMainTable(metaDBTable);
            metaView.setOtherTableIds(methodContext.getValue("OtherTableIds"));
            metaView.setDesc(string);
            metaView.setOwner(n3, n4);
            metaView.setTemplatePath(methodContext.getValue("TemplatePath"));
        } else {
            metaView = this.findViewById(n);
            if (methodContext.containsParameter("MainTableId")) {
                MetaDBTable metaDBTable = this.findDBTableInfo(methodContext.getValue("MainTableId", 0));
                metaView.setMainTable(metaDBTable);
            }
            if (methodContext.containsParameter("OtherTableIds")) {
                metaView.setOtherTableIds(methodContext.getValue("OtherTableIds"));
            }
            if (methodContext.containsParameter("ViewDesc")) {
                metaView.setDesc(methodContext.getValue("ViewDesc"));
            }
            if (methodContext.containsParameter("TemplatePath")) {
                metaView.setTemplatePath(methodContext.getValue("TemplatePath"));
            }
        }
        metaView = this.m_oMetaDataDefMgr.save(user, metaView);
        if (n2 > 0) {
            Channel channel = this.findChannelById(n2);
            this.m_oMetaViewEmployerMgr.setEmployer(user, channel, metaView);
            this.m_oMetaDataDefMgr.createViewRelations(user, metaView, true);
        }
        return metaView;
    }

    public MetaViewField saveViewField(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaViewField metaViewField = null;
        int n = methodContext.getObjectId();
        int n2 = 0;
        if (n == 0) {
            metaViewField = MetaViewField.createNewInstance();
            n2 = methodContext.getValue("ViewId", 0);
        } else {
            metaViewField = this.findViewFieldById(n);
            metaViewField.validCanEditAndLock(user);
            n2 = metaViewField.getViewId();
        }
        MetaView metaView = this.findViewById(n2);
        this.validateRight(user, metaView);
        String[] stringArray = new String[]{"ObjectId"};
        metaViewField = (MetaViewField)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, metaViewField, stringArray);
        MetaViewField metaViewField2 = this.m_oMetaDataDefMgr.save(user, metaView, metaViewField);
        this.m_oMetaDataDefMgr.createViewRelations(user, metaView, false);
        return metaViewField2;
    }

    private MetaViewField findViewFieldById(int n) throws WCMException {
        MetaViewField metaViewField = MetaViewField.findById(n);
        if (metaViewField == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89c6\u56fe\u5b57\u6bb5\uff01[Id=") + n + "]");
        }
        return metaViewField;
    }

    private MetaViewFieldGroup findViewFieldGroupById(int n) throws WCMException {
        MetaViewFieldGroup metaViewFieldGroup = MetaViewFieldGroup.findById(n);
        if (metaViewFieldGroup == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label100", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89c6\u56fe\u5b57\u6bb5\u5206\u7ec4\uff01[Id=") + n + "]");
        }
        return metaViewFieldGroup;
    }

    public boolean testCanDeleteView(MetaView metaView) throws WCMException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(metaView.getKey());
        String string = "select count(DocId) from WCMDocument where Dockind=?";
        int n = DBManager.getDBManager().sqlExecuteIntQuery(string, arrayList);
        return n <= 0;
    }

    public Reports deleteView(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        MetaViews metaViews = MetaViews.findByIds(user, string);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label14", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe"));
        int n = metaViews.size();
        for (int i = 0; i < n; ++i) {
            MetaView metaView = (MetaView)metaViews.getAt(i);
            if (metaView == null) continue;
            this.validateRight(user, metaView);
            try {
                if (!this.testCanDeleteView(metaView)) {
                    String string2 = CMyString.format(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u4e0d\u80fd\u5220\u9664\u89c6\u56fe[{0}],\u56e0\u4e3a\u8be5\u89c6\u56fe\u4e0b\u6570\u636e\u4e0d\u4e3a\u7a7a"), new String[]{metaView.getDesc()});
                    reports.addFailedReport(string2, new WCMException(string2));
                    continue;
                }
                this.m_oMetaDataDefMgr.delete(user, metaView);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label15", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe[") + metaView.getName() + "][" + metaView.getName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label15", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe[") + metaView.getName() + "][" + metaView.getName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), exception);
            }
        }
        return reports;
    }

    public Reports deleteViewField(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        MetaViewFields metaViewFields = MetaViewFields.findByIds(user, string);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label16", "\u5220\u9664\u89c6\u56fe\u5b57\u6bb5\u4fe1\u606f"));
        int n = metaViewFields.size();
        for (int i = 0; i < n; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            if (metaViewField == null) continue;
            this.validateRight(user, this.findViewById(metaViewField.getViewId()));
            try {
                this.m_oMetaDataDefMgr.delete(user, metaViewField);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label17", "\u5220\u9664\u89c6\u56fe\u5b57\u6bb5\u4fe1\u606f[") + metaViewField.getName() + "][" + metaViewField.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label17", "\u5220\u9664\u89c6\u56fe\u5b57\u6bb5\u4fe1\u606f[") + metaViewField.getName() + "][" + metaViewField.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), exception);
            }
        }
        return reports;
    }

    private MetaView findViewById(int n) throws WCMException {
        MetaView metaView = MetaView.findById(n);
        if (metaView == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label18", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + n + "]");
        }
        return metaView;
    }

    public MetaView importViewFromXML(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ViewId", 0);
        MetaView metaView = null;
        if (n > 0) {
            metaView = this.findViewById(n);
        }
        int n2 = methodContext.getValue("ChannelId", 0);
        Channel channel = null;
        if (n2 > 0) {
            channel = this.findChannelById(n2);
            this.validateRight(user, channel);
        } else if (n > 0) {
            this.validateRight(user, metaView);
        } else if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label19", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\uff01"));
        }
        String string = methodContext.getValue("DataXML");
        MetaViewImporter metaViewImporter = new MetaViewImporter(user, metaView);
        metaView = metaViewImporter.importFromXML(string);
        if (channel != null) {
            if (n == 0) {
                metaView.validCanDeleteAndLock(user);
                metaView.setOwner(channel.getWCMType(), channel.getId());
                metaView.save(user);
            }
            this.m_oMetaViewEmployerMgr.setEmployer(user, channel, metaView);
        }
        return metaView;
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label20", "\u6307\u5b9a\u7684\u680f\u76ee\u6ca1\u6709\u627e\u5230\uff01[Id=") + n + "]");
        }
        return channel;
    }

    public MetaView findViewById(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        MetaView metaView = null;
        if (n == 0) {
            metaView = MetaView.createNewInstance();
        } else {
            metaView = MetaView.findById(n);
            if (metaView == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label21", "\u6307\u5b9a\u7684\u89c6\u56fe\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=") + n + "]");
            }
        }
        return metaView;
    }

    public MetaViewField findViewFieldById(MethodContext methodContext) throws Throwable {
        MetaViewField metaViewField;
        int n = methodContext.getObjectId();
        if (n == 0) {
            metaViewField = MetaViewField.createNewInstance();
        } else {
            metaViewField = MetaViewField.findById(n);
            if (metaViewField == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89c6\u56fe\u5b57\u6bb5\uff01[Id=") + n + "]");
            }
        }
        return metaViewField;
    }

    public void setViewFields(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaView metaView = this.findViewById(methodContext.getValue("ViewId", 0));
        MetaDBFields metaDBFields = MetaDBFields.findByIds(user, methodContext.getValue("DBFieldIds"));
        this.validateRight(user, metaView);
        this.m_oMetaDataDefMgr.setViewFields(user, metaView, metaDBFields);
        this.m_oMetaDataDefMgr.createViewRelations(user, metaView);
        this.precompileViewApplication(methodContext, metaView);
    }

    public void setViewFieldsInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("propertyName");
        String string2 = methodContext.getValue("propertyValue");
        String string3 = methodContext.getValue("objectIds");
        MetaView metaView = null;
        MetaViewFields metaViewFields = MetaViewFields.findByIds(user, string3);
        int n = metaViewFields.size();
        for (int i = 0; i < n; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            if (metaViewField == null) continue;
            metaViewField.validCanEditAndLock(user);
            if (metaView == null) {
                int n2 = metaViewField.getViewId();
                metaView = this.findViewById(n2);
                this.validateRight(user, metaView);
            }
            metaViewField.setPropertyWithString(string, string2);
            metaViewField.save();
        }
        this.m_oMetaDataDefMgr.createViewRelations(user, metaView);
    }

    public void changeViewFieldOrder(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaViewField metaViewField = this.findViewFieldById(methodContext.getValue("FromId", 0));
        MetaViewField metaViewField2 = this.findViewFieldById(methodContext.getValue("ToId", 0));
        int n = methodContext.getValue("Position", 1);
        MetaView metaView = this.findViewById(metaViewField.getViewId());
        this.validateRight(user, metaView);
        if (metaViewField.getOrder() == metaViewField2.getOrder() + n) {
            return;
        }
        metaViewField.validCanDeleteAndLock(user);
        metaViewField.setOrder(metaViewField2.getOrder() + n);
        metaViewField.save(user);
    }

    public void changeViewFieldGroupOrder(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaViewFieldGroup metaViewFieldGroup = this.findViewFieldGroupById(methodContext.getValue("MetaViewFieldGroupId", 0));
        int n = methodContext.getValue("GroupOrder", 0);
        metaViewFieldGroup.setOrder(n);
        MetaView metaView = this.findViewById(metaViewFieldGroup.getMetaViewId());
        this.validateRight(user, metaView);
        metaViewFieldGroup.validCanEditAndLock(user);
        metaViewFieldGroup.save(user);
    }

    private void validateRight(User user, MetaView metaView) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        CMSObj cMSObj = this.findOwner(metaView.getOwnerType(), metaView.getOwnerId());
        this.validateRight(user, cMSObj);
    }

    private void validateRight(User user, CMSObj cMSObj) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        int n = -1;
        switch (cMSObj.getWCMType()) {
            case 101: {
                n = 13;
                break;
            }
            case 1: {
                n = -1;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label22", "\u672a\u77e5\u7684Owner Type\uff01[Type=") + cMSObj.getWCMType() + "]");
            }
        }
        if (n >= 0) {
            if (!AuthServer.hasRight(user, cMSObj, n)) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label23", "\u60a8\u65e0\u6743\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01"));
            }
        } else if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label24", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01"));
        }
    }

    private boolean hasRight(User user, CMSObj cMSObj) throws WCMException {
        if (user.isAdministrator()) {
            return true;
        }
        int n = -1;
        switch (cMSObj.getWCMType()) {
            case 101: {
                n = 13;
                break;
            }
            case 1: {
                n = -1;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label22", "\u672a\u77e5\u7684Owner Type\uff01[Type=") + cMSObj.getWCMType() + "]");
            }
        }
        return !(n >= 0 ? !AuthServer.hasRight(user, cMSObj, n) : !user.isAdministrator());
    }

    public void setViewEmployerByChannel(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        int n = methodContext.getValue("ViewId", 0);
        MetaView metaView = null;
        if (n > 0) {
            metaView = this.findViewById(n);
        }
        if (methodContext.getValue("ContainsChildren", false)) {
            SynChildrenExecutorForViewEmploy synChildrenExecutorForViewEmploy = new SynChildrenExecutorForViewEmploy(channel, metaView, n <= 0);
            synChildrenExecutorForViewEmploy.execute(user);
        } else {
            if (!AuthServer.hasRight(user, (CMSObj)channel, 13)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label25", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u680f\u76ee\u4f7f\u7528\u7684\u89c6\u56fe\uff01"));
            }
            if (n > 0) {
                this.m_oMetaViewEmployerMgr.setEmployer(user, channel, metaView);
            } else {
                this.m_oMetaViewEmployerMgr.clearEmployer(user, channel);
            }
        }
    }

    public MetaView findViewByChannel(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("channelId", 0);
        Channel channel = Channel.findById(n);
        if (channel == null) {
            return null;
        }
        MetaView metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel);
        return metaView;
    }

    public Reports createViewRelation(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ViewIds");
        WCMFilter wCMFilter = null;
        if (!CMyString.isEmpty(string)) {
            wCMFilter = new WCMFilter("", "ViewInfoId in(" + string + ")", "");
        }
        MetaViews metaViews = MetaViews.openWCMObjs(user, wCMFilter);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label26", "\u7ed9\u6307\u5b9a\u89c6\u56fe\u4ea7\u751f\u5e94\u7528\uff01"));
        int n = metaViews.size();
        for (int i = 0; i < n; ++i) {
            MetaView metaView = (MetaView)metaViews.getAt(i);
            if (metaView == null) continue;
            try {
                this.validateRight(user, metaView);
                this.m_oMetaDataDefMgr.createViewRelations(user, metaView);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label27", "\u7ed9\u89c6\u56fe[") + metaView.getDesc() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label28", "]\u751f\u6210\u5e94\u7528\u6210\u529f\uff01"));
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label27", "\u7ed9\u89c6\u56fe[") + metaView.getDesc() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label29", "]\u751f\u6210\u5e94\u7528\u5931\u8d25\uff01"), exception);
                continue;
            }
            try {
                this.precompileViewApplication(methodContext, metaView);
                continue;
            }
            catch (Exception exception) {
                m_oLogger.error((Object)(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label30", "\u7f16\u8bd1\u89c6\u56fe[") + metaView.getDesc() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label101", "]\u4ea7\u751f\u5e94\u7528\u5931\u8d25\uff01")), (Throwable)exception);
            }
        }
        return reports;
    }

    private void precompileViewApplication(MethodContext methodContext, MetaView metaView) throws Exception {
        if (methodContext.getServiceContext().getRequest() == null) {
            return;
        }
        String string = CMyString.setStrEndWith(ConfigServer.getServer().getInitProperty("WCM_PATH"), File.separatorChar);
        String string2 = methodContext.getServiceContext().getRequest().getServerName();
        int n = methodContext.getServiceContext().getRequest().getServerPort();
        String string3 = ConfigServer.getServer().getSysConfigValue("METADATA_PRECOMPILE_HOST", string2);
        String string4 = ConfigServer.getServer().getSysConfigValue("METADATA_PRECOMPILE_PORT", String.valueOf(n));
        String string5 = methodContext.getServiceContext().getRequest().getContextPath();
        if (string5.charAt(0) == '/') {
            string5 = string5.substring(1);
        }
        String string6 = ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME", "WCMV6") + "\\metadata\\application\\";
        string6 = string6.replace('\\', File.separatorChar);
        WCMJSPChecker wCMJSPChecker = new WCMJSPChecker(string, string6 + metaView.getId(), string3, Integer.parseInt(string4), string5);
        wCMJSPChecker.run();
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    private MetaDBTable findDBTableInfo(int n) throws WCMException {
        MetaDBTable metaDBTable = MetaDBTable.findById(n);
        if (metaDBTable == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label31", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8868\uff01[Id=") + n + "]");
        }
        return metaDBTable;
    }

    public void saveSynRule(MethodContext methodContext) throws Throwable {
        Object object;
        Object object2;
        int n;
        User user = this.getLoginUser();
        String string = methodContext.getValue("metaSynField");
        String[] stringArray = CMyString.split(string, "&");
        DBManager dBManager = DBManager.getDBManager();
        for (n = 0; n < stringArray.length; ++n) {
            if (CMyString.isEmpty(stringArray[n]) || (object2 = dBManager.getFieldInfo("WCMDOCUMENT", (String)(object = stringArray[n].split("=")[0]))) != null) continue;
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label51", "\u5b57\u6bb5\u540d ") + (String)object + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label52", "\u5728WCMDOCUMENT\u8868\u4e2d\u4e0d\u5b58\u5728"));
        }
        n = methodContext.getValue("synType", 0);
        if (n == 3) {
            object = this.findViewById(methodContext.getValue("viewId", 0));
            this.validateRight(user, (MetaView)object);
            if (string != null) {
                ((BaseObj)object).setPropertyWithString("MetaSynFields", string);
                ((CMSObj)object).save();
            }
        } else {
            int n2 = methodContext.getValue("channelId", 0);
            object2 = Channel.findById(n2);
            if (object2 == null) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label32", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[id\uff1a") + n2 + "]");
            }
            if (this.hasRight(user, (CMSObj)object2)) {
                this.saveSynRule((Channel)object2, string);
            }
            if (n == ViewRangeConstants.ONLY_SELF) {
                return;
            }
            MetaView metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer((Channel)object2);
            Channels channels = this.m_oMetaViewEmployerMgr.getEmployers(metaView, null);
            Channels channels2 = null;
            if (n == ViewRangeConstants.SAME_VIEW_CONTAIN_CHILDREN) {
                WCMFilterMakerForContainsChildren wCMFilterMakerForContainsChildren = new WCMFilterMakerForContainsChildren((BaseChannel)object2);
                wCMFilterMakerForContainsChildren.execute(user);
                channels2 = wCMFilterMakerForContainsChildren.getCurrChannels();
            }
            for (int i = channels.size() - 1; i >= 0; --i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null || channels2 != null && channels2.getById(channel.getId()) == null || !this.hasRight(user, channel)) continue;
                this.saveSynRule(channel, string);
            }
        }
    }

    private void saveSynRule(Channel channel, String string) throws WCMException {
        if (channel == null) {
            return;
        }
        if (string != null) {
            channel.setMetaSynFields(string);
        }
        channel.save();
    }

    public String findSynRule(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = "";
        String string2 = methodContext.getValue("synRuleSetFrom");
        if (string2.equalsIgnoreCase("channel")) {
            int n = methodContext.getValue("channelId", 0);
            Channel channel = Channel.findById(n);
            if (channel == null) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label32", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[id\uff1a") + n + "]");
            }
            this.validateRight(user, channel);
            string = channel.getMetaSynFields();
        } else if (string2.equalsIgnoreCase("metaView")) {
            MetaView metaView = this.findViewById(methodContext.getValue("viewId", 0));
            this.validateRight(user, metaView);
            string = metaView.getPropertyAsString("MetaSynFields", "docTitle=&docContent=");
        }
        HashMap hashMap = new HashMap();
        hashMap = new AttributesString(string).getAttributesMap();
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    private CMSObj findOwner(int n, int n2) throws WCMException {
        switch (n) {
            case 1: {
                return new WCMSystemObject(n2);
            }
        }
        CMSObj cMSObj = (CMSObj)BaseObj.findById(n, n2);
        if (cMSObj == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label33", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u5bf9\u8c61\uff01[Type=") + n + ", Id=" + n2 + "]");
        }
        return cMSObj;
    }

    private void validateRight(User user, MetaDBTable metaDBTable) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        CMSObj cMSObj = this.findOwner(metaDBTable.getOwnerType(), metaDBTable.getOwnerId());
        this.validateRight(user, cMSObj);
    }

    public void recreateAllOfDBTableInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        MetaDBTables metaDBTables = MetaDBTables.findByIds(user, string);
        this.m_oMetaDataDefMgr.recreateAll(user, metaDBTables);
    }

    public String buildAllFromTextFile(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label34", "\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c\u653f\u5e9c\u4fe1\u606f\u516c\u5f00\u670d\u52a1\u7cfb\u7edf\u7684\u521b\u5efa\uff01"));
        }
        SystemBuilder systemBuilder = new SystemBuilder(user, methodContext);
        systemBuilder.m_bCreateMainSite = methodContext.getValue("CreateMainSite", true);
        systemBuilder.start();
        return null;
    }

    private ClassInfo findRootClassInfoByName(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ParentId=0 and CName=?", "");
        wCMFilter.addSearchValues(string);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        if (classInfos.isEmpty()) {
            return null;
        }
        ClassInfo classInfo = (ClassInfo)classInfos.getAt(0);
        return classInfo;
    }

    public String exportViews(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label53", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u7cfb\u7edf\u7684\u7ed3\u6784\uff01"));
        }
        String string = methodContext.getValue("ViewIds");
        MetaViews metaViews = null;
        metaViews = CMyString.isEmpty(string) ? MetaViews.openWCMObjs(user, null) : MetaViews.findByIds(user, string);
        MetaViewExporter metaViewExporter = new MetaViewExporter();
        return metaViewExporter.export(metaViews);
    }

    public Reports importViewsFromXML(MethodContext methodContext) throws WCMException {
        String string = methodContext.getValue("importFile");
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label44", "\u4ece\u6587\u4ef6[") + string + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label45", "]\u5bfc\u5165\u89c6\u56fe!"));
        String string2 = CMyFile.extractFileExt(string);
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label46", "\u53c2\u6570[ImportFile=") + string + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label47", "]\u4e0d\u6b63\u786e\uff01\u6ca1\u6709\u540e\u7f00\u540d"), null);
            return reports;
        }
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label48", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5bfc\u5165\u89c6\u56fe\uff01"), null);
            return reports;
        }
        int n = methodContext.getValue("importType", 0);
        try {
            MetaDataDDLImporter metaDataDDLImporter = new MetaDataDDLImporter(user);
            metaDataDDLImporter.importFromXML(string, n, reports);
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label49", "\u5bfc\u5165\u89c6\u56fe\u5931\u8d25!"), exception);
        }
        return reports;
    }

    public MetaViews queryViewsRelatingToCurrView(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("MetaViewId", 0);
        if (n == 0) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label60", "\u5fc5\u987b\u7684\u53c2\u6570MetaViewId\u672a\u4f20\u5165\uff01"));
        }
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        String string = "VIEWINFOID in (select distinct VIEWID from XWCMVIEWFIELDINFO where FIELDTYPE=? AND RELATIONVIEWID=?)";
        wCMFilter.setWhere(string);
        wCMFilter.addSearchValues(14);
        wCMFilter.addSearchValues(n);
        wCMFilter = wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        MetaViews metaViews = MetaViews.openWCMObjs(null, wCMFilter);
        return metaViews;
    }

    public Channels getChannelsUseingMetaView(MethodContext methodContext) throws WCMException {
        int n = methodContext.getObjectId();
        MetaView metaView = this.findViewById(n);
        if (metaView == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label18", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + n + "]");
        }
        return this.m_oMetaViewEmployerMgr.getEmployers(metaView, null);
    }

    public void setChannelEmployersOfMetaView(MethodContext methodContext) throws Throwable {
        Channel channel;
        int n;
        User user = this.getLoginUser();
        int n2 = methodContext.getValue("ViewId", 0);
        MetaView metaView = null;
        if (n2 <= 0) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label18", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + n2 + "]");
        }
        metaView = this.findViewById(n2);
        Channels channels = this.m_oMetaViewEmployerMgr.getEmployers(metaView, null);
        int[] nArray = CMyString.splitToInt(methodContext.getObjectIds(), ",");
        for (n = channels.size() - 1; n >= 0; --n) {
            channel = (Channel)channels.getAt(n);
            if (channel == null) continue;
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (channel.getId() != nArray[i]) continue;
                nArray[i] = 0;
                bl = true;
                break;
            }
            if (bl) continue;
            if (!AuthServer.hasRight(user, (CMSObj)channel, 13)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label25", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u680f\u76ee\u4f7f\u7528\u7684\u89c6\u56fe\uff01"));
            }
            this.m_oMetaViewEmployerMgr.clearEmployer(user, channel);
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0 || Channel.findById(nArray[n]) == null) continue;
            channel = Channel.findById(nArray[n]);
            if (!AuthServer.hasRight(user, (CMSObj)channel, 13)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label25", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u680f\u76ee\u4f7f\u7528\u7684\u89c6\u56fe\uff01"));
            }
            this.m_oMetaViewEmployerMgr.setEmployer(user, channel, metaView);
        }
    }

    private class SystemBuilder
    extends Thread {
        private MethodContext methodContext = null;
        private User loginUser = null;
        private HttpSession m_oSession = null;
        private String m_sRootDomain = null;
        private boolean m_bCreateMainSite = true;

        public SystemBuilder(User user, MethodContext methodContext) {
            this.methodContext = methodContext;
            this.loginUser = user;
            HttpServletRequest httpServletRequest = methodContext.getServiceContext().getRequest();
            this.m_oSession = httpServletRequest.getSession();
            this.m_sRootDomain = this.makeRootDomain(httpServletRequest);
        }

        private String makeRootDomain(HttpServletRequest httpServletRequest) {
            if (httpServletRequest == null) {
                return "http://not.set/";
            }
            String string = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName();
            int n = httpServletRequest.getServerPort();
            if (n != -1) {
                string = string + ":" + n;
            }
            string = string + "/pub/";
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block12: {
                block11: {
                    try {
                        try {
                            ClassInfo classInfo;
                            String string;
                            ContextHelper.initContext(this.loginUser);
                            String string2 = this.m_bCreateMainSite ? I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label35", "\u673a\u6784\u5206\u7c7b") : I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label36", "\u4e0b\u7ea7\u5355\u4f4d\u673a\u6784\u5206\u7c7b");
                            String string3 = this.m_bCreateMainSite ? I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label37", "\u4e3b\u9898\u5206\u7c7b") : I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label38", "\u4e0b\u7ea7\u5355\u4f4d\u4e3b\u9898\u5206\u7c7b");
                            String string4 = string = this.m_bCreateMainSite ? I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label39", "\u4f53\u88c1\u5206\u7c7b") : I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label40", "\u4e0b\u7ea7\u5355\u4f4d\u4f53\u88c1\u5206\u7c7b");
                            if (this.m_bCreateMainSite) {
                                this.createFlows("workflow.xml");
                                this.createFlows("workflow2.xml");
                            }
                            MetaView metaView = MetaDataDefServiceProvider.this.findViewById(this.methodContext.getValue("viewId", 0));
                            boolean bl = this.methodContext.getValue("ContainCode", false);
                            String string5 = this.methodContext.getValue("FileName");
                            ClassInfo classInfo2 = this.importClassInfo(string5, string2, bl);
                            if (classInfo2 == null) {
                                Object var15_9 = null;
                                break block11;
                            }
                            this.setClassInfoOfViewField(metaView, "organcat", classInfo2);
                            ClassInfo classInfo3 = this.importClassInfo(this.methodContext.getValue("SubCatFileName"), string3, this.methodContext.getValue("SubCatContainCode", false));
                            if (classInfo3 != null) {
                                this.setClassInfoOfViewField(metaView, "subcat", classInfo3);
                            }
                            if ((classInfo = this.importClassInfo(this.methodContext.getValue("ThemeCatFileName"), string, this.methodContext.getValue("ThemeCatContainCode", false))) != null) {
                                this.setClassInfoOfViewField(metaView, "themecat", classInfo);
                            }
                            int n = this.methodContext.getValue("level", 1);
                            StringBuffer stringBuffer = new StringBuffer();
                            if (this.methodContext.getValue("AutoCreateGroup", false)) {
                                IDepartmentMgr iDepartmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
                                ClassInfoToGroupCreator classInfoToGroupCreator = new ClassInfoToGroupCreator();
                                classInfoToGroupCreator.createGroups(classInfo2, iDepartmentMgr.getRootDepartmentGroup(), 0);
                                stringBuffer.append(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label41", "\u65b0\u4ea7\u751f\u7684\u7528\u6237\u4fe1\u606f:<BR><BR>"));
                                stringBuffer.append(CMyString.transDisplay(classInfoToGroupCreator.getNewUserInfos()));
                            }
                            if (this.methodContext.getValue("AutoCreateChannel", false)) {
                                ClassInfoToChannelHelper.createSites(classInfo2, metaView, n, this.m_sRootDomain);
                            }
                            this.m_oSession.setAttribute("UserInfo", (Object)stringBuffer.toString());
                            break block12;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            this.m_oSession.setAttribute("ErrorInfo", (Object)exception.getMessage());
                            Object var15_11 = null;
                            ContextHelper.clear();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_12 = null;
                        ContextHelper.clear();
                        throw throwable;
                    }
                }
                ContextHelper.clear();
                return;
            }
            Object var15_10 = null;
            ContextHelper.clear();
        }

        private void setClassInfoOfViewField(MetaView metaView, String string, ClassInfo classInfo) throws WCMException {
            IMetaDataDefCacheMgr iMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
            MetaViewField metaViewField = iMetaDataDefCacheMgr.getMetaViewField(metaView.getId(), string);
            metaViewField.setClassId(classInfo.getId());
            metaViewField.setType(10);
            IMetaDataDefMgr iMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
            iMetaDataDefMgr.save(this.loginUser, metaView, metaViewField);
        }

        private ClassInfo importClassInfo(String string, String string2, boolean bl) throws Exception {
            if (CMyString.isEmpty(string)) {
                return null;
            }
            ClassInfoUtil classInfoUtil = new ClassInfoUtil();
            boolean bl2 = classInfoUtil.importClassInfos(string2, string, bl, 1);
            if (!bl2) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label42", "\u521b\u5efa\u5206\u7c7b\u6cd5\u5931\u8d25\uff01"));
            }
            ClassInfo classInfo = MetaDataDefServiceProvider.this.findRootClassInfoByName(string2);
            return classInfo;
        }

        private void createFlows(String string) throws WCMException {
            Object object;
            String string2 = ConfigServer.getServer().getInitProperty("WCM_PATH");
            string2 = CMyString.setStrEndWith(string2, File.separatorChar);
            String string3 = string2 + ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME_4GOVINFO", "WCMV6") + File.separatorChar + "gkml" + File.separatorChar + "data" + File.separator;
            String string4 = string3 + string;
            try {
                object = string4;
                string4 = string3 + "workflow_temp.xml";
                if (!CMyFile.fileExists((String)object)) {
                    return;
                }
                CMyFile.copyFile((String)object, string4);
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label43", "\u62f7\u8d1d\u6587\u4ef6\u5931\u8d25"), exception);
            }
            object = MetaDataDefServiceProvider.this.findOwner(1, 4);
            FlowImporter flowImporter = new FlowImporter(this.loginUser, 1);
            flowImporter.setImportWithInfoviewId(false);
            flowImporter.setOwner((CMSObj)object);
            flowImporter.importFromFile(string4, null);
        }
    }
}

