/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyMemory;
import com.trs.infra.util.CMyString;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GovInfoToXML {
    private static int[] m_aYearSpan = new int[]{2003, 2008};
    private static String m_sClassInfoIds = "366";
    private static String m_sClassInfosTagName = "ClassInfos";
    private static String m_sClassInfoTagName = "ClassInfo";
    private static String m_sMetaDatasTagName = "MetaDatas";
    private static String m_sMetaDataTagName = "MetaData";
    private static String m_sPropertiesTagName = "Properties";
    private static int m_nMetaViewId = 39;
    private static int m_nProcessIndex = 1;
    private static WCMFilter m_oFilterOfYear = null;
    private static MetaView m_oMetaView = null;
    private static IClassInfoMgr m_oClassInfoMgr = null;
    private static boolean m_bDebug = true;
    private static String[] m_aFieldName = new String[]{"fileNum", "idxID", "acesmthd", "svobjcat", "Publisher", "PubDate", "Description", "Relation", "subcat"};

    public static void setYearSpan(String string) {
        if (CMyString.isEmpty(string)) {
            return;
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        m_aYearSpan = new int[]{nArray[0], nArray.length > 1 ? nArray[1] : nArray[0]};
    }

    public static void setClassInfoIds(String string) {
        m_sClassInfoIds = string;
    }

    public static void setMetaViewId(int n) {
        m_nMetaViewId = n;
    }

    public void setDebug(boolean bl) {
        m_bDebug = bl;
    }

    public static Element toXML() throws Exception {
        m_oMetaView = MetaView.findById(m_nMetaViewId);
        m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        Element element = DocumentHelper.createElement((String)m_sClassInfosTagName);
        for (int i = m_aYearSpan[0]; i <= m_aYearSpan[1]; ++i) {
            GovInfoToXML.appendClassInfoOfYear(i, element);
        }
        if (m_bDebug) {
            System.out.println(CMyMemory.toMemoryInfo());
        }
        FileWriter fileWriter = new FileWriter("e:/GovInfo.xml");
        element.write((Writer)fileWriter);
        fileWriter.close();
        return element;
    }

    private static void appendClassInfoOfYear(int n, Element element) throws Exception {
        GovInfoToXML.storeWCMFilter(n);
        Element element2 = element.addElement(m_sClassInfoTagName);
        Element element3 = element2.addElement(m_sPropertiesTagName);
        element3.addElement("CName").addCDATA(GovInfoToXML.int2StrOfYear(n) + "\u5e74");
        ClassInfos classInfos = ClassInfos.findByIds(null, m_sClassInfoIds);
        GovInfoToXML.appendClassInfos(element2, classInfos);
    }

    private static void storeWCMFilter(int n) throws Exception {
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.setOrder("PubDate asc");
        wCMFilter.setWhere("PubDate >= ? and PubDate < ?");
        CMyDateTime cMyDateTime = new CMyDateTime();
        cMyDateTime.setDateTimeWithString(n + "-1-1 00:00:00");
        wCMFilter.addSearchValues(cMyDateTime);
        CMyDateTime cMyDateTime2 = new CMyDateTime();
        cMyDateTime2.setDateTimeWithString(n + 1 + "-1-1 00:00:00");
        wCMFilter.addSearchValues(cMyDateTime2);
        m_oFilterOfYear = wCMFilter;
    }

    private static void appendClassInfo(Element element, ClassInfo classInfo) throws Exception {
        if (classInfo == null) {
            return;
        }
        Element element2 = element.addElement(m_sClassInfoTagName);
        GovInfoToXML.appendProperties(element2, classInfo);
        GovInfoToXML.appendMetaDatas(element2, classInfo);
        ClassInfos classInfos = m_oClassInfoMgr.queryChildren(null, classInfo, null);
        GovInfoToXML.appendClassInfos(element2, classInfos);
    }

    private static void appendProperties(Element element, ClassInfo classInfo) {
        if (classInfo == null) {
            return;
        }
        Element element2 = element.addElement(m_sPropertiesTagName);
        element2.addElement("CName").addCDATA(classInfo.getName());
    }

    private static void appendMetaDatas(Element element, ClassInfo classInfo) throws Exception {
        if (classInfo == null) {
            return;
        }
        MetaViewDatas metaViewDatas = new MetaViewDatas(m_oMetaView);
        metaViewDatas.open(GovInfoToXML.getMetaDatasFilter(classInfo));
        if (metaViewDatas == null || metaViewDatas.size() <= 0) {
            return;
        }
        Element element2 = element.addElement(m_sMetaDatasTagName);
        int n = metaViewDatas.size();
        for (int i = 0; i < n; ++i) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(i);
            if (metaViewData == null) continue;
            GovInfoToXML.appendMetaData(element2, metaViewData, classInfo);
        }
    }

    public static WCMFilter getMetaDatasFilter(ClassInfo classInfo) {
        if (classInfo == null) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter("", "", "PubDate asc");
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("exists(select XWCMClassInfoView.MetaDataId");
        stringBuffer.append(" from XWCMClassInfoView");
        stringBuffer.append(" where XWCMClassInfoView.ClassInfoId = ?");
        wCMFilter.addSearchValues(classInfo.getId());
        stringBuffer.append(" and XWCMClassInfoView.MetaDataId=WCMMetaTableGovInfo.MetaDataId)");
        wCMFilter.setWhere(stringBuffer.toString());
        wCMFilter.mergeWith(m_oFilterOfYear);
        return wCMFilter;
    }

    private static void appendMetaData(Element element, MetaViewData metaViewData, ClassInfo classInfo) throws Exception {
        String string;
        if (metaViewData == null) {
            return;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < m_aFieldName.length; ++i) {
            string = metaViewData.getRealProperty(m_aFieldName[i]);
            if (string == null || string.trim().equalsIgnoreCase("null")) {
                string = "";
            }
            hashtable.put(m_aFieldName[i].toUpperCase(), string);
        }
        hashtable.put("CCODE", CMyString.showNull(classInfo.getCode(), ""));
        CMyDateTime cMyDateTime = metaViewData.getPropertyAsDateTime("efectdate");
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            hashtable.put("efectdate".toUpperCase(), (String)hashtable.get("PubDate".toUpperCase()));
        }
        string = element.addElement(m_sMetaDataTagName).addElement(m_sPropertiesTagName);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            string.addElement(string2).addCDATA(string3);
        }
        if (m_bDebug) {
            System.out.println("\u5df2\u751f\u6210\u7b2c" + m_nProcessIndex++ + "\u6761\u8bb0\u5f55");
        }
    }

    private static void appendClassInfos(Element element, ClassInfos classInfos) throws Exception {
        if (classInfos == null || classInfos.size() <= 0) {
            return;
        }
        Element element2 = element.addElement(m_sClassInfosTagName);
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            GovInfoToXML.appendClassInfo(element2, classInfo);
        }
    }

    private static String int2StrOfYear(int n) {
        String[] stringArray = new String[]{"\u25cb", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        StringBuffer stringBuffer = new StringBuffer(4);
        String string = String.valueOf(n);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(stringArray[Integer.parseInt(string.substring(i, i + 1))]);
        }
        return stringBuffer.toString();
    }
}

