/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.center.xml.MetaViewDataExporter;
import com.trs.components.metadata.center.xml.MetaViewDataImporter;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDataDefHelper;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.service.ViewRangeConstants;
import com.trs.components.metadata.service.WCMFilterMakerForContainsChildren;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.util.SynChildrenExecutorBase;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GovInfoServiceProvider
implements ISelfDefinedServiceProvider {
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private IMetaDataDefMgr m_oMetaDataDefMgr = null;
    private Logger logger = Logger.getLogger(GovInfoServiceProvider.class);
    private AppendixMgr m_oAppendixMgr = null;
    private IClassInfoMgr m_oClassInfoMgr = null;

    public GovInfoServiceProvider() {
        this.m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        this.m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
    }

    public MetaViewData saveMetaViewData(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = null;
        channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        if (!AuthServer.hasRight(user, (CMSObj)channel, 31)) {
            throw new WCMException(1002, "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[" + channel.getName() + "][ID=" + channel.getId() + "]\u4e0b\u65b0\u5efa\u8bb0\u5f55\uff01");
        }
        MetaView metaView = null;
        MetaViewData metaViewData = null;
        int n = methodContext.getObjectId();
        if (n == 0) {
            metaView = this.findViewById(methodContext.getValue("ViewId", 0));
            metaViewData = new MetaViewData(metaView);
        } else {
            metaViewData = MetaViewData.findById(n);
            if (metaViewData == null) {
                throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5728\u6307\u5b9a\u89c6\u56fe\u4e0b\u63d0\u4ea4\u7684\u6570\u636e\uff01[Id=" + n + "]");
            }
            metaView = metaViewData.getMetaView();
            metaViewData.validCanEditAndLock(user);
        }
        GovInfoServiceProvider.setViewDataProperties(methodContext, metaViewData);
        switch (metaView.getId()) {
            case 40: {
                this.synIndexIdOnSaveDeptCode(metaViewData);
                break;
            }
            case 39: {
                this.synIndexIdOnSaveGovInfo(metaViewData);
                break;
            }
        }
        metaViewData.save(user);
        return metaViewData;
    }

    private void synIndexIdOnSaveDeptCode(MetaViewData metaViewData) throws WCMException {
        String string = metaViewData.getPropertyAsString("DName");
        String string2 = metaViewData.getPropertyAsString("DCode");
        String[] stringArray = new String[]{"00000000", null};
        if (!metaViewData.isAddMode()) {
            boolean bl = false;
            if (metaViewData.isChangeProperty("DName")) {
                string = metaViewData.getNewPropertyAsString("DName");
                bl = true;
            }
            if (metaViewData.isChangeProperty("DCode")) {
                stringArray[1] = string2;
                string2 = metaViewData.getNewPropertyAsString("DCode");
                bl = true;
            }
            if (!bl) {
                return;
            }
        }
        String[] stringArray2 = new String[]{"update WCMMetaTableGovInfo set idxId=replace(idxId, ?, ?) where Publisher=?"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            Object[] objectArray = new String[]{stringArray[i], string2, string};
            DBManager.getDBManager().sqlExecuteUpdate(stringArray2, objectArray);
        }
    }

    public MetaViewData saveMetaViewDataOfGov(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MetaView metaView = this.findViewById(methodContext.getValue("ViewId", 0));
        MetaViewData metaViewData = new MetaViewData(metaView);
        GovInfoServiceProvider.setViewDataProperties(methodContext, metaViewData);
        int n = this.makeChannelId(methodContext);
        metaViewData.setProperty("ChannelId", n);
        IMetaDataDefCacheMgr iMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        HashMap hashMap = iMetaDataDefCacheMgr.getMetaViewFields(metaView.getId());
        Set set = hashMap.keySet();
        for (String string : set) {
            String string2;
            MetaViewField metaViewField = (MetaViewField)hashMap.get(string);
            if (metaViewField.getType() != 10 || (string2 = metaViewData.getPropertyAsString(string)) == null || (string2 = string2.trim()).length() == 0) continue;
            String string3 = this.convertToClassIds(metaViewField.getClassId(), string2);
            metaViewData.setProperty(string, string3);
        }
        this.synIndexIdOnSaveGovInfo(metaViewData);
        metaViewData.setProperty("Content", CMyString.transDisplay(methodContext.getValue("Content")));
        metaViewData.save(user);
        return metaViewData;
    }

    private void synIndexIdOnSaveGovInfo(MetaViewData metaViewData) throws WCMException {
        String string = metaViewData.getPropertyAsString("Publisher");
        String string2 = metaViewData.getPropertyAsString("PubDate");
        if (!metaViewData.isAddMode()) {
            boolean bl = false;
            if (metaViewData.isChangeProperty("Publisher")) {
                string = metaViewData.getNewPropertyAsString("Publisher");
                bl = true;
            }
            if (metaViewData.isChangeProperty("PubDate")) {
                string2 = metaViewData.getNewPropertyAsString("PubDate");
                bl = true;
            }
            if (!bl) {
                return;
            }
        }
        if (!(string != null && (string = string.trim()).length() != 0 || string2 != null && (string2 = string2.trim()).length() != 0)) {
            return;
        }
        String string3 = GovInfoServiceProvider.queryDeptCode(string);
        metaViewData.setNextId();
        String string4 = "00000" + metaViewData.getId();
        String string5 = string3 + "/" + string2.substring(0, 4) + "-" + string4.substring(string4.length() - 5);
        this.logger.debug((Object)("Index Id:" + string5));
        metaViewData.setProperty("IdxID", string5);
    }

    private int makeChannelId(MethodContext methodContext) throws WCMException {
        int n;
        Channel channel;
        String string = methodContext.getValue("themecat");
        if (string == null || (string = string.trim()).length() == 0) {
            return 2386;
        }
        int n2 = string.indexOf(";");
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if ((channel = Channel.findByName(n = methodContext.getValue("SiteId", 0), string)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u680f\u76ee[Name=" + string + "]\u5728\u7ad9\u70b9[Id=" + n + "]\u4e0b\u4e0d\u5b58\u5728\uff01");
        }
        int n3 = channel.getId();
        return n3;
    }

    public Reports importMetaViewDatas(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = null;
        MetaView metaView = null;
        channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        if (!AuthServer.hasRight(user, (CMSObj)channel, 31)) {
            throw new WCMException(1002, "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[" + channel.getName() + "][ID=" + channel.getId() + "]\u4e0b\u65b0\u5efa\u6587\u6863\uff01");
        }
        metaView = this.findViewById(methodContext.getValue("ViewId", 0));
        String string = null;
        string = methodContext.getValue("XMLSource", 3) == 3 ? MetaDataDefHelper.getViewApplicationPath(metaView.getId()) + "data.xsl" : methodContext.getValue("XSLFile");
        MetaViewDataImporter metaViewDataImporter = new MetaViewDataImporter(user, metaView, channel);
        return metaViewDataImporter.importFromFile(1, methodContext.getValue("ImportFile"), string);
    }

    public MetaViewDatas queryViewDatas(MethodContext methodContext) throws Throwable {
        Object object;
        int n;
        User user = this.getLoginUser();
        Channel channel = null;
        MetaView metaView = null;
        int n2 = methodContext.getValue("ViewId", 0);
        if (n2 > 0) {
            metaView = this.findViewById(n2);
        } else {
            channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
            metaView = this.findViewByChannel(channel);
        }
        Channels channels = new Channels(null, 1, 1);
        if (channel != null) {
            n = methodContext.getValue("_queryType_", 0);
            if (n == ViewRangeConstants.SAME_VIEW_CONTAIN_CHILDREN) {
                object = new WCMFilterMakerForContainsChildren(channel);
                ((SynChildrenExecutorBase)object).execute(user);
                channels = ((WCMFilterMakerForContainsChildren)object).getCurrChannels();
            } else if (n == ViewRangeConstants.SAME_VIEW_CONTAIN_ALL) {
                channels = this.m_oMetaViewEmployerMgr.getEmployers(metaView, null);
            } else {
                channels.addElement(channel);
            }
        } else {
            channels = this.m_oMetaViewEmployerMgr.getEmployers(metaView, null);
        }
        for (n = channels.size() - 1; n >= 0; --n) {
            object = (Channel)channels.getAt(n);
            if (object == null || AuthServer.hasRight(user, (CMSObj)object, 30)) continue;
            channels.remove((BaseObj)object, false);
        }
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        object = this.getQueryFilter(methodContext, user, metaView);
        metaViewDatas.setSelectFields(methodContext.getValue("ChnlDocSelectFields"), ((WCMFilter)object).getSelect());
        ((WCMFilter)object).setSelect(null);
        String string = methodContext.getValue("_sqlWhere_");
        if (!CMyString.isEmpty(string)) {
            if (((WCMFilter)object).getWhere().length() > 0) {
                boolean bl = methodContext.getValue("IsOr", true);
                ((WCMFilter)object).setWhere(((WCMFilter)object).getWhere() + (bl ? " or " : " and ") + "(" + string + ")");
            } else {
                ((WCMFilter)object).setWhere("(" + string + ")");
            }
        }
        this.logger.debug(object);
        metaViewDatas.setPageSize(methodContext.getPageSize());
        metaViewDatas.setCurrPage(methodContext.getPageIndex());
        metaViewDatas.open(channels, (WCMFilter)object);
        return metaViewDatas;
    }

    private WCMFilter getQueryFilter(MethodContext methodContext, User user, MetaView metaView) throws WCMException, CMyException {
        if (methodContext.getValue("AdvSearch", 0) == 1) {
            WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
            return wCMFilter;
        }
        MetaViewFields metaViewFields = this.m_oMetaDataDefMgr.getViewFields(user, metaView, new WCMFilter("", "InOutline=1 or SearchField=1", ""));
        boolean bl = metaView.isMultiTable();
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer((metaViewFields.size() + 1) * 10);
        StringBuffer stringBuffer2 = new StringBuffer(metaViewFields.size() * 10);
        stringBuffer.append("MetaDataId");
        String string = metaView.getTrueTableName();
        int n = metaViewFields.size();
        for (int i = 0; i < n; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            if (metaViewField == null) continue;
            if (metaViewField.isInOutline()) {
                stringBuffer.append(",");
                if (bl || metaViewField.getDBName().equalsIgnoreCase(metaViewField.getName())) {
                    stringBuffer.append(metaViewField.getName());
                } else {
                    stringBuffer.append(metaViewField.getDBName() + " " + metaViewField.getName());
                }
            }
            if (!metaViewField.isSearchField()) continue;
            boolean bl2 = false;
            String string2 = string + "." + (bl ? metaViewField.getName() : metaViewField.getDBName());
            String string3 = methodContext.getValue(metaViewField.getName());
            if (!methodContext.getValue("_isAdvanceSearch_", false)) {
                string3 = this.getIdsFromDescs(metaViewField, string3);
            }
            if (metaViewField.getType() == 9 || metaViewField.getType() == 10) {
                bl2 = true;
            }
            this.makeFilter(wCMFilter, stringBuffer2, string2, metaViewField.getDBType(), string3, methodContext.getValue("IsOr", true), methodContext, bl2);
        }
        wCMFilter.setSelect(stringBuffer.toString());
        if (stringBuffer2.length() > 0) {
            wCMFilter.setWhere(stringBuffer2.toString());
        }
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        return wCMFilter;
    }

    private String getIdsFromDescs(MetaViewField metaViewField, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        String[] stringArray = null;
        boolean bl = false;
        if (string.indexOf(124) >= 0) {
            stringArray = string.split("\\|");
            bl = true;
        } else {
            stringArray = string.split("\\s");
            bl = false;
        }
        switch (MetaDataConstants.formatOfEnumValue(metaViewField.getType())) {
            case -1: {
                int n;
                StringBuffer stringBuffer = new StringBuffer(100);
                HashMap hashMap = metaViewField.getEnmValueMap(false);
                for (n = 0; n < stringArray.length; ++n) {
                    String string2 = (String)hashMap.get(stringArray[n]);
                    if (string2 == null) continue;
                    stringBuffer.append(string2);
                    stringBuffer.append(bl ? "|" : " ");
                }
                if (stringBuffer.length() > 0 && ((n = (int)stringBuffer.charAt(stringBuffer.length() - 1)) == 124 || n == 32)) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                string = stringBuffer.toString();
                break;
            }
            case 10: {
                WCMFilter wCMFilter = new WCMFilter();
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("(");
                stringBuffer.append("ClassInfoId=" + metaViewField.getClassId());
                stringBuffer.append(" or RootId=" + metaViewField.getClassId());
                stringBuffer.append(")");
                if (stringArray.length > 0) {
                    stringBuffer.append(" and (");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(" (CName like ?) ");
                    wCMFilter.addSearchValues(stringArray[i].trim());
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append("or");
                }
                stringBuffer.append(")");
                wCMFilter.setWhere(stringBuffer.toString());
                ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
                string = classInfos.getIdListAsString(bl ? (char)'|' : ' ');
                break;
            }
        }
        return string;
    }

    private void makeFilter(WCMFilter wCMFilter, StringBuffer stringBuffer, String string, int n, String string2, boolean bl, MethodContext methodContext, boolean bl2) throws CMyException {
        if (CMyString.isEmpty(string2) && n != 93) {
            return;
        }
        if (n != 93) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(bl ? " or " : " and ");
            }
            String[] stringArray = null;
            boolean bl3 = false;
            if (string2.indexOf(124) >= 0) {
                stringArray = string2.split("\\|");
                bl3 = true;
            } else {
                stringArray = string2.split("\\s");
                bl3 = false;
            }
            stringBuffer.append("(");
            if (bl2) {
                string = DBManager.getDBManager().getDBType().sqlConcatStr("','", string, "','");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (bl2) {
                    stringArray[i] = "," + stringArray[i] + ",";
                }
                this.makeFilterOfItem(wCMFilter, stringBuffer, string, n, stringArray[i], methodContext, bl);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(bl3 ? " or " : " and ");
            }
            stringBuffer.append(")");
        } else {
            this.makeFilterOfItem(wCMFilter, stringBuffer, string, n, string2, methodContext, bl);
        }
    }

    private void makeFilterOfItem(WCMFilter wCMFilter, StringBuffer stringBuffer, String string, int n, String string2, MethodContext methodContext, boolean bl) throws CMyException {
        if (CMyString.isEmpty(string2) && n != 93) {
            return;
        }
        switch (n) {
            case 12: {
                stringBuffer.append(string);
                if (string2.startsWith("-")) {
                    stringBuffer.append(" not");
                    string2 = string2.substring(1);
                }
                stringBuffer.append(" like ?");
                wCMFilter.addSearchValues("%" + string2 + "%");
                break;
            }
            case 4: {
                stringBuffer.append(string);
                if (string2.startsWith("-")) {
                    stringBuffer.append(" !");
                }
                stringBuffer.append("=?");
                wCMFilter.addSearchValues(Integer.parseInt(string2));
                break;
            }
            case 93: {
                boolean bl2;
                String string3;
                String string4;
                String string5 = string.substring(string.indexOf(".") + 1);
                String string6 = methodContext.getValue("_dateStartSuffix_");
                boolean bl3 = false;
                if (string6 != null && !CMyString.isEmpty(string4 = methodContext.getValue(string5 + string6))) {
                    bl3 = true;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(bl ? " or " : " and ");
                    }
                    stringBuffer.append("(");
                    this.setFilterOfDate(wCMFilter, stringBuffer, string, string4, ">=?", bl);
                }
                if ((string4 = methodContext.getValue("_dateEndSuffix_")) != null && !CMyString.isEmpty(string3 = methodContext.getValue(string5 + string4))) {
                    if (bl3) {
                        stringBuffer.append(" and ");
                    } else if (stringBuffer.length() > 0) {
                        stringBuffer.append(bl ? " or " : " and ");
                    }
                    this.setFilterOfDate(wCMFilter, stringBuffer, string, string3, "<=?", bl);
                }
                if (bl3) {
                    stringBuffer.append(")");
                }
                if ((bl2 = methodContext.getValue("_isAdvanceSearch_", false)) || CMyString.isEmpty(string2)) break;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(bl ? " or " : " and ");
                }
                this.setFilterOfDate(wCMFilter, stringBuffer, string, string2, "=?", bl);
                break;
            }
        }
    }

    private void setFilterOfDate(WCMFilter wCMFilter, StringBuffer stringBuffer, String string, String string2, String string3, boolean bl) throws CMyException {
        if (!CMyString.isEmpty(string2)) {
            stringBuffer.append(string);
            stringBuffer.append(string3);
            CMyDateTime cMyDateTime = new CMyDateTime();
            cMyDateTime.setDateTimeWithString(string2);
            wCMFilter.addSearchValues(cMyDateTime);
        }
    }

    public MetaViewData findViewDataById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("ViewId", 0);
        int n3 = methodContext.getValue("ChannelId", 0);
        MetaViewData metaViewData = null;
        if (n == 0) {
            MetaView metaView = null;
            if (n2 > 0) {
                metaView = this.findViewById(n2);
            } else {
                Channel channel = null;
                channel = this.findChannelById(n3);
                metaView = this.findViewByChannel(channel);
            }
            metaViewData = new MetaViewData(metaView);
        } else {
            metaViewData = MetaViewData.findById(n);
            if (metaViewData == null) {
                throw new WCMException(200006, "\u6307\u5b9a\u7684\u6307\u5b9a\u89c6\u56fe\u6570\u636e\u7684\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=" + n + "]");
            }
            if (n2 > 0) {
                if (!user.isAdministrator()) {
                    throw new WCMException(1002, "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u67e5\u770b\u89c6\u56fe\u4e0b\u7684\u6570\u636e\uff01");
                }
            } else {
                Channel channel = null;
                channel = this.findChannelById(n3);
                this.validateRight(user, metaViewData, channel, 34, "\u67e5\u770b");
            }
        }
        return metaViewData;
    }

    private void validateRight(User user, MetaViewData metaViewData, Channel channel, int n, String string) throws WCMException {
        if (user.getName().equalsIgnoreCase(metaViewData.getCrUserName())) {
            return;
        }
        if (!AuthServer.hasRight(user, (CMSObj)channel, 34)) {
            throw new WCMException(1002, "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[" + channel.getName() + "][ID=" + channel.getId() + "]\u4e0b" + string + "\u6570\u636e\uff01");
        }
    }

    public Reports deleteViewDatas(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        Reports reports = new Reports("\u5220\u9664\u89c6\u56fe\u6570\u636e");
        int[] nArray = CMyString.splitToInt(string, ",");
        for (int i = 0; i < nArray.length; ++i) {
            MetaViewData metaViewData = MetaViewData.findById(nArray[i]);
            if (metaViewData == null) continue;
            try {
                this.validateRight(user, metaViewData, 33);
                metaViewData.delete(user);
                reports.addSucessedReport("\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=" + nArray[i] + "]\u6210\u529f\uff01");
                continue;
            }
            catch (Exception exception) {
                reports.addFailedReport("\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=" + nArray[i] + "]\u5931\u8d25\uff01", exception);
            }
        }
        return reports;
    }

    public Reports copy(MethodContext methodContext) throws Throwable {
        Channel channel;
        int n;
        Reports reports = new Reports("\u590d\u5236\u6587\u6863");
        User user = this.getLoginUser();
        Channels channels = Channels.findByIds(user, methodContext.getValue("ToChannelIds"));
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        if (!user.isAdministrator()) {
            for (n = chnlDocs.size(); n >= 0; --n) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(n);
                if (chnlDoc == null || AuthServer.hasRight(user, (CMSObj)(channel = chnlDoc.getChannel()), 34)) continue;
                reports.addFailedReport("\u590d\u5236\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u67e5\u770b\u680f\u76ee[ID=" + channel.getId() + ",Name=" + channel.getDispDesc() + "]\u4e0b\u7684\u6587\u6863", null);
                chnlDocs.remove(n);
            }
        }
        int n2 = channels.size();
        for (n = 0; n < n2; ++n) {
            channel = (Channel)channels.getAt(n);
            if (channel == null) continue;
            if (!AuthServer.hasRight(user, (CMSObj)channel, 31)) {
                reports.addFailedReport("\u590d\u5236\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[ID=" + channel.getId() + ",Name=" + channel.getDispDesc() + "]\u4e0b\u521b\u5efa\u6587\u6863", null);
                continue;
            }
            MetaView metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel);
            int n3 = chnlDocs.size();
            for (int i = 0; i < n3; ++i) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                int n4 = chnlDoc.getPropertyAsInt("docKind", 0);
                if (chnlDoc == null || n4 == 0) continue;
                if (metaView.getId() != n4) {
                    reports.addFailedReport("\u590d\u5236\u5931\u8d25:\u680f\u76ee[ID=" + channel.getId() + ",Name=" + channel.getDispDesc() + "]\u4f7f\u7528\u7684\u89c6\u56fe\uff3bID=" + metaView.getId() + ",Name=" + metaView.getDesc() + "]\u548c\u5f53\u524d\u680f\u76ee\u89c6\u56fe[ID=" + n4 + "]\u4e0d\u4e00\u81f4", null);
                    continue;
                }
                this.copy(chnlDoc, channel, reports, user);
            }
        }
        return reports;
    }

    private void copy(ChnlDoc chnlDoc, Channel channel, Reports reports, User user) throws Throwable {
        if (chnlDoc == null) {
            return;
        }
        MetaViewData metaViewData = MetaViewData.findById(chnlDoc.getDocId());
        MetaViewData metaViewData2 = (MetaViewData)metaViewData.cloneToNewObj();
        metaViewData2.setMetaView(metaViewData.getMetaView());
        metaViewData2.setProperty("channelId", channel.getId());
        metaViewData2.save(user);
        if (metaViewData.getId() != metaViewData2.getId()) {
            this.m_oAppendixMgr.copyAppendixes(Document.findById(metaViewData.getId()), Document.findById(metaViewData2.getId()));
        }
        reports.addSucessedReport("\u6210\u529f\u590d\u5236\u8bb0\u5f55[" + metaViewData.getTitle() + "]\u5230\u680f\u76ee[" + channel.getDispDesc() + "]\uff01");
    }

    private void validateRight(User user, MetaViewData metaViewData, int n) throws WCMException {
        Channel channel;
        if (user.isAdministrator() || user.getName().equalsIgnoreCase(metaViewData.getCrUserName())) {
            return;
        }
        int n2 = metaViewData.getChannelId();
        if (n2 <= 0) {
            n2 = metaViewData.getPropertyAsInt("ChannelId", 0);
        }
        if (!AuthServer.hasRight(user, (CMSObj)(channel = this.findChannelById(n2)), n)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=" + metaViewData.getId() + "]\uff01");
        }
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=" + n + "]\uff01");
        }
        return channel;
    }

    private MetaView findViewById(int n) throws WCMException {
        MetaView metaView = MetaView.findById(n);
        if (metaView == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=" + n + "]");
        }
        return metaView;
    }

    private MetaView findViewByChannel(Channel channel) throws WCMException {
        MetaView metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel);
        if (metaView == null) {
            throw new WCMException("\u6307\u5b9a\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u89c6\u56fe\uff01[\u680f\u76ee\u4fe1\u606f=" + channel + "]");
        }
        return metaView;
    }

    public static MetaViewData setViewDataProperties(MethodContext methodContext, MetaViewData metaViewData) throws WCMException {
        Map map = methodContext.getParams();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v instanceof String) {
                metaViewData.setProperty(string, v.toString().trim());
                continue;
            }
            if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                metaViewData.setProperty(string, stringArray == null || stringArray.length == 0 ? null : stringArray[0].trim());
                continue;
            }
            metaViewData.setProperty(string, v);
        }
        return metaViewData;
    }

    private String convertToClassIds(int n, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return "";
        }
        WCMFilter wCMFilter = new WCMFilter("", "", "", String.valueOf("CLASSINFOID"));
        String[] stringArray = string.split(";");
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 2 + 20);
        stringBuffer.append("RootId=? and CName in(");
        wCMFilter.addSearchValues(n);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (stringArray[i].length() == 0) continue;
            int n2 = stringArray[i].lastIndexOf(92);
            if (n2 >= 0) {
                String[] stringArray2 = stringArray[i].split("\\\\");
                int n3 = n;
                for (int j = 0; j < stringArray2.length && (CMyString.isEmpty(stringArray2[j]) || (n3 = this.queryClassId(n3, stringArray2[j])) != 0); ++j) {
                }
                if (n3 <= 0) continue;
                return String.valueOf(n3);
            }
            bl = true;
            stringBuffer.append("?,");
            wCMFilter.addSearchValues(stringArray[i]);
        }
        if (!bl) {
            return "";
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append(")");
        wCMFilter.setWhere(stringBuffer.toString());
        wCMFilter.setMaxRowNumber(stringArray.length);
        StringBuffer stringBuffer2 = new StringBuffer(stringArray.length * 2);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        if (classInfos == null || classInfos.isEmpty()) {
            return "";
        }
        stringBuffer2.append(classInfos.getIdAt(0));
        return stringBuffer2.toString();
    }

    private int queryClassId(int n, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ParentId=? and CName=?", "", String.valueOf("CLASSINFOID"));
        wCMFilter.setMaxRowNumber(1);
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        if (classInfos == null || classInfos.isEmpty()) {
            return 0;
        }
        return classInfos.getIdAt(0);
    }

    /*
     * Loose catch block
     */
    private static String queryDeptCode(String string) throws WCMException {
        Connection connection;
        String string2;
        block14: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block13: {
                string2 = null;
                connection = DBManager.getDBManager().getConnection();
                preparedStatement = null;
                resultSet = null;
                preparedStatement = connection.prepareStatement("select DCode from WCMMetaTableDeptCode where DName=?");
                preparedStatement.setString(1, string);
                preparedStatement.setMaxRows(1);
                resultSet = preparedStatement.executeQuery();
                string2 = resultSet.next() ? resultSet.getString(1) : "00000000";
                resultSet.close();
                resultSet = null;
                preparedStatement.close();
                preparedStatement = null;
                Object var7_5 = null;
                if (resultSet == null) break block13;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                    break block14;
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
                {
                }
            }
            break block14;
            {
                catch (Exception exception3) {
                    throw new WCMException("\u83b7\u53d6\u7ec4\u7ec7\u7ed3\u6784\u7f16\u7801\u5931\u8d25\uff01", exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var7_6 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                DBManager.getDBManager().freeConnection(connection);
                throw throwable;
            }
        }
        DBManager.getDBManager().freeConnection(connection);
        return string2;
    }

    private WCMFilter getFilter(ClassInfo classInfo, MetaView metaView, MethodContext methodContext) throws WCMException {
        String string;
        if (metaView == null) {
            return null;
        }
        boolean bl = methodContext.getValue("withChildren", false);
        WCMFilter wCMFilter = new WCMFilter("", "", "MetaDataId desc");
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("exists(select XWCMClassInfoView.MetaDataId");
        stringBuffer.append(" from XWCMClassInfoView");
        stringBuffer.append(" where XWCMClassInfoView.ViewId = ?");
        wCMFilter.addSearchValues(metaView.getId());
        if (classInfo != null) {
            String[] stringArray;
            String string2;
            string = String.valueOf(classInfo.getId());
            if (bl && (string2 = this.m_oClassInfoMgr.queryChildrenWithAllLevel((User)(stringArray = this.getLoginUser()), classInfo, null)) != null && string2.length() > 0) {
                string = string + "," + string2;
            }
            stringBuffer.append(" and XWCMClassInfoView.ClassInfoId in (");
            stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("?,");
                wCMFilter.addSearchValues(stringArray[i]);
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        }
        string = metaView.getTrueTableName();
        stringBuffer.append(" and XWCMClassInfoView.MetaDataId=" + string + ".MetaDataId)");
        wCMFilter.setWhere(stringBuffer.toString());
        return wCMFilter;
    }

    public MetaViewDatas queryObjectsOfView(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("viewId", 0);
        if (n == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u89c6\u56fe\u7684id[viewId]");
        }
        MetaView metaView = MetaView.findById(n);
        if (metaView == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89c6\u56fe[id=" + n + "]\u4e0d\u5b58\u5728");
        }
        int n2 = methodContext.getValue("classInfoId", 0);
        ClassInfo classInfo = ClassInfo.findById(n2);
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        WCMFilter wCMFilter = this.getQueryFilter(methodContext, this.getLoginUser(), metaView);
        wCMFilter.setSelect("");
        this.logger.debug((Object)("filterOfWhere:" + wCMFilter));
        WCMFilter wCMFilter2 = this.getFilter(classInfo, metaView, methodContext);
        this.logger.debug((Object)("filter before merge:" + wCMFilter2));
        wCMFilter2.mergeWith(wCMFilter);
        this.logger.debug((Object)("filter after merge:" + wCMFilter2));
        metaViewDatas.open(wCMFilter2);
        return metaViewDatas;
    }

    public String queryObjectsCountOfView(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("viewId", 0);
        if (n == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u89c6\u56fe\u7684id[viewId]");
        }
        MetaView metaView = MetaView.findById(n);
        if (metaView == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89c6\u56fe[id=" + n + "]\u4e0d\u5b58\u5728");
        }
        WCMFilter wCMFilter = this.getQueryFilter(methodContext, this.getLoginUser(), metaView);
        wCMFilter.setSelect("");
        this.logger.debug((Object)("filterOfWhere:" + wCMFilter));
        User user = this.getLoginUser();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ClassInfos classInfos = null;
        String string = methodContext.getValue("classInfoIds");
        if (string != null) {
            classInfos = ClassInfos.findByIds(user, string);
        } else {
            ClassInfo classInfo = null;
            String string2 = methodContext.getValue("classInfoId");
            if (string2 != null) {
                classInfo = ClassInfo.findById(Integer.parseInt(string2));
            }
            if (classInfo == null) {
                hashMap.put("0", new Integer(this.queryObjectsCountOfClassInfo(metaView, null, wCMFilter)));
            }
            classInfos = this.m_oClassInfoMgr.queryChildren(user, classInfo, null);
        }
        int n2 = classInfos.size();
        for (int i = 0; i < n2; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            hashMap.put(String.valueOf(classInfo.getId()), new Integer(this.queryObjectsCountOfClassInfo(metaView, classInfo, wCMFilter)));
        }
        if (hashMap.size() == 0) {
            hashMap.put("NoObject", new Integer(0));
        }
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public int queryObjectsCountOfClassInfo(MetaView metaView, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        String string;
        if (metaView == null) {
            return 0;
        }
        boolean bl = true;
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("exists(select XWCMClassInfoView.MetaDataId");
        stringBuffer.append(" from XWCMClassInfoView");
        stringBuffer.append(" where XWCMClassInfoView.ViewId = ?");
        wCMFilter2.addSearchValues(metaView.getId());
        if (classInfo != null) {
            String[] stringArray;
            String string2;
            string = String.valueOf(classInfo.getId());
            if (bl && (string2 = this.m_oClassInfoMgr.queryChildrenWithAllLevel((User)(stringArray = this.getLoginUser()), classInfo, null)) != null && string2.length() > 0) {
                string = string + "," + string2;
            }
            stringBuffer.append(" and XWCMClassInfoView.ClassInfoId in (");
            stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("?,");
                wCMFilter2.addSearchValues(stringArray[i]);
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        }
        string = metaView.getTrueTableName();
        stringBuffer.append(" and XWCMClassInfoView.MetaDataId=" + string + ".MetaDataId)");
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.mergeWith(wCMFilter);
        wCMFilter2.setSelect("count(*)");
        wCMFilter2.setFrom(string);
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter2);
    }

    public String exportViewDatas(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        Channel channel = null;
        MetaView metaView = null;
        int n = methodContext.getValue("ViewId", 0);
        if (n > 0) {
            metaView = this.findViewById(n);
        } else {
            channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
            metaView = this.findViewByChannel(channel);
        }
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        int[] nArray = CMyString.splitToInt(string, ",");
        metaViewDatas.setMaxBufferSize(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            MetaViewData metaViewData = new MetaViewData(metaView);
            if (!metaViewData.loadById(nArray[i], "*")) continue;
            metaViewData.setMetaDataId(nArray[i]);
            Document document = Document.findById(nArray[i], "DocTitle,DocContent");
            metaViewData.getProperties().put("DOCTITLE", document.getTitle());
            metaViewData.getProperties().put("DOCCONTENT", document.getContent());
            metaViewDatas.addElement(metaViewData);
        }
        MetaViewDataExporter metaViewDataExporter = new MetaViewDataExporter(metaView);
        return metaViewDataExporter.exportToZip(metaViewDatas);
    }
}

