/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.components.metadata.center.IMetaDataFieldValueCreator;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class GovInfoIndexCreator
implements IMetaDataFieldValueCreator {
    private static Logger logger = Logger.getLogger(GovInfoIndexCreator.class);

    public String getCreatorName() {
        return "\u653f\u5e9c\u4fe1\u606f\u516c\u5f00\u76ee\u5f55\u7d22\u5f15\u4ea7\u751f\u5668";
    }

    public String[] registerRelateTables() {
        return new String[]{"WCMMetaTableGovInfo", "WCMMetaTablexingzheng", "WCMMetaTableleader", "WCMMetaTabledepartment", "WCMMetaTableguifan", "WCMMetaTableguizhang"};
    }

    public void setFieldValueBeforeSaveMetaData(MetaViewData metaViewData) throws WCMException {
        if (!metaViewData.isAddMode()) {
            return;
        }
        String string = this.makeIndexId(metaViewData);
        if (string == null) {
            return;
        }
        metaViewData.setProperty("IdxID", string);
    }

    public void resetFieldValueOnMetaData() throws WCMException {
        String[] stringArray = new String[]{"update WCMMetaTableGovInfo set IdxId=? where MetaDataId=?"};
        MetaViewDatas metaViewDatas = new MetaViewDatas("WCMMetaTableGovInfo");
        metaViewDatas.open(null);
        int n = metaViewDatas.size();
        for (int i = 0; i < n; ++i) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(i);
            String string = this.makeIndexId(metaViewData);
            if (string == null) continue;
            Object[] objectArray = new Object[]{string, new Integer(metaViewData.getId())};
            DBManager.getDBManager().sqlExecuteUpdate(stringArray, objectArray);
        }
    }

    private String makeIndexId(MetaViewData metaViewData) throws WCMException {
        String string;
        String string2 = ConfigServer.getServer().getSysConfigValue("DEPARTMENT_CODE", "000014349");
        int n = metaViewData.getPropertyAsInt("OrganCat", 0);
        ClassInfo classInfo = null;
        if (n > 0) {
            classInfo = ClassInfo.findById(n);
        }
        if (classInfo != null && !CMyString.isEmpty(string = classInfo.getCode())) {
            string2 = string2 + string;
        }
        return string2 + "/" + this.makeIndexIdOfLastRange(metaViewData);
    }

    private boolean equalsDate(String string, String string2) {
        String string3;
        if (string == null || string2 == null) {
            return false;
        }
        String string4 = string.trim();
        int n = string4.indexOf(" ");
        if (n > 0) {
            string4 = string4.substring(0, n);
        }
        if ((n = (string3 = string2.trim()).indexOf(" ")) > 0) {
            string3 = string3.substring(0, n);
        }
        return string3.equals(string4);
    }

    private String makeIndexIdOfLastRange(MetaViewData metaViewData) throws WCMException {
        String string;
        String string2 = "PubDate";
        if (DBManager.getDBManager().getFieldInfo(metaViewData.getDbTableName(), "PubDate") == null) {
            string2 = "CrTime";
        }
        String string3 = null;
        String string4 = metaViewData.getPropertyAsString(string2);
        if (metaViewData.isAddMode()) {
            if (CMyString.isEmpty(string4)) {
                string4 = CMyDateTime.now().toString();
            }
        } else {
            string3 = metaViewData.getPropertyAsString("IdxID");
            string = metaViewData.getNewPropertyAsString(string2);
            if (string != null && !this.equalsDate(string4, string)) {
                string4 = string;
                string3 = null;
            }
        }
        if (string4 == null || string4.trim().length() == 0) {
            return "";
        }
        if (string3 == null) {
            string = string4.substring(0, 4);
            try {
                WCMFilter wCMFilter = new WCMFilter(metaViewData.getDbTableName(), string2 + ">=? and " + string2 + "<=?", "MetaDataId Desc", "IdxId");
                wCMFilter.setMaxRowNumber(1);
                CMyDateTime cMyDateTime = new CMyDateTime();
                cMyDateTime.setDateTimeWithString(string + "-01-01 00:00:00");
                wCMFilter.addSearchValues(cMyDateTime);
                CMyDateTime cMyDateTime2 = new CMyDateTime();
                cMyDateTime2.setDateTimeWithString(string + "-12-31 23:59:59");
                wCMFilter.addSearchValues(cMyDateTime2);
                string3 = GovInfoIndexCreator.sqlExecuteIntQuery(wCMFilter.toSQL(), wCMFilter.getSearchValues());
                if (string3 == null || string3.length() < 10) {
                    return string4.substring(0, 4) + "-" + "00001";
                }
                string3 = string3.substring(string3.length() - 5);
                char c = string3.charAt(0);
                while (c == '\u0000') {
                    string3 = string3.substring(1);
                    c = string3.charAt(0);
                }
                string3 = "00000" + (Integer.parseInt(string3) + 1);
                return string4.substring(0, 4) + "-" + string3.substring(string3.length() - 5);
            }
            catch (Exception exception) {
                logger.error((Object)("\u8ba1\u7b97\u6d41\u6c34\u53f7\u5931\u8d25![PubDate=" + string4 + ", ID=" + metaViewData.getId() + "]"), (Throwable)exception);
                return "";
            }
        }
        int n = string3.lastIndexOf("/");
        if (n >= 0) {
            string3 = string3.substring(n + 1);
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String sqlExecuteIntQuery(String string, List list) throws WCMException {
        DBManager dBManager;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block17: {
            String string2;
            connection = null;
            preparedStatement = null;
            resultSet = null;
            dBManager = DBManager.getDBManager();
            try {
                try {
                    connection = dBManager.getConnection();
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setMaxRows(1);
                    DBManager.setParameters(preparedStatement, list);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block17;
                    string2 = resultSet.getString(1);
                    Object var8_9 = null;
                }
                catch (SQLException sQLException) {
                    throw new WCMException(40, "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, sQLException);
                }
                catch (Exception exception) {
                    throw new WCMException(0, "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (connection != null) {
                        dBManager.freeConnection(connection);
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (resultSet == null) throw throwable;
                    resultSet.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {
                // empty catch block
                return string2;
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet == null) return string2;
            resultSet.close();
            return string2;
        }
        Object var8_10 = null;
        try {}
        catch (Exception exception) {}
        if (connection != null) {
            dBManager.freeConnection(connection);
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return null;
        resultSet.close();
        return null;
    }
}

