/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.center.ClassInfoViewMgr;
import com.trs.components.metadata.center.IClassInfoViewMgr;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfoMgr;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.components.metadata.service.ClassInfoViewService;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;

public class ClassInfoViewServiceProvider
implements ISelfDefinedServiceProvider {
    private ClassInfoViewService m_oClassInfoViewServices = null;
    private IClassInfoViewMgr m_oClassInfoViewMgr = null;
    private ClassInfoMgr m_oClassInfoMgr = new ClassInfoMgr();
    private PublishServer m_oPublishServer = null;
    private TemplateEmployMgr employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");

    public ClassInfoViewServiceProvider() {
        this.m_oClassInfoViewServices = new ClassInfoViewService();
        this.m_oPublishServer = PublishServer.getInstance();
        this.m_oClassInfoViewMgr = (ClassInfoViewMgr)DreamFactory.createObjectById("IClassInfoViewMgr");
    }

    public MetaViews queryViews(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("classInfoId");
        boolean bl = methodContext.getValue("withChildren", false);
        return this.m_oClassInfoViewServices.queryViews(user, string, methodContext.getExtraWCMFilter(), bl);
    }

    public MetaViews queryViewsByClassInfo(MethodContext methodContext) throws Throwable {
        ClassInfo classInfo;
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter();
        String string = "select 1 from XWCMViewFieldInfo where XWCMViewInfo.ViewInfoId = XWCMViewFieldInfo.ViewId and XWCMViewFieldInfo.FieldType=?";
        wCMFilter.addSearchValues(10);
        int n = methodContext.getValue("ClassInfoId", 0);
        if (n != 0 && (classInfo = ClassInfo.findById(n)) != null) {
            string = string + " and XWCMViewFieldInfo.ClassId=?";
            wCMFilter.addSearchValues(classInfo.getRootId());
        }
        wCMFilter.setWhere("exists (" + string + ")");
        return MetaViews.openWCMObjs(user, wCMFilter);
    }

    public Documents queryDocuments(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("classInfoId");
        boolean bl = methodContext.getValue("withChildren", false);
        WCMFilter wCMFilter = new WCMFilter(null, null, "crtime desc", null);
        int n = methodContext.getValue("viewId", 0);
        String string2 = methodContext.getValue("docTitle");
        if (n != 0 && string2 != null) {
            wCMFilter.setWhere("docKind=? and docTitle like ?");
            wCMFilter.addSearchValues(n);
            wCMFilter.addSearchValues("%" + string2 + "%");
        } else if (n != 0) {
            wCMFilter.setWhere("docKind=?");
            wCMFilter.addSearchValues(n);
        } else if (string2 != null) {
            wCMFilter.setWhere("docTitle like ?");
            wCMFilter.addSearchValues("%" + string2 + "%");
        }
        Documents documents = this.m_oClassInfoViewServices.queryDocuments(user, string, wCMFilter, bl);
        this.extendDocumentProperties(methodContext, documents);
        return documents;
    }

    public ClassInfos queryClassInfos(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("docId");
        if (CMyString.isEmpty(string) && CMyString.isEmpty(string = methodContext.getValue("docIds"))) {
            throw new WCMException(I18NMessage.get(ClassInfoViewServiceProvider.class, "ClassInfoViewServiceProvider.label1", "\u6ca1\u6709\u6307\u5b9a\u53c2\u6570docId/docIds"));
        }
        WCMFilter wCMFilter = new WCMFilter();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ClassInfoId in (");
        stringBuffer.append("select ClassInfoId from XWCMClassInfoView");
        stringBuffer.append(" where MetaDataId in (");
        stringBuffer.append(this.getSQLByIds(wCMFilter, string));
        stringBuffer.append(")");
        int n = methodContext.getValue("classInfoId", 0);
        if (n != 0) {
            ClassInfo classInfo = ClassInfo.findById(n);
            if (classInfo == null) {
                throw new WCMException(I18NMessage.get(ClassInfoViewServiceProvider.class, "ClassInfoViewServiceProvider.label2", "\u6307\u5b9a\u7684\u5206\u7c7b\u5df2\u7ecf\u5220\u9664\uff0c\u5206\u7c7bID[") + n + "]");
            }
            String string2 = String.valueOf(n);
            String string3 = this.m_oClassInfoMgr.queryChildrenWithAllLevel(user, classInfo, null);
            if (string3 != null) {
                string2 = string2 + "," + string3;
            }
            stringBuffer.append(" and ClassInfoId in (");
            stringBuffer.append(this.getSQLByIds(wCMFilter, string2));
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        wCMFilter.setWhere(stringBuffer.toString());
        return ClassInfos.openWCMObjs(user, wCMFilter);
    }

    public ClassInfos queryClassInfos1(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("docId");
        if (CMyString.isEmpty(string) && CMyString.isEmpty(string = methodContext.getValue("docIds"))) {
            throw new WCMException(I18NMessage.get(ClassInfoViewServiceProvider.class, "ClassInfoViewServiceProvider.label1", "\u6ca1\u6709\u6307\u5b9a\u53c2\u6570docId/docIds"));
        }
        WCMFilter wCMFilter = null;
        int n = methodContext.getValue("classInfoId", 0);
        if (n != 0) {
            ClassInfo classInfo = ClassInfo.findById(n);
            if (classInfo == null) {
                throw new WCMException(I18NMessage.get(ClassInfoViewServiceProvider.class, "ClassInfoViewServiceProvider.label2", "\u6307\u5b9a\u7684\u5206\u7c7b\u5df2\u7ecf\u5220\u9664\uff0c\u5206\u7c7bID[") + n + "]");
            }
            String string2 = String.valueOf(n);
            String string3 = this.m_oClassInfoMgr.queryChildrenWithAllLevel(user, classInfo, null);
            if (string3 != null) {
                string2 = string2 + "," + string3;
            }
            wCMFilter = new WCMFilter();
            StringBuffer stringBuffer = this.getSQLByIds(wCMFilter, string2);
            stringBuffer.append(")");
            stringBuffer.insert(0, "ClassInfoId in (");
            wCMFilter.setWhere(stringBuffer.toString());
        }
        return this.m_oClassInfoViewServices.queryClassInfos(user, string, wCMFilter);
    }

    private StringBuffer getSQLByIds(WCMFilter wCMFilter, String string) {
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 2);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("?,");
            wCMFilter.addSearchValues(stringArray[i]);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer;
    }

    public String queryDocNumMapping(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        WCMFilter wCMFilter = null;
        String string = methodContext.getValue("docTitle");
        if (string != null && string.length() >= 0) {
            wCMFilter = new WCMFilter();
            object = "MetaDataId in (select docId from WCMDocument where docTitle like ?)";
            wCMFilter.setWhere((String)object);
            wCMFilter.addSearchValues("%" + string + "%");
        }
        object = null;
        String string2 = methodContext.getValue("classInfoIds");
        if (string2 != null) {
            object = ClassInfos.findByIds(user, string2);
        } else {
            ClassInfo classInfo = null;
            String string3 = methodContext.getValue("classInfoId");
            if (string3 != null) {
                classInfo = ClassInfo.findById(Integer.parseInt(string3));
            }
            if (classInfo == null) {
                hashMap.put("0", new Integer(this.m_oClassInfoViewMgr.queryDocumentNum(user, null, wCMFilter)));
            }
            object = this.m_oClassInfoMgr.queryChildren(user, classInfo, null);
        }
        int n = ((BaseObjs)object).size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo = (ClassInfo)((BaseObjs)object).getAt(i);
            if (classInfo == null) continue;
            hashMap.put(String.valueOf(classInfo.getId()), new Integer(this.m_oClassInfoViewMgr.queryDocumentNum(user, classInfo, wCMFilter)));
        }
        if (hashMap.size() == 0) {
            hashMap.put("NoObject", new Integer(0));
        }
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public String queryDocNumMapping2(MethodContext methodContext) throws Throwable {
        HashMap hashMap = new HashMap();
        String string = "Select ClassInfoId, Count(distinct MetaDataId) As DocNum from XWCMClassInfoView Group By ClassInfoId";
        CMyResultSets cMyResultSets = new CMyResultSets();
        cMyResultSets.open(string, "ClassInfoId");
        ClassInfo classInfo = ClassInfo.findById(methodContext.getValue("classInfoId", 0));
        this.queryDocNumMapping(hashMap, classInfo, cMyResultSets);
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    private int queryDocNumMapping(HashMap hashMap, ClassInfo classInfo, CMyResultSets cMyResultSets) throws WCMException {
        User user = this.getLoginUser();
        int n = 0;
        ClassInfos classInfos = this.m_oClassInfoMgr.queryChildren(user, classInfo, null);
        int n2 = classInfos.size();
        for (int i = 0; i < n2; ++i) {
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null) continue;
            n += this.queryDocNumMapping(hashMap, classInfo2, cMyResultSets);
        }
        if (classInfo == null) {
            hashMap.put("0", new Integer(n));
        } else {
            BaseObj baseObj = cMyResultSets.getById(classInfo.getId());
            if (baseObj != null) {
                n += baseObj.getPropertyAsInt("DocNum", 0);
            }
            hashMap.put(String.valueOf(classInfo.getId()), new Integer(n));
        }
        return n;
    }

    public String preview(MethodContext methodContext) throws Throwable {
        Cloneable cloneable;
        String[] stringArray;
        User user = this.getLoginUser();
        ClassInfos classInfos = null;
        int n = methodContext.getValue("ParentId", 0);
        if (n > 0) {
            stringArray = ClassInfo.findById(n);
            if (stringArray != null && stringArray.isRoot()) {
                cloneable = new WCMFilter("", "RootId=?", "");
                ((WCMFilter)cloneable).addSearchValues(n);
                classInfos = ClassInfos.openWCMObjs(user, (WCMFilter)cloneable);
            } else {
                classInfos = this.m_oClassInfoMgr.queryChildren(user, (ClassInfo)stringArray, null);
            }
        }
        stringArray = new String[1];
        cloneable = new HashMap(2);
        int n2 = 0;
        Object[] objectArray = new Object[classInfos.size()];
        HashMap<String, Object> hashMap = null;
        int n3 = classInfos.size();
        for (int i = 0; i < n3; ++i) {
            String[] stringArray2;
            hashMap = new HashMap<String, Object>(2);
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            hashMap.put("Name", classInfo.getName());
            PublishFolderClassImpl publishFolderClassImpl = (PublishFolderClassImpl)PublishElementFactory.makeElementFrom(classInfo);
            this.employMgr.setOutlineTemplates(publishFolderClassImpl, methodContext.getValue("TemplateIds"), true);
            try {
                stringArray2 = this.m_oPublishServer.previewFolder(publishFolderClassImpl, stringArray);
                if (stringArray[0] != null) {
                    hashMap.put("Warning", stringArray[0]);
                }
            }
            catch (Exception exception) {
                stringArray2 = new String[]{};
                int n4 = exception.getMessage().indexOf(10);
                String string = exception.getMessage();
                if (n4 > 0) {
                    string = string.substring(0, n4);
                }
                hashMap.put("Exception", string);
                hashMap.put("ExceptionDetail", CMyException.getStackTraceText(exception));
            }
            n2 += stringArray2.length;
            hashMap.put("URLs", stringArray2);
            objectArray[i] = hashMap;
        }
        ((HashMap)cloneable).put("URLCount", String.valueOf(n2));
        ((HashMap)cloneable).put("Data", objectArray);
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON((HashMap)cloneable, 0);
    }

    public void publish(MethodContext methodContext) throws Throwable {
        Cloneable cloneable;
        Object[] objectArray;
        User user = this.getLoginUser();
        BaseObjs baseObjs = null;
        int n = methodContext.getValue("ParentId", 0);
        if (n > 0) {
            objectArray = ClassInfo.findById(n);
            if (objectArray != null && objectArray.isRoot()) {
                cloneable = new WCMFilter("", "RootId=?", "");
                ((WCMFilter)cloneable).addSearchValues(n);
                baseObjs = ClassInfos.openWCMObjs(user, (WCMFilter)cloneable);
            } else {
                baseObjs = this.m_oClassInfoMgr.queryChildren(user, (ClassInfo)objectArray, null);
            }
        }
        objectArray = new Object[baseObjs.size()];
        cloneable = null;
        int n2 = baseObjs.size();
        for (int i = 0; i < n2; ++i) {
            cloneable = new HashMap(2);
            ClassInfo classInfo = (ClassInfo)baseObjs.getAt(i);
            ((HashMap)cloneable).put("Name", classInfo.getName());
            PublishFolderClassImpl publishFolderClassImpl = (PublishFolderClassImpl)PublishElementFactory.makeElementFrom(classInfo);
            this.employMgr.setOutlineTemplates(publishFolderClassImpl, methodContext.getValue("TemplateIds"), true);
            this.m_oPublishServer.publishFolder(publishFolderClassImpl, 8);
            objectArray[i] = cloneable;
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void extendDocumentProperties(MethodContext methodContext, Documents documents) throws WCMException {
        if (documents == null || documents.isEmpty()) {
            return;
        }
        HashMap<Integer, MetaView> hashMap = new HashMap<Integer, MetaView>(20);
        int n = -1;
        int n2 = 1;
        if (methodContext != null) {
            n = methodContext.getPageSize();
            n2 = methodContext.getPageIndex();
        }
        CPager cPager = new CPager(n);
        cPager.setCurrentPageIndex(n2);
        cPager.setItemCount(documents.size());
        for (int i = cPager.getFirstItemIndex(); i <= cPager.getLastItemIndex(); ++i) {
            int n3;
            Document document = (Document)documents.getAt(i - 1);
            if (document == null || (n3 = document.getPropertyAsInt("DocKind", 0)) == 0) continue;
            Integer n4 = new Integer(n3);
            MetaView metaView = (MetaView)hashMap.get(n4);
            if (metaView == null) {
                metaView = MetaView.findById(n3);
                if (metaView == null) continue;
                hashMap.put(n4, metaView);
            }
            document.getProperties().put("VIEWDESC", metaView.getDesc());
            document.getProperties().put("VIEWNAME", metaView.getName());
        }
    }
}

