/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class ClassInfoToGroupCreator {
    public static final String ROLENAME_SFX_MGR = I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label1", "_\u4fe1\u606f\u7ba1\u7406\u4eba\u5458");
    private static IClassInfoMgr m_oClassInfoMgr;
    private static GroupMgr m_oGroupMgr;
    private static StringBuffer m_sbNewUserInfos;

    public ClassInfoToGroupCreator() {
        m_sbNewUserInfos = new StringBuffer();
    }

    public String getNewUserInfos() {
        return m_sbNewUserInfos.toString();
    }

    public void createGroups(ClassInfo classInfo, Group group, int n) throws WCMException {
        if (classInfo == null || group == null) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        IClassInfoMgr iClassInfoMgr = this.getClassInfoMgr();
        ClassInfos classInfos = iClassInfoMgr.queryChildren(user, classInfo, null);
        int n2 = classInfos.size();
        for (int i = 0; i < n2; ++i) {
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null) continue;
            this.createGroups(classInfo2, group, 1, n);
        }
    }

    private void createGroups(ClassInfo classInfo, Group group, int n, int n2) throws WCMException {
        if (classInfo == null || group == null) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        Group group2 = this.createGroup(group, classInfo.getName(), user);
        this.createUser(user, classInfo.getName(), group2);
        User user2 = this.createUser(user, classInfo.getName() + I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label2", "_\u8d1f\u8d23\u4eba"), group2);
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        user2.setStatus(30);
        user2.save();
        groupMgr.setGroupManager(user2, group2, true);
        user2.setStatus(20);
        user2.save();
        if (n > 1) {
            this.createUser(user, classInfo.getName() + I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label3", "_\u5ba1\u67e5\u5458"), group2);
            this.createUser(user, classInfo.getName() + I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label4", "_\u5904\u7406\u5458"), group2);
        }
        this.createMgrRoleOnGroup(group2);
        if (n2 != 0 && n + 1 > n2) {
            return;
        }
        IClassInfoMgr iClassInfoMgr = this.getClassInfoMgr();
        ClassInfos classInfos = iClassInfoMgr.queryChildren(user, classInfo, null);
        int n3 = classInfos.size();
        for (int i = 0; i < n3; ++i) {
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null) continue;
            this.createGroups(classInfo2, group2, n + 1, n2);
        }
    }

    private void createMgrRoleOnGroup(Group group) throws WCMException {
        Group group2;
        String string = group.getName() + "_" + ROLENAME_SFX_MGR;
        for (group2 = group.getParent(); group2 != null && group2.getParentId() > 0; group2 = group2.getParent()) {
            string = group2.getName() + "_" + string;
        }
        RoleMgr roleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
        Role role = new Role();
        role.setName(string);
        role.setRoleRange(1);
        role.setAttribute("govinfo", "1");
        roleMgr.save(role);
        for (group2 = group.getParent(); group2 != null && group2.getParentId() > 0; group2 = group2.getParent()) {
            Users users = group2.getUsers(null);
            int n = users.size();
            for (int i = 0; i < n; ++i) {
                User user = (User)users.getAt(i);
                if (user == null) continue;
                roleMgr.addUser(role, -1, user);
            }
        }
    }

    private Group getRootGroup(Group group) throws WCMException {
        Group group2 = null;
        while (group != null) {
            group2 = group.getParent();
            if (group2 == null) {
                return group;
            }
            if (I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label5", "\u7ec4\u7ec7\u673a\u6784").equals(group2.getName())) {
                return group;
            }
            group = group2;
        }
        return group;
    }

    private User createUser(User user, String string, Group group) throws WCMException {
        Group group2 = this.getRootGroup(group);
        User user2 = User.findByName(string);
        if (user2 != null) {
            string = group2.getName() + "_" + string;
            user2 = User.findByName(string);
        }
        if (user2 == null) {
            user2 = User.createNewInstance();
            user2.setName(string);
            String string2 = String.valueOf(Math.random()).substring(3, 11);
            user2.setPassword(string2);
            user2.setNickName(string);
            user2.setStatus(20);
            user2.setAttribute("govinfo", "1");
            user2.save(user);
            m_sbNewUserInfos.append(I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label6", "\u7528\u6237\u540d/\u5bc6\u7801\uff1a") + string + "/" + string2);
            m_sbNewUserInfos.append('\n');
        } else if (group != null && user2.getGroups().indexOf(group) >= 0) {
            return user2;
        }
        if (group != null) {
            this.getGroupMgr().addUser(user2, group);
        }
        return user2;
    }

    private Group createGroup(Group group, String string, User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ParentId=? and GName=?", "");
        wCMFilter.addSearchValues(group.getId());
        wCMFilter.addSearchValues(string);
        wCMFilter.setMaxRowNumber(1);
        Groups groups = Groups.openWCMObjs(null, wCMFilter);
        if (!groups.isEmpty()) {
            return (Group)groups.getAt(0);
        }
        Group group2 = Group.createNewInstance();
        group2.setParent(group == null ? 0 : group.getId());
        group2.setName(string);
        group2.setDesc(string);
        group2.setCrUser(user);
        group2.setAttribute("govinfo", "1");
        group2.save(user);
        return group2;
    }

    private IClassInfoMgr getClassInfoMgr() {
        if (m_oClassInfoMgr == null) {
            m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        }
        return m_oClassInfoMgr;
    }

    private GroupMgr getGroupMgr() {
        if (m_oGroupMgr == null) {
            m_oGroupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        }
        return m_oGroupMgr;
    }

    static {
        m_sbNewUserInfos = null;
    }
}

