/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.definition.Flows;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.service.ClassInfoToGroupCreator;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ClassInfoToChannelHelper {
    private static Logger m_oLogger = Logger.getLogger(ClassInfoToChannelHelper.class);
    private static final long RIGHTVALUE_WITH_MGR = 540092153856L;
    private static final long RIGHTVALUE_ONLY_BROWER = 16384L;
    private static final long RIGHT_VALUE_WITH_ADDDOC = 0xC0004000L;
    private static final String SQL_QUERY_GROUP_ID_BY_PATH = "select GroupId from WCMGroup a where GName=? and exists(select 1 from WCMGroup b where b.GName=? and b.GroupId=a.ParentId)";
    private static IMetaViewEmployerMgr m_oMetaViewEmployerMgr;
    private static IClassInfoMgr m_oClassInfoMgr;
    private static IObjectMemberMgr m_oObjectMemberMgr;
    private static Flow s_oFlow;

    private static IMetaViewEmployerMgr getMetaViewEmployerMgr() {
        if (m_oMetaViewEmployerMgr == null) {
            m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        }
        return m_oMetaViewEmployerMgr;
    }

    private static IClassInfoMgr getClassInfoMgr() {
        if (m_oClassInfoMgr == null) {
            m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        }
        return m_oClassInfoMgr;
    }

    private static IObjectMemberMgr getObjectMemberMgr() {
        if (m_oObjectMemberMgr == null) {
            m_oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        }
        return m_oObjectMemberMgr;
    }

    public static void createSites(ClassInfo classInfo, MetaView metaView, int n, String string) throws WCMException {
        if (classInfo == null) {
            throw new WCMException(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label1", "\u6ca1\u6709\u6307\u5b9a\u5bf9\u5e94\u7684\u5206\u7c7b"));
        }
        User user = ContextHelper.getLoginUser();
        IClassInfoMgr iClassInfoMgr = ClassInfoToChannelHelper.getClassInfoMgr();
        ClassInfos classInfos = iClassInfoMgr.queryChildren(user, classInfo, null);
        for (int i = classInfos.size() - 1; i >= 0; --i) {
            WebSite webSite;
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null || (webSite = ClassInfoToChannelHelper.findSiteByName(classInfo2.getName())) != null) continue;
            webSite = ClassInfoToChannelHelper.newSite(user, classInfo2.getName(), string);
            ClassInfoToChannelHelper.importTemplates(webSite);
            ClassInfoToChannelHelper.setDefaultOulineTemplate(webSite, "publicInformationSiteHome");
            ClassInfoToChannelHelper.setOtherOulineTemplates(webSite, new String[]{"navigationHomePage"});
            ClassInfoToChannelHelper.setDetailTemplate(webSite, "detail");
            ClassInfoToChannelHelper.createChildChannels(classInfo2, webSite, metaView, n, 2);
        }
    }

    public static void createChannels(ClassInfo classInfo, BaseChannel baseChannel, MetaView metaView, int n) throws WCMException {
        if (classInfo == null || baseChannel == null) {
            throw new WCMException(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label5", "\u6ca1\u6709\u6307\u5b9a\u5bf9\u5e94\u7684\u5206\u7c7b\u6216\u8005\u680f\u76ee\u7684Host"));
        }
        ClassInfoToChannelHelper.createChildChannels(classInfo, baseChannel, metaView, n, 1);
    }

    private static void createChildChannels(ClassInfo classInfo, BaseChannel baseChannel, MetaView metaView, int n, int n2) throws WCMException {
        if (n > 0 && n2 > n) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        IClassInfoMgr iClassInfoMgr = ClassInfoToChannelHelper.getClassInfoMgr();
        ClassInfos classInfos = iClassInfoMgr.queryChildren(user, classInfo, null);
        int n3 = classInfos.size();
        for (int i = 0; i < n3; ++i) {
            Object object;
            CMSObj cMSObj;
            Object object2;
            long l;
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null) continue;
            boolean bl = classInfo2.isLeaf() && n2 + 1 > n;
            String string = classInfo2.getName();
            Channel channel = ClassInfoToChannelHelper.newChannel(baseChannel, string, string, classInfo2.getCode(), user);
            Group group = ClassInfoToChannelHelper.convertToGroup(channel, baseChannel);
            long l2 = l = bl ? 0xC0004000L : 16384L;
            if (bl) {
                ClassInfoToChannelHelper.saveRightValue(user, group, channel, l);
            } else {
                object2 = string + "_\u8d1f\u8d23\u4eba";
                cMSObj = User.findByName((String)object2);
                object = ClassInfoToChannelHelper.getObjectMemberMgr();
                object.addVisible(user, ((User)cMSObj).getWCMType(), cMSObj.getId(), channel.getWCMType(), channel.getId());
            }
            l = 540092153856L;
            object2 = ClassInfoToChannelHelper.findRoleByName(group);
            ClassInfoToChannelHelper.saveRightValue(user, (CMSObj)object2, channel, l);
            ClassInfoToChannelHelper.getMetaViewEmployerMgr().setEmployer(user, channel, metaView);
            ClassInfoToChannelHelper.setDefaultOulineTemplate(channel, n2 == 2 ? "navigationHomePage" : "interimGeneralOutline");
            ClassInfoToChannelHelper.setDetailTemplate(channel, "detail");
            cMSObj = ClassInfoToChannelHelper.findFlow();
            if (cMSObj.getId() > 0) {
                object = (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
                ((FlowEmployMgr)object).setFlow(channel, cMSObj.getId());
            }
            ClassInfoToChannelHelper.createChildChannels(classInfo2, channel, metaView, n, n2 + 1);
        }
    }

    private static Role findRoleByName(Group group) throws WCMException {
        String string = group.getName() + "_" + ClassInfoToGroupCreator.ROLENAME_SFX_MGR;
        for (Group group2 = group.getParent(); group2 != null && group2.getParentId() > 0; group2 = group2.getParent()) {
            string = group2.getName() + "_" + string;
        }
        WCMFilter wCMFilter = new WCMFilter("", "RoleName=?", "");
        wCMFilter.addSearchValues(string);
        Roles roles = Roles.openWCMObjs(null, wCMFilter);
        if (roles.isEmpty()) {
            return null;
        }
        return (Role)roles.getAt(0);
    }

    private static Right saveRightValue(User user, CMSObj cMSObj, Channel channel, long l) throws WCMException {
        if (cMSObj == null) {
            return null;
        }
        Right right = new Right();
        right.setOperator(cMSObj);
        right.setObject(channel);
        right.setValue(l);
        right.save(user);
        return right;
    }

    private static Channel newChannel(BaseChannel baseChannel, String string, String string2, String string3, User user) throws WCMException {
        int n = baseChannel.getSiteId();
        Channel channel = Channel.findByName(n, string);
        if (channel != null) {
            return ClassInfoToChannelHelper.newChannel(baseChannel, ClassInfoToChannelHelper.makeNewChannelName(baseChannel, string), string2, string3, user);
        }
        channel = Channel.createNewInstance();
        channel.setSite(n);
        if (baseChannel.isSite()) {
            channel.setParent(0);
        } else {
            channel.setParent(baseChannel.getId());
        }
        channel.setName(string);
        channel.setDesc(string2);
        if (channel.getChnlProperty() <= 0) {
            channel.setChnlProperty(4);
        }
        channel.setCrUser(user);
        channel.save(user);
        String string4 = null;
        string4 = CMyString.isEmpty(string3) ? "auto" + channel.getId() : string3;
        FolderPublishConfig folderPublishConfig = FolderPublishConfig.createNewInstance();
        folderPublishConfig.setFolder(101, channel.getId());
        folderPublishConfig.setDataPath(string4);
        folderPublishConfig.save(user);
        return channel;
    }

    private static String makeNewChannelName(BaseChannel baseChannel, String string) throws WCMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(baseChannel.getDesc());
        arrayList.add(string);
        int n = DBManager.getDBManager().sqlExecuteQuery(SQL_QUERY_GROUP_ID_BY_PATH, (List)arrayList, 0);
        if (n == 0) {
            return string + "_1";
        }
        return string + n;
    }

    private static WebSite newSite(User user, String string, String string2) throws WCMException {
        WebSite webSite = WebSite.createNewInstance();
        webSite.setType(4);
        webSite.setName(string);
        webSite.setDesc(string);
        webSite.setParent(0);
        webSite.setCrUser(user);
        webSite.save(user);
        String string3 = "root" + webSite.getId();
        String string4 = CMyString.setStrEndWith(string2, '/') + string3 + '/';
        FolderPublishConfig folderPublishConfig = FolderPublishConfig.createNewInstance();
        folderPublishConfig.setFolder(103, webSite.getId());
        folderPublishConfig.setDataPath(string3);
        folderPublishConfig.setSiteLanguage(8);
        folderPublishConfig.setPageEncoding("UTF-8");
        folderPublishConfig.setRootDomain(string4);
        folderPublishConfig.save(user);
        WCMPubStatusConfig wCMPubStatusConfig = WCMPubStatusConfig.createNewInstance();
        wCMPubStatusConfig.setFolderType(webSite);
        wCMPubStatusConfig.setStatusesCanDoPub("1,2,16,10");
        wCMPubStatusConfig.setStatusIdAfterModify(16);
        wCMPubStatusConfig.save(user);
        return webSite;
    }

    private static WebSite findSiteByName(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "SiteName=?", "");
        wCMFilter.addSearchValues(string);
        WebSites webSites = WebSites.openWCMObjs(null, wCMFilter);
        if (webSites.isEmpty()) {
            return null;
        }
        return (WebSite)webSites.getAt(0);
    }

    private static Group convertToGroup(Channel channel, BaseChannel baseChannel) throws WCMException {
        String[] stringArray = new String[5];
        stringArray[0] = channel.getName();
        stringArray[1] = baseChannel.getName();
        int n = 2;
        for (BaseChannel baseChannel2 = baseChannel.getHost(); baseChannel2 != null; baseChannel2 = baseChannel2.getHost()) {
            stringArray[n++] = baseChannel2.getName();
        }
        IDepartmentMgr iDepartmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        int n2 = iDepartmentMgr.getRootDepartmentGroup().getId();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string = stringArray[i];
            if (string == null) continue;
            WCMFilter wCMFilter = new WCMFilter("", "ParentId=? and GName=?", "");
            wCMFilter.addSearchValues(n2);
            wCMFilter.addSearchValues(string);
            wCMFilter.setMaxRowNumber(1);
            Groups groups = Groups.openWCMObjs(null, wCMFilter);
            if (groups.isEmpty()) {
                throw new WCMException(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label7", "\u5bf9\u5e94\u4e0d\u4e0a\u7ec4\u7ec7[Name=") + string + ",ParentId=" + n2 + "]");
            }
            n2 = groups.getIdAt(0);
            if (i != 0) continue;
            return (Group)groups.getAt(0);
        }
        return null;
    }

    private static void importTemplates(WebSite webSite) throws WCMException {
        Object object;
        String string = ConfigServer.getServer().getInitProperty("WCM_PATH");
        string = CMyString.setStrEndWith(string, File.separatorChar);
        String string2 = string + ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME_4GOVINFO", "WCMV6") + File.separatorChar + "gkml" + File.separatorChar + "data" + File.separator;
        String string3 = string2 + "templates.zip";
        try {
            object = string3;
            string3 = string2 + "templates_temp.zip";
            CMyFile.copyFile((String)object, string3);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label8", "\u62f7\u8d1d\u6587\u4ef6\u5931\u8d25"), exception);
        }
        object = new TemplateImporter();
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(webSite);
        ((TemplateImporter)object).importFromZip(iPublishFolder, string3, 1, 1, null);
    }

    private static void setDefaultOulineTemplate(BaseChannel baseChannel, String string) throws WCMException {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template template = templateCacheMgr.lookupByName(iPublishFolder.getRoot(), string);
        if (template != null) {
            TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            templateEmployMgr.setDefaultOutline(iPublishFolder, template.getId());
        }
    }

    private static void setOtherOulineTemplates(BaseChannel baseChannel, String[] stringArray) throws WCMException {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            Template template = templateCacheMgr.lookupByName(iPublishFolder.getRoot(), stringArray[i]);
            if (template == null) continue;
            stringBuffer.append(template.getId());
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
            TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            templateEmployMgr.setOtherOutlines(User.getSystem(), iPublishFolder, stringBuffer.toString());
        }
    }

    private static void setDetailTemplate(BaseChannel baseChannel, String string) throws WCMException {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template template = templateCacheMgr.lookupByName(iPublishFolder.getRoot(), string);
        if (template != null) {
            TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            templateEmployMgr.setDetailTemplate(iPublishFolder, template.getId(), false);
        }
    }

    private static Flow findFlow() throws WCMException {
        if (s_oFlow == null) {
            WCMFilter wCMFilter = new WCMFilter("", "FlowName=?", "");
            wCMFilter.addSearchValues(I18NMessage.get(ClassInfoToChannelHelper.class, "ClassInfoToChannelHelper.label9", "\u4fe1\u606f\u516c\u5f00\u5ba1\u6838\u6d41\u7a0b"));
            Flows flows = Flows.openWCMObjs(null, wCMFilter);
            s_oFlow = flows.isEmpty() ? new Flow() : (Flow)flows.getAt(0);
        }
        return s_oFlow;
    }

    static {
        s_oFlow = null;
    }
}

