/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfoUtil;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.xml.ClassInfoImporter;
import com.trs.components.metadata.definition.xml.ClassInfoXMLConvertor;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IFindByIdServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ClassInfoServiceProvider
implements ISelfDefinedServiceProvider,
IFindByIdServiceProvider {
    private static Logger logger = Logger.getLogger(ClassInfoServiceProvider.class);
    private static final int SELECT_NODE = 0;
    private static final int ONLY_SELECT_LEAF = 1;
    private int m_nNodeType = 0;
    private IClassInfoMgr m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");

    public String createClassInfoTreeHTMLOfIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("objectIds");
        this.m_nNodeType = methodContext.getValue("SelectType", 0);
        StringBuffer stringBuffer = new StringBuffer(4096);
        if (methodContext.getValue("type", 0) == 0) {
            int[] nArray = CMyString.splitToInt(string, ",");
            this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, 0);
        } else {
            string = this.m_oClassInfoMgr.getPath(ClassInfos.findByIds(user, string));
            int[] nArray = CMyString.splitToInt(string, ",");
            HashMap hashMap = new HashMap(nArray.length);
            this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, 0);
        }
        return stringBuffer.toString();
    }

    private void createClassInfoTreeHTMLOfIds(StringBuffer stringBuffer, int[] nArray, int n) throws WCMException {
        if (n == nArray.length) {
            return;
        }
        ClassInfo classInfo = ClassInfo.findById(nArray[n]);
        if (classInfo == null) {
            return;
        }
        User user = this.getLoginUser();
        ClassInfos classInfos = this.m_oClassInfoMgr.queryChildren(user, classInfo, null);
        if (classInfos.size() <= 0) {
            return;
        }
        ++n;
        int n2 = classInfos.size();
        for (int i = 0; i < n2; ++i) {
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null) continue;
            if (n + 1 < nArray.length && classInfo2.getId() == nArray[n]) {
                this.appendOneClassInfoHTML(stringBuffer, classInfo2);
                stringBuffer.append("<ul>");
                this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, n);
                stringBuffer.append("</ul>");
                continue;
            }
            this.makeClassInfoHTML(stringBuffer, classInfo2);
        }
    }

    private void createClassInfoTreeHTMLOfIds(StringBuffer stringBuffer, int[] nArray, HashMap hashMap, int n) throws WCMException {
        if (n >= nArray.length) {
            return;
        }
        if (hashMap.get(new Integer(nArray[n])) == Boolean.TRUE) {
            this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, n + 1);
            return;
        }
        hashMap.put(new Integer(nArray[n]), Boolean.TRUE);
        ClassInfo classInfo = ClassInfo.findById(nArray[n]);
        if (classInfo == null) {
            this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, n + 1);
            return;
        }
        User user = this.getLoginUser();
        this.appendOneClassInfoHTML(stringBuffer, classInfo);
        ClassInfos classInfos = this.m_oClassInfoMgr.queryChildren(user, classInfo, null);
        if (classInfos.size() <= 0) {
            return;
        }
        stringBuffer.append("<ul>");
        ++n;
        int n2 = classInfos.size();
        for (int i = 0; i < n2; ++i) {
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            if (classInfo2 == null) continue;
            if (n < nArray.length && this.isContain(nArray, classInfo2.getId())) {
                this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, n);
                continue;
            }
            this.makeClassInfoHTML(stringBuffer, classInfo2);
        }
        stringBuffer.append("</ul>");
        this.createClassInfoTreeHTMLOfIds(stringBuffer, nArray, hashMap, n + 1);
    }

    private boolean isContain(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public String createClassInfoTreeHTML(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ParentId", 0);
        this.m_nNodeType = methodContext.getValue("SelectType", 0);
        return this.createClassInfoTreeHTML(user, n);
    }

    public String createClassInfoTreeHTML(User user, int n) throws WCMException {
        ClassInfos classInfos = this.queryClassInfos(user, n, null);
        StringBuffer stringBuffer = new StringBuffer(51200);
        this.makeClassInfoHTML(stringBuffer, classInfos);
        return stringBuffer.toString();
    }

    public ClassInfos queryClassInfos(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ParentId", 0);
        boolean bl = methodContext.getValue("ContainAll", false);
        if (!bl) {
            return this.queryClassInfos(user, n, methodContext.getExtraWCMFilter());
        }
        String string = this.m_oClassInfoMgr.queryChildrenWithAllLevel(user, n, new WCMFilter(methodContext.getQueryFilter()));
        return ClassInfos.findByIds(user, string);
    }

    public ClassInfos queryClassInfos(User user, int n, WCMFilter wCMFilter) throws WCMException {
        ClassInfo classInfo = null;
        if (n > 0) {
            classInfo = this.findClassInfoById(n);
        }
        return this.m_oClassInfoMgr.queryChildren(user, classInfo, wCMFilter);
    }

    public ClassInfos queryAnyClassInfos(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        int n = methodContext.getValue("rootId", 0);
        ClassInfo classInfo = ClassInfo.findById(n);
        if (classInfo == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label25", "\u6ca1\u6709\u627e\u5230\u3010Id=") + n + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label26", "\u3011\u7684\u5206\u7c7b"));
        }
        return this.m_oClassInfoMgr.queryAnyClassInfos(user, classInfo, methodContext.getExtraWCMFilter());
    }

    public void deleteClassInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        this.validateRight();
        if (n > 0) {
            this.deleteClassInfo(user, n);
        } else {
            this.deleteClassInfo(user, methodContext.getObjectIds());
        }
    }

    public void deleteClassInfo(User user, int n) throws WCMException {
        ClassInfo classInfo = this.findClassInfoById(n);
        this.m_oClassInfoMgr.deleteClassInfo(user, classInfo);
    }

    public void deleteClassInfo(User user, String string) throws WCMException {
        ClassInfos classInfos = ClassInfos.findByIds(user, string);
        if (classInfos == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label2", "\u6307\u5b9a\u8282\u70b9\u6ca1\u6709\u627e\u5230\uff01"));
        }
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            this.m_oClassInfoMgr.deleteClassInfo(user, classInfo);
        }
    }

    private void validateRight() throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user.isAdministrator()) {
            return;
        }
        String string = ConfigServer.getServer().getSysConfigValue("ClassInfo_Role_Manager", I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label27", "\u5206\u7c7b\u6cd5\u7ef4\u62a4\u4eba\u5458"));
        RoleMgr roleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
        Role role = roleMgr.findRoleByName(string);
        if (role == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label28", "\u4f60\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u5206\u7c7b\u6cd5\u7ef4\u62a4\u4eba\u5458\uff0c\u4e0d\u80fd\u7ef4\u62a4\u5206\u7c7b\u6cd5"));
        }
        RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
        Roles roles = roleUserCacheMgr.getRoles(user, null);
        if (roles.indexOf(role.getId()) >= 0) {
            return;
        }
        throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label28", "\u4f60\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u5206\u7c7b\u6cd5\u7ef4\u62a4\u4eba\u5458\uff0c\u4e0d\u80fd\u7ef4\u62a4\u5206\u7c7b\u6cd5"));
    }

    public ClassInfo saveClassInfo(MethodContext methodContext) throws WCMException {
        this.validateRight();
        String string = "";
        String string2 = "";
        string = methodContext.containsParameter("Name") ? methodContext.getValue("Name") : methodContext.getValue("CName");
        string2 = methodContext.containsParameter("Desc") ? methodContext.getValue("Desc") : methodContext.getValue("CDesc");
        return this.saveClassInfo(methodContext, this.getLoginUser(), methodContext.getObjectId(), methodContext.getValue("ParentId", 0), methodContext.getValue("PreviousId", -2), string, string2, methodContext.getValue("CCode"));
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public ClassInfo saveClassInfo(User user, int n, int n2, int n3, String string, String string2, String string3) throws WCMException {
        ClassInfo classInfo = null;
        if (n2 > 0 && (classInfo = ClassInfo.findById(n2)) == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label4", "\u6307\u5b9a\u7684\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01[Id=") + n2 + "]");
        }
        ClassInfo classInfo2 = null;
        if (n > 0) {
            classInfo2 = ClassInfo.findById(n);
            if (classInfo2 == null) {
                throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label5", "\u6307\u5b9a\u4e3b\u9898\u6ca1\u6709\u627e\u5230\uff01[ID=") + n + "]");
            }
        } else {
            classInfo2 = ClassInfo.createNewInstance();
            classInfo2.setParentId(n2);
            if (classInfo != null) {
                classInfo2.setRootId(classInfo.isRoot() ? classInfo.getId() : classInfo.getRootId());
            } else {
                classInfo2.setRootId(0);
            }
        }
        if (string != null) {
            classInfo2.setName(string);
        }
        if (string2 != null) {
            classInfo2.setDesc(string2);
        }
        if (string3 != null) {
            classInfo2.setCode(string3);
        }
        if (n3 == -1) {
            classInfo2.setOrder(n3);
        } else if (n3 > 0) {
            int n4 = DBManager.getDBManager().sqlExecuteIntQuery("select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?", new int[]{n3});
            classInfo2.setOrder(n4);
        }
        classInfo2.save(user);
        return classInfo2;
    }

    public ClassInfo saveClassInfo(MethodContext methodContext, User user, int n, int n2, int n3, String string, String string2, String string3) throws WCMException {
        ClassInfo classInfo = null;
        if (n2 > 0 && (classInfo = ClassInfo.findById(n2)) == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label4", "\u6307\u5b9a\u7684\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01[Id=") + n2 + "]");
        }
        ClassInfo classInfo2 = null;
        if (n > 0) {
            classInfo2 = ClassInfo.findById(n);
            if (classInfo2 == null) {
                throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label5", "\u6307\u5b9a\u4e3b\u9898\u6ca1\u6709\u627e\u5230\uff01[ID=") + n + "]");
            }
        } else {
            classInfo2 = ClassInfo.createNewInstance();
            classInfo2.setParentId(n2);
            if (classInfo != null) {
                classInfo2.setRootId(classInfo.isRoot() ? classInfo.getId() : classInfo.getRootId());
            } else {
                classInfo2.setRootId(0);
            }
        }
        String[] stringArray = new String[]{"ObjectId"};
        classInfo2 = (ClassInfo)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, classInfo2, stringArray);
        if (string != null) {
            classInfo2.setName(string);
        }
        if (string2 != null) {
            classInfo2.setDesc(string2);
        }
        if (string3 != null) {
            classInfo2.setCode(string3);
        }
        if (n3 == -1) {
            classInfo2.setOrder(n3);
        } else if (n3 > 0) {
            int n4 = DBManager.getDBManager().sqlExecuteIntQuery("select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?", new int[]{n3});
            classInfo2.setOrder(n4);
        }
        classInfo2.save(user);
        return classInfo2;
    }

    private void makeClassInfoHTML(StringBuffer stringBuffer, ClassInfos classInfos) throws WCMException {
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            this.makeClassInfoHTML(stringBuffer, (ClassInfo)classInfos.getAt(i));
        }
    }

    private void makeClassInfoHTML(StringBuffer stringBuffer, ClassInfo classInfo) throws WCMException {
        if (classInfo == null) {
            return;
        }
        this.appendOneClassInfoHTML(stringBuffer, classInfo);
        int n = DBManager.getDBManager().sqlExecuteIntQuery("select CLASSINFOID from XWCMCLASSINFO where ParentId=?", new int[]{classInfo.getId()});
        if (n > 0) {
            stringBuffer.append("<ul></ul>\n");
        }
    }

    private void appendOneClassInfoHTML(StringBuffer stringBuffer, ClassInfo classInfo) throws WCMException {
        int n = DBManager.getDBManager().sqlExecuteIntQuery("select CLASSINFOID from XWCMCLASSINFO where ParentId=?", new int[]{classInfo.getId()});
        boolean bl = false;
        if (n > 0) {
            bl = true;
        }
        stringBuffer.append("<div objectId=");
        stringBuffer.append("'");
        stringBuffer.append(classInfo.getId());
        stringBuffer.append("'");
        stringBuffer.append(" id=");
        stringBuffer.append("'");
        stringBuffer.append("node_");
        stringBuffer.append(classInfo.getId());
        stringBuffer.append("'");
        if (this.m_nNodeType == 1 && bl) {
            stringBuffer.append(" onlyNode='true'");
        }
        stringBuffer.append(" cDesc=");
        stringBuffer.append("'");
        stringBuffer.append(CMyString.transDisplay(classInfo.getDesc()));
        stringBuffer.append("'");
        stringBuffer.append(" cCode=");
        stringBuffer.append("'");
        stringBuffer.append(CMyString.transDisplay(classInfo.getCode()));
        stringBuffer.append("'");
        stringBuffer.append(" title=");
        stringBuffer.append("'");
        stringBuffer.append("ID:");
        stringBuffer.append(classInfo.getId());
        stringBuffer.append("'");
        stringBuffer.append(">");
        stringBuffer.append("<a href=#>");
        stringBuffer.append(CMyString.transDisplay(classInfo.getName()));
        stringBuffer.append("</a></div>");
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        ClassInfo classInfo = null;
        classInfo = n == 0 ? ClassInfo.createNewInstance() : this.findClassInfoById(n);
        return classInfo;
    }

    private ClassInfo findClassInfoById(int n) throws WCMException {
        ClassInfo classInfo = ClassInfo.findById(n);
        if (classInfo == null) {
            throw new WCMException(200006, I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label6", "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=") + n + "]");
        }
        return classInfo;
    }

    public Object exists(MethodContext methodContext) throws WCMException {
        boolean bl;
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        String string = CMyString.showNull(methodContext.getValue("propertyName"), "CName");
        WCMFilter wCMFilter2 = new WCMFilter("XWCMCLASSINFO", string + "=?", "", "ClassInfoID");
        DBManager dBManager = DBManager.getDBManager();
        int n = dBManager.getFieldInfo("XWCMCLASSINFO", string).getDataType().getType();
        boolean bl2 = bl = n == 4 || n == -5 || n == 5 || n == 2 || n == -6;
        if (bl) {
            wCMFilter2.addSearchValues(methodContext.getValue("propertyValue", 0));
        } else {
            wCMFilter2.addSearchValues(methodContext.getValue("propertyValue"));
        }
        int n2 = dBManager.sqlExecuteIntQuery(wCMFilter2.mergeWith(wCMFilter));
        if (n2 > 0) {
            return ClassInfo.findById(n2);
        }
        return null;
    }

    public String getPath(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("objectId", 0);
        if (n == 0) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label7", "\u6ca1\u6709\u6307\u5b9a\u5206\u7c7b\u6cd5ID"));
        }
        ClassInfo classInfo = ClassInfo.findById(n);
        if (classInfo == null) {
            throw new WCMException(200006, I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label6", "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=") + n + "]");
        }
        return this.m_oClassInfoMgr.getPath(classInfo);
    }

    public Reports importClassInfos(MethodContext methodContext) throws Exception {
        String string = methodContext.getValue("importFile");
        Reports reports = new Reports(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label9", "\u5bfc\u5165\u5206\u7c7b\u6cd5"));
        this.validateRight();
        String string2 = CMyFile.extractFileExt(string);
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            reports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label10", "\u53c2\u6570[ImportFile=") + string + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label11", "]\u4e0d\u6b63\u786e\uff01\u6ca1\u6709\u540e\u7f00\u540d"), null);
            return reports;
        }
        string2 = string2.toUpperCase();
        String string3 = this.getAbsoluteFileName(string);
        if (string2.equals("TXT")) {
            this.importFromTXT(string3, reports, methodContext, false);
        } else if (string2.equals("ZIP")) {
            this.importFromZIP(string3, reports, methodContext);
        } else if (string2.equals("XML")) {
            this.importClassInfosFromXML(string3, reports, methodContext);
        } else {
            reports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label10", "\u53c2\u6570[ImportFile=") + string + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label12", "]\u540e\u7f00\u4e0d\u6b63\u786e\uff01\u4e0d\u662f.zip\u540e\u7f00\u540d"), null);
            return reports;
        }
        return reports;
    }

    private void importFromTXT(String string, Reports reports, MethodContext methodContext, boolean bl) throws Exception {
        boolean bl2 = methodContext.getValue("ContainCode", true);
        int n = methodContext.getValue("importType", 0);
        String string2 = null;
        if (!bl) {
            String string3 = methodContext.getValue("RealFileName");
            string2 = CMyFile.extractMainFileName(string3);
        } else {
            string2 = CMyFile.extractMainFileName(string);
        }
        boolean bl3 = false;
        ClassInfoUtil classInfoUtil = new ClassInfoUtil();
        try {
            bl3 = classInfoUtil.importClassInfos(string2, string, bl2, n);
            if (bl3) {
                reports.addSucessedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label13", "\u6210\u529f\u5bfc\u5165\u5206\u7c7b\u6cd5\uff1a") + string2);
            } else {
                String string4 = I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label14", "\u5bfc\u5165\u7684\u5206\u7c7b\u6cd5[") + string2 + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label15", "]\u51fa\u73b0\u91cd\u590d\uff0c\u5df2\u8df3\u8fc7");
                reports.addFailedReport(string4, new Exception(string4));
            }
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label16", "\u5bfc\u5165\u5206\u7c7b\u6cd5[") + string2 + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label17", "]\u5931\u8d25"), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importFromZIP(String string, Reports reports, MethodContext methodContext) {
        User user = this.getLoginUser();
        String string2 = CMyFile.extractFilePath(string);
        string2 = string2 + "temp" + System.currentTimeMillis() + File.separator;
        int n = methodContext.getValue("importType", 0);
        try {
            try {
                ArrayList arrayList;
                block10: {
                    block9: {
                        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, string2);
                        cMyUnZipFile.setFileNameEncoding("GBK");
                        cMyUnZipFile.addFileExtFilters("TXT");
                        cMyUnZipFile.addFileExtFilters("XML");
                        cMyUnZipFile.doUnZipAnd();
                        arrayList = cMyUnZipFile.getFilteredFiles();
                        if (arrayList == null) break block9;
                        if (!arrayList.isEmpty()) break block10;
                    }
                    Object var13_11 = null;
                    if (string2 == null) return;
                    CMyFile.deleteDir(string2);
                    return;
                }
                try {
                    String string3 = null;
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        string3 = (String)arrayList.get(i);
                        if (string3.endsWith("txt")) {
                            this.importFromTXT(string3, reports, methodContext, true);
                            continue;
                        }
                        ClassInfoImporter classInfoImporter = new ClassInfoImporter(user);
                        classInfoImporter.importFromXML(string3, n);
                        reports.merge(classInfoImporter.getReports());
                    }
                }
                catch (CMyException cMyException) {
                    reports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label18", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25![File=") + string + ",DstPath=" + string2 + "]", cMyException);
                }
                Object var13_12 = null;
                if (string2 == null) return;
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label19", "\u5bfc\u5165\u5206\u7c7b\u6cd5\u5931\u8d25!"), exception);
                Object var13_13 = null;
                if (string2 == null) return;
                CMyFile.deleteDir(string2);
                return;
            }
            CMyFile.deleteDir(string2);
            return;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (string2 == null) throw throwable;
            CMyFile.deleteDir(string2);
            throw throwable;
        }
    }

    private String getAbsoluteFileName(String string) throws WCMException {
        String string2 = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String[] stringArray = new String[]{"U0", "ST"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!FilesMan.isValidFile(string, stringArray[i])) continue;
            string2 = filesMan.mapFilePath(string, 0) + string;
            break;
        }
        if (string2 == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label20", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string + "]");
        }
        if (!CMyFile.fileExists(string2)) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label20", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string2 + "]");
        }
        return string2;
    }

    public void changeOrder(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("SrcObjectId", 0);
        ClassInfo classInfo = this.findClassInfoById(n);
        int n2 = methodContext.getValue("DstObjectId", 0);
        ClassInfo classInfo2 = null;
        if (n2 > 0) {
            classInfo2 = this.findClassInfoById(n2);
        }
        int n3 = classInfo2 == null ? -1 : classInfo2.getOrder();
        classInfo.setOrder(n3);
        classInfo.save(user);
    }

    public void moveAsChild(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("SrcObjectId", 0);
        ClassInfo classInfo = this.findClassInfoById(n);
        int n2 = methodContext.getValue("DstObjectId", 0);
        ClassInfo classInfo2 = this.findClassInfoById(n2);
        if (classInfo.getParentId() == n2) {
            return;
        }
        if (classInfo.getRootId() != classInfo2.getRootId()) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label21", "\u5206\u7c7b\u8282\u70b9[") + n + "," + n2 + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label22", "]\u4e0d\u5728\u4e00\u68f5\u5206\u7c7b\u6811\u4e0a\uff0c\u4e0d\u80fd\u79fb\u52a8"));
        }
        if (this.m_oClassInfoMgr.isAncestor(n, n2)) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label21", "\u5206\u7c7b\u8282\u70b9[") + n + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label23", "]\u4e3a\u8282\u70b9[") + n2 + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label24", "]\u7684\u7956\u5148\u8282\u70b9\uff0c\u4e0d\u80fd\u79fb\u52a8"));
        }
        classInfo.setParentId(n2);
        int n3 = ClassInfo.getMaxOrder(n2);
        classInfo.refreshProperty("ClassOrder", n3);
        classInfo.setOrder(1);
        classInfo.save(user);
    }

    public String exportClassInfos(MethodContext methodContext) throws WCMException {
        this.validateRight();
        User user = this.getLoginUser();
        String string = methodContext.getValue("ClassInfoIds");
        ClassInfos classInfos = null;
        classInfos = CMyString.isEmpty(string) ? ClassInfos.openWCMObjs(user, null) : ClassInfos.findByIds(user, string);
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFilePathName("ST", "xml");
        ClassInfoXMLConvertor classInfoXMLConvertor = new ClassInfoXMLConvertor();
        classInfoXMLConvertor.toXMLFile(classInfos, string2);
        return CMyFile.extractFileName(string2);
    }

    private void importClassInfosFromXML(String string, Reports reports, MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        try {
            String string2 = methodContext.getValue("ImportFile");
            int n = methodContext.getValue("importType", 0);
            ClassInfoImporter classInfoImporter = new ClassInfoImporter(user);
            classInfoImporter.importFromXML(string2, n);
            reports.merge(classInfoImporter.getReports());
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label19", "\u5bfc\u5165\u5206\u7c7b\u6cd5\u5931\u8d25!"), exception);
        }
    }
}

