/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relation;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import java.util.HashMap;

public class WCMTagParserRelNewsForViewData
implements ITagParser,
ITagParser4List {
    private TagItem m_tagItem = null;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    private int m_nCurrDocId = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static NamesRegister s_oNameRegister = new NamesRegister();
    private static TagBeanInfo s_TagBeanInfo;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_RELNEWS");
            tagBeanInfo.setDesc("TRS_RELNEWS");
            tagBeanInfo.setType(TagBeanInfo.BodyType.TAMPLATE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_blank");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MODE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"USERDEF", "KEYWORDS", "ALL"});
            tagBeanAttrInfo.setDefaultValue("USERDEF");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MULTISITE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHNLID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_contents != null) {
            this.m_contents.clear();
        }
        if (this.m_nextRecordContext != null) {
            this.m_nextRecordContext = null;
        }
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        Documents documents = this.getDocuments(publishTagContext);
        this.m_contents = new PublishElementsCMSObjsImpl(documents);
        if (this.m_contents == null || this.m_contents.isEmpty()) {
            return null;
        }
        this.m_nextRecordContext = new PublishTagContext(publishTagContext, this.m_tagItem, this);
        String[] stringArray = TagParseHelper.parse4List(this.m_tagItem, publishTagContext, this);
        return stringArray;
    }

    private Documents getDocuments(PublishTagContext publishTagContext) throws WCMException {
        Document document = null;
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (!(iPublishElement instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMTagParserRelNewsForViewData.class, "WCMTagParserRelNewsForViewData.label1", "TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u5f53\u524d\u5bf9\u8c61\u662f[") + iPublishElement.getInfo() + "]");
        }
        String string = publishTagContext.getAttribute("ID");
        if (!CMyString.isEmpty(string)) {
            MetaViewData metaViewData = this.findViewData(publishTagContext);
            if (metaViewData == null) {
                return Documents.createNewInstance(null);
            }
            Documents documents = Documents.findByIds(null, metaViewData.getPropertyAsString(string));
            this.excludeInvalidDocuments(documents);
            return documents;
        }
        try {
            document = (Document)iPublishElement.getSubstance();
        }
        catch (ClassCastException classCastException) {
            throw new WCMException(I18NMessage.get(WCMTagParserRelNewsForViewData.class, "WCMTagParserRelNewsForViewData.label2", "TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u76f8\u5173\u5bf9\u8c61\u662f\uff1a[") + iPublishElement.getSubstance() + "]", classCastException);
        }
        this.m_nCurrDocId = document.getDocId();
        String string2 = publishTagContext.getAttribute("MODE");
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            string2 = "USERDEF";
        }
        int n = s_oNameRegister.lookup(string2.toUpperCase(), 30);
        boolean bl = publishTagContext.getAttribute("MULTISITE", false);
        String string3 = publishTagContext.getAttribute("CHNLID");
        int n2 = 0;
        if ("SELF".equalsIgnoreCase(string3)) {
            n2 = document.getChannelId();
        } else if (!CMyString.isEmpty(string3)) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                n2 = 0;
            }
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        WCMFilter wCMFilter = new WCMFilter("", "DocStatus=10 and DocChannel>0", "");
        Documents documents = documentMgr.getRelatedDocuments(document, n, wCMFilter, true, bl);
        if (n2 != 0) {
            for (int i = documents.size() - 1; i >= 0; --i) {
                Document document2 = (Document)documents.getAt(i);
                if (document2.getChannelId() == n2) continue;
                documents.removeAt(i, false);
            }
        }
        return documents;
    }

    private void excludeInvalidDocuments(Documents documents) throws WCMException {
        if (documents == null) {
            return;
        }
        for (int i = documents.size() - 1; i >= 0; --i) {
            Document document = (Document)documents.getAt(i);
            if (document != null && !document.isDeleted()) continue;
            documents.removeAt(i, false);
        }
    }

    public int getRecordSize() {
        return this.m_contents == null ? 0 : this.m_contents.size();
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            WCMFilter wCMFilter = new WCMFilter("", "RelDocId=?", "SERN");
            wCMFilter.addSearchValues(iPublishContent.getId());
            WCMFilter wCMFilter2 = new WCMFilter("", "DocId=?", "SERN");
            wCMFilter2.addSearchValues(this.m_nCurrDocId);
            wCMFilter.mergeWith(wCMFilter2);
            RelationMgr relationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
            Relations relations = relationMgr.getRelations(wCMFilter);
            if (relations.size() > 0) {
                Relation relation = (Relation)relations.getAt(0);
                int n = relation.getPropertyAsInt("CHANNELID", 0);
                if (Channel.findById(n) != null) {
                    IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(101, n);
                    iPublishContent.setFolder(iPublishFolder);
                } else {
                    iPublishContent.setFolder(iPublishContent.getOriginalHome());
                }
            } else {
                iPublishContent.setFolder(iPublishContent.getOriginalHome());
            }
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(iPublishContent);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    public PublishTagContext substantiateContext(PublishTagContext publishTagContext) throws WCMException {
        try {
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            iPublishContent.setFolder(iPublishContent.getOriginalHome());
            publishTagContext.setSequenceNumber(this.m_nCurrNumber++);
            publishTagContext.setUpperHost(iPublishContent);
            return publishTagContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    private MetaViewData findViewData(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        CMSObj cMSObj = iPublishElement.getSubstance();
        if (cMSObj instanceof MetaViewData) {
            return (MetaViewData)cMSObj;
        }
        if (cMSObj instanceof Document) {
            MetaView metaView = this.getMetaViewCachedByTagContext(publishTagContext, (Document)cMSObj);
            return this.getViewDataCachedByTagContext(publishTagContext, cMSObj, metaView);
        }
        throw new WCMException(I18NMessage.get(WCMTagParserRelNewsForViewData.class, "WCMTagParserRelNewsForViewData.label3", "TRS_ViewData\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u5f53\u524d\u573a\u666f\u4e0b\uff01[UpperHost=") + cMSObj.getClassName(true) + "]");
    }

    private MetaView getMetaViewCachedByTagContext(PublishTagContext publishTagContext, Document document) throws WCMException {
        String string;
        MetaView metaView;
        HashMap<String, MetaView> hashMap = publishTagContext.getExtraAttributes();
        if (hashMap == null) {
            hashMap = new HashMap<String, MetaView>(1);
            publishTagContext.setExtraAttributes(hashMap);
        }
        if ((metaView = (MetaView)hashMap.get(string = "Curr.View." + document.getId())) == null) {
            metaView = MetaView.findById(document.getKindId());
            if (metaView == null) {
                throw new WCMException(I18NMessage.get(WCMTagParserRelNewsForViewData.class, "WCMTagParserRelNewsForViewData.label4", "\u5f53\u524d\u6587\u6863\u5173\u8054\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[DocId=") + document.getId() + ",ViewId=" + document.getKindId() + "]");
            }
            hashMap.put(string, metaView);
        }
        return metaView;
    }

    private MetaViewData getViewDataCachedByTagContext(PublishTagContext publishTagContext, CMSObj cMSObj, MetaView metaView) throws WCMException {
        String string;
        MetaViewData metaViewData;
        HashMap<String, MetaViewData> hashMap = publishTagContext.getExtraAttributes();
        if (hashMap == null) {
            hashMap = new HashMap<String, MetaViewData>(1);
            publishTagContext.setExtraAttributes(hashMap);
        }
        if ((metaViewData = (MetaViewData)hashMap.get(string = "Curr.ViewData." + cMSObj.getId())) != null) {
            return metaViewData;
        }
        metaViewData = new MetaViewData(metaView);
        metaViewData.loadById(cMSObj.getId(), "");
        hashMap.put(string, metaViewData);
        return metaViewData;
    }

    static {
        s_oNameRegister.register("USERDEF", 30);
        s_oNameRegister.register("RELWORDS", 20);
        s_oNameRegister.register("KEYWORDS", 10);
        s_oNameRegister.register("ALL", 0);
        s_TagBeanInfo = null;
    }
}

