/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;

public class WCMTagParserClassInfos
extends BaseTagParser
implements ITagParser4List {
    private ClassInfo m_oCurrClassInfo = null;
    protected IPublishFolder m_oCurrFolder;
    private IPublishElements m_oPublishClassElements;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private IPublishFolder m_oRoot = null;
    private IPublishElement m_oUpperHost = null;

    protected CMSBaseObjs findObjects(PublishTagContext publishTagContext) throws WCMException {
        this.makeCurrClassInfo(publishTagContext);
        boolean bl = publishTagContext.getAttribute("ReturnBottom", false);
        ClassInfos classInfos = null;
        String string = publishTagContext.getAttribute("parent");
        if (!CMyString.isEmpty(string) && string.equalsIgnoreCase("true")) {
            this.m_oCurrClassInfo = this.m_oCurrClassInfo.getParent();
        }
        classInfos = this.m_oCurrClassInfo != null ? this.m_oCurrClassInfo.getChildren(true) : ClassInfo.findRootClassInfos(true);
        if (!bl) {
            return classInfos;
        }
        ClassInfos classInfos2 = new ClassInfos(null);
        this.findBottomClassInfo(classInfos, classInfos2);
        return classInfos2;
    }

    private void findBottomClassInfo(ClassInfos classInfos, ClassInfos classInfos2) throws WCMException {
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            ClassInfos classInfos3 = classInfo.getChildren(true);
            if (classInfos3 == null || classInfos3.isEmpty()) {
                classInfos2.addElement(classInfo);
                continue;
            }
            this.findBottomClassInfo(classInfos3, classInfos2);
        }
    }

    protected boolean isValidate(PublishTagContext publishTagContext) throws WCMException {
        this.makeCurrClassInfo(publishTagContext);
        return true;
    }

    private void makeCurrClassInfo(PublishTagContext publishTagContext) throws WCMException {
        if (this.m_oCurrClassInfo != null) {
            return;
        }
        String string = publishTagContext.getAttribute("Id");
        if (string != null && (string = string.trim()).length() > 0) {
            int n = -1;
            try {
                n = Integer.parseInt(string);
                this.m_oCurrClassInfo = ClassInfo.findById(n);
                if (this.m_oCurrClassInfo == null) {
                    throw new WCMException(I18NMessage.get(WCMTagParserClassInfos.class, "WCMTagParserClassInfos.label1", "\u6307\u5b9a\u7684ClassInfo\u4e0d\u5b58\u5728\uff01[ID=") + n + "]");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == -1) {
                WCMFilter wCMFilter = new WCMFilter("", "CName=?", "");
                wCMFilter.addSearchValues(string);
                ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
                if (classInfos.isEmpty()) {
                    throw new WCMException(I18NMessage.get(WCMTagParserClassInfos.class, "WCMTagParserClassInfos.label2", "\u6307\u5b9a\u7684ClassInfo\u4e0d\u5b58\u5728\uff01[Name=") + string + "]");
                }
                this.m_oCurrClassInfo = ClassInfo.findByName(string);
            }
            return;
        }
        String string2 = publishTagContext.getAttribute("ClassInfoName");
        if (!CMyString.isEmpty(string2)) {
            this.m_oCurrClassInfo = ClassInfo.findByName(string2);
            return;
        }
        if (publishTagContext.getUpperHost().getSubstance() instanceof ClassInfo) {
            this.m_oCurrClassInfo = (ClassInfo)publishTagContext.getUpperHost().getSubstance();
        }
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        String string;
        if (!publishTagContext.getTagItem().hasChildren()) {
            return null;
        }
        if (!this.isValidate(publishTagContext)) {
            return null;
        }
        this.m_oRoot = publishTagContext.getRoot();
        this.m_oUpperHost = publishTagContext.getUpperHost();
        if (this.m_oUpperHost instanceof PublishFolderClassImpl) {
            this.m_oUpperHost = ((PublishFolderClassImpl)this.m_oUpperHost).getHost();
        }
        CMSBaseObjs cMSBaseObjs = this.findObjects(publishTagContext);
        this.m_oPublishClassElements = PublishElementFactory.makeElementsFrom(cMSBaseObjs);
        this.m_nextRecordContext = new PublishTagContext(publishTagContext, publishTagContext.getTagItem(), this);
        String[] stringArray = TagParseHelper.parse4List(publishTagContext.getTagItem(), publishTagContext, this);
        if (stringArray != null && stringArray.length == 1 && publishTagContext.getAttribute("AUTOMORE", false) && (string = this.parseAutoMore(this.m_oCurrFolder, publishTagContext)) != null) {
            stringArray[0] = stringArray[0] + string;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseAutoMore(IPublishFolder iPublishFolder, PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("BEGINMORE");
        String string2 = publishTagContext.getAttribute("ENDMORE");
        String string3 = publishTagContext.getAttribute("MORETEXT");
        String string4 = publishTagContext.getAttribute("MORETARGET");
        String string5 = publishTagContext.getAttribute("MOREEXTRA");
        if (string3 == null || (string3 = string3.trim()).length() == 0) {
            string3 = I18NMessage.get(WCMTagParserClassInfos.class, "WCMTagParserClassInfos.label3", "\u66f4\u591a\u5185\u5bb9...");
        }
        if (string4 == null || (string4 = string4.trim()).length() == 0) {
            string4 = "_blank";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string6 = publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishFolder);
            string6 = HtmlUtil.calRelativePath(string6, publishTagContext.getPageHttpPath());
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append("<A href=\"").append(string6);
            stringBuffer.append("\" target=\"").append(string4).append("\" ");
            if (string5 != null) {
                stringBuffer.append(string5);
            }
            stringBuffer.append('>').append(string3).append("</A>");
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            }
            String string7 = stringBuffer.toString();
            Object var12_11 = null;
            stringBuffer.setLength(0);
            return string7;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            stringBuffer.setLength(0);
            throw throwable;
        }
    }

    public int getRecordSize() {
        return this.getObjectsSize();
    }

    private int getObjectsSize() {
        return this.m_oPublishClassElements.size();
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            PublishFolderClassImpl publishFolderClassImpl = (PublishFolderClassImpl)this.m_oPublishClassElements.get(this.m_nCurrPos++);
            if (publishFolderClassImpl == null) {
                return this.getNextRecordContext();
            }
            publishFolderClassImpl.setRoot(this.m_oRoot);
            publishFolderClassImpl.setHost(this.m_oUpperHost);
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(publishFolderClassImpl);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    public PublishTagContext substantiateContext(PublishTagContext publishTagContext) throws WCMException {
        try {
            PublishFolderClassImpl publishFolderClassImpl = (PublishFolderClassImpl)this.m_oPublishClassElements.get(this.m_nCurrPos++);
            if (publishFolderClassImpl == null) {
                return this.substantiateContext(publishTagContext);
            }
            publishFolderClassImpl.setRoot(this.m_oRoot);
            publishFolderClassImpl.setHost(this.m_oUpperHost);
            publishTagContext.setSequenceNumber(this.m_nCurrNumber++);
            publishTagContext.setUpperHost(publishFolderClassImpl);
            return publishTagContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }
}

