/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParserFolderBase;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.publish.IClassInfoCountCacheForPublish;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class WCMTagParserClassInfo
extends TagParserFolderBase {
    private static Logger logger = Logger.getLogger(TagParserFolderBase.class);
    private static final int DATA_COUNT = 1;
    private static final int FULL_PATH = 2;

    protected String[] parseHostSpecialProperty(int n, PublishTagContext publishTagContext) {
        if (this.m_host == null || !(this.m_host instanceof ClassInfo)) {
            return null;
        }
        switch (n) {
            case 1: {
                return this.queryDataCount(publishTagContext);
            }
            case 2: {
                return this.getFullPath(publishTagContext);
            }
        }
        return null;
    }

    private String[] getFullPath(PublishTagContext publishTagContext) {
        ClassInfo classInfo = (ClassInfo)this.m_host;
        String string = CMyString.showNull(publishTagContext.getAttribute("class"));
        String string2 = CMyString.showNull(publishTagContext.getAttribute("target"), "_self");
        String string3 = CMyString.showNull(publishTagContext.getAttribute("DELIM"), "&nbsp;&gt;&nbsp;");
        boolean bl = publishTagContext.getAttribute("autolink", true);
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            String string4 = this.getAutoLinkUrl(publishTagContext);
            while (classInfo != null) {
                StringBuffer stringBuffer2 = new StringBuffer(50);
                if (bl) {
                    stringBuffer2.append("<span class='");
                    stringBuffer2.append(string);
                    stringBuffer2.append("'>");
                    stringBuffer2.append("<a href='");
                    stringBuffer2.append(string4);
                    stringBuffer2.append("' target='");
                    stringBuffer2.append(string2);
                    stringBuffer2.append("'>");
                    stringBuffer2.append(classInfo.getName());
                    stringBuffer2.append("</a>");
                    stringBuffer2.append("</span>");
                } else {
                    stringBuffer2.append("<span class='");
                    stringBuffer2.append(string);
                    stringBuffer2.append("'>");
                    stringBuffer2.append(classInfo.getName());
                    stringBuffer2.append("</span>");
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.insert(0, string3);
                }
                stringBuffer.insert(0, stringBuffer2);
                string4 = this.subtractURL(string4);
                classInfo = ClassInfo.findById(classInfo.getParentId());
            }
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label1", "\u83b7\u53d6\u6307\u5b9a\u5206\u7c7b\u7684\u8def\u5f84\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)exception);
        }
        return new String[]{stringBuffer.toString()};
    }

    private String subtractURL(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf("/", n - 1);
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2) + string.substring(n);
    }

    private String[] queryDataCount(PublishTagContext publishTagContext) {
        ClassInfo classInfo = (ClassInfo)this.m_host;
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement instanceof PublishFolderClassImpl) {
            iPublishElement = ((PublishFolderClassImpl)iPublishElement).getHost();
        }
        CMSObj cMSObj = iPublishElement.getSubstance();
        int n = 0;
        if (cMSObj instanceof Channel) {
            n = ((Channel)cMSObj).getId();
        }
        try {
            String string = "IClassInfoCountCacheForPublish";
            IClassInfoCountCacheForPublish iClassInfoCountCacheForPublish = (IClassInfoCountCacheForPublish)publishTagContext.getPageContext().getTaskContext().getCachObject(string);
            if (iClassInfoCountCacheForPublish == null) {
                iClassInfoCountCacheForPublish = (IClassInfoCountCacheForPublish)DreamFactory.createObjectById(string);
                publishTagContext.getPageContext().getTaskContext().putInCache(string, iClassInfoCountCacheForPublish);
            }
            int n2 = 0;
            String string2 = publishTagContext.getAttribute("where");
            if (n == 0) {
                if (CMyString.isEmpty(publishTagContext.getAttribute("where"))) {
                    n2 = iClassInfoCountCacheForPublish.getClassInfoDataCountOfSite(publishTagContext.getRoot().getId(), classInfo.getId());
                } else {
                    String[] stringArray = string2.split(":");
                    if (stringArray.length == 2 && "CHNLID".equals(stringArray[0].toUpperCase())) {
                        try {
                            n2 = iClassInfoCountCacheForPublish.getClassInfoDataCountOfSite(publishTagContext.getRoot().getId(), classInfo.getId(), Integer.parseInt(stringArray[1]));
                        }
                        catch (Exception exception) {
                            throw new WCMException(I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label5", "\u83b7\u53d6\u6307\u5b9a\u680f\u76eeID\u4e0d\u662f\u6570\u5b57\u7ec4\u6210!"));
                        }
                    }
                }
            } else {
                n2 = iClassInfoCountCacheForPublish.getClassInfoDataCountOfChannel(n, classInfo.getId());
            }
            return new String[]{String.valueOf(n2)};
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label2", "\u83b7\u53d6\u6307\u5b9a\u5206\u7c7b\u7684\u6587\u6863\u6570\u76ee\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)exception);
            return null;
        }
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("DATACOUNT", 1);
        this.registerHostSpecialProperty("FullPath", 2);
    }

    public TagBeanInfo getBeanInfo() {
        return null;
    }

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        int n = publishTagContext.getAttribute("ID", 0);
        String string = publishTagContext.getAttribute("parent");
        if (n > 0) {
            ClassInfo classInfo = ClassInfo.findById(n);
            if (!CMyString.isEmpty(string) && string.equalsIgnoreCase("true")) {
                return classInfo.getParent();
            }
            return classInfo;
        }
        String string2 = publishTagContext.getAttribute("ClassInfoName");
        if (!CMyString.isEmpty(string2)) {
            ClassInfo classInfo = ClassInfo.findByName(string2);
            if (!CMyString.isEmpty(string) && string.equalsIgnoreCase("true")) {
                return classInfo.getParent();
            }
            return classInfo;
        }
        CMSObj cMSObj = super.findHost(publishTagContext);
        if (cMSObj instanceof ClassInfo) {
            if (!CMyString.isEmpty(string) && string.equalsIgnoreCase("true")) {
                ClassInfo classInfo = (ClassInfo)cMSObj;
                return classInfo.getParent();
            }
            return cMSObj;
        }
        if (cMSObj instanceof MetaViewField) {
            MetaViewField metaViewField = (MetaViewField)cMSObj;
            ClassInfo classInfo = ClassInfo.findById(metaViewField.getClassId());
            if (classInfo == null) {
                throw new WCMException(I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label3", "\u6307\u5b9a\u7684\u5206\u7c7b\u6cd5\u4e0d\u5b58\u5728\uff01[ClassId=") + metaViewField.getClassId() + "]");
            }
            return classInfo;
        }
        throw new WCMException(I18NMessage.get(WCMTagParserClassInfo.class, "WCMTagParserClassInfo.label4", "\u4e0d\u652f\u6301\u7684\u4f7f\u7528\u573a\u666f\uff01[Class=") + cMSObj.getClass() + "]");
    }

    protected String getAutoLinkUrl(PublishTagContext publishTagContext) throws WCMException {
        Object object;
        PublishFolderClassImpl publishFolderClassImpl = (PublishFolderClassImpl)PublishElementFactory.makeElementFrom(this.m_host);
        publishFolderClassImpl.setRoot(publishTagContext.getRoot());
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement instanceof PublishFolderClassImpl) {
            iPublishElement = ((PublishFolderClassImpl)iPublishElement).getHost();
        }
        publishFolderClassImpl.setHost(iPublishElement);
        if (publishFolderClassImpl.isLink()) {
            return publishFolderClassImpl.getLinkUrl();
        }
        Template template = null;
        String string = publishTagContext.getAttributeTrim("TemplateName");
        if (string != null && string.length() > 0) {
            object = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
            template = ((TemplateCacheMgr)object).lookupByName(publishFolderClassImpl.getRoot(), string);
        }
        if (template == null && publishTagContext.getPageElement() instanceof PublishFolderClassImpl) {
            template = publishTagContext.getPageContext().getTemplate();
        }
        object = "";
        if (template != null) {
            object = template.getOutputFileName();
            boolean bl = ConfigServer.getServer().getSysConfigValue("NAME_BY_TEMPLATE_FILE", "false").equalsIgnoreCase("true");
            boolean bl2 = "true".equalsIgnoreCase(publishTagContext.getAttribute("OnlyTemplateName"));
            if (!bl2 && !bl) {
                object = (String)object + "_" + template.getId();
            }
            object = (String)object + "." + template.getOutputFileExt();
        }
        return CMyString.setStrEndWith(publishTagContext.getPathCompass().getAbsoluteHttpPath(publishFolderClassImpl), '/') + (String)object;
    }
}

