/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.xml;

import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverterByDOM4j;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.Reports;

public class ClassInfoImporter {
    private User m_oCurrUser = null;
    private Reports m_reports = new Reports("");

    public ClassInfoImporter(User user) {
        this.m_oCurrUser = user;
    }

    public Reports getReports() {
        return this.m_reports;
    }

    public void importFromXML(String string, int n) throws WCMException {
        Object object;
        String string2 = string;
        if (!CMyFile.fileExists(string2)) {
            object = FilesMan.getFilesMan();
            string2 = ((FilesMan)object).mapFilePath(string, 0) + string;
        }
        if (!CMyFile.fileExists(string2)) {
            throw new WCMException(I18NMessage.get(ClassInfoImporter.class, "ClassInfoImporter.label1", "\u5b9a\u4e49\u5206\u7c7b\u6cd5\u4fe1\u606f\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[") + string + "][" + string2 + "]");
        }
        object = new XmlToObjConverterByDOM4j(1);
        ((XmlToObjConverterByDOM4j)object).registPersistentObj("XWCMCLASSINFO", ClassInfo.class);
        XmlObject[] xmlObjectArray = ((XmlToObjConverterByDOM4j)object).convertXml(string2, null, null);
        int n2 = 0;
        ClassInfo classInfo = null;
        this.processClassInfos(n2, classInfo, xmlObjectArray, n);
    }

    private void processClassInfos(int n, ClassInfo classInfo, XmlObject[] xmlObjectArray, int n2) throws WCMException {
        int n3 = classInfo == null ? 0 : classInfo.getId();
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            XmlObject xmlObject = xmlObjectArray[i];
            ClassInfo classInfo2 = (ClassInfo)xmlObject.getCurrentObj();
            String string = classInfo2.getName();
            ClassInfo classInfo3 = this.findClassInfoByName(n, n3, string);
            boolean bl = false;
            if (classInfo3 == null || classInfo3 != null && n2 == 2) {
                classInfo2.removeProperty("CLASSINFOID");
                classInfo2.removeProperty("CRUSER");
                classInfo2.removeProperty("CRTIME");
                classInfo2.setRootId(n);
                classInfo2.setParentId(n3);
                classInfo2.save(this.m_oCurrUser);
            } else if (n2 == 0) {
                classInfo2 = classInfo3;
                if (classInfo3.getParentId() == 0) {
                    bl = true;
                    this.m_reports.addSucessedReport(I18NMessage.get(ClassInfoImporter.class, "ClassInfoImporter.label2", "\u8df3\u8fc7\u5206\u7c7b\u6cd5\uff1a") + classInfo2.getName());
                }
            } else if (n2 == 1) {
                try {
                    int n4 = classInfo3.getId();
                    classInfo3.setProperty("CRUSER", this.m_oCurrUser.getName());
                    classInfo3.setProperty("CRTIME", CMyDateTime.now());
                    classInfo3.save(this.m_oCurrUser);
                    if (classInfo3.getParentId() == 0) {
                        String string2 = "delete from XWCMClassInfo where RootId=" + n4;
                        DBManager.getDBManager().sqlExecuteUpdate(string2);
                    }
                    classInfo2 = classInfo3;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (classInfo2.getParentId() == 0 && !bl) {
                this.m_reports.addSucessedReport(I18NMessage.get(ClassInfoImporter.class, "ClassInfoImporter.label3", "\u6210\u529f\u5bfc\u5165\u5206\u7c7b\u6cd5\uff1a") + classInfo2.getName());
            }
            XmlObject[] xmlObjectArray2 = xmlObject.getChild("XWCMCLASSINFOS");
            int n5 = n == 0 ? classInfo2.getId() : n;
            this.processClassInfos(n5, classInfo2, xmlObjectArray2, n2);
        }
    }

    private ClassInfo findClassInfoByName(int n, int n2, String string) throws WCMException {
        String string2 = "RootId=? and ParentId=? and  CName=?";
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        wCMFilter.addSearchValues(string);
        ClassInfos classInfos = ClassInfos.openWCMObjs(this.m_oCurrUser, wCMFilter);
        if (classInfos != null && !classInfos.isEmpty()) {
            return (ClassInfo)classInfos.getAt(0);
        }
        return null;
    }
}

