/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.definition.MetaViewFieldGroups;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;

public class MetaViewFieldGroup
extends CMSObj {
    public static final int OBJ_TYPE = 2093442339;
    public static final String DB_TABLE_NAME = "XWCMMETAVIEWFIELDGROUP";
    public static final String DB_ID_NAME = "METAVIEWFIELDGROUPID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 2093442339;
    }

    public String getGroupName() {
        return this.getPropertyAsString("GROUPNAME");
    }

    public boolean setGroupName(String string) throws WCMException {
        return this.setProperty("GROUPNAME", string);
    }

    public int getMetaViewId() {
        return this.getPropertyAsInt("METAVIEWID", 0);
    }

    public boolean setMetaViewId(int n) throws WCMException {
        return this.setProperty("METAVIEWID", n);
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public boolean setParentId(int n) throws WCMException {
        return this.setProperty("PARENTID", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("GROUPORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("GROUPORDER", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("GROUPNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewFieldGroup.class, "MetaViewFieldGroup.label1", "\u5c5e\u6027GroupName\u6ca1\u6709\u8bbe\u7f6e(MetaViewFieldGroup.isValid)"));
            }
            if (this.getProperty("METAVIEWID") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewFieldGroup.class, "MetaViewFieldGroup.label2", "\u5c5e\u6027MetaViewId\u6ca1\u6709\u8bbe\u7f6e(MetaViewFieldGroup.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(MetaViewFieldGroup.class, "MetaViewFieldGroup.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MetaViewFieldGroup.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
                this.setOrder(n2);
                return;
            }
            n5 = 1;
            n4 = n;
            n3 = n2;
        } else {
            if (!this.isChangeProperty("GROUPORDER")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("GROUPORDER", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (this.isChangeProperty("PARENTID")) {
                    n2 = n + 1;
                } else if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = --n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "GROUPORDER>=" + n3 + " AND GROUPORDER <= " + n4 + " and METAVIEWID=" + this.getMetaViewId();
        String string2 = "UPDATE XWCMMETAVIEWFIELDGROUP SET GROUPORDER = GROUPORDER+(" + n5 + ") WHERE " + string;
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        this.setOrder(n2);
    }

    private int getMaxOrder() throws WCMException {
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(GROUPORDER) from XWCMMETAVIEWFIELDGROUP where METAVIEWID=?", new int[]{this.getMetaViewId()});
    }

    public static final MetaViewFieldGroup findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (MetaViewFieldGroup)BaseObj.findById(MetaViewFieldGroup.class, n);
    }

    public static final MetaViewFieldGroups findByName(int n, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "METAVIEWID=? AND GROUPNAME =?", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        MetaViewFieldGroups metaViewFieldGroups = MetaViewFieldGroups.openWCMObjs(null, wCMFilter);
        return metaViewFieldGroups;
    }

    public static final MetaViewFieldGroup createNewInstance() throws WCMException {
        return (MetaViewFieldGroup)BaseObj.createNewInstance(MetaViewFieldGroup.class);
    }

    public static final MetaViewFieldGroup findByKey(Object object) throws WCMException {
        return (MetaViewFieldGroup)BaseObj.findByKey(MetaViewFieldGroup.class, object);
    }
}

