/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaDataType;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.HashMap;

public class MetaViewField
extends CMSObj {
    public static final int OBJ_TYPE = 1886731157;
    public static final String DB_TABLE_NAME = "XWCMVIEWFIELDINFO";
    public static final String DB_ID_NAME = "VIEWFIELDINFOID";
    public static final String DB_FIELD_DBTYPE_NAME = "DBTYPE";
    private MetaDBField m_oDBField = null;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;
    private MetaDataType m_oMetaDataType = null;
    private MetaDataType m_oMetaDBDataType = null;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1886731157;
    }

    public String getTableName() {
        return this.getPropertyAsString("TABLENAME");
    }

    public boolean setTableName(String string) throws WCMException {
        return this.setProperty("TABLENAME", string);
    }

    public int getTableId() {
        return this.getPropertyAsInt("TABLEID", 0);
    }

    public boolean setTableId(int n) throws WCMException {
        return this.setProperty("TABLEID", n);
    }

    public String getName() {
        return this.getPropertyAsString("FIELDNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("FIELDNAME", string);
    }

    public String getDBName() {
        return this.getPropertyAsString("DBFIELDNAME");
    }

    public boolean setDBName(String string) throws WCMException {
        return this.setProperty("DBFIELDNAME", string);
    }

    public String getAnotherName() {
        return this.getPropertyAsString("ANOTHERNAME");
    }

    public boolean setAnotherName(String string) throws WCMException {
        return this.setProperty("ANOTHERNAME", string);
    }

    public int getType() {
        return this.getPropertyAsInt("FIELDTYPE", 0);
    }

    public boolean setType(int n) throws WCMException {
        return this.setProperty("FIELDTYPE", n);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString("DEFAULTVALUE");
    }

    public boolean setDefaultValue(String string) throws WCMException {
        return this.setProperty("DEFAULTVALUE", string);
    }

    public String getEnmValue() {
        return this.getPropertyAsString("ENMVALUE", "");
    }

    public boolean setEnmValue(String string) throws WCMException {
        return this.setProperty("ENMVALUE", string);
    }

    public boolean isNotNull() {
        return this.getPropertyAsBoolean("NOTNULL", false);
    }

    public boolean setNotNull(boolean bl) throws WCMException {
        return this.setProperty("NOTNULL", bl);
    }

    public boolean isRadioOrCheck() {
        return this.getPropertyAsBoolean("Radorchk", false);
    }

    public boolean setRadioOrCheck(boolean bl) throws WCMException {
        return this.setProperty("Radorchk", bl);
    }

    public int getClassId() {
        return this.getPropertyAsInt("CLASSID", 0);
    }

    public boolean setClassId(int n) throws WCMException {
        return this.setProperty("CLASSID", n);
    }

    public int getViewId() {
        return this.getPropertyAsInt("ViewId", 0);
    }

    public boolean setView(int n) throws WCMException {
        return this.setProperty("ViewId", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("FIELDORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("FIELDORDER", n);
    }

    public boolean isInOutline() {
        return this.getPropertyAsBoolean("INOUTLINE", false);
    }

    public boolean setInOutline(boolean bl) throws WCMException {
        return this.setProperty("INOUTLINE", bl);
    }

    public boolean isInDetail() {
        return this.getPropertyAsBoolean("INDETAIL", true);
    }

    public boolean setInDetail(boolean bl) throws WCMException {
        return this.setProperty("INDETAIL", bl);
    }

    public boolean isSearchField() {
        return this.getPropertyAsBoolean("SEARCHFIELD", false);
    }

    public boolean setSearchField(boolean bl) throws WCMException {
        return this.setProperty("SEARCHFIELD", bl);
    }

    public boolean isTitleField() {
        return this.getPropertyAsBoolean("TITLEFIELD", false);
    }

    public boolean setTitleField(boolean bl) throws WCMException {
        return this.setProperty("TITLEFIELD", bl);
    }

    public boolean isIdentityField() {
        return this.getPropertyAsBoolean("IDENTITYFIELD", false);
    }

    public boolean setIdentityField(boolean bl) throws WCMException {
        return this.setProperty("IDENTITYFIELD", bl);
    }

    public int getDBFieldId() {
        return this.getPropertyAsInt("DBFIELD", 0);
    }

    public MetaDBField getDBField() throws WCMException {
        if (this.m_oDBField == null) {
            this.m_oDBField = MetaDBField.findById(this.getDBFieldId());
            if (this.m_oDBField == null) {
                throw new WCMException(I18NMessage.get(MetaViewField.class, "MetaViewField.label1", "\u76f8\u5173\u7684\u7269\u7406\u5b57\u6bb5\u4e0d\u5b58\u5728![ID=") + this.getDBFieldId() + "]");
            }
        }
        return this.m_oDBField;
    }

    public boolean setDBField(int n) throws WCMException {
        return this.setProperty("DBFIELD", n);
    }

    public String getValidator() {
        return this.getPropertyAsString("Validator");
    }

    public boolean setValidator(String string) throws WCMException {
        return this.setProperty("Validator", string);
    }

    public int getDBType() {
        return this.getPropertyAsInt(DB_FIELD_DBTYPE_NAME, 0);
    }

    public boolean setDBType(int n) throws WCMException {
        return this.setProperty(DB_FIELD_DBTYPE_NAME, n);
    }

    public int getLength() {
        return this.getPropertyAsInt("DBLENGTH", 0);
    }

    public boolean setLength(int n) throws WCMException {
        return this.setProperty("DBLENGTH", n);
    }

    public int getScale() {
        return this.getPropertyAsInt("DBSCALE", 0);
    }

    public boolean setScale(int n) throws WCMException {
        return this.setProperty("DBSCALE", n);
    }

    public boolean isFromMainTable() {
        return this.getPropertyAsBoolean("FromMainTable", false);
    }

    public boolean setFromMainTable(boolean bl) throws WCMException {
        return this.setProperty("FromMainTable", bl);
    }

    public int getFieldGroupId() {
        return this.getPropertyAsInt("FIELDGROUPID", 0);
    }

    public boolean setFieldGroupId(int n) throws WCMException {
        return this.setProperty("FIELDGROUPID", n);
    }

    public int getRelationViewId() {
        return this.getPropertyAsInt("RELATIONVIEWID", 0);
    }

    public boolean setRelationViewId(int n) throws WCMException {
        return this.setProperty("RELATIONVIEWID", n);
    }

    public void inheritDBFieldInfo(MetaDBField metaDBField) throws WCMException {
        this.m_oDBField = metaDBField;
        this.setTableName(this.m_oDBField.getTableName());
        this.setTableId(this.m_oDBField.getTableId());
        this.setDBField(this.m_oDBField.getId());
        this.setDBName(this.m_oDBField.getName());
        this.setDBType(this.m_oDBField.getDBType());
        this.setLength(this.m_oDBField.getLength());
        this.setScale(this.m_oDBField.getScale());
        if (this.getProperty("ANOTHERNAME") == null) {
            this.setAnotherName(this.m_oDBField.getAnotherName());
        }
        if (this.getProperty("FIELDTYPE") == null) {
            this.setType(this.m_oDBField.getType());
        }
        if (this.getProperty("DEFAULTVALUE") == null) {
            this.setDefaultValue(this.m_oDBField.getDefaultValue());
        }
        if (this.getProperty("ENMVALUE") == null) {
            this.setEnmValue(this.m_oDBField.getEnmValue());
        }
        if (this.getProperty("CLASSID") == null) {
            this.setClassId(this.m_oDBField.getClassId());
        }
        if (this.getProperty("FIELDNAME") == null) {
            this.setName(this.getDBName());
        }
        if (this.getProperty("NOTNULL") == null) {
            this.setNotNull(this.m_oDBField.getPropertyAsBoolean("NOTNULL", false));
        }
        if (this.getProperty("NOTEDIT") == null) {
            this.setEditable(!this.m_oDBField.getPropertyAsBoolean("NOTEDIT", false));
        }
        if (this.getProperty("HIDDENFIELD") == null) {
            this.setHidden(this.m_oDBField.getPropertyAsBoolean("HIDDENFIELD", false));
        }
        if (this.getProperty("Radorchk") == null) {
            this.setRadioOrCheck(this.m_oDBField.getPropertyAsBoolean("Radorchk", false));
        }
    }

    public boolean isValid() throws WCMException {
        int n;
        Object object;
        int n2 = 0;
        if (this.isAddMode()) {
            if (this.getProperty("TABLENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewField.class, "MetaViewField.label2", "\u5c5e\u6027TableName\u6ca1\u6709\u8bbe\u7f6e(ViewFieldInfo.isValid)"));
            }
            if (this.getProperty("TABLEID") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewField.class, "MetaViewField.label3", "\u5c5e\u6027TableId\u6ca1\u6709\u8bbe\u7f6e(ViewFieldInfo.isValid)"));
            }
            if (this.getProperty("DBFIELD") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewField.class, "MetaViewField.label4", "\u5c5e\u6027DBField\u6ca1\u6709\u8bbe\u7f6e(ViewFieldInfo.isValid)"));
            }
            if (this.getProperty("ViewId") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewField.class, "MetaViewField.label5", "\u5c5e\u6027OwnerView\u6ca1\u6709\u8bbe\u7f6e(ViewFieldInfo.isValid)"));
            }
            object = this.getDBField();
            if (this.getProperty("ANOTHERNAME") == null) {
                this.setAnotherName(((MetaDBField)object).getAnotherName());
            }
            if (this.getProperty("FIELDTYPE") == null) {
                this.setType(((MetaDBField)object).getType());
            }
            if (this.getProperty("DBFIELDNAME") == null) {
                this.setDBName(((MetaDBField)object).getName());
            }
            if (this.getProperty("DEFAULTVALUE") == null) {
                this.setDefaultValue(((MetaDBField)object).getDefaultValue());
            }
            if (this.getProperty("ENMVALUE") == null) {
                this.setEnmValue(((MetaDBField)object).getEnmValue());
            }
            if (this.getProperty("CLASSID") == null) {
                this.setClassId(((MetaDBField)object).getClassId());
            }
            if (this.getProperty("FIELDNAME") == null) {
                this.setName(this.getDBName());
            }
            if (this.getProperty("INDETAIL") == null) {
                this.setInDetail(true);
            }
            if (this.getProperty("TITLEFIELD") == null) {
                this.setTitleField(false);
            }
            if (this.getProperty("SearchField") == null) {
                this.setSearchField(false);
            }
            if (this.getProperty("IdentityField") == null) {
                this.setIdentityField(false);
            }
            if (this.getProperty("NotNull") == null) {
                this.setNotNull(false);
            }
            if (this.getProperty("InMultiTable") == null) {
                this.setInMultiTable(false);
            }
            n2 = this.getType();
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MetaViewField.class, "MetaViewField.label6", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ViewFieldInfo.isValid)"));
            }
            n2 = this.getNewPropertyAsInt("FIELDTYPE", 0);
        }
        if (n2 != 0) {
            object = null;
            object = n2 == 1 ? MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType()) : MetaDataConstants.DATA_TYPES.getDataTypeById(n2);
            if (this.isAddMode() && this.getProperty("DBLENGTH") == null) {
                this.setLength(((MetaDataType)object).getMaxLength());
            } else if (!this.isAddMode() && this.getType() != n2 && this.getNewProperty("DBLENGTH") == null) {
                this.setLength(((MetaDataType)object).getMaxLength());
            }
            if (this.getDBType() == 2005 || this.getDBType() == 93 || this.getDBType() == 4) {
                this.setLength(0);
            }
        }
        if ((n = DBManager.getDBManager().sqlExecuteIntQuery("select VIEWFIELDINFOID from XWCMVIEWFIELDINFO where ViewId=? and DBField=? and VIEWFIELDINFOID<>?", new int[]{this.getViewId(), this.getDBFieldId(), this.getId()})) > 0) {
            throw new WCMException(I18NMessage.get(MetaViewField.class, "MetaViewField.label7", "\u89c6\u56fe\u4e2d\u5df2\u7ecf\u6709\u5b57\u6bb5\u548c\u6307\u5b9a\u7684\u7269\u7406\u5b57\u6bb5\u5173\u8054\uff01[ViewId=") + this.getViewId() + ", DBFieldId=" + this.getDBFieldId() + ", CurrId=" + this.getId() + "]");
        }
        this.changeOrder();
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("ClassId") == null) {
                this.setClassId(0);
            }
            super.insert(user);
        }
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
                this.setOrder(n2);
                return;
            }
            n5 = 1;
            n4 = n;
            n3 = n2;
        } else {
            if (!this.isChangeProperty("FIELDORDER")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("FIELDORDER", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (this.isChangeProperty("PARENTID")) {
                    n2 = n + 1;
                } else if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = --n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "FIELDORDER>=" + n3 + " AND FIELDORDER <= " + n4 + " and ViewId=" + this.getViewId();
        String string2 = "UPDATE XWCMVIEWFIELDINFO SET FIELDORDER = FIELDORDER+(" + n5 + ") WHERE " + string;
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        this.setOrder(n2);
    }

    private int getMaxOrder() throws WCMException {
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(FIELDORDER) from XWCMVIEWFIELDINFO where ViewId=?", new int[]{this.getViewId()});
    }

    public String getClassName() {
        int n = this.getClassId();
        if (n == 0) {
            return "";
        }
        try {
            ClassInfo classInfo = ClassInfo.findById(this.getClassId());
            if (classInfo != null) {
                return classInfo.getName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public String getTypeDesc() {
        if (this.m_oMetaDataType == null) {
            this.m_oMetaDataType = MetaDataConstants.DATA_TYPES.getDataTypeById(this.getType());
        }
        return this.m_oMetaDataType.getDataTypeDesc();
    }

    public String getDBTypeDesc() {
        if (this.m_oMetaDBDataType == null) {
            this.m_oMetaDBDataType = MetaDataConstants.DB_DATA_TYPES.getDataTypeById(this.getDBType());
        }
        return this.m_oMetaDBDataType.getDataTypeDesc();
    }

    public HashMap getEnmValueMap(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.getEnmValue();
        String[] stringArray = string.split("~");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("`");
            if (bl) {
                hashMap.put(stringArray2.length > 1 ? stringArray2[1] : stringArray2[0], stringArray2[0]);
                continue;
            }
            hashMap.put(stringArray2[0], stringArray2.length > 1 ? stringArray2[1] : stringArray2[0]);
        }
        return hashMap;
    }

    public String getValueFromLabel(String string) {
        String string2 = this.getEnmValue();
        String[] stringArray = string2.split("~");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("`");
            if (stringArray2[0].indexOf(string) < 0) continue;
            return stringArray2.length > 1 ? stringArray2[1] : stringArray2[0];
        }
        return null;
    }

    public String[] getValuesFromLabel(String string) {
        String string2 = this.getEnmValue();
        if (CMyString.isEmpty(string2)) {
            return new String[0];
        }
        String[] stringArray = string2.split("~");
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split("`");
            if (stringArray3[0].indexOf(string) < 0) continue;
            stringArray2[n++] = stringArray3.length > 1 ? stringArray3[1] : stringArray3[0];
        }
        String[] stringArray4 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray4, 0, n);
        return stringArray4;
    }

    public static final MetaViewField findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (MetaViewField)BaseObj.findById(MetaViewField.class, n);
    }

    public static final MetaViewField createNewInstance() throws WCMException {
        return (MetaViewField)BaseObj.createNewInstance(MetaViewField.class);
    }

    public static final MetaViewField findByKey(Object object) throws WCMException {
        return (MetaViewField)BaseObj.findByKey(MetaViewField.class, object);
    }

    public boolean isHidden() {
        return this.getPropertyAsBoolean("HIDDENFIELD", false);
    }

    public boolean setHidden(boolean bl) throws WCMException {
        return this.setProperty("HIDDENFIELD", bl);
    }

    public boolean isEditable() {
        return !this.getPropertyAsBoolean("NOTEDIT", false);
    }

    public boolean setEditable(boolean bl) throws WCMException {
        return this.setProperty("NOTEDIT", !bl);
    }

    public boolean isInMultiTable() throws WCMException {
        return this.getPropertyAsBoolean("INMULTITABLE", false);
    }

    public boolean setInMultiTable(boolean bl) throws WCMException {
        return this.setProperty("INMULTITABLE", bl);
    }
}

