/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaDBFields;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaDataDefHelper;
import com.trs.components.metadata.definition.MetaDataType;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.TableInfo;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class MetaDataDefMgr
implements IMetaDataDefMgr {
    private static final String SQL_SYN_VIEWDBFIELDNAME = "update XWCMVIEWFIELDINFO set DBFIELDNAME=? where DBFIELD=?";
    private static final String WHERE_QUERY_VIEWS_BY_OTHERTABLE = "ViewInfoId in(select XWCMVIEWOtherTables.ViewId from XWCMVIEWOtherTables where XWCMVIEWOtherTables.TableId=?)";
    private static Logger logger = Logger.getLogger(MetaDataDefMgr.class);
    private DBManager m_oDBMgr = DBManager.getDBManager();
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");

    public MetaDBTable save(User user, MetaDBTable metaDBTable) throws WCMException {
        WCMFilter wCMFilter;
        boolean bl = metaDBTable.isAddMode();
        boolean bl2 = metaDBTable.isChangeProperty("TABLENAME");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (bl) {
            string2 = MetaDataConstants.makeTrueTableName(metaDBTable.getName());
        } else if (bl2) {
            string3 = MetaDataConstants.makeTrueTableName(metaDBTable.getName());
            string2 = MetaDataConstants.makeTrueTableName(metaDBTable.getNewPropertyAsString("TABLENAME"));
            string = this.m_oDBMgr.getDBType().sqlRenameTable(string3, string2);
        }
        if (string2 != null && !string2.equalsIgnoreCase(string3) && this.m_oDBMgr.getTableInfo(string2) != null) {
            throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label1", "\u6307\u5b9a\u7684\u8868\u540d[") + string2 + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label2", "]\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        metaDBTable.save(user);
        if (bl) {
            this.createTableInDB(user, metaDBTable, string2);
        } else if (bl2) {
            this.m_oDBMgr.sqlExecuteUpdate(string);
            this.m_oDBMgr.reloadTableInfo(string2);
            string4 = this.m_oDBMgr.getDBType().sqlRenameField(string2, string3 + "ID", string2 + "ID");
            if (string2 != null && !string2.equalsIgnoreCase(string3)) {
                this.m_oDBMgr.sqlExecuteUpdate(string4);
            }
        }
        if (string2 != null) {
            this.m_oDBMgr.reloadTableInfo(string2);
        }
        if (bl2) {
            this.m_oDBMgr.getTableInfos().removeTableInfo(string3);
        }
        MetaViews metaViews = new MetaViews(user, 1, 1);
        if (bl2) {
            wCMFilter = new WCMFilter("", "MainTableId=?", "");
            wCMFilter.addSearchValues(metaDBTable.getId());
            metaViews.addElements(MetaViews.openWCMObjs(null, wCMFilter));
            String[] stringArray = new String[]{"update XWCMDBFieldInfo set TableName=? where TableId=?", "update XWCMViewFieldInfo set TableName=? where TableId=?", "update XWCMViewInfo set ViewName=? where MainTableId=? and ViewName=MainTableName", "update XWCMViewInfo set MainTableName=? where MainTableId=?"};
            Object[] objectArray = new Object[]{metaDBTable.getName(), metaDBTable.getKey()};
            this.m_oDBMgr.sqlExecuteUpdate(stringArray, objectArray);
        }
        if (bl2) {
            wCMFilter = new WCMFilter("", WHERE_QUERY_VIEWS_BY_OTHERTABLE, "");
            wCMFilter.addSearchValues(metaDBTable.getId());
            metaViews.addElements(MetaViews.openWCMObjs(null, wCMFilter));
            int n = metaViews.size();
            for (int i = 0; i < n; ++i) {
                MetaView metaView = (MetaView)metaViews.getAt(i);
                if (metaView == null) continue;
                String string5 = "WCMMetaRelation" + metaView.getId();
                String string6 = this.m_oDBMgr.getDBType().sqlRenameField(string5, string3 + "ID", string2 + "ID");
                try {
                    this.m_oDBMgr.sqlExecuteUpdate(string6);
                    this.m_oDBMgr.reloadTableInfo(string5);
                    continue;
                }
                catch (Exception exception) {
                    logger.error((Object)(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label3", "\u66f4\u65b0\u5173\u8054\u8868\u5b57\u6bb5\u5931\u8d25\uff01\n[SQL=") + string6 + "]\n" + exception.getMessage()));
                }
            }
        }
        this.recreateViewRelations(user, metaViews);
        return metaDBTable;
    }

    private void createTableInDB(User user, MetaDBTable metaDBTable, String string) throws WCMException {
        if (this.m_oDBMgr.getTableInfo(string) != null) {
            return;
        }
        String string2 = this.m_oDBMgr.getDBType().sqlCreateTableWithPrimary(string, string + "ID");
        this.m_oDBMgr.sqlExecuteUpdate(string2);
        this.m_oDBMgr.reloadTableInfo(string);
        this.appendDefaultFields(user, metaDBTable);
        String string3 = String.valueOf(System.currentTimeMillis());
        string3 = string3.substring(string3.length() - 9);
        String string4 = "IX_" + metaDBTable.getName() + "_" + string3;
        String string5 = "create unique index " + string4 + " on " + string + "(MetaDataId)";
        this.m_oDBMgr.sqlExecuteUpdate(string5);
    }

    public MetaDBField save(User user, MetaDBTable metaDBTable, MetaDBField metaDBField) throws WCMException {
        Object[] objectArray;
        int n = metaDBField.getLength();
        int n2 = metaDBField.getScale();
        boolean bl = metaDBField.isAddMode();
        boolean bl2 = metaDBField.isModifyColumnProperties(true);
        boolean bl3 = metaDBField.isModifyColumnProperties(false);
        boolean bl4 = false;
        String string = MetaDataConstants.makeTrueTableName(metaDBTable.getName());
        String string2 = null;
        String string3 = null;
        if (bl) {
            string3 = metaDBField.getName();
        } else {
            string3 = metaDBField.getNewPropertyAsString("FIELDNAME");
            boolean bl5 = bl4 = string3 != null && !metaDBField.getName().equalsIgnoreCase(string3);
            if (bl4) {
                string2 = this.m_oDBMgr.getDBType().sqlRenameField(string, metaDBField.getName(), string3);
            } else {
                string3 = null;
            }
            if (metaDBField.isChangeProperty("DBTYPE")) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label4", "\u5b57\u6bb5\u7c7b\u578b\u53d8\u66f4\u7684\u64cd\u4f5c\u6bd4\u8f83\u590d\u6742\uff0c\u4e0d\u652f\u6301\uff01"));
            }
        }
        metaDBField.setTableName(metaDBTable.getName());
        metaDBField.setTableId(metaDBTable.getId());
        if (string3 != null) {
            MetaDataDefMgr.validateFieldNotExists(string, string3);
        }
        metaDBField.isValid();
        if (bl) {
            this.createFieldInDB(user, metaDBField, string);
        } else if (bl4) {
            try {
                this.alterFiledNameInDB(metaDBField, string2);
            }
            catch (WCMException wCMException) {
                metaDBField.cancelUpdate(user);
                throw wCMException;
            }
        }
        if (!bl && bl3) {
            metaDBField.setGetPropertyFromNew(true);
            objectArray = this.m_oDBMgr.getFieldInfo(string, metaDBField.getName());
            boolean bl6 = false;
            bl6 = objectArray != null && objectArray.getDataType().getType() == metaDBField.getDBType() ? metaDBField.getLength() != n || metaDBField.getScale() != n2 : true;
            if (bl6) {
                try {
                    this.alterFieldInDB(metaDBField, string);
                }
                catch (WCMException wCMException) {
                    metaDBField.cancelUpdate(user);
                    throw wCMException;
                }
            }
            metaDBField.setGetPropertyFromNew(false);
        }
        metaDBField.save(user);
        if (bl || bl4 || bl2) {
            this.m_oDBMgr.reloadTableInfo(string);
        }
        if (bl4) {
            objectArray = new Object[]{string3, metaDBField.getKey()};
            this.m_oDBMgr.sqlExecuteUpdate(new String[]{SQL_SYN_VIEWDBFIELDNAME}, objectArray);
            this.createViewRelationsOfDBField(user, metaDBField);
        }
        return metaDBField;
    }

    private static void validateFieldNotExists(String string, String string2) throws WCMException {
        if (DBManager.getDBManager().getFieldInfo(string, string2) != null) {
            throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label5", "\u6307\u5b9a\u7684\u5b57\u6bb5\u540d[") + string2 + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label6", "]\u5728\u8868[") + string + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label7", "]\u4e2d\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
    }

    private void alterFieldInDB(MetaDBField metaDBField, String string) throws WCMException {
        try {
            int n = metaDBField.getLength();
            if (metaDBField.isStringField()) {
                n = MetaDataConstants.getExpandLength(n);
            }
            String string2 = this.m_oDBMgr.getDBType().sqlModifyField(string, metaDBField.getName(), metaDBField.getSqlType(), n, !metaDBField.isNotNull(), metaDBField.getScale());
            this.m_oDBMgr.sqlExecuteUpdate(string2);
        }
        catch (WCMException wCMException) {
            if (metaDBField.isChangeProperty("DBLENGTH")) {
                String string3 = I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label29", "\u5b57\u6bb5[") + metaDBField.getAnotherName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label30", "]\u957f\u5ea6\u53d8\u66f4\u4e0d\u6210\u529f\uff0c") + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label31", "\u53ef\u80fd\u67d0\u4e9b\u6570\u636e\u7684\u957f\u5ea6\u8d85\u8fc7\u4e86\u5f53\u524d\u65b0\u7684\u957f\u5ea6[") + metaDBField.getLength() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label32", "]\u6216\u8005\u65b0\u7684\u957f\u5ea6\u8d85\u8fc7\u4e86\u6570\u636e\u5e93\u6700\u5927\u957f\u5ea6");
                throw new WCMException(2, string3, wCMException);
            }
            if (metaDBField.isChangeProperty("DBTYPE")) {
                String string4 = I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label29", "\u5b57\u6bb5[") + metaDBField.getAnotherName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label33", "]\u7c7b\u578b\u53d8\u66f4\u4e0d\u6210\u529f\uff0c") + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label34", "\u53ef\u80fd\u662f\u8001\u7684\u7c7b\u578b\u4e0d\u80fd\u8f6c\u6362\u6210\u65b0\u7684\u7c7b\u578b");
                throw new WCMException(2, string4, wCMException);
            }
            throw wCMException;
        }
    }

    private void alterFiledNameInDB(MetaDBField metaDBField, String string) throws WCMException {
        try {
            this.m_oDBMgr.sqlExecuteUpdate(string);
        }
        catch (Throwable throwable) {
            String string2 = I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label35", "\u4fee\u6539\u5b57\u6bb5[") + metaDBField.getAnotherName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label36", "]\u4e0d\u6210\u529f\uff0c") + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label37", "\u53ef\u80fd\u662f\u6570\u636e\u5e93\u7684\u4fdd\u7559\u5b57\u6216\u8005\u6570\u636e\u5e93\u4e0d\u5141\u8bb8\u4fee\u6539\u5b57\u6bb5\u540d\uff01");
            throw new WCMException(2, string2, throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createFieldInDB(User user, MetaDBField metaDBField, String string) throws WCMException {
        boolean bl = false;
        int n = metaDBField.getLength();
        if (metaDBField.isStringField()) {
            n = MetaDataConstants.getExpandLength(n);
        }
        try {
            try {
                String string2 = this.m_oDBMgr.getDBType().sqlAddField(string, metaDBField.getName(), metaDBField.getSqlType(), n, !metaDBField.isNotNull(), metaDBField.getDefaultValue(), metaDBField.getScale());
                this.m_oDBMgr.sqlExecuteUpdate(string2);
                return;
            }
            catch (Throwable throwable) {
                String string3 = I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label38", "\u5b57\u6bb5\u540d[") + metaDBField.getName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label39", "]\u662f\u4fdd\u7559\u5b57\u3001\u4e0d\u552f\u4e00\u6216\u957f\u5ea6[") + metaDBField.getLength() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label40", "]\u8fc7\u5927\uff01");
                throw new WCMException(2, string3, throwable);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl) throw throwable;
            metaDBField.unlock();
            throw throwable;
        }
    }

    public MetaView save(User user, MetaView metaView) throws WCMException {
        if (metaView.isAddMode()) {
            metaView.setName(metaView.getMainTableName());
        } else {
            if (!metaView.isModified(true)) {
                return metaView;
            }
            metaView.validCanEditAndLock(user);
        }
        metaView.save(user);
        return metaView;
    }

    public MetaViewField save(User user, MetaView metaView, MetaViewField metaViewField) throws WCMException {
        this.resetTitleField(metaViewField, metaView);
        if (metaViewField.isAddMode()) {
            metaViewField.setView(metaView.getId());
            if (metaViewField.getDBFieldId() == 0) {
                MetaDBField metaDBField = this.createDBFieldFromViewField(user, metaView, metaViewField);
                metaViewField.inheritDBFieldInfo(metaDBField);
            } else {
                metaViewField.inheritDBFieldInfo(metaViewField.getDBField());
            }
            metaViewField.setFromMainTable(metaView.getMainTableName().equalsIgnoreCase(metaViewField.getTableName()));
        } else {
            int n;
            MetaDBField metaDBField;
            int n2;
            metaViewField.validCanEditAndLock(user);
            if (metaViewField.isChangeProperty("DBFIELD")) {
                n2 = metaViewField.getNewPropertyAsInt("DBFIELD", 0);
                metaDBField = MetaDBField.findById(n2);
                if (metaDBField == null) {
                    throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label8", "\u65b0\u76f8\u5173\u7684\u7269\u7406\u5b57\u6bb5\u65e0\u6548\uff01[ID=") + n2 + "]");
                }
                metaViewField.inheritDBFieldInfo(metaDBField);
            } else if (metaViewField.isChangeProperty("DBLENGTH")) {
                n2 = metaViewField.getPropertyAsInt("DBFIELD", 0);
                metaDBField = MetaDBField.findById(n2);
                n = metaViewField.getNewPropertyAsInt("DBLENGTH", 0);
                if (metaDBField.getLength() < n) {
                    metaDBField.setLength(n);
                    this.save(user, metaDBField.getMetaDBTable(), metaDBField);
                }
            }
            if (metaViewField.isChangeProperty("DBSCALE")) {
                n2 = metaViewField.getPropertyAsInt("DBFIELD", 0);
                metaDBField = MetaDBField.findById(n2);
                n = metaViewField.getNewPropertyAsInt("DBSCALE", 0);
                metaDBField.setScale(n);
                this.save(user, metaDBField.getMetaDBTable(), metaDBField);
            }
        }
        this.assertViewFieldNameNotSimilar(metaViewField, "FIELDNAME");
        this.assertViewFieldNameNotSimilar(metaViewField, "ANOTHERNAME");
        metaViewField.save(user);
        return metaViewField;
    }

    private void assertViewFieldNameNotSimilar(MetaViewField metaViewField, String string) throws WCMException {
        String string2 = string;
        String string3 = null;
        string3 = metaViewField.getFinalPropertyAsString(string2);
        if (CMyString.isEmpty(string3)) {
            return;
        }
        String string4 = string3;
        int n = 0;
        while (string4 != null) {
            WCMFilter wCMFilter = new WCMFilter("XWCMVIEWFIELDINFO", "ViewId=? and " + string2 + "=? and " + "VIEWFIELDINFOID" + "<>?", "", "VIEWFIELDINFOID");
            wCMFilter.addSearchValues(metaViewField.getViewId());
            wCMFilter.addSearchValues(string4);
            wCMFilter.addSearchValues(metaViewField.getId());
            if (DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) <= 0) break;
            string4 = string3 + ++n;
        }
        if (string4 != null && !string4.equals(string3)) {
            metaViewField.setPropertyWithString(string, string4);
        }
    }

    public MetaViewField getMetaViewField(MetaView metaView, int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter(null, "viewId =? and dbField=?", null);
        wCMFilter.addSearchValues(metaView.getId());
        wCMFilter.addSearchValues(n);
        MetaViewFields metaViewFields = MetaViewFields.openWCMObjs(null, wCMFilter);
        if (metaViewFields.size() > 0) {
            return (MetaViewField)metaViewFields.getAt(0);
        }
        return null;
    }

    public void resetTitleField(MetaViewField metaViewField) throws WCMException {
        int n = metaViewField.getViewId();
        this.resetTitleField(metaViewField, MetaView.findById(n));
    }

    private void resetTitleField(MetaViewField metaViewField, MetaView metaView) throws WCMException {
        boolean bl = false;
        if (metaViewField.isAddMode()) {
            bl = metaViewField.getPropertyAsBoolean("TITLEFIELD", false);
        } else {
            boolean bl2 = bl = metaViewField.getNewPropertyAsInt("TITLEFIELD", 0) != 0 && !metaViewField.isTitleField();
        }
        if (bl) {
            this.clearTitleField(metaView);
        }
    }

    public void clearTitleField(MetaView metaView) throws WCMException {
        User user = ContextHelper.getLoginUser();
        HashMap hashMap = this.m_oDataDefCacheMgr.getMetaViewFields(metaView.getId());
        for (MetaViewField metaViewField : hashMap.values()) {
            if (!metaViewField.isTitleField()) continue;
            metaViewField.validCanEditAndLock(user);
            metaViewField.setTitleField(false);
            metaViewField.save(user);
            break;
        }
    }

    public String createDDLSQL(MetaDBTable metaDBTable) throws WCMException {
        String string = "WCMMetaTable" + metaDBTable.getName();
        String string2 = string + "Id";
        DBType dBType = this.m_oDBMgr.getDBType();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dBType.sqlCreateTable());
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append("(\n");
        stringBuffer.append("      ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(dBType.getTypeName(4));
        stringBuffer.append(" Primary Key \n");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String createDDLSQL(MetaView metaView) throws WCMException {
        if (!metaView.isMultiTable()) {
            return null;
        }
        MetaViewFields metaViewFields = this.getViewFields(null, metaView, null);
        int n = 100 + (metaViewFields.size() + MetaDataConstants.DEFAULT_FIELDS.getDataTypesCount()) * 50;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("create View ");
        stringBuffer.append(metaView.getName());
        stringBuffer.append(" as\n");
        stringBuffer.append(" select ");
        String string = "WCMMetaRelation" + metaView.getId();
        this.appendDefaultSelectFields(stringBuffer, string);
        stringBuffer.append("\n");
        int n2 = metaViewFields.size();
        for (int i = 0; i < n2; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            if (metaViewField == null) continue;
            stringBuffer.append(",");
            if (metaViewField.getName().equalsIgnoreCase(metaViewField.getDBName())) {
                stringBuffer.append("WCMMetaTable");
                stringBuffer.append(metaViewField.getTableName());
                stringBuffer.append(".");
                stringBuffer.append(metaViewField.getName());
                continue;
            }
            stringBuffer.append("WCMMetaTable");
            stringBuffer.append(metaViewField.getTableName());
            stringBuffer.append(".");
            stringBuffer.append(metaViewField.getDBName());
            stringBuffer.append(" ");
            stringBuffer.append(metaViewField.getName());
        }
        stringBuffer.append("\n");
        stringBuffer.append(" from ");
        stringBuffer.append(string);
        stringBuffer.append("\n");
        String string2 = MetaDataConstants.makeTrueTableName(metaView.getMainTableName());
        this.appendLeftJoinWithRelationTable(stringBuffer, string, string2);
        stringBuffer.append("\n");
        MetaDBTables metaDBTables = metaView.getOtherTables(null, new WCMFilter("", "", "", "TableName"));
        int n3 = metaDBTables.size();
        for (int i = 0; i < n3; ++i) {
            MetaDBTable metaDBTable = (MetaDBTable)metaDBTables.getAt(i);
            if (metaDBTable == null) continue;
            String string3 = MetaDataConstants.makeTrueTableName(metaDBTable.getName());
            this.appendLeftJoinWithRelationTable(stringBuffer, string, string3);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void appendDefaultSelectFields(StringBuffer stringBuffer, String string) {
        for (int i = 0; i < MetaDataConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            MetaDataType metaDataType = MetaDataConstants.DEFAULT_FIELDS.getDataTypeAt(i);
            String string2 = metaDataType.getKey();
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            stringBuffer.append(".");
            stringBuffer.append(string2);
        }
    }

    private void appendLeftJoinWithRelationTable(StringBuffer stringBuffer, String string, String string2) {
        String string3 = string2 + "ID";
        stringBuffer.append(" left outer join ");
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" on ");
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string3);
        stringBuffer.append("=");
        stringBuffer.append(string2);
        stringBuffer.append(".");
        stringBuffer.append("MetaDataId");
    }

    public void delete(User user, MetaDBField metaDBField) throws WCMException {
        Object object;
        String string;
        DBType dBType = this.m_oDBMgr.getDBType();
        String string2 = MetaDataConstants.makeTrueTableName(metaDBField.getTableName());
        if (this.m_oDBMgr.getFieldInfo(string2, string = metaDBField.getName().trim().toUpperCase()) != null) {
            object = null;
            try {
                object = dBType.sqlDropField(string2, string);
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label9", "\u751f\u6210\u5220\u9664\u5b57\u6bb5\u811a\u672c\u51fa\u9519\uff01"), exception);
            }
            this.m_oDBMgr.sqlExecuteUpdate((String)object);
            this.m_oDBMgr.getTableInfos().getTableInfo(string2).removeFieldInfo(string);
        }
        metaDBField.delete(user);
        object = new WCMFilter("", "exists(select XWCMViewFieldInfo.ViewId from XWCMViewFieldInfo where XWCMViewFieldInfo.DBField=? and XWCMViewInfo.ViewInfoId=XWCMViewFieldInfo.ViewId)", "");
        ((WCMFilter)object).addSearchValues(metaDBField.getId());
        MetaViews metaViews = MetaViews.openWCMObjs(user, (WCMFilter)object);
        object = new WCMFilter("", "DBField=?", "");
        ((WCMFilter)object).addSearchValues(metaDBField.getId());
        MetaViewFields metaViewFields = MetaViewFields.openWCMObjs(user, (WCMFilter)object);
        metaViewFields.removeAll(true);
        this.recreateViewRelations(user, metaViews);
    }

    public void delete(User user, MetaDBTable metaDBTable) throws WCMException {
        Object object;
        Cloneable cloneable;
        Object object2;
        block22: {
            CMSObj cMSObj;
            int n;
            int n2;
            try {
                object2 = this.getViewsUsingTable(metaDBTable);
                n2 = ((BaseObjs)object2).size();
                for (n = 0; n < n2; ++n) {
                    cMSObj = (MetaView)((BaseObjs)object2).getAt(n);
                    if (cMSObj == null) continue;
                    cloneable = new WCMFilter("", "", "");
                    cloneable.setWhere("docKind=" + cMSObj.getId());
                    object = Documents.openWCMObjs(user, cloneable);
                    int n3 = ((Documents)object).size();
                    for (int i = 0; i < n3; ++i) {
                        Document document = (Document)((Documents)object).getAt(i);
                        if (document == null) continue;
                        this.m_oDocumentMgr.delete(document, null, true);
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
            try {
                object2 = this.getDFieldInfos(user, metaDBTable, null);
                n2 = ((BaseObjs)object2).size();
                for (n = 0; n < n2; ++n) {
                    cMSObj = (MetaDBField)((BaseObjs)object2).getAt(n);
                    if (cMSObj == null) continue;
                    try {
                        cMSObj.delete(user);
                        continue;
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception);
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
            try {
                object2 = this.m_oDBMgr.getDBType();
                String string = MetaDataConstants.makeTrueTableName(metaDBTable.getName());
                if (this.m_oDBMgr.getTableInfo(string) == null) break block22;
                String string2 = null;
                try {
                    string2 = ((DBType)object2).sqlDropTable(string);
                }
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label10", "\u751f\u6210\u5220\u9664\u8868\u811a\u672c\u51fa\u9519\uff01"), exception);
                }
                this.m_oDBMgr.sqlExecuteUpdate(string2);
                this.m_oDBMgr.getTableInfos().removeTableInfo(string);
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        try {
            metaDBTable.delete(user);
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        object2 = new WCMFilter("", "MainTableName=?", "");
        ((WCMFilter)object2).addSearchValues(metaDBTable.getName());
        MetaViews metaViews = MetaViews.openWCMObjs(user, (WCMFilter)object2);
        int n = metaViews.size();
        for (int i = 0; i < n; ++i) {
            cloneable = (MetaView)metaViews.getAt(i);
            if (cloneable == null) continue;
            try {
                this.delete(user, (MetaView)cloneable);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        object2 = new WCMFilter("", "exists(select XWCMViewOtherTables.ViewId from XWCMViewOtherTables where XWCMViewOtherTables.TableId=? and XWCMViewInfo.ViewInfoId=XWCMViewOtherTables.ViewId)", "");
        ((WCMFilter)object2).addSearchValues(metaDBTable.getId());
        metaViews = MetaViews.openWCMObjs(user, (WCMFilter)object2);
        this.m_oDBMgr.sqlExecuteUpdate("delete from XWCMViewOtherTables where TableId=" + metaDBTable.getId());
        String string = "tableId=" + metaDBTable.getId();
        int n4 = metaViews.size();
        for (n = 0; n < n4; ++n) {
            object = (MetaView)metaViews.getAt(n);
            if (object == null) continue;
            MetaViewFields metaViewFields = this.getViewFields(user, (MetaView)object, new WCMFilter("", string, ""));
            int n5 = metaViewFields.size();
            for (int i = 0; i < n5; ++i) {
                MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
                if (metaViewField == null) continue;
                metaViewField.delete(user);
            }
            MetaDBTables metaDBTables = ((MetaView)object).getOtherTables(user, new WCMFilter("", "", "", "TableName"));
            if (!metaDBTables.isEmpty()) continue;
            try {
                DBManager.getDBManager().sqlExecuteUpdate("drop view " + ((MetaView)object).getName());
            }
            catch (Exception exception) {
                System.err.println(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label11", "\u589e\u52a0\u4e4b\u524d\u5220\u9664\u89c6\u56fe\u5931\u8d25\uff01SQL=drop view ") + ((MetaView)object).getName());
                System.err.println(exception.getMessage());
            }
            ((MetaView)object).setName(((MetaView)object).getMainTableName());
            ((CMSObj)object).save();
        }
        this.recreateViewRelations(user, metaViews);
    }

    public MetaDBFields getDFieldInfos(User user, MetaDBTable metaDBTable, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "TABLEID=?", "");
        wCMFilter2.addSearchValues(metaDBTable.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return MetaDBFields.openWCMObjs(user, wCMFilter2);
    }

    public String createViewRelations(User user, MetaView metaView) throws WCMException {
        return this.createViewRelations(user, metaView, true);
    }

    public String createViewRelations(User user, MetaView metaView, boolean bl) throws WCMException {
        MetaDBTables metaDBTables = metaView.getOtherTables(user, new WCMFilter("", "", "", "TableName"));
        this.createViewRelationTable(metaView, metaDBTables);
        if (!metaDBTables.isEmpty()) {
            String string = "WCMMetaView" + metaView.getId();
            metaView.validCanEditAndLock(user);
            metaView.setName(string);
            metaView.save(user);
            String string2 = this.createDDLSQL(metaView);
            if (!CMyString.isEmpty(string2)) {
                try {
                    DBManager.getDBManager().sqlExecuteUpdate("drop view " + metaView.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DBManager.getDBManager().sqlExecuteUpdate(string2);
                DBManager.getDBManager().reloadTableInfo(metaView.getName());
            }
        }
        if (bl) {
            this.createViewApplication(metaView);
        }
        return null;
    }

    public void createViewApplication0(MetaView metaView) throws WCMException {
        String string = MetaDataDefHelper.getViewApplicationRootPath();
        String string2 = string + "template" + File.separatorChar;
        this.createViewApplication(metaView, string2, string);
        String string3 = metaView.getTemplatePath();
        if (!CMyString.isEmpty(string3) && !"template".equalsIgnoreCase(string3)) {
            String string4 = string + "customtemplates" + File.separatorChar + string3;
            this.createViewApplication(metaView, string4, string);
        }
        string2 = string + metaView.getId() + File.separatorChar + "template" + File.separatorChar;
        this.createViewApplication(metaView, string2, string);
    }

    public void createViewApplication(MetaView metaView) throws WCMException {
        this.createViewApplication0(metaView);
        IClusterMsgCenter iClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
        String[] stringArray = new String[]{String.valueOf(metaView.getId())};
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"start to notify other cluster node create view application.");
            }
            iClusterMsgCenter.send("META.CR", stringArray, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"end to notify other cluster node create view application.");
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Fail to notify other cluster node.", (Throwable)exception);
        }
    }

    private void createViewRelationTable(MetaView metaView, MetaDBTables metaDBTables) throws WCMException {
        Object object;
        if (metaDBTables == null || metaDBTables.isEmpty()) {
            return;
        }
        boolean bl = false;
        String string = "WCMMetaRelation" + metaView.getId();
        TableInfo tableInfo = this.m_oDBMgr.getTableInfo(string);
        if (tableInfo == null) {
            String string2 = this.m_oDBMgr.getDBType().sqlCreateTableWithPrimary(string, string + "ID");
            this.m_oDBMgr.sqlExecuteUpdate(string2);
            String string3 = MetaDataConstants.makeTrueTableName(metaView.getMainTableName()) + "ID";
            object = this.m_oDBMgr.getDBType().sqlAddField(string, string3, 4, 0, false, "0", 0);
            this.m_oDBMgr.sqlExecuteUpdate((String)object);
            this.m_oDBMgr.reloadTableInfo(string);
        }
        int n = metaDBTables.size();
        for (int i = 0; i < n; ++i) {
            object = (MetaDBTable)metaDBTables.getAt(i);
            String string4 = MetaDataConstants.makeTrueTableName(((MetaDBTable)object).getName()) + "ID";
            if (tableInfo != null && tableInfo.getFieldInfo(string4) != null) continue;
            String string5 = this.m_oDBMgr.getDBType().sqlAddField(string, string4, 4, 0, false, "0", 0);
            this.m_oDBMgr.sqlExecuteUpdate(string5);
            bl = true;
        }
        this.appendDefaultFields(string);
        if (bl) {
            this.m_oDBMgr.reloadTableInfo(string);
        }
    }

    public boolean createViewApplication(MetaView metaView, String string, String string2) throws WCMException {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        boolean bl = false;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string3;
            if (fileArray[i].isDirectory()) continue;
            bl = true;
            String string4 = null;
            try {
                string3 = fileArray[i].getAbsolutePath();
                object4 = CharsetDetector.detect(string3);
                string4 = CMyFile.readFile(string3, (String)object4);
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label14", "\u8bfb\u53d6\u6587\u4ef6[") + fileArray[i].getAbsolutePath() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label15", "]\u51fa\u73b0\u5f02\u5e38\uff01"), exception);
            }
            string3 = null;
            try {
                object4 = TagDocumentReader.read(string4);
                if (object4 == null) {
                    throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label16", "\u89e3\u6790\u6a21\u677f\u6587\u4ef6[") + fileArray[i].getAbsolutePath() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label17", "]\u5931\u8d25\uff01"));
                }
                object3 = new PublishTaskContext(null, null);
                object2 = PublishElementFactory.makeElementFrom(metaView);
                object = new PublishPageContext((IPublishElement)object2, (PublishTaskContext)object3);
                PublishTagContext publishTagContext = new PublishTagContext((PublishPageContext)object);
                String[] stringArray = TagParseHelper.parseItems(((TagDocument)object4).getItems(), publishTagContext);
                string3 = stringArray[0];
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label16", "\u89e3\u6790\u6a21\u677f\u6587\u4ef6[") + fileArray[i].getAbsolutePath() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label15", "]\u51fa\u73b0\u5f02\u5e38\uff01"), exception);
            }
            object4 = "UTF-8";
            object3 = ConfigServer.getServer().getSysConfigValue("METADATA_JSP_FILEENCODING", "GB2312");
            object2 = fileArray[i].getName();
            object = object4;
            if (((String)object2).endsWith(".jsp")) {
                object = object3;
            }
            try {
                CMyFile.writeFile(string2 + metaView.getId() + File.separatorChar + (String)object2, string3, (String)object);
                continue;
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label18", "\u5199\u6587\u4ef6[") + string2 + fileArray[i].getName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label15", "]\u51fa\u73b0\u5f02\u5e38\uff01"), exception);
            }
        }
        return bl;
    }

    public MetaViewFields getViewFields(User user, MetaView metaView, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "ViewId=?", "");
        wCMFilter2.addSearchValues(metaView.getId());
        wCMFilter2.setOrder("FIELDORDER desc");
        wCMFilter2.mergeWith(wCMFilter);
        return MetaViewFields.openWCMObjs(user, wCMFilter2);
    }

    public void appendDefaultFields(User user, MetaDBTable metaDBTable) throws WCMException {
        String string = MetaDataConstants.makeTrueTableName(metaDBTable.getName());
        this.appendDefaultFields(string);
    }

    private void appendDefaultFields(String string) throws WCMException {
        TableInfo tableInfo = this.m_oDBMgr.getTableInfo(string);
        if (tableInfo == null) {
            logger.info((Object)(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label19", "\u6307\u5b9a\u7684\u8868[") + string + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label20", "]\u4e0d\u5b58\u5728\uff01")));
            return;
        }
        boolean bl = false;
        for (int i = 0; i < MetaDataConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            MetaDataType metaDataType = MetaDataConstants.DEFAULT_FIELDS.getDataTypeAt(i);
            String string2 = metaDataType.getKey();
            if (tableInfo.getFieldInfo(string2) != null) {
                logger.info((Object)(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label19", "\u6307\u5b9a\u7684\u8868[") + string + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label21", "]\u7684\u5b57\u6bb5[") + string2 + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label2", "]\u5df2\u7ecf\u5b58\u5728\uff01")));
                continue;
            }
            bl = true;
            String string3 = this.m_oDBMgr.getDBType().sqlAddField(string, string2, metaDataType.getSqlDataType(), metaDataType.getMaxLength(), true, null, 0);
            this.m_oDBMgr.sqlExecuteUpdate(string3);
        }
        if (bl) {
            this.m_oDBMgr.reloadTableInfo(string);
        }
    }

    private MetaDBField createDBFieldFromViewField(User user, MetaView metaView, MetaViewField metaViewField) throws WCMException {
        String string = metaViewField.getName();
        if (this.m_oDBMgr.getFieldInfo(MetaDataConstants.makeTrueTableName(metaView.getMainTableName()), string) != null) {
            String string2 = "TableName=? and FieldName=?";
            WCMFilter wCMFilter = new WCMFilter("", string2, "");
            wCMFilter.addSearchValues(metaView.getMainTableName());
            wCMFilter.addSearchValues(string);
            MetaDBFields metaDBFields = MetaDBFields.openWCMObjs(user, wCMFilter);
            if (metaDBFields.isEmpty()) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label22", "\u6570\u636e\u6709\u8bef\uff0c\u5b57\u6bb5[") + string + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label23", "]\u5728\u6570\u636e\u8868[") + metaView.getMainTableName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label24", "]\u7ed3\u6784\u4e2d\u6ca1\u6709\u63cf\u8ff0"));
            }
            return (MetaDBField)metaDBFields.getAt(0);
        }
        MetaDBField metaDBField = MetaDBField.createNewInstance();
        TableInfo tableInfo = DBManager.getDBManager().getTableInfo("XWCMDBFIELDINFO");
        Hashtable hashtable = metaViewField.getProperties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (tableInfo.getFieldInfo(string3) == null) continue;
            metaDBField.setProperty(string3, hashtable.get(string3));
        }
        metaDBField.setTableId(metaView.getMainTableId());
        metaDBField.setTableName(metaView.getMainTableName());
        metaDBField.setName(metaViewField.getName());
        metaDBField.setAnotherName(metaViewField.getAnotherName());
        return this.save(user, metaView.getMainTable(), metaDBField);
    }

    private MetaViewField createViewFieldFromDBField(User user, MetaView metaView, MetaDBField metaDBField) throws WCMException {
        int n = this.m_oDBMgr.sqlExecuteIntQuery("select VIEWFIELDINFOID from XWCMVIEWFIELDINFO where ViewId=? and DBFIELD=?", new int[]{metaView.getId(), metaDBField.getId()});
        if (n > 0) {
            return null;
        }
        MetaViewField metaViewField = MetaViewField.createNewInstance();
        TableInfo tableInfo = DBManager.getDBManager().getTableInfo("XWCMVIEWFIELDINFO");
        Hashtable hashtable = metaDBField.getProperties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (tableInfo.getFieldInfo(string) == null) continue;
            metaViewField.setProperty(string, hashtable.get(string));
        }
        metaViewField.setView(metaView.getId());
        metaViewField.setDBField(metaDBField.getId());
        metaViewField.setDBName(metaDBField.getName());
        metaViewField.save(user);
        return metaViewField;
    }

    public void setViewFields(User user, MetaView metaView, MetaDBFields metaDBFields) throws WCMException {
        if (metaDBFields.isEmpty()) {
            String string = "delete from XWCMVIEWFIELDINFO where ViewId=" + metaView.getId();
            this.m_oDBMgr.sqlExecuteUpdate(string);
        } else {
            int n = metaDBFields.size();
            for (int i = 0; i < n; ++i) {
                MetaDBField metaDBField = (MetaDBField)metaDBFields.getAt(i);
                if (metaDBField == null) continue;
                this.createViewFieldFromDBField(user, metaView, metaDBField);
            }
            String string = "delete from XWCMVIEWFIELDINFO where ViewId=" + metaView.getId() + " and DBFIELD not in(" + metaDBFields.getIdListAsString() + ")";
            this.m_oDBMgr.sqlExecuteUpdate(string);
        }
        this.m_oDataDefCacheMgr.reloadViewCache(metaView.getId());
    }

    public void delete(User user, MetaViewField metaViewField) throws WCMException {
        metaViewField.delete(user);
    }

    public void delete(User user, MetaView metaView) throws WCMException {
        Object object;
        String string;
        if (metaView.isMultiTable()) {
            try {
                string = "drop view WCMMetaView" + metaView.getId();
                this.m_oDBMgr.sqlExecuteUpdate(string);
            }
            catch (Exception exception) {
                logger.error((Object)I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label25", "\u5220\u9664\u591a\u8868\u89c6\u56fe\u7684\u5173\u8054\u89c6\u56fe\u5931\u8d25\uff01"), (Throwable)exception);
            }
            try {
                string = "WCMMetaRelation" + metaView.getId();
                object = "drop table " + string;
                this.m_oDBMgr.sqlExecuteUpdate((String)object);
            }
            catch (Exception exception) {
                logger.error((Object)I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label26", "\u5220\u9664\u591a\u8868\u89c6\u56fe\u7684\u5173\u8054\u8868\u5931\u8d25\uff01"), (Throwable)exception);
            }
        }
        CMyFile.deleteDir(MetaDataDefHelper.getViewApplicationRootPath() + metaView.getId());
        string = "delete from XWCMVIEWFIELDINFO where ViewId=" + metaView.getId();
        this.m_oDBMgr.sqlExecuteUpdate(string);
        metaView.delete(user);
        object = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        object.clearEmployer(user, metaView);
    }

    public MetaViews getViewsUsingTable(MetaDBTable metaDBTable) throws WCMException {
        String string = "MainTableId=? or ViewInfoId in(select XWCMViewOtherTables.ViewId from XWCMViewOtherTables where XWCMViewOtherTables.TableId=?)";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(metaDBTable.getId());
        wCMFilter.addSearchValues(metaDBTable.getId());
        return MetaViews.openWCMObjs(null, wCMFilter);
    }

    public MetaViews getViewsContainsTable(MetaDBTable metaDBTable) throws WCMException {
        String string = "ViewInfoId in(select XWCMViewOtherTables.ViewId from XWCMViewOtherTables where XWCMViewOtherTables.TableId=?)";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(metaDBTable.getId());
        return MetaViews.openWCMObjs(null, wCMFilter);
    }

    private void createViewRelationsOfDBField(User user, MetaDBField metaDBField) throws WCMException {
        MetaViews metaViews = this.getViewsUsingField(user, metaDBField);
        this.recreateViewRelations(user, metaViews);
    }

    private void recreateViewRelations(User user, MetaViews metaViews) throws WCMException {
        int n = metaViews.size();
        for (int i = 0; i < n; ++i) {
            MetaView metaView = (MetaView)metaViews.getAt(i);
            this.m_oDataDefCacheMgr.reloadViewCache(metaView.getId());
            try {
                this.createViewRelations(user, metaView);
                continue;
            }
            catch (Throwable throwable) {
                logger.error((Object)(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label27", "\u4ea7\u751f\u89c6\u56fe[Name=") + metaView.getDesc() + "][Id=" + metaView.getId() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label28", "]\u7684\u76f8\u5173\u5185\u5bb9\u5931\u8d25\uff01")), throwable);
            }
        }
    }

    public MetaViews getViewsUsingField(User user, MetaDBField metaDBField) throws WCMException {
        String string = "exists(select XWCMVIEWFIELDINFO.ViewId from XWCMVIEWFIELDINFO where XWCMVIEWFIELDINFO.DBField=? and XWCMVIEWFIELDINFO.ViewId=XWCMVIEWINFO.VIEWINFOID)";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(metaDBField.getId());
        return MetaViews.openWCMObjs(user, wCMFilter);
    }

    public void recreateAll(User user, MetaDBTables metaDBTables) throws WCMException {
        int n = metaDBTables.size();
        for (int i = 0; i < n; ++i) {
            MetaDBTable metaDBTable = (MetaDBTable)metaDBTables.getAt(i);
            if (metaDBTable == null) continue;
            String string = MetaDataConstants.makeTrueTableName(metaDBTable.getName());
            this.createTableInDB(user, metaDBTable, string);
            MetaDBFields metaDBFields = this.getDFieldInfos(user, metaDBTable, null);
            int n2 = metaDBFields.size();
            for (int j = 0; j < n2; ++j) {
                MetaDBField metaDBField = (MetaDBField)metaDBFields.getAt(j);
                if (metaDBField == null) continue;
                this.createFieldInDB(user, metaDBField, string);
            }
            this.m_oDBMgr.reloadTableInfo(string);
            MetaViews metaViews = this.getViewsUsingTable(metaDBTable);
            int n3 = metaViews.size();
            for (n2 = 0; n2 < n3; ++n2) {
                MetaView metaView = (MetaView)metaViews.getAt(n2);
                if (metaView == null) continue;
                this.createViewRelations(user, metaView, true);
            }
        }
    }

    public ClassInfos getClassInfosUsingMetaView(User user, MetaView metaView) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("exists(select 1 from XWCMViewFieldInfo");
        stringBuffer.append(" where fieldType=");
        stringBuffer.append(10);
        if (metaView != null) {
            stringBuffer.append(" and ViewId=").append(metaView.getId());
        } else {
            stringBuffer.append(" and exists(select 1 from XWCMViewInfo");
            stringBuffer.append(" where ViewInfoId=XWCMViewFieldInfo.ViewId)");
        }
        stringBuffer.append(" and ClassId = XWCMCLASSINFO.ClassInfoId)");
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.setWhere(stringBuffer.toString());
        return ClassInfos.openWCMObjs(user, wCMFilter);
    }

    public MetaViews getMetaViewsUsingClassInfo(User user, ClassInfo classInfo) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("exists(select 1 from XWCMViewFieldInfo");
        stringBuffer.append(" where fieldType=");
        stringBuffer.append(10);
        if (classInfo != null) {
            stringBuffer.append(" and ClassId=").append(classInfo.getId());
        } else {
            stringBuffer.append(" and exists(select 1 from XWCMClassInfo");
            stringBuffer.append(" where ClassInfoId=XWCMViewFieldInfo.ClassId)");
        }
        stringBuffer.append(" and viewId = XWCMVIEWINFO.viewInfoId)");
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.setWhere(stringBuffer.toString());
        return MetaViews.openWCMObjs(user, wCMFilter);
    }
}

