/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaDataDefCacheMgr
implements IMetaDataDefCacheMgr {
    private static Logger logger = Logger.getLogger(MetaDataDefCacheMgr.class);
    private HashMap m_hViewsCaches = null;

    public synchronized void clear() {
        if (this.m_hViewsCaches != null) {
            Collection collection = this.m_hViewsCaches.values();
            for (HashMap hashMap : collection) {
                hashMap.clear();
            }
            this.m_hViewsCaches.clear();
            this.m_hViewsCaches = null;
        }
    }

    public synchronized boolean init() throws WCMException {
        if (this.m_hViewsCaches != null) {
            return true;
        }
        this.m_hViewsCaches = new HashMap();
        MetaViewFields metaViewFields = MetaViewFields.openWCMObjs(null, null);
        int n = metaViewFields.size();
        for (int i = 0; i < n; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            this.putToViewCache(metaViewField);
        }
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        this.init();
        return true;
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (baseObj instanceof MetaViewField) {
            this.putToViewCache((MetaViewField)baseObj);
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) {
        if (baseObj instanceof MetaViewField) {
            MetaViewField metaViewField = (MetaViewField)baseObj;
            this.removeFromViewCache(metaViewField);
        } else if (baseObj instanceof MetaView) {
            this.removeFromViewCache(baseObj.getId());
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        logger.debug((Object)"The cache of the metaviewfield is updated.");
        if (baseObj instanceof MetaViewField) {
            this.putToViewCache((MetaViewField)baseObj, true);
        }
    }

    public MetaViewField getMetaViewField(int n, String string) throws WCMException {
        HashMap hashMap = (HashMap)this.getViewsCaches().get(new Integer(n));
        if (hashMap == null) {
            return null;
        }
        return (MetaViewField)hashMap.get(string.toUpperCase());
    }

    public HashMap getMetaViewFields(int n) throws WCMException {
        HashMap hashMap = (HashMap)this.getViewsCaches().get(new Integer(n));
        return hashMap == null ? new HashMap() : hashMap;
    }

    public Map getMetaViewFields(int n, int n2) throws WCMException {
        HashMap hashMap = this.getMetaViewFields(n);
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            MetaViewField metaViewField = (MetaViewField)entry.getValue();
            if (metaViewField.getType() != n2) continue;
            hashMap2.put(entry.getKey(), metaViewField);
        }
        return hashMap2;
    }

    public List getSortedMetaViewFields(int n) throws WCMException {
        HashMap hashMap = (HashMap)this.getViewsCaches().get(new Integer(n));
        if (hashMap == null) {
            return null;
        }
        Object[] objectArray = hashMap.values().toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                MetaViewField metaViewField = (MetaViewField)object;
                MetaViewField metaViewField2 = (MetaViewField)object2;
                return metaViewField2.getOrder() - metaViewField.getOrder();
            }
        });
        return Arrays.asList(objectArray);
    }

    public boolean isTitleFieldName(int n, String string) throws WCMException {
        MetaViewField metaViewField = this.getMetaViewField(n, string);
        if (metaViewField == null) {
            return false;
        }
        return metaViewField.isTitleField();
    }

    public boolean isFieldWithType(int n, String string, int n2) throws WCMException {
        MetaViewField metaViewField = this.getMetaViewField(n, string);
        if (metaViewField == null) {
            return false;
        }
        return metaViewField.getType() == n2;
    }

    public boolean isEditorField(MetaViewField metaViewField) throws WCMException {
        if (metaViewField == null) {
            return false;
        }
        int n = metaViewField.getType();
        if (n == 12 || n == 16) {
            return true;
        }
        return n == 1 && metaViewField.getDBType() == 2005;
    }

    public boolean isEditorField(int n, String string) throws WCMException {
        MetaViewField metaViewField = this.getMetaViewField(n, string);
        return this.isEditorField(metaViewField);
    }

    public synchronized void reloadViewCache(int n) throws WCMException {
        this.removeFromViewCache(n);
        WCMFilter wCMFilter = new WCMFilter("", "ViewId=?", "");
        wCMFilter.addSearchValues(n);
        MetaViewFields metaViewFields = MetaViewFields.openWCMObjs(null, wCMFilter);
        int n2 = metaViewFields.size();
        for (int i = 0; i < n2; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            this.putToViewCache(metaViewField);
        }
    }

    private void putToViewCache(MetaViewField metaViewField) throws WCMException {
        this.putToViewCache(metaViewField, false);
    }

    private void putToViewCache(MetaViewField metaViewField, boolean bl) throws WCMException {
        Integer n;
        HashMap<String, MetaViewField> hashMap;
        if (this.m_hViewsCaches == null) {
            this.init();
        }
        if ((hashMap = (HashMap<String, MetaViewField>)this.m_hViewsCaches.get(n = new Integer(metaViewField.getViewId()))) == null) {
            hashMap = new HashMap<String, MetaViewField>();
            this.m_hViewsCaches.put(n, hashMap);
        }
        String string = null;
        if (bl) {
            string = metaViewField.getNewPropertyAsString("FieldName");
            if (string != null) {
                hashMap.remove(metaViewField.getName().toUpperCase());
            } else {
                string = metaViewField.getName();
            }
        } else {
            string = metaViewField.getName();
        }
        hashMap.put(string.toUpperCase(), metaViewField);
    }

    private void removeFromViewCache(MetaViewField metaViewField) {
        if (this.m_hViewsCaches == null) {
            return;
        }
        Integer n = new Integer(metaViewField.getViewId());
        HashMap hashMap = (HashMap)this.m_hViewsCaches.get(n);
        if (hashMap == null) {
            return;
        }
        hashMap.remove(metaViewField.getName().toUpperCase());
    }

    private void removeFromViewCache(int n) {
        if (this.m_hViewsCaches == null) {
            return;
        }
        Integer n2 = new Integer(n);
        HashMap hashMap = (HashMap)this.m_hViewsCaches.get(n2);
        if (hashMap == null) {
            return;
        }
        hashMap.clear();
        this.m_hViewsCaches.remove(n2);
    }

    private HashMap getViewsCaches() throws WCMException {
        if (this.m_hViewsCaches == null) {
            this.init();
        }
        return this.m_hViewsCaches;
    }
}

