/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.StringTokenizer;

public class ClassInfoMgr
implements IClassInfoMgr {
    public void deleteClassInfo(User user, ClassInfo classInfo) throws WCMException {
        if (classInfo == null) {
            return;
        }
        ClassInfos classInfos = this.queryChildren(user, classInfo, null);
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo2 = (ClassInfo)classInfos.getAt(i);
            this.deleteClassInfo(user, classInfo2);
        }
        classInfo.delete(user);
    }

    public ClassInfos queryChildren(User user, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "ParentId=?", "ClassOrder desc");
        wCMFilter2.addSearchValues(classInfo == null ? 0 : classInfo.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return ClassInfos.openWCMObjs(user, wCMFilter2);
    }

    public String queryChildrenWithFirstLevel(User user, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        return this.queryChildren(user, classInfo, wCMFilter).getIdListAsString();
    }

    public String queryChildrenWithFirstLevel(User user, ClassInfo classInfo, WCMFilter wCMFilter, char c) throws WCMException {
        return this.queryChildren(user, classInfo, wCMFilter).getIdListAsString(c);
    }

    public String queryChildrenWithAllLevel(User user, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        return this.queryChildrenWithAllLevel(user, classInfo, wCMFilter, ',');
    }

    public String queryChildrenWithAllLevel(User user, ClassInfo classInfo, WCMFilter wCMFilter, char c) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = classInfo == null ? 0 : classInfo.getId();
        this.queryChildrenWithAllLevel(user, n, wCMFilter, stringBuffer, c);
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String queryChildrenWithAllLevel(User user, int n, WCMFilter wCMFilter) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer();
        this.queryChildrenWithAllLevel(user, n, wCMFilter, stringBuffer, ',');
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private void queryChildrenWithAllLevel(User user, int n, WCMFilter wCMFilter, StringBuffer stringBuffer, char c) throws WCMException {
        int n2;
        WCMFilter wCMFilter2 = new WCMFilter("", "ParentId=?", "ClassOrder desc");
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        ClassInfos classInfos = ClassInfos.openWCMObjs(user, wCMFilter2);
        int n3 = classInfos.size();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(classInfos.getIdAt(n2)).append(c);
        }
        n3 = classInfos.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.queryChildrenWithAllLevel(user, classInfos.getIdAt(n2), wCMFilter, stringBuffer, c);
        }
    }

    public String getPath(ClassInfos classInfos) throws WCMException {
        if (classInfos == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            stringBuffer.append(this.getPath(classInfo)).append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String getPath(ClassInfo classInfo) throws WCMException {
        if (classInfo == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.insert(0, classInfo.getId());
        while (!classInfo.isRoot()) {
            int n = classInfo.getParentId();
            stringBuffer.insert(0, n + ",");
            classInfo = ClassInfo.findById(n);
        }
        return stringBuffer.toString();
    }

    public ClassInfo getClassInfo(String string) throws WCMException {
        return this.getClassInfo(string, "\\");
    }

    public ClassInfo getClassInfo(String string, String string2) throws WCMException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = 0;
        ClassInfo classInfo = null;
        String string3 = null;
        User user = User.findByName("admin");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (CMyString.isEmpty(string3)) continue;
            classInfo = this.getClassInfo(n, string3, user);
            if (classInfo == null) break;
            n = classInfo.getId();
        }
        return classInfo;
    }

    private ClassInfo getClassInfo(int n, String string, User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "parentId=? and cName=?", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        ClassInfos classInfos = ClassInfos.openWCMObjs(user, wCMFilter);
        int n2 = classInfos.size();
        for (int i = 0; i < n2; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            return classInfo;
        }
        return null;
    }

    public static void main(String[] stringArray) throws WCMException {
        ClassInfoMgr classInfoMgr = new ClassInfoMgr();
        ClassInfo classInfo = classInfoMgr.getClassInfo(I18NMessage.get(ClassInfoMgr.class, "ClassInfoMgr.label1", "\u4e3b\u9898\u5206\u7c7b\\\u56fd\u52a1\u9662\u7ec4\u7ec7\u673a\u6784\\\u56fd\u52a1\u9662\u529e\u516c\u5385"));
        System.out.println(classInfo);
        if (classInfo != null) {
            System.out.println("---------------" + classInfo);
        }
    }

    public String getNamePath(ClassInfos classInfos) throws WCMException {
        if (classInfos == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            stringBuffer.append(this.getNamePath(classInfo)).append(";");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String getNamePath(ClassInfo classInfo) throws WCMException {
        if (classInfo == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.insert(0, classInfo.getName());
        while (!classInfo.isRoot()) {
            int n = classInfo.getParentId();
            if ((classInfo = ClassInfo.findById(n)) == null) continue;
            stringBuffer.insert(0, classInfo.getName() + "/");
        }
        return stringBuffer.toString();
    }

    public ClassInfos getClassInfosByName(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "cName=?", "");
        wCMFilter.addSearchValues(string);
        return ClassInfos.openWCMObjs(null, wCMFilter);
    }

    public ClassInfos getClassInfosByName(int n, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "rootId=? and cName=?", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        return ClassInfos.openWCMObjs(null, wCMFilter);
    }

    public boolean isAncestor(int n, int n2) throws WCMException {
        ClassInfo classInfo = ClassInfo.findById(n2);
        while (classInfo != null) {
            int n3 = classInfo.getParentId();
            if (n == n3) {
                return true;
            }
            classInfo = ClassInfo.findById(n3);
        }
        return false;
    }

    public ClassInfos queryAnyClassInfos(User user, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "rootId=?", "ClassOrder desc");
        wCMFilter2.addSearchValues(classInfo == null ? 0 : classInfo.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return ClassInfos.openWCMObjs(user, wCMFilter2);
    }
}

