/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center.xml;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverterForSpecialProperty;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class MetaViewDataToXML
extends BaseObjToXmlConverterForSpecialProperty {
    private static Logger logger = Logger.getLogger(MetaViewDataToXML.class);
    private IMetaDataDefCacheMgr m_oCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private MetaView m_oView = null;
    private ArrayList m_arAppFiles = new ArrayList();

    public MetaViewDataToXML(MetaView metaView) {
        this.m_oView = metaView;
    }

    public ArrayList getAppFiles() {
        return this.m_arAppFiles;
    }

    protected String[][] getSpecialProperty(BaseObj baseObj, int n, String string, Object object) throws ConvertException {
        CMSObj cMSObj;
        try {
            cMSObj = this.m_oCacheMgr.getMetaViewField(this.m_oView.getId(), string);
            if (cMSObj == null) {
                return null;
            }
            switch (((MetaViewField)cMSObj).getType()) {
                case 8: {
                    this.m_arAppFiles.add(object.toString());
                    break;
                }
                case 12: 
                case 16: {
                    HTMLContent hTMLContent = new HTMLContent(object.toString());
                    this.m_arAppFiles.addAll(hTMLContent.getWCMFiles());
                    MetaViewData metaViewData = (MetaViewData)baseObj;
                    return new String[][]{{metaViewData.getRealProperty(string)}};
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Exception to record files!", (Throwable)exception);
        }
        try {
            cMSObj = (MetaViewData)baseObj;
            return new String[][]{{"RealValue", ((MetaViewData)cMSObj).getRealProperty(string)}};
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(MetaViewDataToXML.class, "MetaViewDataToXML.label1", "\u8f6c\u6362[") + string + I18NMessage.get(MetaViewDataToXML.class, "MetaViewDataToXML.label2", "]\u5c5e\u6027\u5931\u8d25\uff01"), exception);
        }
    }

    protected void registerHostSpecialProperties() {
        HashMap hashMap = null;
        try {
            hashMap = this.m_oCacheMgr.getMetaViewFields(this.m_oView.getId());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        int n = 1;
        for (MetaViewField metaViewField : hashMap.values()) {
            block6: {
                switch (metaViewField.getType()) {
                    case -1: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 16: {
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                this.registerHostSpecialProperty(metaViewField.getName(), n);
            }
            ++n;
        }
    }

    protected Element toXmlElement(BaseObj baseObj, String string) throws WCMException {
        Element element = super.toXmlElement(baseObj, string);
        element.element("PROPERTIES").addElement("CHNLNAME");
        MetaViewData metaViewData = (MetaViewData)baseObj;
        if (metaViewData != null) {
            String string2 = metaViewData.getChannel().getName();
            element.element("PROPERTIES").element("CHNLNAME").addCDATA(string2);
        }
        return element;
    }

    protected Element[] getChildElement(BaseObj baseObj) throws WCMException {
        MetaViewData metaViewData = (MetaViewData)baseObj;
        Document document = Document.findById(metaViewData.getMetaDataId());
        if (document == null) {
            logger.error((Object)(I18NMessage.get(MetaViewDataToXML.class, "MetaViewDataToXML.label3", "\u6570\u636e\u53ef\u80fd\u6709\u8bef\uff0c\u6240\u5c5e\u6587\u6863\u4e0d\u5b58\u5728\uff01[ID=") + metaViewData.getMetaDataId() + "]"));
            return null;
        }
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes appendixes = appendixMgr.getAppendixes(document, -1);
        appendixes.setMaxBufferSize(appendixes.size());
        int n = appendixes.size();
        for (int i = 0; i < n; ++i) {
            Appendix appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null || appendix.getFlag() == 40) continue;
            this.m_arAppFiles.add(appendix.getFile());
        }
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        return new Element[]{objToXmlConverter.toXmlElement(appendixes, null)};
    }

    public String getElementTag(BaseObj baseObj) {
        return "MetaViewData";
    }

    public String getElementTag(BaseObjs baseObjs) {
        return "MetaViewDataS";
    }
}

