/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center.xml;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaDataCenterClassInfoHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.xml.XMLToMetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MetaViewDataImporter {
    private static Logger logger = Logger.getLogger(MetaViewDataImporter.class);
    private static final String CHILD_TAG_APPENDIXES = "WCMAPPENDIXS";
    private MetaView m_oDstView = null;
    private Channel m_oDstChannel = null;
    private User m_oCurrUser = null;
    private String m_sCurrImportFile = null;
    private String m_sCurrXSLFile = null;
    private String m_sUnZIPTempPath = null;
    private boolean bImportToCurrChannel = true;
    private boolean bImportByChnlName = true;
    private int m_nImportType = 1;
    private Reports m_oCurrReports = null;
    private static IMetaDataDefCacheMgr m_oDataDefCacheMgr = null;
    private static IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private CMyUnZipFile m_oZIPUtil = null;

    public MetaViewDataImporter(User user, MetaView metaView, Channel channel) {
        this.m_oCurrUser = user;
        this.m_oDstView = metaView;
        this.m_oDstChannel = channel;
        m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    }

    public Reports importFromFile(int n, String string, String string2) throws WCMException {
        this.m_oCurrReports = new Reports(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label2", "\u5bfc\u5165\u8bb0\u5f55!"));
        String string3 = CMyFile.extractFileExt(string);
        if (string3 == null || (string3 = string3.trim()).length() == 0) {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label3", "\u53c2\u6570[ImportFile=") + string + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label4", "]\u4e0d\u6b63\u786e\uff01\u6ca1\u6709\u540e\u7f00\u540d"), null);
            return this.m_oCurrReports;
        }
        string3 = string3.toUpperCase();
        String string4 = null;
        try {
            string4 = MetaViewDataImporter.converToAbsoluteFileName(string);
        }
        catch (Exception exception) {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label5", "\u5bfc\u5165\u7684\u6587\u4ef6\u6709\u8bef\uff01\uff08\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u89c4\u5219\u4e0d\u5bf9\uff09"), exception);
            return this.m_oCurrReports;
        }
        String string5 = string2;
        try {
            if (!CMyString.isEmpty(string5)) {
                string5 = MetaViewDataImporter.converToAbsoluteFileName(string5);
            }
        }
        catch (Exception exception) {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label6", "XSL\u6587\u4ef6\u6709\u8bef\uff01\uff08\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u89c4\u5219\u4e0d\u5bf9\uff09"), exception);
            return this.m_oCurrReports;
        }
        this.m_sCurrImportFile = string4;
        this.m_sCurrXSLFile = string5;
        this.m_nImportType = n;
        if (string3.equals("XML")) {
            this.importFromXML(string4);
        } else if (string3.equals("ZIP")) {
            this.importFromZip();
        } else {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label7", "\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b[FileExt=") + string3 + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label8", "]\u4e0d\u6b63\u786e\uff01"), null);
            return this.m_oCurrReports;
        }
        if (this.m_oCurrReports.getSucessedReporter().size() > 0 && this.m_oCurrReports.getFailedReporter().isEmpty()) {
            this.m_oCurrReports.setTitle(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label9", "\u5bfc\u5165\u8bb0\u5f55\u6210\u529f!"));
            CMyFile.deleteDir(string4);
        } else {
            this.m_oCurrReports.setTitle(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label10", "\u5bfc\u5165\u8bb0\u5f55\u65f6\u51fa\u73b0\u9519\u8bef!"));
            if (this.m_oCurrReports.getFailedReporter().isEmpty()) {
                throw new WCMException(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label21", "\u5bfc\u5165\u7684\u64cd\u4f5c\u65b9\u5f0f\u9009\u62e9\u9519\u8bef\u3002"));
            }
        }
        return this.m_oCurrReports;
    }

    public void setImportToCurrChannel(boolean bl) {
        this.bImportToCurrChannel = bl;
    }

    public boolean isImportToCurrChannel() {
        return this.bImportToCurrChannel;
    }

    public void setImportByChnlName(boolean bl) {
        this.bImportByChnlName = bl;
    }

    public boolean isImportByChnlName() {
        return this.bImportByChnlName;
    }

    private void importFromXML(String string) {
        Object object;
        Object object2;
        XMLToMetaViewData xMLToMetaViewData = new XMLToMetaViewData(this.m_nImportType);
        xMLToMetaViewData.registPersistentObj("WCMAPPENDIX", Appendix.class);
        XmlObject[] xmlObjectArray = null;
        try {
            xmlObjectArray = xMLToMetaViewData.convertXml(string, this.m_sCurrXSLFile, null);
        }
        catch (Throwable throwable) {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label11", "\u5c06XML\u8f6c\u6362\u6210Obj\u5931\u8d25\uff01[XML=") + string + "]", throwable);
            return;
        }
        int n = xmlObjectArray.length;
        HashMap hashMap = new HashMap(10, 1.0f);
        if (this.m_oZIPUtil != null) {
            Hashtable hashtable = this.m_oZIPUtil.getAllFileNameIndex();
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                String string2 = CMyFile.extractFileExt((String)object);
                if (string2.equalsIgnoreCase("xml")) continue;
                hashMap.put(((String)object).toLowerCase(), hashtable.get(object));
            }
        }
        for (int i = n - 1; i >= 0; --i) {
            try {
                object2 = (MetaViewData)xmlObjectArray[i].getCurrentObj();
                ((BaseObj)object2).removeProperty("MetaDataId");
                ((MetaViewData)object2).setMetaDataId(0);
                if (this.isImportToCurrChannel()) {
                    ((BaseObj)object2).setProperty("CHANNELID", this.m_oDstChannel.getId());
                    ((MetaViewData)object2).setView(this.m_oDstView);
                } else {
                    int n2;
                    object = null;
                    if (this.isImportByChnlName()) {
                        n2 = this.m_oDstChannel.getSiteId();
                        String string3 = ((BaseObj)object2).getPropertyAsString("CHNLNAME");
                        object = Channel.findByName(n2, string3);
                    } else {
                        n2 = ((MetaViewData)object2).getPropertyAsInt("ChannelId", 0);
                        object = Channel.findById(n2);
                    }
                    if (object != null) {
                        this.m_oDstView = m_oMetaViewEmployerMgr.getViewOfEmployer((Channel)object);
                        ((BaseObj)object2).setProperty("CHANNELID", ((BaseObj)object).getId());
                        ((MetaViewData)object2).setView(this.m_oDstView);
                    } else {
                        logger.warn((Object)"omited a metaviewdata import because the original channel do not existed!");
                        this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label13", "\u5c06\u7b2c[") + (i + 1) + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label15", "]\u6761\u8bb0\u5f55\u5165\u5e93\u65f6\u51fa\u73b0\u9519\u8bef\uff01"), new WCMException(I18NMessage.makeObjectNotFound(new String[]{String.valueOf(((BaseObj)object2).getPropertyAsString("CHNLNAME")), String.valueOf(((MetaViewData)object2).getPropertyAsInt("ChannelId", 0)), WCMTypes.getLowerObjName(101)})));
                        continue;
                    }
                }
                if (this.m_oDstView.isMultiTable()) {
                    this.dowithOtherDatasOfOtherTable((MetaViewData)object2);
                }
                this.rendHtmlFields((MetaViewData)object2, hashMap);
                MetaDataCenterClassInfoHelper.renderClassInfoFields((MetaViewData)object2);
                this.rendAppendixFields((MetaViewData)object2);
                this.rendDateFields((MetaViewData)object2);
                this.rendSpecialFields4Excel((MetaViewData)object2);
                ((MetaViewData)object2).translateFields();
                ((CMSObj)object2).save(this.m_oCurrUser);
                this.m_oCurrReports.addSucessedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label13", "\u5c06\u7b2c[") + (i + 1) + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label14", "]\u6761\u8bb0\u5f55\u5165\u5e93\u6210\u529f\uff01"));
                this.processAppendix(xmlObjectArray[i], ((BaseObj)object2).getId());
                continue;
            }
            catch (Throwable throwable) {
                this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label13", "\u5c06\u7b2c[") + (i + 1) + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label15", "]\u6761\u8bb0\u5f55\u5165\u5e93\u65f6\u51fa\u73b0\u9519\u8bef\uff01"), throwable);
            }
        }
        MetaDataCenterClassInfoHelper.destory();
    }

    private void dowithOtherDatasOfOtherTable(MetaViewData metaViewData) throws WCMException, CMyException {
        Object object;
        Object object22;
        HashMap<Object, WCMFilter> hashMap = new HashMap<Object, WCMFilter>();
        HashMap hashMap2 = m_oDataDefCacheMgr.getMetaViewFields(this.m_oDstView.getId());
        boolean bl = false;
        for (Object object22 : hashMap2.values()) {
            if (object22 == null || ((MetaViewField)object22).isFromMainTable()) continue;
            if (bl) {
                metaViewData.removeProperty(((MetaViewField)object22).getName());
                continue;
            }
            int n = ((MetaViewField)object22).getType();
            if (((MetaViewField)object22).getLength() >= 500 || n == 12 || n == 16 || n == 8) {
                metaViewData.removeProperty(((MetaViewField)object22).getName());
                continue;
            }
            if (((MetaViewField)object22).getDBType() == 2005) continue;
            object = ((MetaViewField)object22).getTableName().toUpperCase();
            WCMFilter wCMFilter = (WCMFilter)hashMap.get(object);
            if ((wCMFilter = this.makeQueryOtherDataIdFilter((MetaViewField)object22, wCMFilter, metaViewData)) != null) {
                hashMap.put(object, wCMFilter);
            } else {
                bl = true;
            }
            metaViewData.removeProperty(((MetaViewField)object22).getName());
        }
        if (bl) {
            hashMap.clear();
        }
        Iterator<Object> iterator = hashMap.keySet().iterator();
        object22 = DBManager.getDBManager();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = (WCMFilter)hashMap.get(string);
            int n = ((DBManager)object22).sqlExecuteIntQuery((WCMFilter)object);
            if (n <= 0) continue;
            metaViewData.setProperty(((WCMFilter)object).getFrom() + "ID", n);
        }
    }

    private WCMFilter makeQueryOtherDataIdFilter(MetaViewField metaViewField, WCMFilter wCMFilter, MetaViewData metaViewData) throws CMyException {
        String string = metaViewField.getName();
        String string2 = metaViewData.getPropertyAsString(string);
        if (CMyString.isEmpty(string2)) {
            return wCMFilter;
        }
        String string3 = null;
        if (wCMFilter == null) {
            string3 = metaViewField.getDBName() + "=?";
            wCMFilter = new WCMFilter(MetaDataConstants.makeTrueTableName(metaViewField.getTableName()).toUpperCase(), string3, "", "MetaDataId");
        } else {
            string3 = wCMFilter.getWhere() + " and " + metaViewField.getDBName() + "=?";
        }
        wCMFilter.setWhere(string3);
        switch (metaViewField.getDBType()) {
            case 93: {
                CMyDateTime cMyDateTime = new CMyDateTime();
                if (!cMyDateTime.testDateFormat(string2)) {
                    return null;
                }
                cMyDateTime.setDateTimeWithString(string2);
                wCMFilter.addSearchValues(cMyDateTime);
                break;
            }
            case 4: {
                int n;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Throwable throwable) {
                    return null;
                }
                wCMFilter.addSearchValues(n);
                break;
            }
            case 6: {
                float f;
                try {
                    f = Float.parseFloat(string2);
                }
                catch (Throwable throwable) {
                    return null;
                }
                wCMFilter.addSearchValues(f);
                break;
            }
            case 8: {
                double d;
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Throwable throwable) {
                    return null;
                }
                wCMFilter.addSearchValues(d);
                break;
            }
            default: {
                wCMFilter.addSearchValues(string2);
            }
        }
        return wCMFilter;
    }

    private void rendAppendixFields(MetaViewData metaViewData) throws WCMException {
        if (this.m_sUnZIPTempPath == null) {
            return;
        }
        HashMap hashMap = m_oDataDefCacheMgr.getMetaViewFields(metaViewData.getMetaView().getId());
        for (MetaViewField metaViewField : hashMap.values()) {
            String string;
            String string2;
            if (metaViewField == null || metaViewField.getType() != 8 || CMyString.isEmpty(string2 = metaViewData.getFinalPropertyAsString(string = metaViewField.getName()))) continue;
            string2 = string2.trim();
            if (!CMyFile.fileExists(this.m_sUnZIPTempPath + string2)) {
                logger.debug((Object)(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label16", "\u9644\u4ef6[") + this.m_sUnZIPTempPath + string2 + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label17", "]\u4e0d\u5b58\u5728\uff0c\u6240\u4ee5\u5ffd\u7565")));
                metaViewData.removeProperty(string);
                continue;
            }
            FilesMan filesMan = FilesMan.getFilesMan();
            String string3 = filesMan.getNextFileName("P0", CMyFile.extractFileExt(string2));
            String string4 = filesMan.mapFilePath(string3, 0);
            try {
                CMyFile.copyFile(this.m_sUnZIPTempPath + string2, string4 + string3);
            }
            catch (CMyException cMyException) {
                this.m_oCurrReports.addWarnedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label18", "\u5904\u7406\u9644\u4ef6\u5931\u8d25\uff01[DocId=") + this.m_sUnZIPTempPath + string2 + "]", cMyException);
                continue;
            }
            metaViewData.setPropertyWithString(string, string3);
        }
    }

    private void rendDateFields(MetaViewData metaViewData) throws CMyException {
        HashMap hashMap = m_oDataDefCacheMgr.getMetaViewFields(metaViewData.getMetaView().getId());
        for (MetaViewField metaViewField : hashMap.values()) {
            String string;
            String string2;
            if (metaViewField == null || metaViewField.getType() != 11 || CMyString.isEmpty(string2 = metaViewData.getFinalPropertyAsString(string = metaViewField.getName()))) continue;
            string2 = string2.trim();
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            metaViewData.setPropertyWithString(string, "1900-01-01");
            metaViewData.getPropertyAsDateTime(string).dateAdd(3, n - 2);
        }
    }

    private void rendSpecialFields4Excel(MetaViewData metaViewData) throws WCMException {
        HashMap hashMap = m_oDataDefCacheMgr.getMetaViewFields(metaViewData.getMetaView().getId());
        for (MetaViewField metaViewField : hashMap.values()) {
            String string;
            String string2;
            if (metaViewField == null || !metaViewField.isFromMainTable() || CMyString.isEmpty(string2 = metaViewData.getFinalPropertyAsString(string = metaViewField.getName()))) continue;
            string2 = string2.trim();
            switch (MetaDataConstants.formatOfEnumValue(metaViewField.getType())) {
                case 5: {
                    try {
                        Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (string2.equals(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label23", "\u662f"))) {
                            string2 = "1";
                        }
                        if (!string2.equals(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label24", "\u5426"))) break;
                        string2 = "0";
                    }
                    break;
                }
                case -1: {
                    HashMap hashMap2 = metaViewField.getEnmValueMap(false);
                    Object[] objectArray = string2.split(",");
                    if (objectArray != null && objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            Object object = objectArray[i];
                            if (!hashMap2.containsKey(object) || hashMap2.containsValue(object)) continue;
                            objectArray[i] = (String)hashMap2.get(object);
                        }
                    }
                    string2 = CMyString.join(objectArray, ",");
                    break;
                }
            }
            metaViewData.setProperty(string, string2);
        }
    }

    private void rendHtmlFields(MetaViewData metaViewData, HashMap hashMap) throws WCMException {
        HashMap hashMap2 = m_oDataDefCacheMgr.getMetaViewFields(metaViewData.getMetaView().getId());
        Iterator iterator = hashMap2.values().iterator();
        if (!hashMap.isEmpty()) {
            while (iterator.hasNext()) {
                String string;
                String string2;
                MetaViewField metaViewField = (MetaViewField)iterator.next();
                if (metaViewField == null || metaViewField.getType() != 12 && metaViewField.getType() != 16 || CMyString.isEmpty(string2 = metaViewData.getFinalPropertyAsString(string = metaViewField.getName()))) continue;
                string2 = HTMLContent.saveHTMLContentFromOut(string2, hashMap);
                metaViewData.setPropertyWithString(string, string2);
            }
        } else {
            while (iterator.hasNext()) {
                String string;
                String string3;
                MetaViewField metaViewField = (MetaViewField)iterator.next();
                if (metaViewField == null || metaViewField.getType() != 12 && metaViewField.getType() != 16 || CMyString.isEmpty(string3 = metaViewData.getFinalPropertyAsString(string = metaViewField.getName()))) continue;
                metaViewData.setPropertyWithString(string, string3);
            }
        }
    }

    void rendHTMLFields(MetaViewData metaViewData) throws WCMException {
        Object object;
        if (this.m_oZIPUtil == null) {
            return;
        }
        Hashtable hashtable = this.m_oZIPUtil.getAllFileNameIndex();
        HashMap hashMap = new HashMap(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = CMyFile.extractFileExt((String)object);
            if (string.equalsIgnoreCase("xml")) continue;
            hashMap.put(((String)object).toLowerCase(), hashtable.get(object));
        }
        if (hashMap.isEmpty()) {
            return;
        }
        object = m_oDataDefCacheMgr.getMetaViewFields(metaViewData.getMetaView().getId());
        for (MetaViewField metaViewField : object.values()) {
            String string;
            String string2;
            if (metaViewField == null || metaViewField.getType() != 12 && metaViewField.getType() != 16 || CMyString.isEmpty(string2 = metaViewData.getFinalPropertyAsString(string = metaViewField.getName()))) continue;
            string2 = HTMLContent.saveHTMLContentFromOut(string2, hashMap);
            metaViewData.setPropertyWithString(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importFromZip() {
        ArrayList arrayList;
        this.m_sUnZIPTempPath = CMyFile.extractFilePath(this.m_sCurrImportFile);
        this.m_sUnZIPTempPath = this.m_sUnZIPTempPath + "temp" + System.currentTimeMillis() + File.separator;
        try {
            block7: {
                this.m_oZIPUtil = new CMyUnZipFile(this.m_sCurrImportFile, this.m_sUnZIPTempPath);
                try {
                    this.m_oZIPUtil.addFileExtFilters("XML");
                    this.m_oZIPUtil.doUnZipAnd();
                }
                catch (CMyException cMyException) {
                    this.m_sUnZIPTempPath = null;
                    this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label19", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25![File=") + this.m_sCurrImportFile + ",DstPath=" + this.m_sUnZIPTempPath + "]", cMyException);
                    Object var5_3 = null;
                    if (this.m_oCurrReports.getFailedReporter() != null && !this.m_oCurrReports.getFailedReporter().isEmpty() || logger.isDebugEnabled()) return;
                    CMyFile.deleteFile(this.m_sCurrImportFile);
                    if (this.m_sUnZIPTempPath == null) return;
                    CMyFile.deleteDir(this.m_sUnZIPTempPath);
                    return;
                }
                arrayList = this.m_oZIPUtil.getFilteredFiles();
                if (arrayList == null) break block7;
                if (!arrayList.isEmpty()) break block8;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.m_oCurrReports.getFailedReporter() != null && !this.m_oCurrReports.getFailedReporter().isEmpty() || logger.isDebugEnabled()) throw throwable;
            CMyFile.deleteFile(this.m_sCurrImportFile);
            if (this.m_sUnZIPTempPath == null) throw throwable;
            CMyFile.deleteDir(this.m_sUnZIPTempPath);
            throw throwable;
        }
        if (this.m_oCurrReports.getFailedReporter() != null && !this.m_oCurrReports.getFailedReporter().isEmpty() || logger.isDebugEnabled()) return;
        CMyFile.deleteFile(this.m_sCurrImportFile);
        if (this.m_sUnZIPTempPath == null) return;
        CMyFile.deleteDir(this.m_sUnZIPTempPath);
        {
            block8: {
                return;
            }
            String string = null;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                string = (String)arrayList.get(i);
                if (this.isExportedFileForOfflineView(CMyFile.extractFileName(string)) || FilesMan.isValidFile(CMyFile.extractFileName(string), "P0")) continue;
                this.importFromXML(string);
            }
        }
        Object var5_5 = null;
        if (this.m_oCurrReports.getFailedReporter() != null && !this.m_oCurrReports.getFailedReporter().isEmpty() || logger.isDebugEnabled()) return;
        CMyFile.deleteFile(this.m_sCurrImportFile);
        if (this.m_sUnZIPTempPath == null) return;
        CMyFile.deleteDir(this.m_sUnZIPTempPath);
        return;
    }

    public static String converToAbsoluteFileName(String string) throws WCMException {
        String string2 = null;
        File file = new File(string);
        if (file.exists()) {
            string2 = file.getAbsolutePath();
        } else {
            FilesMan filesMan = FilesMan.getFilesMan();
            String[] stringArray = new String[]{"U0", "ST"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!FilesMan.isValidFile(string, stringArray[i])) continue;
                string2 = filesMan.mapFilePath(string, 0) + string;
                break;
            }
            if (string2 == null) {
                throw new WCMException(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label20", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string + "]");
            }
            if (!CMyFile.fileExists(string2)) {
                throw new WCMException(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label20", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + string2 + "]");
            }
        }
        return string2;
    }

    private boolean isExportedFileForOfflineView(String string) {
        return "trs_wcm_viewer_index.htm".equals(string) || "trs_wcm_viewer_doview.htm".equals(string) || "resource.xml".equals(string) || "reference.xml".equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processAppendix(XmlObject xmlObject, int n) throws WCMException {
        block26: {
            Object object;
            Object object2;
            if (this.m_sUnZIPTempPath == null) {
                return;
            }
            XmlObject[] xmlObjectArray = xmlObject.getChild(CHILD_TAG_APPENDIXES);
            if (xmlObjectArray == null || xmlObjectArray.length == 0) {
                return;
            }
            Appendix appendix = null;
            String string = null;
            String string2 = null;
            FilesMan filesMan = FilesMan.getFilesMan();
            String string3 = this.m_sUnZIPTempPath;
            boolean bl = false;
            for (int i = 0; i < xmlObjectArray.length; ++i) {
                appendix = (Appendix)xmlObjectArray[i].getCurrentObj();
                appendix.setDocId(n);
                int n2 = appendix.getFlag();
                if (n2 != 40) {
                    if (n2 == 30) continue;
                    object2 = appendix.getFile();
                    if (!CMyFile.fileExists(this.m_sUnZIPTempPath + (String)object2)) continue;
                    appendix.setSrcFile((String)object2);
                    appendix.setFileExt(CMyFile.extractFileExt((String)object2));
                    object = appendix.getDesc();
                    if (object == null || ((String)object).length() == 0) {
                        appendix.setDesc(appendix.getFile());
                    }
                    if (n2 == 20) {
                        string = filesMan.getNextFileName("W0", appendix.getFileExt());
                        bl = true;
                    } else {
                        string = filesMan.getNextFileName("P0", appendix.getFileExt());
                    }
                    appendix.setUsedVersions(1L);
                    string2 = filesMan.mapFilePath(string, 0);
                    try {
                        CMyFile.copyFile(string3 + (String)object2, string2 + string);
                    }
                    catch (CMyException cMyException) {
                        this.m_oCurrReports.addWarnedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label18", "\u5904\u7406\u9644\u4ef6\u5931\u8d25\uff01[DocId=") + n + ",File=" + (String)object2 + "]", cMyException);
                        continue;
                    }
                    appendix.setFile(string);
                }
                appendix.save(this.m_oCurrUser);
            }
            if (bl) {
                DBManager dBManager;
                block24: {
                    block23: {
                        dBManager = DBManager.getDBManager();
                        String string4 = "update WCMDOCUMENT set ATTACHPIC=? where DOCID=?";
                        object2 = null;
                        object = null;
                        object2 = dBManager.getConnection();
                        object = object2.prepareStatement(string4);
                        object.setInt(1, 1);
                        object.setInt(2, n);
                        object.executeUpdate();
                        if (dBManager.getFieldInfo("WCMCHNLDOC", "ATTACHPIC") == null) break block23;
                        string4 = "update WCMCHNLDOC set ATTACHPIC=? where DOCID=?";
                        object.close();
                        object = object2.prepareStatement(string4);
                        object.setInt(1, 1);
                        object.setInt(2, n);
                        object.executeUpdate();
                    }
                    Object var16_18 = null;
                    if (object == null) break block24;
                    try {
                        object.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    dBManager.freeConnection((Connection)object2);
                }
                break block26;
                {
                    catch (Exception exception) {
                        Object var16_19 = null;
                        if (object != null) {
                            try {
                                object.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        if (object2 != null) {
                            dBManager.freeConnection((Connection)object2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (object2 != null) {
                        dBManager.freeConnection((Connection)object2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

