/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.ISynDocumentWorker;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class SynDocumentWorker
implements ISynDocumentWorker,
Runnable,
Serializable {
    private static Logger logger = Logger.getLogger(SynDocumentWorker.class);
    private Map m_oParamMap = new HashMap();
    private Map m_oParams = null;
    private User m_oLoginUser = ContextHelper.getLoginUser();
    private HttpSession m_oSession = null;
    public static final String RUNNINGFLAG = "isRunning";
    public static final String HANDLEDCOUNT = "handledCount";
    public static final String NORIGHTCOUNT = "noRightCount";
    public static final String HANDINGCHANNEL = "handingChannel";
    public static final String ERRORINFO = "errorInfo";
    public static final String SYNDOCPROGRESSINFO = "synDocProgressInfo";
    public static final String ENABLEINTERRUPT = "enableInterrupt";

    public SynDocumentWorker(HttpSession httpSession) {
        this.m_oSession = httpSession;
        Object object = httpSession.getAttribute(SYNDOCPROGRESSINFO);
        if (object == null) {
            this.m_oParams = this.initParamsMap();
            httpSession.setAttribute(SYNDOCPROGRESSINFO, (Object)this.m_oParams);
        } else {
            this.m_oParams = (Map)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Logger logger = SynDocumentWorker.logger;
        synchronized (logger) {
            block24: {
                boolean bl;
                block23: {
                    block22: {
                        block21: {
                            if (this.m_oParams == null) return;
                            if (this.m_oParams.size() <= 1) {
                                return;
                            }
                            bl = this.isRunning();
                            if (bl) {
                                return;
                            }
                            bl = true;
                            this.m_oParams.put(RUNNINGFLAG, new Boolean(bl));
                            try {
                                try {
                                    ContextHelper.initContext(this.m_oLoginUser);
                                    WebSites webSites = this.getWebsites();
                                    Channels channels = this.getChannels();
                                    MetaViews metaViews = this.getMetaviews();
                                    if (webSites == null && channels == null && metaViews == null) {
                                        Object var8_7 = null;
                                        bl = false;
                                        if (this.m_oParams != null) {
                                            this.m_oParams.put(RUNNINGFLAG, new Boolean(bl));
                                        }
                                        break block21;
                                    }
                                    boolean bl2 = this.isEnableInterrupt();
                                    if (bl2) {
                                        break block22;
                                    }
                                    if (channels != null) {
                                        this.synChnlDocs(channels);
                                    } else if (webSites != null) {
                                        this.synWebsiteDocs(webSites);
                                    } else if (metaViews != null) {
                                        this.synMetaviewDocs(metaViews);
                                    }
                                    if (this.isEnableInterrupt()) {
                                        this.resetParams();
                                    }
                                    break block23;
                                }
                                catch (WCMException wCMException) {
                                    SynDocumentWorker.logger.error((Object)"\u540c\u6b65\u6587\u6863\u65f6\u51fa\u73b0\u9519\u8bef\uff01", (Throwable)wCMException);
                                    Object var8_10 = null;
                                    bl = false;
                                    if (this.m_oParams != null) {
                                        this.m_oParams.put(RUNNINGFLAG, new Boolean(bl));
                                    }
                                    ContextHelper.clear();
                                    break block24;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_11 = null;
                                bl = false;
                                if (this.m_oParams != null) {
                                    this.m_oParams.put(RUNNINGFLAG, new Boolean(bl));
                                }
                                ContextHelper.clear();
                                throw throwable;
                            }
                        }
                        ContextHelper.clear();
                        return;
                    }
                    Object var8_8 = null;
                    bl = false;
                    if (this.m_oParams != null) {
                        this.m_oParams.put(RUNNINGFLAG, new Boolean(bl));
                    }
                    ContextHelper.clear();
                    return;
                }
                Object var8_9 = null;
                bl = false;
                if (this.m_oParams != null) {
                    this.m_oParams.put(RUNNINGFLAG, new Boolean(bl));
                }
                ContextHelper.clear();
            }
            return;
        }
    }

    public void synWebsiteDocs(String string) throws Throwable {
        if (this.m_oLoginUser == null || !this.m_oLoginUser.isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u540c\u6b65\u6587\u6863\u7684\u6743\u9650\uff01");
        }
        if (CMyString.isEmpty(string)) {
            return;
        }
        WebSites webSites = WebSites.findByIds(this.m_oLoginUser, string);
        if (webSites.size() <= 0) {
            return;
        }
        this.setWebsites(webSites);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void synMetaviewDocs(String string) throws Throwable {
        if (this.m_oLoginUser == null || !this.m_oLoginUser.isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u540c\u6b65\u6587\u6863\u7684\u6743\u9650\uff01");
        }
        if (CMyString.isEmpty(string)) {
            return;
        }
        MetaViews metaViews = MetaViews.findByIds(this.m_oLoginUser, string);
        if (metaViews.size() <= 0) {
            return;
        }
        this.setMetaviews(metaViews);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void synChannelDocs(String string) throws Throwable {
        if (this.m_oLoginUser == null || !this.m_oLoginUser.isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u540c\u6b65\u6587\u6863\u7684\u6743\u9650\uff01");
        }
        if (CMyString.isEmpty(string)) {
            return;
        }
        Channels channels = Channels.findByIds(this.m_oLoginUser, string);
        if (channels.size() <= 0) {
            return;
        }
        this.setChannels(channels);
        Thread thread = new Thread(this);
        if (thread.isAlive()) {
            System.out.println("\u7ebf\u7a0b\u5df2\u542f\u52a8....");
            return;
        }
        thread.start();
    }

    public boolean isRunning() {
        return (Boolean)this.m_oParams.get(RUNNINGFLAG);
    }

    public boolean isFinished() {
        boolean bl = !this.isRunning();
        int n = this.getHandledCount();
        int n2 = this.getNoRightCount();
        boolean bl2 = n == 0 && n2 == 0;
        return bl && bl2;
    }

    public int getHandledCount() {
        return (Integer)this.m_oParams.get(HANDLEDCOUNT);
    }

    public int getNoRightCount() {
        return (Integer)this.m_oParams.get(NORIGHTCOUNT);
    }

    public String getHandingChannelInfo() {
        return (String)this.m_oParams.get(HANDINGCHANNEL);
    }

    public String getErrorInfo() {
        return ((StringBuffer)this.m_oParams.get(ERRORINFO)).toString();
    }

    public void setEnableInterrupt(boolean bl) {
        this.m_oParams.put(ENABLEINTERRUPT, new Boolean(bl));
    }

    public void resetParams() {
        this.m_oParamMap.clear();
        this.m_oParams.clear();
        this.m_oParams = null;
        this.m_oLoginUser = null;
        this.m_oSession.setAttribute(SYNDOCPROGRESSINFO, (Object)this.m_oParams);
    }

    private boolean isEnableInterrupt() {
        return (Boolean)this.m_oParams.get(ENABLEINTERRUPT);
    }

    private void synMetaviewDocs(MetaViews metaViews) throws WCMException {
        int n = metaViews.size();
        for (int i = 0; i < n; ++i) {
            if (this.isEnableInterrupt()) {
                return;
            }
            MetaView metaView = (MetaView)metaViews.getAt(i);
            if (metaView == null) continue;
            this.synMetaviewDocs(metaView);
        }
    }

    private void synMetaviewDocs(MetaView metaView) throws WCMException {
        Channels channels = this.getMetaViewEmployerMgr().getEmployers(metaView, null);
        this.synChnlDocs(channels);
    }

    private void synWebsiteDocs(WebSites webSites) throws WCMException {
        int n = webSites.size();
        for (int i = 0; i < n; ++i) {
            if (this.isEnableInterrupt()) {
                return;
            }
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            this.synWebsiteDocs(webSite);
        }
    }

    private void setProcessingChannelInfo(String string) {
        this.m_oParams.put(HANDINGCHANNEL, string);
    }

    private void synWebsiteDocs(WebSite webSite) throws WCMException {
        Channels channels = this.getChannelMgr().getChannels(webSite.getId(), null);
        this.synChnlDocs(channels);
    }

    private void synChnlDocs(Channels channels) throws WCMException {
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            if (this.isEnableInterrupt()) {
                return;
            }
            Channel channel = (Channel)channels.getAt(i);
            String string = channel.getName() + "\u680f\u76ee...\u680f\u76eeid\u4e3a[" + channel.getId() + "]";
            this.setProcessingChannelInfo(string);
            if (channel == null) continue;
            this.synChnlDocs(channel);
            this.setProcessingChannelInfo("");
        }
    }

    private void synChnlDocs(Channel channel) throws WCMException {
        MetaView metaView = this.getMetaViewEmployerMgr().getViewOfEmployer(channel);
        if (metaView == null) {
            return;
        }
        int n = (Integer)this.m_oParams.get(NORIGHTCOUNT);
        int n2 = (Integer)this.m_oParams.get(HANDLEDCOUNT);
        StringBuffer stringBuffer = (StringBuffer)this.m_oParams.get(ERRORINFO);
        WCMFilter wCMFilter = new WCMFilter("", "DocKind=? and DocChannel=?", "");
        wCMFilter.addSearchValues(metaView.getId());
        wCMFilter.addSearchValues(channel.getId());
        Documents documents = Documents.openWCMObjs(this.m_oLoginUser, wCMFilter);
        if (documents.size() <= 0) {
            return;
        }
        int n3 = documents.size();
        for (int i = 0; i < n3; ++i) {
            Document document = (Document)documents.getAt(i);
            if (this.isEnableInterrupt()) {
                return;
            }
            if (document == null) continue;
            if (!AuthServer.hasRight(this.m_oLoginUser, (CMSObj)document.getChannel(), 32)) {
                this.m_oParams.put(NORIGHTCOUNT, new Integer(++n));
                continue;
            }
            int n4 = document.getId();
            MetaViewData metaViewData = MetaViewData.findById(n4);
            try {
                metaViewData.synDocumentFieldValueWithRule(document);
            }
            catch (Exception exception) {
                stringBuffer.append("\u540c\u6b65\u6587\u6863[" + document.getTitle() + "]\u65f6\u51fa\u9519\uff0c\u6587\u6863id\u4e3a[" + n4 + "] \r\n");
                logger.error((Object)("\u540c\u6b65\u6587\u6863[" + document.getTitle() + "]\u65f6\u51fa\u9519\uff0c\u6587\u6863id\u4e3a[" + n4 + "] \r\n"));
                this.m_oParams.put(ERRORINFO, stringBuffer);
            }
            this.getDocumentMgr().save(document);
            this.m_oParams.put(HANDLEDCOUNT, new Integer(++n2));
        }
    }

    private void setWebsites(WebSites webSites) {
        this.m_oParamMap.put("websites", webSites);
    }

    private WebSites getWebsites() {
        WebSites webSites = (WebSites)this.m_oParamMap.get("websites");
        return webSites;
    }

    private void setChannels(Channels channels) {
        this.m_oParamMap.put("channels", channels);
    }

    private Channels getChannels() {
        Channels channels = (Channels)this.m_oParamMap.get("channels");
        return channels;
    }

    private void setMetaviews(MetaViews metaViews) {
        this.m_oParamMap.put("metaviews", metaViews);
    }

    private MetaViews getMetaviews() {
        MetaViews metaViews = (MetaViews)this.m_oParamMap.get("metaviews");
        return metaViews;
    }

    private ChannelMgr getChannelMgr() {
        return (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
    }

    private DocumentMgr getDocumentMgr() {
        return (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    }

    private IMetaViewEmployerMgr getMetaViewEmployerMgr() {
        return (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    }

    private Map initParamsMap() {
        this.m_oParams = new HashMap();
        this.m_oParams.put(ENABLEINTERRUPT, new Boolean(false));
        this.m_oParams.put(RUNNINGFLAG, new Boolean(false));
        this.m_oParams.put(HANDLEDCOUNT, new Integer(0));
        this.m_oParams.put(NORIGHTCOUNT, new Integer(0));
        this.m_oParams.put(HANDINGCHANNEL, new String(""));
        this.m_oParams.put(ERRORINFO, new StringBuffer(""));
        return this.m_oParams;
    }
}

