/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.DatasWithChnlDocFilterHelper;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyMemory;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MetaViewDatas
extends CMSBaseObjs {
    private static Logger logger = Logger.getLogger(MetaViewDatas.class);
    private String m_sDbTableName = null;
    private String m_sIdFieldname = "MetaDataId";
    private MetaView m_oMetaView = null;
    private DatasWithChnlDocFilterHelper m_oDatasFilterHelper = null;
    public static int MAX_ROW_NUM = 1000;
    public static final String DB_TABLE_NAME = "WCMCHNLDOC";
    public static final String ID_FIELD_NAME = "RECID";
    private boolean m_bFromRecycle = false;
    private String m_sSelectFieldsFromDB = null;
    private String m_sSelectFieldsFromChnlDoc = "WCMCHNLDOC.RecId,WCMCHNLDOC.ChnlId,WCMCHNLDOC.DocId,WCMCHNLDOC.DocChannel,WCMCHNLDOC.DOCSTATUS";
    public static final Integer ID_NOT_LOAD = new Integer(0);
    public static boolean QUERY_ACCORD_DOCUMENT_RIGHT = true;
    public static int MAX_FETCH_SIZE = 1000;
    private Map m_hViewDocumentsCache = null;
    private HashMap m_hPublicCache = new HashMap(2);
    private int m_nRightIndex = -1;
    private boolean bLoadAll = false;
    private static final int OPEN_MODE_OLD = 0;
    private static final int OPEN_MODE_NEW = 1;
    private int m_nOpenMode = 1;
    private boolean m_bFromOneTable = false;
    private int m_nRecCount = -1;

    public MetaViewDatas(MetaView metaView) {
        this.m_oMetaView = metaView;
        this.m_sDbTableName = !metaView.isMultiTable() ? MetaDataConstants.makeTrueTableName(metaView.getName()) : metaView.getName();
        this.m_oDatasFilterHelper = new DatasWithChnlDocFilterHelper(this.m_sDbTableName, "MetaDataId");
        this.m_sSelectFieldsFromDB = this.m_sDbTableName + ".*";
    }

    public MetaViewDatas(String string) {
        this.m_sDbTableName = string;
        this.m_oDatasFilterHelper = new DatasWithChnlDocFilterHelper(this.m_sDbTableName, "MetaDataId");
        this.m_sSelectFieldsFromDB = this.m_sDbTableName + ".*";
    }

    public MetaViewDatas(String string, String string2) {
        this.m_sDbTableName = string;
        this.m_sIdFieldname = string2;
        this.m_oDatasFilterHelper = new DatasWithChnlDocFilterHelper(this.m_sDbTableName, "MetaDataId");
        this.m_sSelectFieldsFromDB = this.m_sDbTableName + ".*";
    }

    public MetaViewDatas(User user, int n, int n2) {
        super(user, n, n2);
    }

    protected String getDbTableName() {
        return this.m_sDbTableName;
    }

    public void setDbTableName(String string) {
        this.m_sDbTableName = string;
    }

    public Class getElementClass() {
        return MetaViewData.class;
    }

    public void setMetaView(MetaView metaView) {
        this.m_oMetaView = metaView;
    }

    public MetaView getMetaView() {
        return this.m_oMetaView;
    }

    public String getIdFieldName() {
        return this.m_sIdFieldname;
    }

    public void setIdFieldName(String string) {
        this.m_sIdFieldname = string;
    }

    public BaseObjs newInstance() throws Exception {
        return new MetaViewDatas(null, 1, 1);
    }

    protected BaseObj createElementInstance() {
        MetaViewData metaViewData = new MetaViewData(this.m_sDbTableName, this.m_sIdFieldname);
        if (this.m_oMetaView != null) {
            metaViewData.setMetaView(this.m_oMetaView);
        }
        return metaViewData;
    }

    public static final MetaViewDatas findByIds(String string, String string2) {
        MetaViewDatas metaViewDatas = MetaViewDatas.createNewInstance(string);
        if (string2 == null || string2.length() <= 0) {
            return metaViewDatas;
        }
        metaViewDatas.addElement(string2);
        return metaViewDatas;
    }

    public static final MetaViewDatas findByIds(MetaView metaView, String string) {
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        if (string == null || string.length() <= 0) {
            return metaViewDatas;
        }
        metaViewDatas.addElement(string);
        return metaViewDatas;
    }

    public static final MetaViewDatas openWCMObjs(String string, WCMFilter wCMFilter) throws WCMException {
        MetaViewDatas metaViewDatas = MetaViewDatas.createNewInstance(string);
        metaViewDatas.open(wCMFilter);
        return metaViewDatas;
    }

    public static final MetaViewDatas openWCMObjs(MetaView metaView, WCMFilter wCMFilter) throws WCMException {
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        metaViewDatas.loadViewDatas(wCMFilter);
        return metaViewDatas;
    }

    public static MetaViewDatas createNewInstance(String string) {
        return new MetaViewDatas(string);
    }

    public BaseChannel getCurrChannelOrSite() {
        return (BaseChannel)this.m_hPublicCache.get(MetaViewData.KEY_CURR_HOST);
    }

    public boolean canSort() {
        BaseChannel baseChannel = this.getCurrChannelOrSite();
        if (baseChannel == null) {
            return false;
        }
        if (baseChannel.isSite()) {
            return false;
        }
        Channel channel = (Channel)baseChannel;
        if (channel.isOnlySearch()) {
            return false;
        }
        String string = channel.getOrderBy();
        return string == null || (string = string.trim()).length() <= 0 || string.toUpperCase().indexOf("DOCORDERPRI") >= 0;
    }

    public void open(Channels channels, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.m_oDatasFilterHelper.makeChannelFilter(channels, wCMFilter, this.isFromRecycle());
        if (wCMFilter2 == null) {
            return;
        }
        if (channels.size() == 1) {
            this.m_hPublicCache.put(MetaViewData.KEY_CURR_HOST, channels.getAt(0));
        }
        this.loadViewDatas(wCMFilter2);
    }

    public void open(Channel channel, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.m_oDatasFilterHelper.makeChannelFilter(channel, wCMFilter, true, this.isFromRecycle());
        if (wCMFilter2 == null) {
            return;
        }
        this.m_hPublicCache.put(MetaViewData.KEY_CURR_HOST, channel);
        this.loadViewDatas(wCMFilter2);
    }

    public void open(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.m_oDatasFilterHelper.makeFilter(webSite, wCMFilter, true, this.isFromRecycle());
        if (wCMFilter2 == null) {
            return;
        }
        this.m_hPublicCache.put(MetaViewData.KEY_CURR_HOST, webSite);
        this.loadViewDatas(wCMFilter2);
    }

    public void open(WebSites webSites, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.m_oDatasFilterHelper.makeFilter(webSites, wCMFilter, true, this.isFromRecycle());
        if (wCMFilter2 == null) {
            return;
        }
        if (webSites.size() == 1) {
            this.m_hPublicCache.put(MetaViewData.KEY_CURR_HOST, webSites.getAt(0));
        }
        this.loadViewDatas(wCMFilter2);
    }

    public void setLoadAllDatas(boolean bl) {
        this.bLoadAll = bl;
    }

    public void loadViewDatas(WCMFilter wCMFilter) throws WCMException {
        if (CMyString.isEmpty(wCMFilter.getFrom())) {
            wCMFilter.setFrom(DB_TABLE_NAME);
        }
        String string = "1=1";
        if (!CMyString.isEmpty(wCMFilter.getWhere())) {
            string = wCMFilter.getWhere();
        }
        if (this.m_oMetaView != null) {
            string = string + " and WCMChnlDoc.DocKind=?";
            wCMFilter.addSearchValues(this.m_oMetaView.getId());
        }
        String string2 = string.toUpperCase();
        if (!this.isFromRecycle()) {
            if (string2.indexOf("DOCCHANNEL") < 0) {
                string = string + " and DOCCHANNEL>0";
            }
            if (string2.indexOf("DOCSTATUS") < 0) {
                string = string + " and DOCSTATUS>0";
            }
            if (string2.indexOf("CHNLID") < 0) {
                string = string + " and CHNLID>0";
            }
        }
        wCMFilter.setWhere(string);
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)"openViewDocuments SQL Info:");
            logger.fatal((Object)(wCMFilter + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        int n = DBManager.getDBManager().sqlExecuteCountQuery(wCMFilter);
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("Query Count use [" + debugTimer.getTime() + "]ms!"));
            logger.fatal((Object)(wCMFilter.toCountQueryInfo() + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (n == 0) {
            return;
        }
        CPager cPager = new CPager(this.getPageSize());
        cPager.setItemCount(n);
        if (this.bLoadAll) {
            cPager.setPageSize(n);
            this.setPageSize(n);
        }
        cPager.setCurrentPageIndex(this.getCurrPage());
        debugTimer.start();
        this.loadPreDatasOfPage(wCMFilter, cPager);
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPrePageDatas use [" + debugTimer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (this.isEmpty() || this.m_sSelectFieldsFromDB == null || this.m_sSelectFieldsFromDB.length() == 0) {
            return;
        }
        debugTimer.start();
        this.loadViewDatasOfPage(cPager.getCurrentPageIndex() - 1);
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPageDocuments use [" + debugTimer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
    }

    /*
     * Loose catch block
     */
    private void loadPreDatasOfPage(WCMFilter wCMFilter, CPager cPager) throws WCMException {
        block27: {
            DebugTimer debugTimer = new DebugTimer();
            this.vIdList = new Vector(cPager.getItemCount());
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            String string = "";
            WCMFilter wCMFilter2 = null;
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label1", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            wCMFilter2 = this.makeQueryPreDataFilter(wCMFilter, this.m_sSelectFieldsFromChnlDoc);
            string = wCMFilter2.toSQL();
            connection = this.getDBManager().getConnection();
            statement = connection.prepareStatement(string);
            if (cPager.getPageSize() < 0) {
                if (cPager.getItemCount() < MAX_FETCH_SIZE) {
                    statement.setFetchSize(cPager.getItemCount());
                } else {
                    statement.setFetchSize(MAX_FETCH_SIZE);
                }
            } else if (cPager.getPageSize() < MAX_FETCH_SIZE) {
                statement.setFetchSize(cPager.getPageSize());
            } else {
                statement.setFetchSize(MAX_FETCH_SIZE);
            }
            DBManager.setParameters((PreparedStatement)statement, wCMFilter2);
            debugTimer.start();
            resultSet = statement.executeQuery();
            debugTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.fatal((Object)wCMFilter2);
            }
            int n = 0;
            ResultSetMetaData resultSetMetaData = null;
            while (resultSet.next()) {
                if (++n < cPager.getFirstItemIndex()) {
                    this.vIdList.add(ID_NOT_LOAD);
                    continue;
                }
                if (resultSetMetaData == null) {
                    resultSetMetaData = resultSet.getMetaData();
                }
                MetaViewData metaViewData = null;
                metaViewData = this.m_oMetaView != null ? new MetaViewData(this.m_oMetaView, this.m_hPublicCache) : new MetaViewData(this.m_sDbTableName);
                metaViewData.readChnlDocPropertyFromRs(resultSet, resultSetMetaData);
                if (!this.isVisible(metaViewData)) {
                    --n;
                    cPager.setItemCount(cPager.getItemCount() - 1);
                    continue;
                }
                int n2 = resultSet.getInt(ID_FIELD_NAME);
                this.vIdList.add(new Integer(n2));
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(metaViewData.getKey(), metaViewData);
                this.putViewDocument(metaViewData.getMetaDataId(), metaViewData);
                if (n < cPager.getLastItemIndex()) continue;
                break;
            }
            resultSet.close();
            for (int i = n; i < cPager.getItemCount(); ++i) {
                this.vIdList.add(ID_NOT_LOAD);
            }
            this.currIndex = this.size() > 0 ? 0 : -2;
            Object var14_16 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
            break block27;
            {
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label2", "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + wCMFilter2, sQLException);
                }
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label3", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", exception);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    private WCMFilter makeQueryPreDataFilter(WCMFilter wCMFilter, String string) {
        WCMFilter wCMFilter2 = new WCMFilter(wCMFilter);
        String string2 = wCMFilter.getFrom();
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            wCMFilter2.setFrom(this.getDbTableName());
        }
        wCMFilter2.setSelect(string);
        return wCMFilter2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadViewDatasOfPage(int var1_1) throws WCMException {
        block30: {
            block26: {
                if (this.pageSize == -1 || this.pageSize > MetaViewDatas.MAX_FETCH_SIZE) {
                    this.pageSize = MetaViewDatas.MAX_FETCH_SIZE;
                    var2_2 = 1;
                    var3_4 = 0;
                    while (var3_4 < this.size()) {
                        this.loadViewDatasOfPage(var2_2);
                        var3_4 += MetaViewDatas.MAX_FETCH_SIZE;
                        ++var2_2;
                    }
                    return true;
                }
                var2_3 = this.makeLoadViewDatasSQLOfPage(var1_1);
                if (var2_3 == null) {
                    return false;
                }
                var3_5 = new DebugTimer();
                var4_6 = null;
                var5_7 = null;
                var6_8 = null;
                var7_9 = null;
                try {
                    try {
                        var4_6 = this.getDBManager().getConnection();
                        var5_7 = var4_6.prepareStatement(var2_3);
                        var5_7.setMaxRows(this.pageSize);
                        if (this.pageSize > MetaViewDatas.MAX_FETCH_SIZE) {
                            var5_7.setFetchSize(MetaViewDatas.MAX_FETCH_SIZE);
                        } else {
                            var5_7.setFetchSize(this.pageSize);
                        }
                        this.setPreStmtParamsOfPageViewDatas(var1_1, var5_7);
                        var3_5.start();
                        var6_8 = var5_7.executeQuery();
                        var3_5.stop();
                        if (MetaViewDatas.logger.isDebugEnabled() && var3_5.getTime() > MetaViewDatas.DEBUG_USE_TIME) {
                            MetaViewDatas.logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + var3_5.getTime() + "]ms"));
                            MetaViewDatas.logger.debug((Object)("strSQL:" + var2_3));
                        }
                        var3_5.start();
                        while (var6_8.next()) {
                            if (var7_9 == null) {
                                var7_9 = var6_8.getMetaData();
                            }
                            if ((var9_13 = this.getViewDocuments(var8_10 = var6_8.getInt("MetaDataId"))) == null) {
                                this.printErrorInfo(var8_10, var2_3, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label4", "ViewDocument\u7f13\u51b2\u7ef4\u62a4\u6709\u95ee\u9898\uff1f\u6307\u5b9a\u7684DocId\u5bf9\u5e94\u7684ViewDocument\u4e0d\u80fd\u83b7\u5f97\uff01"));
                                continue;
                            }
                            var10_14 = var9_13[0];
                            var10_14.readFromRs(var6_8, var7_9);
                            var12_16 = var9_13.length;
                            for (var11_15 = 1; var11_15 < var12_16; ++var11_15) {
                                var9_13[var11_15].cloneDocumentProperties(var10_14);
                            }
                        }
                        var3_5.stop();
                        if (MetaViewDatas.logger.isDebugEnabled() && var3_5.getTime() > MetaViewDatas.DEBUG_USE_TIME) {
                            MetaViewDatas.logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + var3_5.getTime() + "]ms"));
                            MetaViewDatas.logger.debug((Object)("strSQL:" + var2_3));
                        }
                        var8_10 = 1;
                        var14_17 = null;
                        if (var6_8 == null) break block26;
                    }
                    catch (SQLException var8_11) {
                        throw new WCMException(40, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + var2_3, var8_11);
                    }
                    catch (Exception var8_12) {
                        throw new WCMException(0, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + var2_3, var8_12);
                    }
                }
                catch (Throwable var13_21) {
                    var14_18 = null;
                    if (var6_8 != null) {
                        try {
                            var6_8.close();
                        }
                        catch (Exception var15_20) {
                            // empty catch block
                        }
                    }
                    if (var5_7 != null) {
                        try {
                            var5_7.close();
                        }
                        catch (Exception var15_20) {
                            // empty catch block
                        }
                    }
                    if (var4_6 == null) throw var13_21;
                    this.getDBManager().freeConnection(var4_6);
                    throw var13_21;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 617->627)] { 
lbl85:
                // 1 sources

                var6_8.close();
                break block26;
lbl87:
                // 1 sources

                catch (Exception var15_19) {
                    // empty catch block
                }
            }
            if (var5_7 != null) {
                ** try [egrp 3[TRYBLOCK] [5 : 634->644)] { 
lbl92:
                // 1 sources

                var5_7.close();
                break block30;
lbl94:
                // 1 sources

                catch (Exception var15_19) {
                    // empty catch block
                }
            }
        }
        if (var4_6 == null) return (boolean)var8_10;
        this.getDBManager().freeConnection(var4_6);
        return (boolean)var8_10;
    }

    private void printErrorInfo(int n, String string, String string2) {
        logger.error((Object)string2);
        logger.error((Object)("DocId:" + n));
        logger.error((Object)("strSQL:" + string));
        if (this.m_oObjsBuffer != null) {
            logger.error((Object)("m_oObjsBuffer:" + this.m_oObjsBuffer));
            logger.error((Object)("m_oObjsBuffer.size:" + this.m_oObjsBuffer.size()));
        } else {
            logger.error((Object)"m_oObjsBuffer is null.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setPreStmtParamsOfPageViewDatas(int var1_1, PreparedStatement var2_2) throws SQLException {
        var3_3 = this.getStartPos(var1_1);
        if (var3_3 >= (var4_4 = this.getEndPos(var3_3)) || var3_3 < 0) {
            return;
        }
        var5_5 = this.size();
        var6_6 = var3_3;
        var7_7 = 1;
        while (var6_6 < var4_4) {
            block4: {
                var8_8 = 0;
                if (var6_6 >= var5_5) ** GOTO lbl19
                if (!this.m_bFromOneTable) break block4;
                var8_8 = this.getIdAt(var6_6);
                ** GOTO lbl19
            }
            var9_9 = (MetaViewData)this.getAt(var6_6);
            if (var9_9 == null) {
                this.printErrorInfo(this.getIdAt(var6_6), null, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label6", "setPageDocumentsPreStmtParams\u53d1\u73b0\u7a0b\u5e8f\u9519\u8bef\uff01"));
            } else {
                var8_8 = var9_9.getMetaDataId();
lbl19:
                // 3 sources

                var2_2.setInt(var7_7, var8_8);
            }
            ++var6_6;
            ++var7_7;
        }
    }

    private String makeLoadViewDatasSQLOfPage(int n) {
        this.m_sSelectFieldsFromDB = "MetaDataId," + this.m_sSelectFieldsFromDB;
        String string = this.m_sDbTableName;
        String string2 = CMyString.filterForSQL2(this.makeLoadPageWhere(n));
        StringBuffer stringBuffer = new StringBuffer(this.m_sSelectFieldsFromDB.length() + string.length() + string2.length() + 21);
        stringBuffer.append("select ");
        stringBuffer.append(this.m_sSelectFieldsFromDB);
        stringBuffer.append(" from ");
        stringBuffer.append(string);
        if (string2.length() > 0) {
            stringBuffer.append(" where ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String makeLoadPageWhere(int n) {
        int n2;
        int n3 = this.getStartPos(n);
        if (n3 >= (n2 = this.getEndPos(n3)) || n3 < 0) {
            return "";
        }
        String string = "MetaDataId in(";
        string = string + "?";
        for (int i = n3 + 1; i < n2; ++i) {
            string = string + ", ?";
        }
        string = string + ")";
        return string;
    }

    private void putViewDocument(int n, MetaViewData metaViewData) {
        if (this.m_hViewDocumentsCache == null) {
            this.m_hViewDocumentsCache = this.pageSize > 0 ? new HashMap(this.pageSize) : new HashMap(this.vIdList.capacity());
        }
        MetaViewData[] metaViewDataArray = null;
        Integer n2 = new Integer(n);
        metaViewDataArray = (MetaViewData[])this.m_hViewDocumentsCache.get(n2);
        if (metaViewDataArray == null) {
            metaViewDataArray = new MetaViewData[]{metaViewData};
        } else {
            int n3 = metaViewDataArray.length;
            MetaViewData[] metaViewDataArray2 = new MetaViewData[n3 + 1];
            if (n3 > 0) {
                System.arraycopy(metaViewDataArray, 0, metaViewDataArray2, 0, n3);
            }
            metaViewDataArray2[n3] = metaViewData;
            metaViewDataArray = metaViewDataArray2;
        }
        this.m_hViewDocumentsCache.put(n2, metaViewDataArray);
    }

    private MetaViewData[] getViewDocuments(int n) {
        if (this.m_hViewDocumentsCache == null) {
            return null;
        }
        Integer n2 = new Integer(n);
        return (MetaViewData[])this.m_hViewDocumentsCache.get(n2);
    }

    public void open(CMSBaseObjs cMSBaseObjs, WCMFilter wCMFilter) throws WCMException {
        if (cMSBaseObjs instanceof Channels) {
            this.open((Channels)cMSBaseObjs, wCMFilter);
        } else if (cMSBaseObjs instanceof WebSites) {
            this.open((WebSites)cMSBaseObjs, wCMFilter);
        } else {
            throw new WCMException(I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label7", "\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b[") + cMSBaseObjs.getClassName(true) + "]\uff01");
        }
    }

    public boolean isFromRecycle() {
        return this.m_bFromRecycle;
    }

    public void setFromRecycle(boolean bl) {
        this.m_bFromRecycle = bl;
    }

    public void setSelectFieldsFromChnlDoc(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        String[] stringArray = string.split(",");
        String string2 = "WCMCHNLDOC.";
        int n = string.indexOf(46) > 0 ? string2.length() : 0;
        StringBuffer stringBuffer = new StringBuffer(string.length() + n * stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            if (stringArray[i].indexOf(46) < 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(stringArray[i]);
        }
        this.m_sSelectFieldsFromChnlDoc = stringBuffer.toString();
    }

    public void setSelectFieldsOfMetaTable(String string) {
        this.m_sSelectFieldsFromDB = string;
    }

    public void setSelectFields(String string, String string2) {
        this.setSelectFieldsFromChnlDoc(string);
        this.setSelectFieldsOfMetaTable(string2);
    }

    public int getRightIndex() {
        return this.m_nRightIndex;
    }

    public void setRightIndex(int n) {
        this.m_nRightIndex = n;
    }

    public MetaViewDatas() {
    }

    public static MetaViewDatas findByIds(String string) throws WCMException {
        Object object;
        int[] nArray = CMyString.splitToInt(string, ",");
        if (nArray.length == 0) {
            return new MetaViewDatas();
        }
        int n = 0;
        for (int i = 0; i < nArray.length && ((object = Document.findById(nArray[i])) == null || (n = ((BaseObj)object).getPropertyAsInt("docKind", 0)) == 0); ++i) {
        }
        if (n == 0) {
            return new MetaViewDatas();
        }
        MetaView metaView = MetaView.findById(n);
        object = null;
        object = !metaView.isMultiTable() ? MetaDataConstants.makeTrueTableName(metaView.getName()) : metaView.getName();
        MetaViewDatas metaViewDatas = MetaViewDatas.findByIds((String)object, string);
        metaViewDatas.setMetaView(metaView);
        return metaViewDatas;
    }

    public void setNeedWithAuthFilter(User user, boolean bl) {
        this.m_oDatasFilterHelper.setNeedWithAuthFilter(user, bl);
    }

    public int getOpenMode() {
        return this.m_nOpenMode;
    }

    public void setOpenMode(int n) {
        this.m_nOpenMode = n;
    }

    public synchronized void open(WCMFilter wCMFilter) throws WCMException {
        this.open(wCMFilter, null);
    }

    public synchronized void open(WCMFilter wCMFilter, WCMFilter wCMFilter2) throws WCMException {
        if (this.m_nOpenMode == 0) {
            super.open(wCMFilter);
            return;
        }
        if (CMyString.isEmpty(wCMFilter.getFrom())) {
            wCMFilter.setFrom(this.getDbTableName());
        }
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)"==========open SQL Info=========");
            logger.fatal((Object)(wCMFilter + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        int n = this.m_nRecCount;
        DebugTimer debugTimer = new DebugTimer();
        if (n < 0) {
            debugTimer.start();
            n = wCMFilter2 != null ? DBManager.getDBManager().sqlExecuteCountQuery(wCMFilter2) : DBManager.getDBManager().sqlExecuteCountQuery(wCMFilter);
            debugTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.fatal((Object)("Query Count use [" + debugTimer.getTime() + "]ms!"));
                logger.fatal((Object)(wCMFilter.toCountQueryInfo() + "\n"));
                logger.fatal((Object)CMyMemory.toMemoryInfo());
            }
            this.m_nRecCount = n;
        }
        if (n == 0) {
            return;
        }
        CPager cPager = new CPager(this.getPageSize());
        cPager.setItemCount(n);
        cPager.setCurrentPageIndex(this.getCurrPage());
        debugTimer.start();
        int n2 = this.loadPrePageDatasOneTable(wCMFilter, cPager);
        if ((n2 == 0 || n2 < n && n2 < this.getPageSize()) && wCMFilter2 != null) {
            if ((wCMFilter = this.removeTimeLimitFromSrcFilter(wCMFilter, wCMFilter2)) == null) {
                return;
            }
            logger.info((Object)"reload data remove time limit!");
            logger.info((Object)wCMFilter);
            n2 = this.loadPrePageDatasOneTable(wCMFilter, cPager);
        }
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPrePageDatas use [" + debugTimer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (this.isEmpty()) {
            return;
        }
        debugTimer.start();
        this.loadViewDatasOfPageOneTable(cPager.getCurrentPageIndex() - 1);
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPageDocuments use [" + debugTimer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
    }

    private WCMFilter removeTimeLimitFromSrcFilter(WCMFilter wCMFilter, WCMFilter wCMFilter2) {
        if (wCMFilter2 == null) {
            return null;
        }
        List list = wCMFilter.getSearchValues();
        if (list == null) {
            return null;
        }
        List list2 = wCMFilter2.getSearchValues();
        if (list2 == null || list.size() <= list2.size()) {
            return null;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Object e = list.get(i);
            if (!(e instanceof CMyDateTime)) continue;
            list.remove(i);
        }
        wCMFilter.setWhere(wCMFilter2.getWhere());
        return wCMFilter;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadPrePageDatasOneTable(WCMFilter var1_1, CPager var2_2) throws WCMException {
        block37: {
            block34: {
                block36: {
                    block33: {
                        this.m_bFromOneTable = true;
                        var3_3 = new DebugTimer();
                        this.vIdList = new Vector<E>(var2_2.getItemCount());
                        var4_4 = null;
                        var5_5 = null;
                        var6_6 = null;
                        var7_7 = "";
                        var9_8 = null;
                        try {
                            try {
                                if (this.currMode == 2) {
                                    throw new WCMException(1100, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label1", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
                                }
                                var9_8 = this.makeQueryPreDataFilter(var1_1, this.getDbTableName() + "." + this.getIdFieldName());
                                var7_7 = var9_8.toSQL();
                                var4_4 = this.getDBManager().getConnection();
                                var5_5 = var4_4.prepareStatement(var7_7);
                                var10_9 = MetaViewDatas.MAX_FETCH_SIZE;
                                if (var2_2.getPageSize() < 0) {
                                    if (var2_2.getItemCount() < var10_9) {
                                        var5_5.setFetchSize(var2_2.getItemCount());
                                    } else {
                                        var5_5.setFetchSize(var10_9);
                                    }
                                } else {
                                    if (var2_2.getPageSize() < var10_9) {
                                        var5_5.setFetchSize(var2_2.getPageSize());
                                    } else {
                                        var5_5.setFetchSize(var10_9);
                                    }
                                    if (var2_2.getCurrentPageIndex() == 1) {
                                        var11_12 = Math.min(var2_2.getPageSize(), this.m_nRecCount);
                                        var5_5.setMaxRows(var11_12);
                                    } else if (MetaViewDatas.MAX_ROW_NUM > 0 && var2_2.getLastItemIndex() <= MetaViewDatas.MAX_ROW_NUM) {
                                        var11_12 = Math.min(var2_2.getLastItemIndex(), this.m_nRecCount);
                                        var5_5.setMaxRows(var11_12);
                                    }
                                }
                                DBManager.setParameters((PreparedStatement)var5_5, var9_8);
                                var3_3.start();
                                var6_6 = var5_5.executeQuery();
                                var3_3.stop();
                                if (MetaViewDatas.logger.isDebugEnabled()) {
                                    MetaViewDatas.logger.debug((Object)var9_8);
                                    MetaViewDatas.logger.debug((Object)("query id use[" + var3_3.getTime() + "]ms!"));
                                }
                                var11_12 = 0;
                                var12_13 = null;
                                while (var6_6.next()) {
                                    if (++var11_12 < var2_2.getFirstItemIndex()) {
                                        this.vIdList.add(MetaViewDatas.ID_NOT_LOAD);
                                        continue;
                                    }
                                    if (var12_13 == null) {
                                        var12_13 = var6_6.getMetaData();
                                    }
                                    var8_14 = var6_6.getInt(this.getIdFieldName());
                                    this.vIdList.add(new Integer(var8_14));
                                    if (var11_12 < var2_2.getLastItemIndex()) continue;
                                }
                                var6_6.close();
                                if (var11_12 == 0) {
                                    var13_15 = var11_12;
                                    var15_17 = null;
                                    break block33;
                                }
                                for (var13_16 = var11_12; var13_16 < var2_2.getItemCount(); ++var13_16) {
                                    this.vIdList.add(MetaViewDatas.ID_NOT_LOAD);
                                }
                                var13_16 = var11_12;
                                break block34;
                            }
                            catch (SQLException var10_10) {
                                throw new WCMException(40, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label2", "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + var9_8, var10_10);
                            }
                            catch (Exception var10_11) {
                                throw new WCMException(0, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label3", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", var10_11);
                            }
                        }
                        catch (Throwable var14_23) {
                            var15_19 = null;
                            try {
                                if (var5_5 != null) {
                                    var5_5.close();
                                }
                            }
                            catch (Exception var16_22) {
                                var16_22.printStackTrace();
                            }
                            if (var4_4 != null) {
                                this.getDBManager().freeConnection(var4_4);
                            }
                            this.currIndex = this.size() > 0 ? 0 : -2;
                            throw var14_23;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [7 : 663->678)] { 
lbl89:
                    // 1 sources

                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    break block36;
lbl92:
                    // 1 sources

                    catch (Exception var16_20) {
                        var16_20.printStackTrace();
                    }
                }
                if (var4_4 != null) {
                    this.getDBManager().freeConnection(var4_4);
                }
                this.currIndex = this.size() > 0 ? 0 : -2;
                return var13_15;
            }
            var15_18 = null;
            ** try [egrp 2[TRYBLOCK] [7 : 663->678)] { 
lbl102:
            // 1 sources

            if (var5_5 != null) {
                var5_5.close();
            }
            break block37;
lbl105:
            // 1 sources

            catch (Exception var16_21) {
                var16_21.printStackTrace();
            }
        }
        if (var4_4 != null) {
            this.getDBManager().freeConnection(var4_4);
        }
        this.currIndex = this.size() > 0 ? 0 : -2;
        return var13_16;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadViewDatasOfPageOneTable(int var1_1) throws WCMException {
        block30: {
            block26: {
                if (this.pageSize == -1 || this.pageSize > MetaViewDatas.MAX_FETCH_SIZE) {
                    this.pageSize = MetaViewDatas.MAX_FETCH_SIZE;
                    var2_2 = 1;
                    var3_4 = 0;
                    while (var3_4 < this.size()) {
                        this.loadViewDatasOfPage(var2_2);
                        var3_4 += MetaViewDatas.MAX_FETCH_SIZE;
                        ++var2_2;
                    }
                    return true;
                }
                var2_3 = this.makeLoadViewDatasSQLOfPage(var1_1);
                if (var2_3 == null) {
                    return false;
                }
                var3_5 = new DebugTimer();
                var4_6 = null;
                var5_7 = null;
                var6_8 = null;
                var7_9 = null;
                try {
                    try {
                        var4_6 = this.getDBManager().getConnection();
                        var5_7 = var4_6.prepareStatement(var2_3);
                        var5_7.setMaxRows(this.pageSize);
                        if (this.pageSize > MetaViewDatas.MAX_FETCH_SIZE) {
                            var5_7.setFetchSize(MetaViewDatas.MAX_FETCH_SIZE);
                        } else {
                            var5_7.setFetchSize(this.pageSize);
                        }
                        this.setPreStmtParamsOfPageViewDatas(var1_1, var5_7);
                        var3_5.start();
                        var6_8 = var5_7.executeQuery();
                        var3_5.stop();
                        if (MetaViewDatas.logger.isDebugEnabled() && var3_5.getTime() > MetaViewDatas.DEBUG_USE_TIME) {
                            MetaViewDatas.logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + var3_5.getTime() + "]ms"));
                            MetaViewDatas.logger.debug((Object)("strSQL:" + var2_3));
                        }
                        var3_5.start();
                        while (var6_8.next()) {
                            if (var7_9 == null) {
                                var7_9 = var6_8.getMetaData();
                            }
                            var8_10 = null;
                            var8_10 = this.m_oMetaView != null ? new MetaViewData(this.m_oMetaView, this.m_hPublicCache) : new MetaViewData(this.m_sDbTableName);
                            if (this.m_sDbTableName != null) {
                                var8_10.setDbTableName(this.m_sDbTableName);
                            }
                            var8_10.readFromRs(var6_8, var7_9);
                            if (this.m_oObjsBuffer == null) {
                                this.m_oObjsBuffer = new Hashtable<K, V>();
                            }
                            this.m_oObjsBuffer.put(var8_10.getKey(), var8_10);
                        }
                        var3_5.stop();
                        if (MetaViewDatas.logger.isDebugEnabled() && var3_5.getTime() > MetaViewDatas.DEBUG_USE_TIME) {
                            MetaViewDatas.logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + var3_5.getTime() + "]ms"));
                            MetaViewDatas.logger.debug((Object)("strSQL:" + var2_3));
                        }
                        var8_11 = true;
                        var10_14 = null;
                        if (var6_8 == null) break block26;
                    }
                    catch (SQLException var8_12) {
                        throw new WCMException(40, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + var2_3, var8_12);
                    }
                    catch (Exception var8_13) {
                        throw new WCMException(0, I18NMessage.get(MetaViewDatas.class, "MetaViewDatas.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + var2_3, var8_13);
                    }
                }
                catch (Throwable var9_18) {
                    var10_15 = null;
                    if (var6_8 != null) {
                        try {
                            var6_8.close();
                        }
                        catch (Exception var11_17) {
                            // empty catch block
                        }
                    }
                    if (var5_7 != null) {
                        try {
                            var5_7.close();
                        }
                        catch (Exception var11_17) {
                            // empty catch block
                        }
                    }
                    if (var4_6 == null) throw var9_18;
                    this.getDBManager().freeConnection(var4_6);
                    throw var9_18;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 628->638)] { 
lbl85:
                // 1 sources

                var6_8.close();
                break block26;
lbl87:
                // 1 sources

                catch (Exception var11_16) {
                    // empty catch block
                }
            }
            if (var5_7 != null) {
                ** try [egrp 3[TRYBLOCK] [5 : 645->655)] { 
lbl92:
                // 1 sources

                var5_7.close();
                break block30;
lbl94:
                // 1 sources

                catch (Exception var11_16) {
                    // empty catch block
                }
            }
        }
        if (var4_6 == null) return var8_11;
        this.getDBManager().freeConnection(var4_6);
        return var8_11;
    }

    public void setRecCount(int n) {
        if (n < 0) {
            return;
        }
        this.m_nRecCount = n;
    }

    public int getRecCount() {
        if (this.m_nRecCount < 0) {
            return this.size();
        }
        return this.m_nRecCount;
    }

    public int size() {
        if (this.m_nRecCount <= 0) {
            return super.size();
        }
        return this.m_nRecCount;
    }

    private boolean hasRight(RightValue rightValue) {
        if (this.m_nRightIndex == 64) {
            return rightValue.getValue() > 0L;
        }
        return rightValue.isHasRight(this.m_nRightIndex);
    }

    private boolean isVisible(MetaViewData metaViewData) throws WCMException {
        if (this.m_nRightIndex == -1 || !QUERY_ACCORD_DOCUMENT_RIGHT) {
            return true;
        }
        int n = metaViewData.getMetaDataId();
        if (!DocumentAuthServer.isDefineRightOnDocument(n)) {
            return true;
        }
        RightValue rightValue = new RightValue();
        rightValue.load(this.currUser, 605, n, true);
        if (this.hasRight(rightValue)) {
            return true;
        }
        String string = DBManager.getDBManager().sqlExecuteStringQuery("select CrUser from WCMDocument where DocId=?", new int[]{n});
        return this.currUser.getName().equals(string);
    }
}

