/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.metadata.center.ClassInfoView;
import com.trs.components.metadata.center.IClassInfoViewMgr;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ClassInfoViewMgr
implements IClassInfoViewMgr {
    private static Logger logger = Logger.getLogger(ClassInfoViewMgr.class);
    private IClassInfoMgr m_oClassInfoMgr = null;
    private IMetaDataDefMgr m_oMetaDataDefMgr = null;
    private IMetaDataDefCacheMgr m_oMetaDataDefCacheMgr = null;
    String SQL_CLEAR_BY_DOCID = "delete from XWCMClassInfoView where MetaDataId = ?";
    String SQL_CLEAR_BY_CLASSINFOID = "delete from XWCMClassInfoView where ClassInfoId = ?";

    public IClassInfoMgr getClassInfoMgr() {
        if (this.m_oClassInfoMgr == null) {
            this.m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        }
        return this.m_oClassInfoMgr;
    }

    public IMetaDataDefMgr getMetaDataDefMgr() {
        if (this.m_oMetaDataDefMgr == null) {
            this.m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        }
        return this.m_oMetaDataDefMgr;
    }

    public IMetaDataDefCacheMgr getMetaDataDefCacheMgr() {
        if (this.m_oMetaDataDefCacheMgr == null) {
            this.m_oMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        }
        return this.m_oMetaDataDefCacheMgr;
    }

    public void save(User user, MetaViewData metaViewData) throws WCMException {
        if (!metaViewData.isAddMode()) {
            this.delete(user, metaViewData);
        }
        int n = metaViewData.getId();
        MetaView metaView = metaViewData.getMetaView();
        int n2 = metaView.getId();
        WCMFilter wCMFilter = new WCMFilter("", "FieldType = ?", "");
        wCMFilter.addSearchValues(10);
        MetaViewFields metaViewFields = metaView.getViewFields(user, wCMFilter);
        int n3 = metaViewFields.size();
        for (int i = 0; i < n3; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            if (metaViewField == null) continue;
            String string = null;
            string = metaViewData.isAddMode() || !metaViewData.isChangeProperty(metaViewField.getName()) ? metaViewData.getPropertyAsString(metaViewField.getName()) : metaViewData.getNewPropertyAsString(metaViewField.getName());
            if (!metaViewField.isFromMainTable()) {
                String string2 = "WCMMetaRelation" + metaView.getId();
                CMSObjDefaultImpl cMSObjDefaultImpl = new CMSObjDefaultImpl(string2, "MetaDataId");
                cMSObjDefaultImpl.loadById(n, null);
                cMSObjDefaultImpl.validCanEditAndLock(user);
                int n4 = cMSObjDefaultImpl.getPropertyAsInt("WCMMetaTable" + metaViewField.getTableName() + "id", 0);
                MetaViewData metaViewData2 = MetaViewData.findById(n4);
                if (metaViewData2 == null) continue;
                string = metaViewData2.getPropertyAsString(metaViewField.getName());
            }
            this.insertClassInfoView(user, n, n2, string);
        }
    }

    private void insertClassInfoView(User user, int n, int n2, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            int n3 = Integer.parseInt((String)stringTokenizer.nextElement());
            if (n3 == 0) continue;
            ClassInfoView classInfoView = new ClassInfoView();
            classInfoView.setClassInfoId(n3);
            classInfoView.setMetaDataID(n);
            classInfoView.setViewID(n2);
            classInfoView.save(user);
        }
    }

    public void delete(User user, MetaViewData metaViewData) throws WCMException {
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{this.SQL_CLEAR_BY_DOCID}, new int[]{metaViewData.getId()});
    }

    public Documents queryDocuments(User user, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        if (classInfo == null) {
            return this.queryAllDocuments(user, wCMFilter);
        }
        if (classInfo.isRoot()) {
            return this.queryAllDocumentsInRoot(user, classInfo, wCMFilter);
        }
        ClassInfos classInfos = new ClassInfos(user);
        classInfos.addElement(classInfo);
        return this.queryDocuments(user, classInfos, wCMFilter);
    }

    public Documents queryDocuments(User user, ClassInfos classInfos, WCMFilter wCMFilter) throws WCMException {
        if (classInfos == null || classInfos.isEmpty()) {
            return this.queryAllDocuments(user, wCMFilter);
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer(classInfos.size() * 2 + 300);
        stringBuffer.append("exists(select 1");
        stringBuffer.append(" from XWCMClassInfoView");
        stringBuffer.append(" where XWCMClassInfoView.ClassInfoId in(");
        stringBuffer.append(classInfos.getIdListAsString());
        stringBuffer.append(")");
        stringBuffer.append(" and XWCMClassInfoView.MetaDataId=WCMDocument.docId)");
        stringBuffer.append(" and WCMDocument.DocChannel>0 and WCMDocument.DocStatus>0");
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.mergeWith(wCMFilter);
        logger.debug((Object)wCMFilter2);
        return Documents.openWCMObjs(user, wCMFilter2);
    }

    private Documents queryAllDocuments(User user, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        String string = "docId in (select distinct(XWCMClassInfoView.MetaDataId) from XWCMClassInfoView)";
        wCMFilter2.setWhere(string);
        wCMFilter2.mergeWith(wCMFilter);
        logger.debug((Object)wCMFilter2);
        return Documents.openWCMObjs(user, wCMFilter2);
    }

    private Documents queryAllDocumentsInRoot(User user, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        String string = "DocId in (select metadataid from xwcmclassinfoview where ClassInfoId in (select classinfoid from xwcmclassinfo where rootid=?))";
        wCMFilter2.setWhere(string);
        wCMFilter2.addSearchValues(classInfo.getId());
        wCMFilter2.mergeWith(wCMFilter);
        logger.debug((Object)wCMFilter2);
        return Documents.openWCMObjs(user, wCMFilter2);
    }

    public MetaViews queryViews(User user, ClassInfos classInfos, WCMFilter wCMFilter) throws WCMException {
        Cloneable cloneable;
        if (classInfos == null || classInfos.isEmpty()) {
            return this.queryAllViews(user, wCMFilter);
        }
        if (classInfos.size() == 1 && ((ClassInfo)(cloneable = (ClassInfo)classInfos.getAt(0))).isRoot()) {
            return this.queryAllViewsInRoot(user, (ClassInfo)cloneable, wCMFilter);
        }
        cloneable = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer(classInfos.size() * 2 + 300);
        stringBuffer.append("exists(select XWCMClassInfoView.ViewId");
        stringBuffer.append(" from XWCMClassInfoView");
        stringBuffer.append(" where XWCMClassInfoView.ClassInfoId in(");
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            int n2 = classInfos.getIdAt(i);
            if (n2 == 0) continue;
            stringBuffer.append("?,");
            ((WCMFilter)cloneable).addSearchValues(n2);
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        stringBuffer.append(" and XWCMClassInfoView.ViewId=XWCMViewInfo.viewInfoId)");
        ((WCMFilter)cloneable).setWhere(stringBuffer.toString());
        ((WCMFilter)cloneable).mergeWith(wCMFilter);
        logger.debug((Object)cloneable);
        return MetaViews.openWCMObjs(user, (WCMFilter)cloneable);
    }

    private MetaViews queryAllViews(User user, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        String string = "viewInfoId in (select distinct(XWCMClassInfoView.ViewId) from XWCMClassInfoView)";
        wCMFilter2.setWhere(string);
        wCMFilter2.mergeWith(wCMFilter);
        logger.debug((Object)wCMFilter2);
        return MetaViews.openWCMObjs(user, wCMFilter2);
    }

    private MetaViews queryAllViewsInRoot(User user, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        String string = "viewInfoId in (select viewId from xwcmclassinfoview where ClassInfoId in (select classinfoid from xwcmclassinfo where rootid=?))";
        wCMFilter2.setWhere(string);
        wCMFilter2.addSearchValues(classInfo.getId());
        wCMFilter2.mergeWith(wCMFilter);
        logger.debug((Object)wCMFilter2);
        return MetaViews.openWCMObjs(user, wCMFilter2);
    }

    public ClassInfos queryClassInfos(User user, Document document, WCMFilter wCMFilter) throws WCMException {
        if (document == null) {
            return null;
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        String string = "ClassInfoId in(select XWCMClassInfoView.ClassInfoId from XWCMClassInfoView where XWCMClassInfoView.MetaDataId = ?)";
        wCMFilter2.setWhere(string.toString());
        wCMFilter2.addSearchValues(document.getDocId());
        wCMFilter2.mergeWith(wCMFilter);
        logger.debug((Object)wCMFilter2);
        return ClassInfos.openWCMObjs(user, wCMFilter2);
    }

    public int queryDocumentNum(User user, ClassInfo classInfo) throws WCMException {
        if (classInfo == null) {
            String string = "Select count(distinct MetaDataId) from XWCMClassInfoView";
            return DBManager.getDBManager().sqlExecuteIntQuery(string);
        }
        if (classInfo.isRoot()) {
            String string = "Select count(distinct MetaDataId) from XWCMClassInfoView where ClassInfoId in (select ClassInfoId from XWCMClassInfo where RootId=?)";
            return DBManager.getDBManager().sqlExecuteIntQuery(string, new int[]{classInfo.getId()});
        }
        String string = String.valueOf(classInfo.getId());
        String string2 = this.getClassInfoMgr().queryChildrenWithAllLevel(user, classInfo, null);
        if (string2 != null && string2.length() > 0) {
            string = string + "," + string2;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("Select count(distinct MetaDataId) from XWCMClassInfoView");
        stringBuffer.append(" where XWCMClassInfoView.ClassInfoId in(");
        int n = string.split(",").length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("?,");
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return DBManager.getDBManager().sqlExecuteIntQuery(stringBuffer.toString(), CMyString.splitToInt(string, ","));
    }

    public int queryDocumentNum(User user, ClassInfo classInfo, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("XWCMClassInfoView", "", "", "count(distinct MetaDataId)");
        if (classInfo != null) {
            if (classInfo.isRoot()) {
                String string = "ClassInfoId in (select ClassInfoId from XWCMClassInfo where RootId=?)";
                wCMFilter2.setWhere(string);
                wCMFilter2.addSearchValues(classInfo.getId());
            } else {
                String string = String.valueOf(classInfo.getId());
                String string2 = this.getClassInfoMgr().queryChildrenWithAllLevel(user, classInfo, null);
                if (string2 != null && string2.length() > 0) {
                    string = string + "," + string2;
                }
                String[] stringArray = string.split(",");
                StringBuffer stringBuffer = new StringBuffer(300);
                stringBuffer.append("XWCMClassInfoView.ClassInfoId in(");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("?,");
                    wCMFilter2.addSearchValues(stringArray[i]);
                }
                stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
                wCMFilter2.setWhere(stringBuffer.toString());
            }
        }
        wCMFilter2.mergeWith(wCMFilter);
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter2);
    }

    public void delete(User user, ClassInfo classInfo) throws WCMException {
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{this.SQL_CLEAR_BY_CLASSINFOID}, new int[]{classInfo.getId()});
    }

    public MetaViewDatas queryViewDatas(User user, ClassInfo classInfo, MetaView metaView) throws WCMException {
        MetaViewDatas metaViewDatas = new MetaViewDatas(metaView);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("MetaDataId in(");
        stringBuffer.append(" Select MetaDataId from XWCMClassInfoView Where");
        stringBuffer.append(" ViewId = ");
        stringBuffer.append(metaView.getId());
        stringBuffer.append(" and ");
        stringBuffer.append(" ClassInfoId = ");
        stringBuffer.append(classInfo.getId());
        stringBuffer.append(")");
        metaViewDatas.open(new WCMFilter("", stringBuffer.toString(), ""));
        return metaViewDatas;
    }

    public void moveViewDatasByClassInfo(User user, ClassInfo classInfo, int n) throws WCMException {
        String string = null;
        if (n != 0) {
            string = String.valueOf(n);
        }
        this.moveViewDatasByClassInfo(user, classInfo, string);
    }

    public void moveViewDatasByClassInfo(User user, ClassInfo classInfo, String string) throws WCMException {
        if (classInfo == null) {
            return;
        }
        int n = classInfo.getId();
        int n2 = classInfo.getRootId();
        ClassInfos classInfos = ClassInfos.createNewInstance(user);
        classInfos.addElement(classInfo);
        MetaViews metaViews = this.queryViews(user, classInfos, null);
        int n3 = metaViews.size();
        for (int i = 0; i < n3; ++i) {
            MetaView metaView = (MetaView)metaViews.getAt(i);
            if (metaView == null) continue;
            WCMFilter wCMFilter = new WCMFilter("", "fieldType=10", "");
            MetaViewFields metaViewFields = this.getMetaDataDefMgr().getViewFields(user, metaView, wCMFilter);
            String string2 = null;
            String string3 = null;
            int n4 = metaViewFields.size();
            for (int j = 0; j < n4; ++j) {
                MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(j);
                if (metaViewField == null || metaViewField.getClassId() != n2) continue;
                string2 = metaViewField.getName();
                string3 = metaViewField.getDBName();
                break;
            }
            if (string3 == null) continue;
            MetaViewDatas metaViewDatas = this.queryViewDatas(user, classInfo, metaView);
            int n5 = metaViewDatas.size();
            for (n4 = 0; n4 < n5; ++n4) {
                MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(n4);
                if (metaViewData == null) continue;
                String string4 = metaViewData.getPropertyAsString(string2);
                if (CMyString.isEmpty(string4)) {
                    if (CMyString.isEmpty(string)) continue;
                    string4 = String.valueOf(classInfo.getId());
                }
                boolean bl = CMyString.isEmpty(string) || string4.matches(".*(^|,)" + string + "($|,).*");
                String string5 = null;
                if (bl) {
                    string5 = string4.replaceFirst("(^|,)" + n + "($|,)", "$1$2");
                    int n6 = string5.length();
                    if (n6 > 1) {
                        if (string5.charAt(0) == ',') {
                            string5 = string5.substring(1);
                        }
                        if (string5.charAt((n6 = string5.length()) - 1) == ',') {
                            string5 = string5.substring(0, n6 - 1);
                        }
                    }
                } else {
                    string5 = string4.replaceFirst("(^|,)" + n + "($|,)", "$1" + string + "$2");
                }
                if (string5 == null || string5.equalsIgnoreCase(string4)) continue;
                metaViewData.setPropertyWithString(string3, string5);
                metaViewData.setSkipValid(true);
                metaViewData.save(user);
            }
        }
    }

    public void moveViewDatasByClassInfo(MetaViewData metaViewData, ClassInfo classInfo, ClassInfo classInfo2, User user) throws WCMException {
        if (metaViewData == null || classInfo == null || classInfo.equals(classInfo2)) {
            return;
        }
        MetaViewFields metaViewFields = this.getViewFields(metaViewData.getMetaView(), classInfo, user);
        if (metaViewFields == null || metaViewFields.isEmpty()) {
            return;
        }
        int n = metaViewFields.size();
        for (int i = 0; i < n; ++i) {
            MetaViewField metaViewField = (MetaViewField)metaViewFields.getAt(i);
            if (metaViewField == null) continue;
            this.moveViewDatasByClassInfo(metaViewData, metaViewField, classInfo, classInfo2, user);
        }
    }

    public void moveViewDatasByClassInfo(MetaViewDatas metaViewDatas, ClassInfo classInfo, ClassInfo classInfo2, User user) throws WCMException {
        if (metaViewDatas == null || classInfo == null || classInfo.equals(classInfo2)) {
            return;
        }
        int n = metaViewDatas.size();
        for (int i = 0; i < n; ++i) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(i);
            if (metaViewData == null) continue;
            if (metaViewData.getMetaView() == null) {
                metaViewData.setMetaView(metaViewDatas.getMetaView());
            }
            this.moveViewDatasByClassInfo(metaViewData, classInfo, classInfo2, user);
        }
    }

    public void moveViewDatasByClassInfo(MetaViewData metaViewData, MetaViewField metaViewField, ClassInfo classInfo, ClassInfo classInfo2, User user) throws WCMException {
        if (metaViewData == null || classInfo == null || classInfo.equals(classInfo2)) {
            return;
        }
        String string = metaViewField.getName();
        String string2 = metaViewData.getPropertyAsString(string);
        if (CMyString.isEmpty(string2)) {
            return;
        }
        String string3 = String.valueOf(classInfo.getId());
        if (string2.indexOf(string3) < 0) {
            return;
        }
        String string4 = null;
        if (classInfo2 != null) {
            string4 = String.valueOf(classInfo2.getId());
        }
        boolean bl = CMyString.isEmpty(string4) || string2.matches(".*(^|,)" + string4 + "($|,).*");
        String string5 = null;
        if (bl) {
            string5 = string2.replaceFirst("(^|,)" + string3 + "($|,)", "$1$2");
            int n = string5.length();
            if (n > 1) {
                if (string5.charAt(0) == ',') {
                    string5 = string5.substring(1);
                }
                if (string5.charAt((n = string5.length()) - 1) == ',') {
                    string5 = string5.substring(0, n - 1);
                }
            }
        } else {
            string5 = string2.replaceFirst("(^|,)" + string3 + "($|,)", "$1" + string4 + "$2");
        }
        if (string2.equalsIgnoreCase(string5)) {
            return;
        }
        metaViewData.setPropertyWithString(metaViewField.getDBName(), string5);
        metaViewData.save(user);
    }

    private MetaViewFields getViewFields(MetaView metaView, ClassInfo classInfo, User user) throws WCMException {
        if (classInfo == null) {
            return MetaViewFields.createNewInstance(user);
        }
        String string = "FieldType=10 and CLASSID=" + classInfo.getRootId();
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.setWhere(string);
        return this.getMetaDataDefMgr().getViewFields(user, metaView, wCMFilter);
    }

    public ClassInfos queryClassInfos(User user, Documents documents, WCMFilter wCMFilter) throws WCMException {
        if (documents == null) {
            return null;
        }
        WCMFilter wCMFilter2 = new WCMFilter();
        StringBuffer stringBuffer = new StringBuffer(300);
        int n = documents.size();
        for (int i = 0; i < n; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            stringBuffer.append("?,");
            wCMFilter2.addSearchValues(document.getId());
        }
        if (stringBuffer.length() <= 0) {
            return null;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        StringBuffer stringBuffer2 = new StringBuffer(350);
        stringBuffer2.append("ClassInfoId in (");
        stringBuffer2.append("select ClassInfoId from XWCMClassInfoView Where MetaDataId in(");
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append("))");
        wCMFilter2.setWhere(stringBuffer2.toString());
        wCMFilter2.mergeWith(wCMFilter);
        logger.debug((Object)wCMFilter2);
        return ClassInfos.openWCMObjs(user, wCMFilter2);
    }

    public void moveViewDatasByClassInfos(MetaViewDatas metaViewDatas, ClassInfos classInfos, ClassInfo classInfo, User user) throws WCMException {
        if (metaViewDatas == null || metaViewDatas.isEmpty()) {
            return;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return;
        }
        int n = metaViewDatas.size();
        for (int i = 0; i < n; ++i) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(i);
            if (metaViewData == null) continue;
            if (metaViewData.getMetaView() == null) {
                metaViewData.setMetaView(metaViewDatas.getMetaView());
            }
            this.moveViewDataByClassInfos(metaViewData, classInfos, classInfo, user);
        }
    }

    public void moveViewDataByClassInfos(MetaViewData metaViewData, ClassInfos classInfos, ClassInfo classInfo, User user) throws WCMException {
        if (metaViewData == null) {
            return;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return;
        }
        boolean bl = false;
        MetaView metaView = metaViewData.getMetaView();
        if (metaView == null) {
            throw new WCMException(I18NMessage.get(ClassInfoViewMgr.class, "ClassInfoViewMgr.label1", "\u5f53\u524d\u64cd\u4f5c\u7684\u8bb0\u5f55\u6ca1\u6709\u89c6\u56fe\u4fe1\u606f"));
        }
        Map map = this.getMetaDataDefCacheMgr().getMetaViewFields(metaView.getId(), 10);
        for (MetaViewField metaViewField : map.values()) {
            if (!this.moveViewDataByClassInfos0(metaViewData, metaViewField, classInfos, classInfo, user)) continue;
            bl = true;
        }
        if (bl) {
            metaViewData.save(user);
        }
    }

    public void moveViewDatasByClassInfos(MetaViewDatas metaViewDatas, MetaViewField metaViewField, ClassInfos classInfos, ClassInfo classInfo, User user) throws WCMException {
        if (metaViewDatas == null || metaViewDatas.isEmpty()) {
            return;
        }
        if (metaViewField == null || metaViewField.getType() != 10) {
            return;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return;
        }
        int n = metaViewDatas.size();
        for (int i = 0; i < n; ++i) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(i);
            if (metaViewData == null) continue;
            this.moveViewDataByClassInfos(metaViewData, metaViewField, classInfos, classInfo, user);
        }
    }

    public void moveViewDataByClassInfos(MetaViewData metaViewData, MetaViewField metaViewField, ClassInfos classInfos, ClassInfo classInfo, User user) throws WCMException {
        if (metaViewData == null) {
            return;
        }
        if (metaViewField == null || metaViewField.getType() != 10) {
            return;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return;
        }
        if (this.moveViewDataByClassInfos0(metaViewData, metaViewField, classInfos, classInfo, user)) {
            metaViewData.save(user);
        }
    }

    private boolean moveViewDataByClassInfos0(MetaViewData metaViewData, MetaViewField metaViewField, ClassInfos classInfos, ClassInfo classInfo, User user) throws WCMException {
        String string;
        int[] nArray;
        if (metaViewData == null) {
            return false;
        }
        if (metaViewField == null || metaViewField.getType() != 10) {
            return false;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return false;
        }
        if (classInfo != null && metaViewField.getClassId() != classInfo.getRootId()) {
            return false;
        }
        String string2 = metaViewData.getPropertyAsString(metaViewField.getName());
        if (CMyString.isEmpty(string2)) {
            return false;
        }
        int[] nArray2 = ArrayUtil.split(string2, ",");
        if (!ArrayUtil.containAny(nArray2, nArray = ArrayUtil.split(string = classInfos.getIdListAsString(), ","))) {
            return false;
        }
        int[] nArray3 = ArrayUtil.removeAll(nArray2, nArray);
        if (classInfo != null) {
            nArray3 = ArrayUtil.addAll(nArray3, new int[]{classInfo.getId()});
        }
        if (ArrayUtil.equals(nArray2, nArray3)) {
            return false;
        }
        String string3 = ArrayUtil.join(nArray3, ",");
        metaViewData.setPropertyWithString(metaViewField.getDBName(), string3);
        return true;
    }

    public void copyViewDatasByClassInfos(MetaViewDatas metaViewDatas, ClassInfos classInfos, User user) throws WCMException {
        if (metaViewDatas == null || metaViewDatas.isEmpty()) {
            return;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return;
        }
        int n = metaViewDatas.size();
        for (int i = 0; i < n; ++i) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(i);
            if (metaViewData == null) continue;
            if (metaViewData.getMetaView() == null) {
                metaViewData.setMetaView(metaViewDatas.getMetaView());
            }
            this.copyViewDataByClassInfos(metaViewData, classInfos, user);
        }
    }

    public void copyViewDatasByClassInfos(MetaViewDatas metaViewDatas, MetaViewField metaViewField, ClassInfos classInfos, User user) throws WCMException {
        if (metaViewDatas == null || metaViewDatas.isEmpty()) {
            return;
        }
        if (metaViewField == null || metaViewField.getType() != 10) {
            return;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return;
        }
        int n = metaViewDatas.size();
        for (int i = 0; i < n; ++i) {
            MetaViewData metaViewData = (MetaViewData)metaViewDatas.getAt(i);
            if (metaViewData == null) continue;
            this.copyViewDataByClassInfos(metaViewData, metaViewField, classInfos, user);
        }
    }

    public void copyViewDataByClassInfos(MetaViewData metaViewData, ClassInfos classInfos, User user) throws WCMException {
        if (metaViewData == null) {
            return;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return;
        }
        boolean bl = false;
        MetaView metaView = metaViewData.getMetaView();
        if (metaView == null) {
            throw new WCMException(I18NMessage.get(ClassInfoViewMgr.class, "ClassInfoViewMgr.label2", "\u89c6\u56fe\u8bb0\u5f55\u7adf\u7136\u6ca1\u6709\u89c6\u56fe\u4fe1\u606f"));
        }
        Map map = this.getMetaDataDefCacheMgr().getMetaViewFields(metaView.getId(), 10);
        for (MetaViewField metaViewField : map.values()) {
            if (!this.copyViewDataByClassInfos0(metaViewData, metaViewField, classInfos, user)) continue;
            bl = true;
        }
        if (bl) {
            metaViewData.save(user);
        }
    }

    public void copyViewDataByClassInfos(MetaViewData metaViewData, MetaViewField metaViewField, ClassInfos classInfos, User user) throws WCMException {
        if (metaViewData == null) {
            return;
        }
        if (metaViewField == null || metaViewField.getType() != 10) {
            return;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return;
        }
        if (this.copyViewDataByClassInfos0(metaViewData, metaViewField, classInfos, user)) {
            metaViewData.save(user);
        }
    }

    private boolean copyViewDataByClassInfos0(MetaViewData metaViewData, MetaViewField metaViewField, ClassInfos classInfos, User user) throws WCMException {
        Object object;
        if (metaViewData == null) {
            return false;
        }
        if (metaViewField == null || metaViewField.getType() != 10) {
            return false;
        }
        if (classInfos == null || classInfos.isEmpty()) {
            return false;
        }
        int n = metaViewField.getClassId();
        int n2 = 0;
        int[] nArray = new int[classInfos.size()];
        int n3 = classInfos.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            object = (ClassInfo)classInfos.getAt(i);
            if (object == null || n != ((ClassInfo)object).getRootId() || ArrayUtil.indexOf(nArray, n4 = ((BaseObj)object).getId(), 0, n2) >= 0) continue;
            nArray[n2++] = n4;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        String string = metaViewData.getPropertyAsString(metaViewField.getName());
        object = ArrayUtil.split(string, ",");
        nArray2 = ArrayUtil.addAll((int[])object, nArray2);
        if (ArrayUtil.equals((int[])object, nArray2)) {
            return false;
        }
        String string2 = ArrayUtil.join(nArray2, null);
        metaViewData.setPropertyWithString(metaViewField.getDBName(), string2);
        return true;
    }

    private static class ArrayUtil {
        private ArrayUtil() {
        }

        public static int[] removeAll(int[] nArray, int[] nArray2) {
            int[] nArray3 = null;
            if (nArray2 == null || nArray2.length <= 0) {
                nArray3 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray3, 0, nArray3.length);
                return nArray3;
            }
            int n = 0;
            int[] nArray4 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                if (ArrayUtil.indexOf(nArray2, nArray[i]) >= 0) continue;
                nArray4[n++] = nArray[i];
            }
            nArray3 = new int[n];
            System.arraycopy(nArray4, 0, nArray3, 0, nArray3.length);
            return nArray3;
        }

        public static int[] addAll(int[] nArray, int[] nArray2) {
            int[] nArray3 = null;
            if (nArray2 == null || nArray2.length <= 0) {
                nArray3 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray3, 0, nArray3.length);
                return nArray3;
            }
            int[] nArray4 = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
            int n = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                if (ArrayUtil.indexOf(nArray, nArray2[i]) >= 0) continue;
                nArray4[nArray.length + n++] = nArray2[i];
            }
            nArray3 = new int[n + nArray.length];
            System.arraycopy(nArray4, 0, nArray3, 0, nArray3.length);
            return nArray3;
        }

        public static String join(int[] nArray, String string) {
            if (nArray == null || nArray.length <= 0) {
                return new String();
            }
            return ArrayUtil.join(nArray, 0, nArray.length, string);
        }

        public static String join(int[] nArray, int n, int n2, String string) {
            if (nArray == null || nArray.length <= n || n2 < 0 || n >= n2) {
                return new String();
            }
            if (string == null) {
                string = ",";
            }
            StringBuffer stringBuffer = new StringBuffer(nArray.length * 3);
            for (int i = n; i < n2; ++i) {
                stringBuffer.append(nArray[i]).append(string);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - string.length());
            }
            return stringBuffer.toString();
        }

        public static int[] split(String string, String string2) {
            if (string == null || string.length() <= 0) {
                return new int[0];
            }
            if (string2 == null) {
                string2 = ",";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                nArray[n] = Integer.parseInt(string3.trim());
                ++n;
            }
            return nArray;
        }

        public static boolean equals(int[] nArray, int[] nArray2) {
            return ArrayUtil.containAll(nArray, nArray2) && ArrayUtil.containAll(nArray2, nArray);
        }

        public static boolean containAll(int[] nArray, int[] nArray2) {
            if (nArray2 == null) {
                return true;
            }
            for (int i = 0; i < nArray2.length; ++i) {
                if (ArrayUtil.indexOf(nArray, nArray2[i]) >= 0) continue;
                return false;
            }
            return true;
        }

        public static boolean containAny(int[] nArray, int[] nArray2) {
            if (nArray2 == null) {
                return true;
            }
            for (int i = 0; i < nArray2.length; ++i) {
                if (ArrayUtil.indexOf(nArray, nArray2[i]) < 0) continue;
                return true;
            }
            return false;
        }

        public static int indexOf(int[] nArray, int n) {
            if (nArray == null || nArray.length == 0) {
                return -1;
            }
            return ArrayUtil.indexOf(nArray, n, 0, nArray.length);
        }

        public static int indexOf(int[] nArray, int n, int n2, int n3) {
            if (nArray == null || nArray.length <= n2 || n3 < 0 || n2 >= n3) {
                return -1;
            }
            if (n3 > nArray.length) {
                n3 = nArray.length;
            }
            for (int i = n2; i < n3; ++i) {
                if (nArray[i] != n) continue;
                return i;
            }
            return -1;
        }
    }
}

