/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewDatas;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMTagParserInfoViewDatas
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(WCMTagParserInfoViewDatas.class);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_DOCUMENT = new ArrayList(16);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA;
    private InfoViewEmployMgr m_oInfoViewEmployMgr = null;
    private InfoView m_oCurrInfoview = null;
    private BaseChannel m_oChannel = null;
    private TagItem m_oTagItem = null;
    private Logger m_oLogger = Logger.getLogger(WCMTagParserInfoViewDatas.class);

    public WCMTagParserInfoViewDatas() {
        this.m_oInfoViewEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        this.makeCurrChannel(publishTagContext);
        if (this.m_oChannel != null) {
            this.m_oCurrFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        }
        return super.parse(publishTagContext);
    }

    private void makeCurrChannel(PublishTagContext publishTagContext) {
        try {
            int n = publishTagContext.getAttribute("ChannelId", 0);
            this.m_oChannel = n != 0 ? Channel.findById(n) : WCMTagParserHelper.findFolderHost(publishTagContext.getTagItem(), publishTagContext, false);
            this.m_oLogger.debug((Object)("\u5f53\u524d\u680f\u76ee\u662f\uff1a----" + this.m_oChannel.getName()));
        }
        catch (Exception exception) {
            this.m_oLogger.debug((Object)exception);
        }
    }

    protected CMSBaseObjs findObjects(PublishTagContext publishTagContext) throws WCMException {
        this.makeCurrInfoview(publishTagContext);
        String string = publishTagContext.getAttribute("Where");
        String string2 = publishTagContext.getAttribute("Order");
        if (this.m_oChannel == null || publishTagContext.getAttribute("DirectFromInfoViewTable", false)) {
            String string3;
            WCMFilter wCMFilter = new WCMFilter(null, null, null);
            StringBuffer stringBuffer = new StringBuffer(300);
            stringBuffer.append("exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.DocId=");
            stringBuffer.append(this.m_oCurrInfoview.getTrueTableName() + ".DocumentId");
            stringBuffer.append(" and WCMChnlDoc.docFlag =? ");
            wCMFilter.addSearchValues(this.m_oCurrInfoview.getId());
            int[] nArray = new int[]{10};
            if (publishTagContext.isPreview() && this.m_oChannel != null) {
                IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
                nArray = this.getPreviewStatus(iPublishFolder);
            }
            stringBuffer.append(" and WCMChnlDoc.DOCSTATUS in(");
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append("?,");
                wCMFilter.addSearchValues(nArray[i]);
            }
            if (nArray.length > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            stringBuffer.append(")");
            if (this.m_oChannel != null && !publishTagContext.getAttribute("IgnoreChannel", false)) {
                if (this.m_oChannel.isSite()) {
                    stringBuffer.append(" and WCMChnlDoc.ChnlId in(select WCMChannel.ChannelId from WCMChannel where WCMChannel.SiteId=?)");
                    wCMFilter.addSearchValues(this.m_oChannel.getId());
                } else {
                    Channel channel = (Channel)this.m_oChannel;
                    if (!channel.isOnlySearch()) {
                        stringBuffer.append(" and WCMChnlDoc.ChnlId=?");
                        wCMFilter.addSearchValues(this.m_oChannel.getId());
                    }
                    if ((string3 = channel.getQuery()) != null && string3.length() > 0) {
                        stringBuffer.append(stringBuffer.length() > 0 ? " and (" : "(");
                        stringBuffer.append(string3);
                        stringBuffer.append(')');
                    }
                }
            }
            stringBuffer.append(")");
            if (!CMyString.isEmpty(string)) {
                stringBuffer.append(" and (" + string + ")");
            }
            wCMFilter.setWhere(stringBuffer.toString());
            if (!CMyString.isEmpty(string2)) {
                wCMFilter.setOrder(string2);
            } else {
                wCMFilter.setOrder("CRTIME desc");
            }
            InfoViewDatas infoViewDatas = new InfoViewDatas(this.m_oCurrInfoview.getId());
            string3 = this.getSelectFields(this.m_oCurrInfoview.getTrueTableName().toUpperCase(), "TRS_INFOVIEWDATA", publishTagContext);
            wCMFilter.setSelect(string3);
            int n = publishTagContext.getAttribute("NUM", -1);
            if (n == -1) {
                n = 300;
                publishTagContext.getTagItem().setAttribute("NUM", n);
            }
            infoViewDatas.setPageSize(n);
            infoViewDatas.setMaxBufferSize(n);
            infoViewDatas.open(wCMFilter);
            return infoViewDatas;
        }
        WCMFilter wCMFilter = new WCMFilter(null, null, string2);
        string = !CMyString.isEmpty(string) ? "exists(select " + this.m_oCurrInfoview.getTrueTableName() + ".DocumentId from " + this.m_oCurrInfoview.getTrueTableName() + " where (" + string + ") and WCMChnlDoc.DocId=" + this.m_oCurrInfoview.getTrueTableName() + ".DocumentId)" : "exists(select " + this.m_oCurrInfoview.getTrueTableName() + ".DocumentId from " + this.m_oCurrInfoview.getTrueTableName() + " where WCMChnlDoc.DocId=" + this.m_oCurrInfoview.getTrueTableName() + ".DocumentId)";
        wCMFilter.setWhere(string);
        WCMFilter wCMFilter2 = new WCMFilter("WCMChnlDoc", "WCMChnlDoc.DocFlag=?", "", this.getSelectFields("WCMDOCUMENT", "TRS_DOCUMENT", publishTagContext));
        wCMFilter2.mergeWith(wCMFilter);
        wCMFilter2.addSearchValues(this.m_oCurrInfoview.getId());
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        if (publishTagContext.isPreview()) {
            return this.getPreviewContents(iPublishFolder, wCMFilter2);
        }
        return this.getPublishedContents(wCMFilter2);
    }

    protected boolean isValidate(PublishTagContext publishTagContext) throws WCMException {
        this.makeCurrInfoview(publishTagContext);
        return true;
    }

    private void makeCurrInfoview(PublishTagContext publishTagContext) throws WCMException {
        if (this.m_oCurrInfoview != null) {
            return;
        }
        int n = publishTagContext.getAttribute("InfoViewId", 0);
        if (n > 0) {
            System.out.println("----infoviewId:---------" + n);
            this.m_oCurrInfoview = InfoView.findById(n);
        } else {
            IPublishElement iPublishElement = publishTagContext.getUpperHost();
            CMSObj cMSObj = iPublishElement.getSubstance();
            if (this.m_oChannel == null || !(this.m_oChannel instanceof Channel)) {
                throw new WCMException("\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9\uff0c\u53ea\u80fd\u7528\u5728\u6307\u5b9a\u680f\u76ee\u6216\u8005\u6307\u5b9a\u6587\u6863\u4e0a\uff01\u5f53\u524d\u5bf9\u8c61\u662f[" + cMSObj.getClassName(true) + "]\u7684\u5b9e\u4f8b");
            }
            int n2 = this.m_oChannel.getId();
            List list = this.m_oInfoViewEmployMgr.getEmployedInfoViews(101, n2);
            if (list != null && list.size() > 0) {
                this.m_oCurrInfoview = (InfoView)list.get(0);
            }
        }
        if (this.m_oCurrInfoview == null) {
            throw new WCMException("\u6ca1\u6709\u5173\u8054\u5230\u6709\u6548\u7684\u8868\u5355");
        }
        this.m_oLogger.debug((Object)("\u5f53\u524d\u8868\u5355\u662f\uff1a----" + this.m_oCurrInfoview.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(String string, String string2, PublishTagContext publishTagContext) {
        String string3 = (string + ".SELECT").toUpperCase();
        String string4 = publishTagContext.getTagItem().getExtraAttributeValue(string3);
        if (string4 == null) {
            TagItem tagItem = publishTagContext.getTagItem();
            synchronized (tagItem) {
                string4 = publishTagContext.getTagItem().getExtraAttributeValue(string3);
                if (string4 == null) {
                    string4 = this.makeSelectFields(string, string2, publishTagContext);
                    publishTagContext.getTagItem().setExtraAttribute(string3, string4);
                }
            }
        }
        return string4;
    }

    private String makeSelectFields(String string, String string2, PublishTagContext publishTagContext) {
        ArrayList arrayList = null;
        arrayList = string.equalsIgnoreCase("WCMDOCUMENT") ? FIELDS_DEFAULT_LIST_OF_DOCUMENT : FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA;
        String string3 = (String)arrayList.get(0);
        int n = arrayList.size();
        for (int i = 1; i < n; ++i) {
            string3 = string3 + "," + arrayList.get(i);
        }
        ArrayList arrayList2 = TagParseHelper.makeSelectFields(publishTagContext.getTagItem(), string2);
        DBManager dBManager = DBManager.getDBManager();
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            String string4 = (String)arrayList2.get(i);
            if (arrayList.indexOf(string4) >= 0) continue;
            try {
                if (dBManager.getFieldInfo(string, string4) == null) {
                    publishTagContext.addWarning("TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[" + string4 + "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01");
                    continue;
                }
            }
            catch (WCMException wCMException) {
                wCMException.printStackTrace();
                try {
                    publishTagContext.addWarning("\u83b7\u53d6\u6307\u5b9a\u7684Field[" + string4 + "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01" + CMyException.getStackTraceText(wCMException));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            string3 = string3 + "," + string4;
        }
        return string3;
    }

    private CMSBaseObjs getPreviewContents(IPublishFolder iPublishFolder, WCMFilter wCMFilter) throws WCMException {
        return this.getContents(this.getPreviewStatus(iPublishFolder), wCMFilter);
    }

    private CMSBaseObjs getPublishedContents(WCMFilter wCMFilter) throws WCMException {
        return this.getContents(this.getPublishStatus(), wCMFilter);
    }

    private CMSBaseObjs getContents(int[] nArray, WCMFilter wCMFilter) throws WCMException {
        this.m_oLogger.debug((Object)("sql\u662f\uff1a----" + wCMFilter));
        if (nArray == null || nArray.length <= 0) {
            return null;
        }
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        wCMFilter2.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String string = "WCMCHNLDOC.DOCSTATUS in(?";
        wCMFilter2.addSearchValues(0, nArray[0]);
        int n = nArray.length;
        for (int i = 1; i < n; ++i) {
            string = string + ",?";
            wCMFilter2.addSearchValues(i, nArray[i]);
        }
        string = string + ")";
        wCMFilter2.setWhere(string);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        this.m_oLogger.debug((Object)("sql2\u662f\uff1a----" + wCMFilter));
        Documents documents = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            if (this.m_oChannel == null || !(this.m_oChannel instanceof Channel)) {
                throw new WCMException("\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9\uff0c\u53ea\u80fd\u7528\u5728\u8868\u5355\u6216\u6307\u5b9a\u680f\u76ee\u4e0a\uff01\u5f53\u524d\u5bf9\u8c61\u662f[" + this.m_oChannel + "]\u7684\u5b9e\u4f8b");
            }
            documents = DocumentsGetHelper.getDocuments((Channel)this.m_oChannel, wCMFilter2);
        } else {
            DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            documents = documentMgr.getDocuments(this.m_oChannel, wCMFilter2);
        }
        debugTimer.stop();
        return documents;
    }

    private int[] getPreviewStatus(IPublishFolder iPublishFolder) throws WCMException {
        IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        int[] nArray = iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(iPublishFolder2.getType(), iPublishFolder2.getId());
        if (nArray == null) {
            return new int[]{10};
        }
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray2.length - 1] = 10;
        return nArray2;
    }

    private int[] getPublishStatus() throws WCMException {
        return new int[]{10};
    }

    static {
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCID");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCTITLE");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCFLAG");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("CRTIME");
        FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA = new ArrayList(4);
        FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA.add("ChannelId");
        FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA.add("CRTIME");
        FIELDS_DEFAULT_LIST_OF_INFOVIEWDATA.add("DOCTITLE");
    }
}

