/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.infoview.persistent.InfoViewDocument;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.html.HtmlUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class TagParserInfoViewData
implements ITagParser {
    private static final Logger s_logger = Logger.getLogger(TagParserInfoViewData.class);
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_INFOVIEWDATA");
            tagBeanInfo.setDesc("TRS_INFOVIEWDATA");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setDesc("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setRequired(true);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOFORMAT");
            tagBeanAttrInfo.setDesc("AUTOFORMAT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanAttrInfo.setRequired(false);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("DATEFORMAT");
            tagBeanAttrInfo.setDesc("DATEFORMAT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanAttrInfo.setRequired(false);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOFORMATTYPE");
            tagBeanAttrInfo.setDesc("AUTOFORMATTYPE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("HTML");
            tagBeanAttrInfo.setRequired(false);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TRUNCATEDFLAG");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("...");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) throws WCMException {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        Object object;
        Object object2;
        String string = publishTagContext.getAttribute("FIELD");
        if (string == null || string.length() <= 0) {
            return null;
        }
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        CMSObj cMSObj = iPublishElement.getSubstance();
        String string2 = null;
        if (cMSObj instanceof Document) {
            object2 = (Document)cMSObj;
            if (((Document)object2).getChannel().getType() != 13) {
                return null;
            }
            object = this.getInfoViewDocumentUseCache(publishTagContext, (Document)object2);
            string2 = this.getFieldValue(string, (InfoViewDocument)object, publishTagContext);
        } else if (cMSObj instanceof InfoViewData) {
            object2 = (InfoViewData)cMSObj;
            string2 = this.getFieldValue(string, (InfoViewData)object2, publishTagContext);
        } else {
            object2 = new StringBuffer(256);
            ((StringBuffer)object2).append(publishTagContext.getTagItem().getDescWithPos());
            ((StringBuffer)object2).append(I18NMessage.get(TagParserInfoViewData.class, "TagParserInfoViewData.label1", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,\u53ef\u80fd\u76f4\u63a5\u7528\u5728\u4e86\u6982\u89c8\u9875\u9762\u4e2d\u6216\u8005\u5176\u5b83\u975e"));
            ((StringBuffer)object2).append(I18NMessage.get(TagParserInfoViewData.class, "TagParserInfoViewData.label2", "TRS_DOCUMENTS\u6982\u89c8\u7f6e\u6807\u4e2d\uff01[tag-host="));
            ((StringBuffer)object2).append(cMSObj).append(']');
            publishTagContext.addWarning(((StringBuffer)object2).toString());
        }
        if (string2 == null) {
            return null;
        }
        object2 = this.calImagePath(publishTagContext);
        object = new HTMLContent(string2);
        string2 = ((HTMLContent)object).parseHTMLContent((String)object2);
        this.distributionHTMLContentFiles((HTMLContent)object, publishTagContext, (IPublishContent)iPublishElement);
        string2 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string2);
        string2 = TagParseHelper.formatTextIfNeeded(publishTagContext, string2);
        return new String[]{string2};
    }

    private InfoViewDocument getInfoViewDocumentUseCache(PublishTagContext publishTagContext, Document document) throws WCMException {
        Object v;
        InfoViewDocument infoViewDocument = null;
        HashMap<String, InfoViewDocument> hashMap = publishTagContext.getExtraAttributes();
        if (hashMap == null) {
            hashMap = new HashMap<String, InfoViewDocument>(1);
            publishTagContext.setExtraAttributes(hashMap);
        }
        if ((v = hashMap.get("INFOVIEW_DOCUMENT")) instanceof InfoViewDocument) {
            infoViewDocument = (InfoViewDocument)v;
        }
        if (infoViewDocument == null || infoViewDocument.getDocId() != document.getId()) {
            infoViewDocument = InfoViewDocument.findSelfByDocument(document);
            hashMap.put("INFOVIEW_DOCUMENT", infoViewDocument);
        }
        return infoViewDocument;
    }

    private String getFieldValue(String string, InfoViewDocument infoViewDocument, PublishTagContext publishTagContext) {
        string = string.replaceAll("/[^:]*:", "/").replaceAll("^[^:*]:", "/");
        string = InfoViewHelper.getDBFieldByField(infoViewDocument.getInfoViewId(), string, false);
        Object object = infoViewDocument.getProperty(string);
        String string2 = null;
        if (object instanceof CMyDateTime) {
            string2 = ((CMyDateTime)object).toString(this.getDateFormat(publishTagContext));
        } else if (object instanceof String) {
            string2 = (String)object;
        } else if (object != null) {
            string2 = object.toString();
        }
        return string2;
    }

    private String getFieldValue(String string, InfoViewData infoViewData, PublishTagContext publishTagContext) {
        string = string.replaceAll("/[^:]*:", "/").replaceAll("^[^:*]:", "/");
        string = InfoViewHelper.getDBFieldByField(infoViewData.getInfoViewId(), string, false);
        Object object = infoViewData.getProperty(string);
        String string2 = null;
        if (object instanceof CMyDateTime) {
            string2 = ((CMyDateTime)object).toString(this.getDateFormat(publishTagContext));
        } else if (object instanceof String) {
            string2 = (String)object;
        } else if (object != null) {
            string2 = object.toString();
        }
        return string2;
    }

    protected String getDateFormat(PublishTagContext publishTagContext) {
        String string = publishTagContext.getAttribute("DATEFORMAT");
        if (string == null || (string = string.trim()).length() == 0) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        return TagParseHelper.parseDateFormat(string);
    }

    private void distributionHTMLContentFiles(HTMLContent hTMLContent, PublishTagContext publishTagContext, IPublishContent iPublishContent) {
        try {
            List list = hTMLContent.getWCMFiles();
            int n = list.size();
            if (n <= 0) {
                return;
            }
            boolean bl = publishTagContext.isPreview();
            PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
            iPublishContent.setFolder(iPublishContent.getOriginalHome());
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = (String)list.get(i);
                if (string2 == null || !CMyFile.fileExists(string = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2)) continue;
                String string3 = publishPathCompass.getLocalPath(iPublishContent, bl);
                PublishSyncGlobalTuner.insureLocalPathExists(string3);
                CMyFile.copyFile(string, string3 + string2);
                if (bl) continue;
                publishTagContext.getFileDistributeShip().distributeFile(string, iPublishContent, null, true);
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)(I18NMessage.get(TagParserInfoViewData.class, "TagParserInfoViewData.label3", "\u53d1\u5e03") + iPublishContent + I18NMessage.get(TagParserInfoViewData.class, "TagParserInfoViewData.label4", "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01")), (Throwable)exception);
        }
    }

    private String calImagePath(PublishTagContext publishTagContext) throws WCMException {
        String string = "InfoViewImagePath";
        PublishPageContext publishPageContext = publishTagContext.getPageContext();
        String string2 = publishPageContext.getExtraAttribute(string);
        if (string2 != null) {
            return string2;
        }
        IPublishContent iPublishContent = (IPublishContent)publishTagContext.getUpperHost();
        String string3 = publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishContent.getOriginalHome());
        String string4 = PublishPathCompass.calSubDirectory(iPublishContent, false);
        string2 = string3 + string4;
        if (!publishTagContext.getAttribute("UrlIsABS", false)) {
            string2 = HtmlUtil.calRelativePath(string2, publishTagContext.getPageHttpPath());
        }
        publishPageContext.setExtraAttribute(string, string2);
        return string2;
    }

    public void clear() {
    }
}

