/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.process;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.FlowUserHelper;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.infoview.InfoViewDataHelper;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SendEmailForInfoViewHandler
implements IActionHandler {
    private static final int VAR_RECEIVER_CRUSER = 1996496058;
    private static final int VAR_RECEIVER_DEPTMGR = -2022387309;
    private static final int VAR_RECEIVER_SPDEPTMGR = 268620950;
    private static final int VAR_RECEIVER_PREDEALER = 1434819164;
    private static final int VAR_RECEIVER_CURRDEALER = -641375541;
    private static Logger logger = Logger.getLogger(SendEmailForInfoViewHandler.class);
    private Document m_oCurrDocument = null;
    private Map m_hVarValues = null;

    public boolean execute(ExecuteContext executeContext, FlowAction flowAction) throws WCMException {
        Document document;
        CMSObj cMSObj = executeContext.getFlowContent().getSubinstance();
        if (!(cMSObj instanceof Document)) {
            return false;
        }
        this.m_oCurrDocument = document = (Document)cMSObj;
        ActionParametersAnalyser actionParametersAnalyser = new ActionParametersAnalyser(flowAction.getParams());
        String string = actionParametersAnalyser.getParameterValue("Fields");
        Map map = this.makeProperties(executeContext, document, string);
        String string2 = actionParametersAnalyser.getParameterValue("MailTemplateFile");
        String string3 = this.makeEmailContent(document, map, string2);
        User user = executeContext.getPostUser();
        Users users = this.makeReceiverUsers(actionParametersAnalyser, executeContext);
        this.m_hVarValues = new HashMap(5);
        this.m_hVarValues.put("CONTENTTITLE".toUpperCase(), executeContext.getFlowContent().getDesc());
        this.m_hVarValues.put("CurrDateTime".toUpperCase(), CMyDateTime.now().toString());
        this.m_hVarValues.put("SenderName".toUpperCase(), executeContext.getPostUser().getName());
        this.sendMail(string3, user, actionParametersAnalyser, map, users);
        return true;
    }

    private void sendMail(String string, User user, ActionParametersAnalyser actionParametersAnalyser, Map map, Users users) throws WCMException {
        String string2 = string.replaceAll("&quot;", "\"").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
        String string3 = this.getActionParameterWithContent("MailTitle", actionParametersAnalyser, map);
        int n = users.size();
        for (int i = 0; i < n; ++i) {
            User user2 = (User)users.getAt(i);
            if (user2 == null) continue;
            this.m_hVarValues.put("ReceiverName".toUpperCase(), user2.getName());
            Message message = new Message();
            message.setCrUser(user);
            message.setTitle(string3);
            message.setBody(string2);
            message.setReceivers(204, users.getIdListAsString());
            message.setSendTypes("Email");
            message.setProperty("MsgType", 1L);
            message.save(user);
            MessageServer.send(message);
        }
    }

    private Users makeReceiverUsers(ActionParametersAnalyser actionParametersAnalyser, ExecuteContext executeContext) throws WCMException {
        String string = actionParametersAnalyser.getParameterValue("Receiver");
        Users users = null;
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        switch (string.toUpperCase().hashCode()) {
            case 1996496058: {
                users = new Users(null, 1, 1);
                User user = executeContext.getFlowContent().getCrUser();
                if (user == null) break;
                users.addElement(user);
                break;
            }
            case -2022387309: {
                users = FlowUserHelper.getDeptMgrsOfUserx(executeContext.getPostUser());
                break;
            }
            case 268620950: {
                String string2 = executeContext.getFlowContent().getProperty(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label1", "\u652f\u6301\u90e8\u95e8"));
                users = FlowUserHelper.getDeptMgrsByGrpName(string2);
                break;
            }
            case 1434819164: {
                users = new Users(null, 1, 1);
                User user = executeContext.getCurrFlowDoc().getPostUser();
                if (user == null) break;
                users.addElement(user);
                break;
            }
            case -641375541: {
                users = new Users(null, 1, 1);
                User user = executeContext.getCurrFlowDoc().getToUser();
                if (user == null) break;
                users.addElement(user);
                break;
            }
            default: {
                String[] stringArray = string.split(",");
                users = new Users(null, stringArray.length, 1);
                for (int i = 0; i < stringArray.length; ++i) {
                    User user = User.findByName(stringArray[i]);
                    if (user == null) continue;
                    users.addElement(user);
                }
            }
        }
        return users;
    }

    private String getActionParameterWithContent(String string, ActionParametersAnalyser actionParametersAnalyser, Map map) throws WCMException {
        String string2 = actionParametersAnalyser.getParameterValue(string);
        string2 = this.parsePageVariables(string2, map);
        return string2;
    }

    private Map makeProperties(ExecuteContext executeContext, Document document, String string) throws WCMException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.putDefaultValues(executeContext, document, hashMap);
        String[] stringArray = new String[]{};
        if (!CMyString.isEmpty(string)) {
            stringArray = string.split(",");
        }
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = InfoViewDataHelper.getProperty(document, stringArray[i].trim());
            if (!CMyString.isEmpty(string2)) {
                hashMap.put(stringArray[i], string2);
                continue;
            }
            hashMap.put(stringArray[i], " ");
        }
        return hashMap;
    }

    private void putDefaultValues(ExecuteContext executeContext, Document document, Map map) {
        Users users;
        map.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label2", "\u6807\u9898"), document.getTitle());
        map.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label3", "\u5f53\u524d\u65f6\u95f4"), CMyDateTime.now().toString(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label4", "yyyy\u5e74MM\u6708dd\u65e5")));
        User user = executeContext.getPostUser();
        if (user != null) {
            map.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label5", "\u5904\u7406\u4eba"), user.getTrueName());
            map.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label6", "\u5904\u7406\u4eba\u90ae\u4ef6\u5730\u5740"), user.getEmail());
        }
        if ((users = executeContext.getFlowContext().getToUsers()) != null && !users.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = users.size();
            for (int i = 0; i < n; ++i) {
                User user2 = (User)users.getAt(i);
                if (user2 == null) continue;
                stringBuffer.append(user2.getEmail());
                stringBuffer.append(";");
                stringBuffer2.append(user2.getTrueName());
                stringBuffer2.append("\u3001");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer2.setLength(stringBuffer2.length() - 1);
            map.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label7", "\u63a5\u6536\u4eba"), stringBuffer2.toString());
            map.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label8", "\u63a5\u6536\u4eba\u90ae\u4ef6\u5730\u5740"), stringBuffer.toString());
        }
    }

    private String makeEmailContent(Document document, Map map, String string) throws WCMException {
        String string2 = this.getEmailTemplateContent(string);
        String string3 = this.parsePageVariables(string2, map);
        return string3;
    }

    private String getEmailTemplateContent(String string) throws WCMException {
        String string2 = ConfigServer.getServer().getInitProperty("WCM_PATH");
        String string3 = (string2 = CMyString.setStrEndWith(string2, File.separatorChar)) + string;
        if (!CMyFile.fileExists(string3)) {
            throw new WCMException(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label9", "\u90ae\u4ef6\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u8bbe\u7f6e\u7684\u65f6\u5019\u6b63\u786e\uff01[File=") + string3 + "][ConfigFile=" + string + "]");
        }
        try {
            return CMyFile.readFile(string3, "UTF-8");
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label10", "\u8bfb\u53d6\u90ae\u4ef6\u6a21\u677f\u5931\u8d25\uff01[File=") + string3 + "][ConfigFile=" + string + "]", exception);
        }
    }

    public String parsePageVariables(String string, Map map) throws WCMException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        try {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            stringBuffer = new StringBuffer();
            while (n2 < cArray.length) {
                char c;
                if ((c = cArray[n2++]) == '$' && n2 < n && cArray[n2] == '{') {
                    StringBuffer stringBuffer2 = new StringBuffer(16);
                    ++n2;
                    int n3 = 0;
                    boolean bl = false;
                    while (n3++ < 20 && n2 < n) {
                        if ((c = cArray[n2++]) == '}') {
                            bl = true;
                            break;
                        }
                        stringBuffer2.append(c);
                    }
                    if (bl) {
                        String string2 = stringBuffer2.toString().trim();
                        String string3 = "";
                        Object object = map.get(string2);
                        if (object == null && (object = InfoViewDataHelper.getProperty(this.m_oCurrDocument, string2)) == null) {
                            object = this.m_oCurrDocument.getProperty(string2);
                        }
                        if (object != null) {
                            string3 = object.toString();
                        }
                        if (string3 != null) {
                            stringBuffer.append(string3);
                            continue;
                        }
                        stringBuffer.append("${").append(stringBuffer2).append('}');
                        continue;
                    }
                    stringBuffer.append("${").append(stringBuffer2);
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label11", "\u89e3\u6790\u5185\u5bb9\u4e2d\u7684\u53d8\u91cf\u5931\u8d25!"), exception);
        }
    }
}

