/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.process;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.components.infoview.InfoViewDataHelper;
import com.trs.components.infoview.db.InfoviewXMLDataUpdator;
import com.trs.components.infoview.process.WorkDaysCounter;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoInsertRepeatTableForToUsers
implements IActionHandler {
    private static Logger logger = Logger.getLogger(AutoInsertRepeatTableForToUsers.class);

    public boolean execute(ExecuteContext executeContext, FlowAction flowAction) throws WCMException {
        Users users = executeContext.getCurrFlowDoc().getToUsers(null);
        if (users == null || users.size() == 0) {
            return false;
        }
        ActionParametersAnalyser actionParametersAnalyser = new ActionParametersAnalyser(flowAction.getParams());
        String string = actionParametersAnalyser.getParameterValue("VacationDays");
        List list = this.makeVacationDaysList(string);
        String string2 = actionParametersAnalyser.getParameterValue("WorkDays");
        int n = 10;
        if (!CMyString.isEmpty(string2)) {
            n = Integer.parseInt(string2);
        }
        String string3 = actionParametersAnalyser.getParameterValue("ReplyDep");
        String string4 = actionParametersAnalyser.getParameterValue("Deadline");
        String string5 = actionParametersAnalyser.getParameterValue("RepeatField");
        Document document = (Document)executeContext.getFlowContent().getSubinstance();
        String string6 = CMyDateTime.now().toString("yyyy-MM-dd");
        String string7 = this.makeDeadLine(list, string6, n);
        InfoviewXMLDataUpdator infoviewXMLDataUpdator = new InfoviewXMLDataUpdator(document.getContent());
        List list2 = infoviewXMLDataUpdator.getFieldValue(string3);
        this.synRepeatFieldForUsers(list2, infoviewXMLDataUpdator, users, string5, string3, string4, string7);
        String string8 = infoviewXMLDataUpdator.update(null);
        document.setContent(string8);
        document.save(null);
        return false;
    }

    private void synRepeatFieldForUsers(List list, InfoviewXMLDataUpdator infoviewXMLDataUpdator, Users users, String string, String string2, String string3, String string4) throws WCMException {
        String string5 = string.split("_")[1];
        boolean bl = false;
        if (list.size() == 1 && CMyString.isEmpty((String)list.get(0))) {
            bl = true;
        }
        int n = infoviewXMLDataUpdator.getRepeatFieldSize(string5);
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.getAt(i);
            if (user == null) continue;
            boolean bl2 = false;
            for (int j = 0; j < list.size(); ++j) {
                String string6 = (String)list.get(j);
                if (!string6.equals(user.getName())) continue;
                bl2 = true;
            }
            if (bl2) continue;
            if (n == 1 && i == 0 && bl) {
                infoviewXMLDataUpdator.setRepeatField(string2, user.getName(), i + 1);
                infoviewXMLDataUpdator.setRepeatField(string3, string4, i + 1);
                continue;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(string2, user.getName());
            hashMap.put(string3, string4);
            if (n > 0) {
                infoviewXMLDataUpdator.addRepeatFieldLine(string5, hashMap);
                continue;
            }
            infoviewXMLDataUpdator.addRepeatFieldGroup(string, hashMap);
        }
    }

    private void clearRepeatFieldInfo(List list, String string, InfoviewXMLDataUpdator infoviewXMLDataUpdator, Users users) {
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (CMyString.isEmpty(string2) && i > 0) {
                infoviewXMLDataUpdator.setRemoveField(string, i + 1);
                continue;
            }
            boolean bl = false;
            for (int j = 0; j < users.size(); ++j) {
                String string3;
                User user = (User)users.getAt(j);
                if (user == null || !string2.equals(string3 = user.getName())) continue;
                bl = true;
            }
            if (bl || CMyString.isEmpty(string2)) continue;
            infoviewXMLDataUpdator.setRemoveField(string, i + 1);
        }
    }

    private String makeDeadLine(List list, String string, int n) {
        Object object;
        Date date = new Date();
        try {
            object = new WorkDaysCounter();
            ((WorkDaysCounter)object).setVacationList(list);
            date = ((WorkDaysCounter)object).getWorkDayAsDate(string, n);
        }
        catch (ParseException parseException) {
            logger.error((Object)"\u8ba1\u7b97\u56de\u590d\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)parseException);
        }
        object = new CMyDateTime();
        ((CMyDateTime)object).setDateTime(date);
        return ((CMyDateTime)object).toString("yyyy-MM-dd");
    }

    private String getBasicDateFieldValue(Document document, String string) throws WCMException {
        String string2 = InfoViewDataHelper.getProperty(document, string);
        if (CMyString.isEmpty(string2)) {
            return CMyDateTime.now().toString("yyyy-MM-dd");
        }
        CMyDateTime cMyDateTime = new CMyDateTime();
        try {
            cMyDateTime.setDateTimeWithString(string2);
        }
        catch (CMyException cMyException) {
            throw new WCMException("\u5f53\u524d\u8868\u5355\u5b57\u6bb5\u3010" + string + "\u3011\u7684\u503c\u3010" + string2 + "\u3011\u4e3a\u975e\u6cd5\u7684\u65f6\u95f4\u683c\u5f0f", cMyException);
        }
        return string2;
    }

    private List makeVacationDaysList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (CMyString.isEmpty(string)) {
            return arrayList;
        }
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws WCMException {
        ContextHelper.initContext(User.findByName("admin"));
        AutoInsertRepeatTableForToUsers autoInsertRepeatTableForToUsers = new AutoInsertRepeatTableForToUsers();
        autoInsertRepeatTableForToUsers.execute(null, null);
    }
}

