/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.db.InfoViewDataType;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import org.apache.log4j.Logger;

public class InfoViewField
extends CMSObj {
    private static final Logger logger = Logger.getLogger(InfoViewField.class);
    public static final int OBJ_TYPE = 1105;
    public static final String DB_TABLE_NAME = "WCMINFOVIEWFIELD";
    public static final String DB_ID_NAME = "IVFIELDID";
    private InfoView m_oOwner;

    public static final InfoViewField findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (InfoViewField)BaseObj.findById(InfoViewField.class, n);
    }

    public static final InfoViewField createNewInstance() throws WCMException {
        return (InfoViewField)BaseObj.createNewInstance(InfoViewField.class);
    }

    public int getWCMType() {
        return 1105;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("INFOVIEWID") == null && this.m_oOwner != null && this.m_oOwner.getId() > 0) {
                this.setProperty("INFOVIEWID", this.m_oOwner.getId());
            }
            if (this.getProperty("INFOVIEWID") == null) {
                throw new WCMException(1106, I18NMessage.get(InfoViewField.class, "InfoViewField.label1", "\u5c5e\u6027INFOVIEWID\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FIELDNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(InfoViewField.class, "InfoViewField.label2", "\u5c5e\u6027FIELDNAME\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("DATATYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(InfoViewField.class, "InfoViewField.label3", "\u5c5e\u6027DATATYPE\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (!this.containsProperty("DataControl")) {
                switch (this.getDataType()) {
                    case 12: {
                        this.setDataControl("type:'string',max_len:" + this.getMaxLength());
                        break;
                    }
                    case 91: {
                        this.setDataControl("type:'date'");
                        break;
                    }
                    case 4: {
                        this.setDataControl("type:'int',value_range:'-2147483648,2147483647'");
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            switch (this.getNewPropertyAsInt("DATATYPE", 0)) {
                case 93: {
                    String string = this.getNewPropertyAsString("DATACONTROL");
                    if (string != null && string.indexOf("type:'date'") >= 0) {
                        string.replaceAll("type:'date'", "");
                    }
                    this.setDataControl(string);
                    break;
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[InfoViewField,");
        stringBuffer.append("Name:").append(this.getName()).append(',');
        stringBuffer.append("Desc:").append(this.getDesc()).append(',');
        stringBuffer.append("Type:").append(this.getDataType()).append(',');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    InfoView getOwner() {
        return this.m_oOwner;
    }

    void setOwner(InfoView infoView) {
        this.m_oOwner = infoView;
    }

    public String getName() {
        return (String)this.getProperty("FIELDNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("FIELDNAME", string);
    }

    public String getXPath() {
        return (String)this.getProperty("XSLTXPATH");
    }

    public boolean setXPath(String string) throws WCMException {
        return this.setProperty("XSLTXPATH", string);
    }

    public String getDesc() {
        return (String)this.getProperty("FIELDDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("FIELDDESC", string);
    }

    public int getInfoViewID() {
        return this.getPropertyAsInt("INFOVIEWID", 0);
    }

    public boolean setInfoViewID(int n) throws WCMException {
        return this.setProperty("INFOVIEWID", n);
    }

    public boolean isSpecialRight() {
        return this.getPropertyAsBoolean("SPECIALRIGHT", false);
    }

    public boolean setSpecialRight(boolean bl) throws WCMException {
        return this.setProperty("SPECIALRIGHT", bl);
    }

    public boolean isPublicFill() {
        return this.getPropertyAsBoolean("PUBLICFILL", false);
    }

    public boolean setPublicFill(boolean bl) throws WCMException {
        return this.setProperty("PUBLICFILL", bl);
    }

    public boolean isPublicView() {
        return this.getPropertyAsBoolean("PUBLICVIEW", false);
    }

    public boolean setPublicView(boolean bl) throws WCMException {
        return this.setProperty("PUBLICVIEW", bl);
    }

    public boolean isNillable() {
        return this.getPropertyAsBoolean("NILLABLE", false);
    }

    public boolean setNillable(boolean bl) throws WCMException {
        return this.setProperty("NILLABLE", bl);
    }

    public int getDataType() {
        return this.getPropertyAsInt("DATATYPE", 0);
    }

    public String getDataTypeAsString() {
        InfoViewDataType infoViewDataType = InfoViewConstants.DB_DATA_TYPES.getDataTypeById(this.getDataType());
        if (infoViewDataType == null) {
            logger.warn((Object)(I18NMessage.get(InfoViewField.class, "InfoViewField.label4", "\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff1f") + this.getDataType()));
            infoViewDataType = InfoViewConstants.DB_DATA_TYPES.getDataTypeById(12);
        }
        return infoViewDataType.getKey();
    }

    public boolean setDataType(int n) throws WCMException {
        return this.setProperty("DATATYPE", n);
    }

    public String getDataControl() {
        return (String)this.getProperty("DATACONTROL");
    }

    public boolean setDataControl(String string) throws WCMException {
        return this.setProperty("DATACONTROL", string);
    }

    public String getDataPattern() {
        return (String)this.getProperty("DATAPATTERN");
    }

    public boolean setDataPattern(String string) throws WCMException {
        return this.setProperty("DATAPATTERN", string);
    }

    public int getFixLength() {
        return this.getPropertyAsInt("FIXLENGTH", 0);
    }

    public boolean setFixLength(int n) throws WCMException {
        return this.setProperty("FIXLENGTH", n);
    }

    public int getMaxLength() {
        return this.getPropertyAsInt("MAXLENGTH", 0);
    }

    public boolean setMaxLength(int n) throws WCMException {
        return this.setProperty("MAXLENGTH", n);
    }

    public int getMinLength() {
        return this.getPropertyAsInt("MINLENGTH", 0);
    }

    public boolean setMinLength(int n) throws WCMException {
        return this.setProperty("MINLENGTH", n);
    }

    public String getFieldType() {
        return this.getPropertyAsString("FIELDTYPE");
    }

    public boolean setFieldType(String string) throws WCMException {
        return this.setProperty("FIELDTYPE", string);
    }

    public String getDefaultValue() {
        return (String)this.getProperty("DEFAULTVALUE");
    }

    public boolean setDefaultValue(String string) throws WCMException {
        return this.setProperty("DEFAULTVALUE", string);
    }

    public String getEnumValue() {
        return (String)this.getProperty("ENUMVALUE");
    }

    public boolean setEnumValue(String string) throws WCMException {
        return this.setProperty("ENUMVALUE", string);
    }

    public int getClassId() {
        return this.getPropertyAsInt("ClassId", 0);
    }

    public boolean setClassId(int n) throws WCMException {
        return this.setProperty("ClassId", n);
    }

    public boolean isOutlineField() {
        return this.getPropertyAsInt("InOutline", 0) != 0;
    }

    public boolean setOutlineField(boolean bl) throws WCMException {
        return this.setProperty("InOutline", bl ? 1L : 0L);
    }

    public boolean isSearchField() {
        return this.getPropertyAsInt("InSearch", 0) != 0;
    }

    public boolean setSearchField(boolean bl) throws WCMException {
        return this.setProperty("InSearch", bl ? 1L : 0L);
    }

    public String getGateWayBinding() {
        return (String)this.getProperty("GateWayBinding");
    }

    public boolean setGateWayBinding(String string) throws WCMException {
        return this.setProperty("GateWayBinding", string);
    }

    public boolean isReadOnly() {
        return this.getPropertyAsInt("ReadOnly", 0) != 0;
    }

    public boolean setReadOnly(boolean bl) throws WCMException {
        return this.setProperty("ReadOnly", bl ? 1L : 0L);
    }

    public boolean isBackReadOnly() {
        return this.getPropertyAsInt("BackReadOnly", 0) != 0;
    }

    public boolean setBackReadOnly(boolean bl) throws WCMException {
        return this.setProperty("BackReadOnly", bl ? 1L : 0L);
    }

    public boolean isBackShowAble() {
        return this.getPropertyAsInt("BackShowAble", 1) != 0;
    }

    public boolean setBackShowAble(boolean bl) throws WCMException {
        return this.setProperty("BackShowAble", bl ? 1L : 0L);
    }

    public String getTrueFieldName() throws WCMException {
        return this.getPropertyAsString("TrueFieldName");
    }

    public boolean setTrueFieldName(String string) throws WCMException {
        return this.setProperty("TrueFieldName", string);
    }
}

