/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.infoview.persistent.InfoViewGroup;
import com.trs.components.infoview.persistent.InfoViewGroups;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InfoView
extends CMSObj {
    public static final int OBJ_TYPE = 1104;
    public static final String DB_TABLE_NAME = "WCMINFOVIEW";
    public static final String DB_ID_NAME = "INFOVIEWID";
    private HashMap m_oMapFields;
    private ArrayList m_oFieldList;
    private List m_oGroupList = null;
    private HashMap m_oMapGroups = null;

    public static final InfoView findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (InfoView)BaseObj.findById(InfoView.class, n);
    }

    public static final InfoView createNewInstance() throws WCMException {
        return (InfoView)BaseObj.createNewInstance(InfoView.class);
    }

    public int getWCMType() {
        return 1104;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("INFOVIEWNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(InfoView.class, "InfoView.label1", "\u5c5e\u6027INFOVIEWNAME\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TITLEPATTERN") == null) {
                this.setTitlePattern(I18NMessage.get(InfoView.class, "InfoView.label2", "\u81ea\u5b9a\u4e49\u8868\u5355\u6570\u636e"));
            }
        }
        return true;
    }

    private List getFieldList() {
        if (this.m_oFieldList == null) {
            this.m_oMapFields = new HashMap();
            this.m_oFieldList = new ArrayList();
        }
        return this.m_oFieldList;
    }

    public void addField(InfoViewField infoViewField) {
        if (infoViewField == null) {
            return;
        }
        infoViewField.setOwner(this);
        this.getFieldList().add(infoViewField);
        this.m_oMapFields.put(infoViewField.getName(), infoViewField);
    }

    public InfoViewField getField(String string) throws WCMException {
        if (this.m_oMapFields == null) {
            this.allFields();
        }
        return (InfoViewField)this.m_oMapFields.get(string);
    }

    public List allFields() throws WCMException {
        this.m_oFieldList = null;
        this.loadFields();
        return this.getFieldList();
    }

    public List allGroups() throws WCMException {
        this.m_oGroupList = null;
        this.loadGroups();
        return this.getGroupList();
    }

    private List getGroupList() {
        if (this.m_oGroupList == null) {
            this.m_oMapGroups = new HashMap();
            this.m_oGroupList = new ArrayList();
        }
        return this.m_oGroupList;
    }

    public void addGroup(InfoViewGroup infoViewGroup) {
        if (infoViewGroup == null) {
            return;
        }
        this.getGroupList().add(infoViewGroup);
        this.m_oMapGroups.put(infoViewGroup.getName(), infoViewGroup);
    }

    private synchronized void loadGroups() throws WCMException {
        InfoViewGroups infoViewGroups = null;
        WCMFilter wCMFilter = new WCMFilter("", "INFOVIEWID=" + this.getId(), "");
        try {
            infoViewGroups = new InfoViewGroups(ContextHelper.getLoginUser());
            infoViewGroups.open(wCMFilter);
            for (int i = 0; i < infoViewGroups.size(); ++i) {
                this.addGroup((InfoViewGroup)infoViewGroups.getAt(i));
            }
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(InfoView.class, "InfoView.label3", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u8282\u96c6\u5408\u51fa\u9519"), wCMException);
        }
    }

    public void removeField(InfoViewField infoViewField) {
        if (infoViewField == null) {
            return;
        }
        if (this.m_oFieldList != null) {
            this.m_oFieldList.remove(infoViewField);
        }
        if (this.m_oMapFields != null) {
            this.m_oMapFields.remove(infoViewField.getName());
        }
    }

    private synchronized void loadFields() throws WCMException {
        InfoViewFields infoViewFields = null;
        WCMFilter wCMFilter = new WCMFilter("", "INFOVIEWID=" + this.getId(), "");
        try {
            infoViewFields = new InfoViewFields(ContextHelper.getLoginUser());
            infoViewFields.open(wCMFilter);
            for (int i = 0; i < infoViewFields.size(); ++i) {
                this.addField((InfoViewField)infoViewFields.getAt(i));
            }
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(InfoView.class, "InfoView.label4", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u9879\u96c6\u5408\u51fa\u9519"), wCMException);
        }
    }

    public int getSiteID() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public boolean setSiteID(int n) throws WCMException {
        return this.setProperty("SITEID", n);
    }

    public String getName() {
        return (String)this.getProperty("INFOVIEWNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("INFOVIEWNAME", string);
    }

    public String getDesc() {
        return (String)this.getProperty("INFOVIEWDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("INFOVIEWDESC", string);
    }

    public String getTitlePattern() {
        return (String)this.getProperty("TITLEPATTERN");
    }

    public boolean setTitlePattern(String string) throws WCMException {
        return this.setProperty("TITLEPATTERN", string);
    }

    public boolean isNeedVerifycode() {
        return this.getPropertyAsBoolean("NEEDVERIFYCODE", true);
    }

    public boolean setNeedVerifycode(boolean bl) throws WCMException {
        return this.setProperty("NEEDVERIFYCODE", bl);
    }

    public String getInfoViewPath() {
        return (String)this.getProperty("INFOVIEWPATH");
    }

    public boolean setInfoViewPath(String string) throws WCMException {
        return this.setProperty("INFOVIEWPATH", string);
    }

    public String getInfoPathFile() {
        return (String)this.getProperty("INFOPATHFILE");
    }

    public boolean setInfoPathFile(String string) throws WCMException {
        return this.setProperty("INFOPATHFILE", string);
    }

    public String getNewInfoPathFile() {
        return this.getNewPropertyAsString("INFOPATHFILE");
    }

    public String getAllFileList() {
        return (String)this.getProperty("ALLFILELIST");
    }

    public boolean setAllFileList(String string) throws WCMException {
        return this.setProperty("ALLFILELIST", string);
    }

    public String getXSLTFile() {
        return (String)this.getProperty("XSLTFILE");
    }

    public boolean setXSLTFilet(String string) throws WCMException {
        return this.setProperty("XSLTFILE", string);
    }

    public String getNewXSLTFile() {
        return (String)this.getProperty("NEWXSLTFILE");
    }

    public boolean setNewXSLTFilet(String string) throws WCMException {
        return this.setProperty("NEWXSLTFILE", string);
    }

    public String getSchemaFile() {
        return (String)this.getProperty("SCHEMAFILE");
    }

    public boolean setSchemaFile(String string) throws WCMException {
        return this.setProperty("SCHEMAFILE", string);
    }

    public String getTemplateFile() {
        return (String)this.getProperty("TEMPLATEFILE");
    }

    public boolean setTemplateFile(String string) throws WCMException {
        return this.setProperty("TEMPLATEFILE", string);
    }

    public String getTemplateFileContent() throws WCMException {
        InfoViewMgr infoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
        return infoViewMgr.getTemplateFileContent(this);
    }

    public boolean hasDocSerial() {
        return this.getPropertyAsBoolean("HASDOCSERIAL", false);
    }

    public boolean setDocSerial(boolean bl) throws WCMException {
        return this.setProperty("HASDOCSERIAL", bl);
    }

    public String getSerialPattern() {
        return (String)this.getProperty("SERIALPATTERN");
    }

    public boolean setSerialPattern(String string) throws WCMException {
        return this.setProperty("SERIALPATTERN", string);
    }

    public int getSerialPeriod() {
        return this.getPropertyAsInt("SERIALPERIOD", 0);
    }

    public boolean setSerialPeriod(int n) throws WCMException {
        return this.setProperty("SERIALPERIOD", n);
    }

    public String getSerialField() {
        return (String)this.getProperty("SERIALFIELD");
    }

    public boolean setSerialField(String string) throws WCMException {
        return this.setProperty("SERIALFIELD", string);
    }

    public boolean isReplyNoticeRequired() {
        return this.getPropertyAsBoolean("REPLYNOTICEREQUIRED", false);
    }

    public boolean setReplyNoticeRequired(boolean bl) throws WCMException {
        return this.setProperty("REPLYNOTICEREQUIRED", bl);
    }

    public String getNoticeRelatedField() {
        return this.getPropertyAsString("NOTICERELATEDFIELD");
    }

    public boolean setNoticeRelatedField(String string) throws WCMException {
        return this.setProperty("NOTICERELATEDFIELD", string);
    }

    public String getNoticeSubjectPattern() {
        return this.getPropertyAsString("NOTICESUBJECTPATTERN");
    }

    public boolean setNoticeSubjectPattern(String string) throws WCMException {
        return this.setProperty("NOTICESUBJECTPATTERN", string);
    }

    public String getNoticeContentPattern() {
        return this.getPropertyAsString("NOTICECONTENTPATTERN");
    }

    public boolean setNoticeContentPattern(String string) throws WCMException {
        return this.setProperty("NOTICECONTENTPATTERN", string);
    }

    public String getOutlineFields() {
        return this.getPropertyAsString("OutlineFields");
    }

    public boolean setOutlineFields(String string) throws WCMException {
        return this.setProperty("OutlineFields", string) && this.setOutlineDBFields(this.getDBFieldsByFields(string));
    }

    public String getSearchFields() {
        return this.getPropertyAsString("SearchFields");
    }

    public boolean setSearchFields(String string) throws WCMException {
        return this.setProperty("SearchFields", string) && this.setSearchDBFields(this.getDBFieldsByFields(string));
    }

    public String getDocContentPattern() {
        return this.getPropertyAsString("DocContentPattern");
    }

    public boolean setDocContentPattern(String string) throws WCMException {
        return this.setProperty("DocContentPattern", string);
    }

    private String getDBFieldsByFields(String string) {
        return InfoViewHelper.getDBFieldsByFields(this, string, true);
    }

    public String getOutlineDBFields() {
        String string = this.getPropertyAsString("OutlineDBFields");
        if (CMyString.isEmpty(string)) {
            String string2 = this.getOutlineFields();
            return this.getDBFieldsByFields(string2);
        }
        return string;
    }

    public boolean setOutlineDBFields(String string) throws WCMException {
        return this.setProperty("OutlineDBFields", string);
    }

    public String getOrderField() {
        return this.getPropertyAsString("OrderField");
    }

    public boolean setOrderField(String string) throws WCMException {
        return this.setProperty("OrderField", string);
    }

    public String getSearchDBFields() {
        String string = this.getPropertyAsString("SearchDBFields");
        if (CMyString.isEmpty(string)) {
            String string2 = this.getSearchFields();
            return this.getDBFieldsByFields(string2);
        }
        return string;
    }

    public boolean setSearchDBFields(String string) throws WCMException {
        return this.setProperty("SearchDBFields", string);
    }

    public String getTrueTableName() {
        return InfoViewConstants.makeTrueTableName(this.getId());
    }
}

