/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.helper;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import java.util.List;

public class InfoViewTemplateHelper {
    private static final String DEFAULT_INFOVIEW_TEMP_PREFIX = "detail";
    private static InfoViewEmployMgr m_oIVEmployMgr = null;

    private static InfoViewEmployMgr getInfoViewEmployMgr() {
        if (m_oIVEmployMgr == null) {
            m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
        }
        return m_oIVEmployMgr;
    }

    public static String generateContent(MethodContext methodContext, User user) throws WCMException {
        PublishPageContext publishPageContext = InfoViewTemplateHelper.buildPageContext(methodContext);
        if (publishPageContext == null) {
            return null;
        }
        Template template = InfoViewTemplateHelper.getTemplate(methodContext, publishPageContext, user);
        if (template == null) {
            return null;
        }
        String[] stringArray = PageGenerator.generateContent(publishPageContext, template);
        if (stringArray == null) {
            return null;
        }
        int n = methodContext.getValue("Page", 1);
        if (n >= stringArray.length || n < 1) {
            n = 1;
        }
        if (n >= 1) {
            return stringArray[n - 1];
        }
        return null;
    }

    private static PublishPageContext buildPageContext(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("DocumentId", 0);
        IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.lookupElement(605, n);
        PublishTaskContext publishTaskContext = new PublishTaskContext(null, iPublishContent.getFolder());
        PublishPageContext publishPageContext = new PublishPageContext(iPublishContent, publishTaskContext);
        return publishPageContext;
    }

    public static Template getDetailTemplate(PublishPageContext publishPageContext) throws WCMException {
        IPublishContent iPublishContent = (IPublishContent)publishPageContext.getPageElement();
        iPublishContent.setFolder(iPublishContent.getRealHome());
        Template template = iPublishContent.getDetailTemplate();
        if (template == null) {
            throw new WCMException("[" + iPublishContent.getSubstance() + I18NMessage.get(InfoViewTemplateHelper.class, "InfoViewTemplateHelper.label1", "]\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
        return template;
    }

    private static Template getTemplate(MethodContext methodContext, PublishPageContext publishPageContext, User user) throws WCMException {
        Object object;
        int n = methodContext.getValue("InfoViewId", 0);
        if (n <= 0) {
            int n2 = methodContext.getValue("ChannelId", 0);
            if (n2 <= 0) {
                throw new WCMException(10, I18NMessage.get(InfoViewTemplateHelper.class, "InfoViewTemplateHelper.label2", "\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u672a\u4f20\u5165InfoViewId/ChannelId\uff0c\u6216\u4f20\u5165\u7684\u503c\u65e0\u6548\uff01"));
            }
            List list = InfoViewTemplateHelper.getInfoViewEmployMgr().getEmployedInfoViews(101, n2);
            object = null;
            if (list != null && list.size() > 0) {
                object = (InfoView)list.get(0);
            }
            if (object == null) {
                throw new WCMException(10, I18NMessage.get(InfoViewTemplateHelper.class, "InfoViewTemplateHelper.label3", "\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u4f20\u5165\u7684ChannelId\u503c\u65e0\u6548\u6216\u8005\u680f\u76ee\u4e0d\u662f\u81ea\u5b9a\u4e49\u8868\u5355\u680f\u76ee\uff01"));
            }
            n = ((BaseObj)object).getId();
        }
        Template template = null;
        boolean bl = methodContext.getValue("UseDetailTemp", false);
        if (bl) {
            template = InfoViewTemplateHelper.getDetailTemplate(publishPageContext);
        } else {
            object = Templates.openWCMObjs(user, null);
            String string = CMyString.showNull(methodContext.getValue("TempNamePrefix"), DEFAULT_INFOVIEW_TEMP_PREFIX);
            String string2 = InfoViewTemplateHelper.getTempName(string, n);
            template = ((Templates)object).findByName(string2);
        }
        return template;
    }

    private static String getTempName(String string, int n) {
        return string + "_" + n;
    }

    public static String getContent(int n, String string, String string2) throws WCMException {
        PublishPageContext publishPageContext = InfoViewTemplateHelper.buildPageContext(n);
        String[] stringArray = null;
        try {
            TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument tagDocument = templateParseMgr.parse(publishPageContext.getTemplate());
            if (tagDocument == null) {
                return null;
            }
            PublishTagContext publishTagContext = new PublishTagContext(publishPageContext);
            stringArray = TagParseHelper.parseItems(tagDocument.getItems(), publishTagContext);
            if (stringArray == null || stringArray.length < 1) {
                return null;
            }
            return stringArray[0];
        }
        catch (Exception exception) {
            throw new WCMException(237, I18NMessage.get(InfoViewTemplateHelper.class, "InfoViewTemplateHelper.label4", "\u83b7\u5f97\u5e94\u7528\u6a21\u677f\u53d6\u5f97\u6587\u4ef6\u5185\u5bb9\u5931\u8d25:'") + string + ")'", exception);
        }
    }

    private static PublishPageContext buildPageContext(int n) throws WCMException {
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(101, n);
        PublishTaskContext publishTaskContext = new PublishTaskContext(null, iPublishElement.getFolder());
        PublishPageContext publishPageContext = new PublishPageContext(iPublishElement, publishTaskContext);
        return publishPageContext;
    }
}

