/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.components.infoview.InfoViewConfig;
import com.trs.components.infoview.extract.DataGroup;
import com.trs.components.infoview.extract.DataType;
import com.trs.components.infoview.extract.manifest.CalculatedField;
import com.trs.components.infoview.extract.manifest.Manifest;
import com.trs.components.infoview.extract.manifest.MenuButton;
import com.trs.components.infoview.extract.manifest.View;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class XSLTViewBuilder {
    public static final String FLAG_TRS_OBJ_TYPENAME = "trs_obj_typename";
    public static final String FLAG_TRS_OBJ_TYPE = "trs_obj_type";
    public static final String FLAG_TRS_OBJ_ID = "trs_obj_id";
    public static final String FLAG_TRS_OBJ_PUB = "trs_obj_publish";
    public static final String NAME_DATA_SECTION = "DataSection";
    public static final String NAME_DATA_FIELD = "DataField";
    public static final String TYPE_DATA_SECTION = String.valueOf(1107);
    public static final String TYPE_DATA_FIELD = String.valueOf(1105);
    private String m_sXSDURI;
    private String m_sXSDPrefix;
    private String m_sXSLURI;
    private String m_sXSLPrefix;
    private Manifest m_oManifest;
    private InfoViewConfig m_oIVConfig;
    private List m_oGroupList;
    private List m_oTypeList;
    private DataType m_oRootType;
    private Element m_oRootTemplate;
    private Element m_oFormTemplate;
    private HashMap m_oMapTemplates;

    public void init(InfoViewConfig infoViewConfig, Manifest manifest, List list, DataType dataType, List list2) {
        this.m_oIVConfig = infoViewConfig;
        this.m_oManifest = manifest;
        this.m_oGroupList = list;
        this.m_oRootType = dataType;
        this.m_oTypeList = list2;
    }

    public void build(View view) {
        Element element = view.getDOM4JDocument().getRootElement();
        if (element == null) {
            return;
        }
        this.prepare(element, view.getViewWidth());
        view.setXSLPrefix(this.m_sXSLPrefix);
        this.reformElementChildren(this.m_oRootTemplate, "");
        this.reformTopSection(element, view);
    }

    void addTemplateXML(String string) {
        Element element = this.m_oFormTemplate.addElement("textarea");
        element.addAttribute("name", "ObjectXML");
        element.addAttribute("style", "display:none");
        element.setText(string);
    }

    private void prepare(Element element, String string) {
        Element element2;
        Namespace namespace = null;
        this.m_sXSLURI = "http://www.w3.org/1999/XSL/Transform";
        this.m_sXSDURI = this.m_oManifest.getRootSchemaURI();
        namespace = element.getNamespaceForURI(this.m_sXSLURI);
        this.m_sXSLPrefix = namespace.getPrefix();
        namespace = element.getNamespaceForURI(this.m_sXSDURI);
        this.m_sXSDPrefix = namespace.getPrefix();
        this.m_oMapTemplates = new HashMap();
        this.addOutputIndent(element);
        Iterator iterator = element.elementIterator("template");
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            String string2 = element2.attributeValue("mode");
            if (string2 == null) {
                this.m_oRootTemplate = element2;
                continue;
            }
            Object v = this.m_oMapTemplates.get(string2);
            if (v == null) {
                this.m_oMapTemplates.put(string2, element2);
                continue;
            }
            if (v instanceof ArrayList) {
                ((ArrayList)v).add(element2);
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(v);
            arrayList.add(element2);
            this.m_oMapTemplates.put(string2, arrayList);
        }
        element2 = (Element)this.m_oRootTemplate.selectSingleNode(".//head");
        this.addScript(element2);
        this.addStyle(element2);
    }

    private void addOutputIndent(Element element) {
        Element element2 = element.element("output");
        if (element2 != null) {
            element2.addAttribute("indent", "yes");
        }
    }

    private void addScript(Element element) {
        String[] stringArray = CMyString.split(this.m_oIVConfig.getScriptURI(), ",");
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = element.addElement("script");
            element2.addAttribute("language", "JavaScript");
            element2.addAttribute("src", stringArray[i]);
        }
    }

    private void addStyle(Element element) {
        String[] stringArray = CMyString.split(this.m_oIVConfig.getStyleURI(), ",");
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = element.addElement("link");
            element2.addAttribute("rel", "stylesheet");
            element2.addAttribute("type", "text/css");
            element2.addAttribute("href", stringArray[i]);
        }
    }

    private void reformTopSection(Element element, View view) {
        for (Element element2 : this.m_oRootTemplate.selectNodes("//div")) {
            String string = this.findChildSection(element2, view);
            if (string != null) continue;
            string = this.findChildTable(element2, view);
        }
    }

    private Element getTemplate(String string, String string2) {
        Object v = this.m_oMapTemplates.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof ArrayList) {
            if (string2 == null) {
                return null;
            }
            ArrayList arrayList = (ArrayList)v;
            try {
                for (Element element : arrayList) {
                    String string3 = element.attributeValue("match");
                    if (!string2.equals(string3) && !string2.endsWith("/" + string3)) continue;
                    return element;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        if (v instanceof Element) {
            return (Element)v;
        }
        return null;
    }

    private String findChildSection(Element element, View view) {
        Element element2 = element.element("apply-templates");
        if (element2 == null) {
            return null;
        }
        String string = element2.attributeValue("mode");
        if (string == null) {
            return null;
        }
        Element element3 = this.getTemplate(string, element2.attributeValue("select"));
        if (element3 == null) {
            return null;
        }
        Element element4 = element3.element("div");
        if (element4 == null) {
            return null;
        }
        String string2 = element4.attributeValue("xctname");
        if (string2 == null) {
            return null;
        }
        if ("RepeatingSection".equalsIgnoreCase(string2) || "Section".equalsIgnoreCase(string2)) {
            element4.addAttribute(FLAG_TRS_OBJ_TYPENAME, NAME_DATA_SECTION);
            element4.addAttribute(FLAG_TRS_OBJ_TYPE, TYPE_DATA_SECTION);
            String string3 = element4.attributeValue("trs_temp_id");
            if (string3 != null) {
                this.m_oGroupList.add(new DataGroup(string3, element4, view));
            }
            return string3;
        }
        return null;
    }

    private String findChildTable(Element element, View view) {
        Element element2 = element.element("table");
        if (element2 == null) {
            return null;
        }
        Iterator iterator = element2.elementIterator("tbody");
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            String string = element3.attributeValue("xctname");
            if (!"RepeatingTable".equalsIgnoreCase(string)) continue;
            element3.addAttribute(FLAG_TRS_OBJ_TYPENAME, NAME_DATA_SECTION);
            element3.addAttribute(FLAG_TRS_OBJ_TYPE, TYPE_DATA_SECTION);
            String string2 = element3.attributeValue("trs_temp_id");
            if (string2 != null) {
                this.m_oGroupList.add(new DataGroup(string2, element3, view));
            }
            return string2;
        }
        return null;
    }

    private void reformElementChildren(Element element, String string) {
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            this.reformElementSelf((Element)iterator.next(), string);
        }
    }

    private void reformElementSelf(Element element, String string) {
        String string2 = string;
        if (this.m_sXSLPrefix.equals(element.getNamespacePrefix())) {
            string2 = this.reformXSLElement(element, string);
            if (string2 == null) {
                return;
            }
        } else {
            this.reformHTMLElement(element, string);
        }
        this.reformElementChildren(element, string2);
    }

    private String reformXSLElement(Element element, String string) {
        String string2 = element.attributeValue("select");
        if (string2 == null) {
            return string;
        }
        String string3 = this.appendXPath(string, string2);
        if ("apply-templates".equals(element.getName())) {
            this.reformXSLTemplate(element, string3);
            return null;
        }
        return string3;
    }

    private void reformXSLTemplate(Element element, String string) {
        Element element2;
        String string2 = element.attributeValue("mode");
        if (string2 != null && (element2 = this.getTemplate(string2, element.attributeValue("select"))) != null) {
            this.reformElementChildren(element2, string);
        }
    }

    private void reformBinding(Element element, String string, String string2) {
        ArrayList arrayList;
        DataType dataType;
        if ("PlainList".equalsIgnoreCase(string) || "BulletedList".equalsIgnoreCase(string) || "NumberedList".equalsIgnoreCase(string) || "ExpressionBox".equalsIgnoreCase(string)) {
            return;
        }
        String string3 = element.attributeValue("binding");
        if (string3 == null && "RepeatingTable".equalsIgnoreCase(string)) {
            string3 = this.findRepeatingTableBinding(element);
        }
        boolean bl = false;
        if (string3 != null) {
            string3 = this.appendXPath(string2, string3);
        } else {
            bl = true;
            string3 = string2;
        }
        if (string3 == null || string3.length() <= 0) {
            return;
        }
        element.addAttribute("trs_temp_id", string3);
        if (bl) {
            return;
        }
        element.addAttribute("id", string3);
        element.addAttribute("name", string3);
        CalculatedField calculatedField = this.m_oManifest.getCalculatedField(string3);
        if (calculatedField != null) {
            element.addAttribute("trs_calc_expression", CMyString.filterForXsltValue(calculatedField.getExpression()));
            element.addAttribute("trs_calc_refresh", calculatedField.getRefresh());
        }
        if ((dataType = this.m_oRootType.findDataType(string3, this.m_sXSDPrefix)) != null) {
            dataType.setDisplayName(element.attributeValue("title"));
            dataType.setBindElement(element);
            dataType.setDisplayFieldType(string);
            element.addAttribute(FLAG_TRS_OBJ_TYPENAME, NAME_DATA_FIELD);
            element.addAttribute(FLAG_TRS_OBJ_TYPE, TYPE_DATA_FIELD);
            if (!dataType.isNillable()) {
                element.addAttribute("not_null", "1");
                element.addAttribute("validation", "required:true");
            }
            element.addAttribute("elname", dataType.getDisplayName());
            element.addAttribute("pattern", dataType.getTRSTypeName());
            element.addAttribute("trs_field_name", dataType.getNewBindName());
            if (!this.containsWith(this.m_oTypeList, dataType)) {
                this.m_oTypeList.add(dataType);
            }
        }
        if ((arrayList = this.m_oManifest.getDefaultView().getContextMenuForBinding(string3)) != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                MenuButton menuButton = (MenuButton)arrayList.get(i);
                element.addAttribute(menuButton.getBindAction(), menuButton.getCaption());
            }
        }
    }

    private boolean containsWith(List list, DataType dataType) {
        for (int i = 0; i < list.size(); ++i) {
            DataType dataType2 = (DataType)list.get(i);
            if (dataType2 == null || dataType2.getBindName() == null || !dataType2.getBindName().equals(dataType.getBindName())) continue;
            return true;
        }
        return false;
    }

    private void reformHTMLElement(Element element, String string) {
        String string2;
        if ("div".equals(element.getName()) && element.attributeValue("xmlToEdit") != null) {
            element.addAttribute("style", "display:none");
            return;
        }
        if ("img".equals(element.getName())) {
            this.reformHTMLImage(element);
        }
        if ((string2 = element.attributeValue("xctname")) == null) {
            return;
        }
        if ("InlineImage".equals(string2)) {
            this.reformHTMLInlineImage(element);
        }
        if ("ExpressionBox".equals(string2)) {
            this.reformHTMLExpressionBox(element);
        }
        this.reformBinding(element, string2, string);
    }

    private void reformHTMLInlineImage(Element element) {
        Attribute attribute;
        Element element2;
        Attribute attribute2 = element.attribute("src");
        if (attribute2 != null) {
            element.remove(attribute2);
        }
        if ((element2 = element.getParent()) != null && (attribute = element2.attribute("test")) != null) {
            attribute.setValue("1=1");
        }
    }

    private void reformHTMLImage(Element element) {
        Attribute attribute = element.attribute("src");
        if (attribute == null) {
            return;
        }
        if ("res://infopath.exe/calendar.gif".equals(attribute.getValue())) {
            attribute.setValue("TRSCalendar.gif");
        }
    }

    private void reformHTMLExpressionBox(Element element) {
        Element element2 = element.element("if");
        if (element2 == null) {
            return;
        }
        Element element3 = element2.element("value-of");
        if (element3 == null) {
            return;
        }
        Attribute attribute = element3.attribute("select");
        if (attribute == null) {
            return;
        }
        element.addAttribute("trs_calc_expression", CMyString.filterForXsltValue(attribute.getValue()));
        element.addAttribute("trs_calc_refresh", "onChange");
    }

    private String appendXPath(String string, String string2) {
        if (string.length() <= 0) {
            return string2;
        }
        if (string2.charAt(0) == '/') {
            return string2;
        }
        if (string2.equals(".")) {
            return string;
        }
        while (string2.charAt(0) == '.') {
            if (string2.startsWith("./")) {
                string2 = string2.substring(2);
                continue;
            }
            if (!string2.startsWith("../")) continue;
            if (string.length() <= 0) {
                return string2;
            }
            int n = string.lastIndexOf(47);
            if (n < 0) {
                n = 0;
            }
            string = string.substring(0, n);
            string2 = string2.substring(3);
        }
        if (string.length() <= 0) {
            return string2;
        }
        return string + '/' + string2;
    }

    private String findRepeatingTableBinding(Element element) {
        Element element2 = element.element("for-each");
        if (element2 == null) {
            return null;
        }
        Attribute attribute = element2.attribute("select");
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }
}

