/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.components.infoview.extract.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class DataTypeBuilder {
    private static final HashMap s_InnerTypes = new HashMap();
    private String m_sTargetURI;
    private String m_sTargetPrefix;
    private String m_sSchemaURI;
    private String m_sSchemaPrefix;
    private HashMap m_oTopElements;
    private HashMap m_oMapDataTyee;

    private void prepare(Element element) {
        Namespace namespace = null;
        this.m_sSchemaURI = "http://www.w3.org/2001/XMLSchema";
        this.m_sTargetURI = element.attributeValue("targetNamespace");
        namespace = element.getNamespaceForURI(this.m_sTargetURI);
        this.m_sTargetPrefix = namespace.getPrefix();
        namespace = element.getNamespaceForURI(this.m_sSchemaURI);
        this.m_sSchemaPrefix = namespace.getPrefix();
        this.m_oTopElements = new HashMap();
        this.m_oMapDataTyee = new HashMap();
    }

    private void normalize() {
        Iterator iterator = this.m_oTopElements.values().iterator();
        while (iterator.hasNext()) {
            this.normalizeDataType((DataType)iterator.next());
        }
    }

    private void normalizeDataType(DataType dataType) {
        Cloneable cloneable;
        if (dataType.isInnerType()) {
            return;
        }
        if (dataType.getRefName() != null && dataType.getRefType() == null) {
            DataType dataType2 = this.getDefType(dataType.getRefName());
            dataType.setRefType(dataType2);
            this.normalizeDataType(dataType2);
            return;
        }
        if (dataType.getDataName() != null && dataType.getDataType() == null) {
            DataType dataType3 = this.getDataType(dataType.getDataName());
            dataType.setDataType(dataType3);
            this.normalizeDataType(dataType3);
            return;
        }
        if (dataType.getBaseName() != null && dataType.getBaseType() == null) {
            cloneable = this.getDataType(dataType.getBaseName());
            dataType.setBaseType((DataType)cloneable);
            this.normalizeDataType((DataType)cloneable);
        }
        if (dataType.isComplexType() && (cloneable = dataType.getChildren()) != null) {
            Iterator iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                this.normalizeDataType((DataType)iterator.next());
            }
        }
    }

    private DataType getDefType(String string) {
        String string2 = string.substring(this.m_sTargetPrefix.length() + 1);
        return (DataType)this.m_oTopElements.get(string2);
    }

    private DataType getDataType(String string) {
        String string2 = string.substring(this.m_sTargetPrefix.length() + 1);
        return (DataType)this.m_oMapDataTyee.get(string2);
    }

    public void build(Document document) {
        Element element = document.getRootElement();
        if (element != null) {
            this.prepare(element);
            Iterator iterator = null;
            iterator = element.elementIterator("element");
            while (iterator.hasNext()) {
                this.iterateDataTypeElement((Element)iterator.next(), null);
            }
            iterator = element.elementIterator("simpleType");
            while (iterator.hasNext()) {
                this.iterateTopSimpleType((Element)iterator.next());
            }
            iterator = element.elementIterator("complexType");
            while (iterator.hasNext()) {
                this.iterateTopComplexType((Element)iterator.next());
            }
            this.normalize();
        }
    }

    public DataType getSchema(String string) {
        return (DataType)this.m_oTopElements.get(string);
    }

    private void iterateDataTypeElement(Element element, DataType dataType) {
        Object object;
        DataType dataType2 = null;
        String string = element.attributeValue("name");
        String string2 = element.attributeValue("type");
        String string3 = element.attributeValue("ref");
        if (string2 != null) {
            dataType2 = this.buildInnerType(string2);
            if (dataType2 == null) {
                dataType2 = DataType.getSimpleType();
                dataType2.setDataName(string2);
            }
            if ((object = element.attributeValue("nillable")) != null) {
                dataType2.setNillable((String)object);
            }
        } else if (string3 != null) {
            dataType2 = DataType.getSimpleType();
            dataType2.setRefName(string3);
        }
        if (dataType2 == null) {
            Element element2;
            object = element.element("simpleType");
            if (object != null) {
                dataType2 = this.buildSimpleType((Element)object);
            }
            if ((element2 = element.element("complexType")) != null) {
                dataType2 = this.buildComplexType(element2);
            }
        }
        if (dataType2 != null) {
            if (dataType != null) {
                dataType.addChild(dataType2);
            } else {
                this.m_oTopElements.put(string, dataType2);
            }
            dataType2.setName(string);
        }
    }

    private void iterateTopComplexType(Element element) {
        String string = element.attributeValue("name");
        if (string == null) {
            return;
        }
        DataType dataType = this.buildComplexType(element);
        if (dataType != null) {
            dataType.setTypeName(string);
            this.m_oMapDataTyee.put(string, dataType);
        }
    }

    private void iterateTopSimpleType(Element element) {
        String string = element.attributeValue("name");
        if (string == null) {
            return;
        }
        DataType dataType = this.buildSimpleType(element);
        if (dataType != null) {
            dataType.setTypeName(string);
            this.m_oMapDataTyee.put(string, dataType);
        }
    }

    private DataType buildSimpleType(Element element) {
        String string;
        Element element2 = element.element("restriction");
        if (element2 != null && (string = element2.attributeValue("base")) != null) {
            DataType dataType = this.buildInnerType(string);
            if (dataType != null) {
                this.buildSimpleType(dataType, element2);
            } else {
                dataType = DataType.getSimpleType();
                dataType.setBaseName(string);
            }
            return dataType;
        }
        return null;
    }

    private void buildSimpleType(DataType dataType, Element element) {
        Element element2 = null;
        element2 = element.element("minLength");
        if (element2 != null) {
            dataType.setMinLength(Integer.parseInt(element2.attributeValue("value")));
        }
        if ((element2 = element.element("maxLength")) != null) {
            dataType.setMaxLength(Integer.parseInt(element2.attributeValue("value")));
        }
    }

    private DataType buildComplexType(Element element) {
        Object object;
        Element element2;
        Iterator iterator;
        Iterator iterator2;
        DataType dataType = DataType.getComplexType();
        Element element3 = element.element("sequence");
        if (element3 != null) {
            iterator2 = element3.elementIterator("element");
            while (iterator2.hasNext()) {
                this.iterateDataTypeElement((Element)iterator2.next(), dataType);
            }
        }
        if ((iterator2 = element.element("all")) != null) {
            iterator = iterator2.elementIterator("element");
            while (iterator.hasNext()) {
                this.iterateDataTypeElement((Element)iterator.next(), dataType);
            }
        }
        if ((iterator = element.element("complexContent")) != null) {
            element2 = iterator.element("extension");
            if (element2 != null) {
                dataType.setBaseName(element2.attributeValue("base"));
                element3 = element2.element("sequence");
                if (element3 != null) {
                    object = element3.elementIterator("element");
                    while (object.hasNext()) {
                        this.iterateDataTypeElement((Element)object.next(), dataType);
                    }
                }
            }
            if ((object = iterator.element("restriction")) != null) {
                dataType.setBaseName(object.attributeValue("base"));
            }
        }
        if ((element2 = element.element("simpleContent")) != null) {
            Element element4;
            object = element2.element("extension");
            if (object != null) {
                dataType.setBaseName(object.attributeValue("base"));
                this.buildSimpleType(dataType, (Element)object);
            }
            if ((element4 = element2.element("restriction")) != null) {
                dataType.setBaseName(element4.attributeValue("base"));
                this.buildSimpleType(dataType, element4);
            }
        }
        return dataType;
    }

    private DataType buildInnerType(String string) {
        DataType dataType = null;
        String string2 = (String)s_InnerTypes.get(string);
        if (string2 != null) {
            dataType = DataType.getInnerType();
        }
        if (string.startsWith(this.m_sSchemaPrefix)) {
            string2 = string.substring(this.m_sSchemaPrefix.length() + 1);
            dataType = DataType.getInnerType();
        }
        if (dataType != null) {
            dataType.setBaseName(string2);
        }
        return dataType;
    }

    static {
        s_InnerTypes.put("any", "any");
        s_InnerTypes.put("anyURI", "anyURI");
        s_InnerTypes.put("base64Binary", "base64Binary");
        s_InnerTypes.put("boolean", "boolean");
        s_InnerTypes.put("date", "date");
        s_InnerTypes.put("integer", "integer");
        s_InnerTypes.put("string", "string");
    }
}

