/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

class PatternAnalyzer {
    private String m_sPattern;
    private Document m_oDocument;
    private User m_oUser;
    private String m_sInfogateUserName;

    public final Document getDocument() {
        return this.m_oDocument;
    }

    public final void setDocument(Document document) {
        this.m_oDocument = document;
    }

    public final User getCurrentUser() {
        return this.m_oUser;
    }

    public final void setCurrentUser(User user) {
        this.m_oUser = user;
    }

    public final void setInfogateUserName(String string) {
        this.m_sInfogateUserName = string;
    }

    public final String getInfogateUserName() {
        return this.m_sInfogateUserName;
    }

    public final String getPattern() {
        return this.m_sPattern;
    }

    public final void setPattern(String string) {
        this.m_sPattern = string;
    }

    public PatternAnalyzer(String string) {
        this.m_sPattern = string;
    }

    public String getAnalyzedResult() {
        if (CMyString.isEmpty(this.m_sPattern)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        PatternPart[] patternPartArray = this.analyzePattern();
        PatternPart patternPart = null;
        Node node = null;
        for (int i = 0; i < patternPartArray.length; ++i) {
            Element element;
            String string;
            patternPart = patternPartArray[i];
            if (patternPart.isconstant) {
                stringBuffer.append(patternPart.name);
                continue;
            }
            if (patternPart.name.indexOf("::") == 0) {
                stringBuffer.append(this.getSysVariableValue(patternPart.name));
                continue;
            }
            node = this.m_oDocument.selectSingleNode("//" + patternPart.name);
            if (node == null) continue;
            String string2 = node.getStringValue();
            if (node instanceof Element && !CMyString.isEmpty(string = (element = (Element)node).attributeValue("FileName"))) {
                string2 = string;
            }
            if (CMyString.isEmpty(string2)) {
                stringBuffer.append(' ').append(patternPart.name);
                stringBuffer.append(" not set ");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private PatternPart[] analyzePattern() {
        ArrayList<PatternPart> arrayList = new ArrayList<PatternPart>();
        char[] cArray = this.m_sPattern.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(16);
        char c = '\u0000';
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            PatternPart patternPart;
            c = cArray[i];
            if (c == '$' && i + 1 < cArray.length && cArray[i + 1] == '{') {
                if (n == 0 && stringBuffer.length() > 0) {
                    patternPart = new PatternPart(stringBuffer.toString(), true);
                    arrayList.add(patternPart);
                    stringBuffer.setLength(0);
                }
                ++i;
                ++n;
                continue;
            }
            if (c == '}' && n > 0) {
                --n;
                patternPart = new PatternPart(stringBuffer.toString(), false);
                arrayList.add(patternPart);
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(new PatternPart(stringBuffer.toString(), true));
        }
        PatternPart[] patternPartArray = new PatternPart[arrayList.size()];
        return arrayList.toArray(patternPartArray);
    }

    private String getSysVariableValue(String string) {
        String string2 = string.substring(2, string.length());
        String string3 = "";
        if ("user".equalsIgnoreCase(string2)) {
            string3 = this.getInfogateUserName();
            if (CMyString.isEmpty(string3) && CMyString.isEmpty(string3 = this.getCurrentUser().getTrueName())) {
                string3 = this.getCurrentUser().getName();
            }
        } else {
            String string4 = "yyyyMMdd";
            if (string2.indexOf(",") != -1) {
                string4 = string2.substring(string2.indexOf(",") + 1, string2.length());
            }
            if (CMyString.isEmpty(string3 = CMyDateTime.now().toString(string4))) {
                string3 = CMyDateTime.now().toString("yyyyMMdd");
            }
        }
        return string3;
    }

    public static void main(String[] stringArray) {
    }

    private class PatternPart {
        public String name;
        public boolean isconstant;

        public PatternPart(String string, boolean bl) {
            this.name = string;
            this.isconstant = bl;
        }
    }
}

