/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.RightSet;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeField;
import com.trs.cms.process.definition.FlowNodeFields;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.IInitValueCreator;
import com.trs.components.infoview.CABFileExtractor;
import com.trs.components.infoview.InfoViewConfig;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.PatternAnalyzer;
import com.trs.components.infoview.RightHostInfoViewField;
import com.trs.components.infoview.RightHostInfoViewGroup;
import com.trs.components.infoview.RightHostInfoViewView;
import com.trs.components.infoview.config.GatewayConfig;
import com.trs.components.infoview.db.IInfoViewDBMgr;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.components.infoview.extract.DataGroup;
import com.trs.components.infoview.extract.DataType;
import com.trs.components.infoview.extract.InfoPathFileData;
import com.trs.components.infoview.extract.XSLTViewBuilder;
import com.trs.components.infoview.extract.XSLTViewConstrainter;
import com.trs.components.infoview.extract.manifest.View;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.infoview.persistent.InfoViewGroup;
import com.trs.components.infoview.persistent.InfoViewGroups;
import com.trs.components.infoview.persistent.InfoViewSerialGenerator;
import com.trs.components.infoview.persistent.InfoViewView;
import com.trs.components.infoview.persistent.InfoViewViews;
import com.trs.components.infoview.persistent.InfoViews;
import com.trs.components.infoview.publish.tagparser.FormProperty;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.FieldInfo;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;

public class InfoViewMgr {
    private static final Logger s_logger = Logger.getLogger(InfoViewMgr.class);
    public static final String PUBLISH_SCRIPT_PATH = "infoview/";
    public static final String NS_XSL_URI = "http://www.w3.org/1999/XSL/Transform";
    public static final float INCREASE_FIELD_LENGTH_FACTOR = 1.5f;
    private InfoViewEmployMgr m_oIVEmployMgr = null;
    private IInfoViewDBMgr m_oIVDBMgr = null;
    private InfoViewConfig m_oInfoViewCfg = this.loadInfoViewConfig();
    private CABFileExtractor m_CABExtractor = (CABFileExtractor)DreamFactory.createObjectById("CABFileExtractor");
    private FilesMan m_oFilesManMgr;
    private Random m_oRandomMaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFileContent(String string) throws IOException {
        String string2;
        block6: {
            FileInputStream fileInputStream = null;
            try {
                int n;
                char[] cArray = new char[2048];
                fileInputStream = new FileInputStream(string);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer(4096);
                while ((n = bufferedReader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
                bufferedReader.close();
                fileInputStream = null;
                string2 = stringBuffer.toString();
                Object var9_8 = null;
                if (fileInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var9_9 = null;
                    if (fileInputStream == null) break block7;
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public InfoViewMgr() {
        if (this.m_CABExtractor != null) {
            this.m_CABExtractor.init(this.m_oInfoViewCfg);
        }
        this.m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
        this.m_oIVDBMgr = (IInfoViewDBMgr)DreamFactory.createObjectById("IInfoViewDBMgr");
        this.m_oFilesManMgr = FilesMan.getFilesMan();
        this.m_oRandomMaker = new Random(System.currentTimeMillis());
    }

    public InfoViewConfig getInfoViewConfig() {
        if (this.m_oInfoViewCfg == null) {
            this.m_oInfoViewCfg = this.loadInfoViewConfig();
        }
        return this.m_oInfoViewCfg;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private InfoViewConfig loadInfoViewConfig() {
        List list = XMLConfigServer.getInstance().getConfigObjects("InfoViewConfig");
        if (list == null || list.size() == 0) {
            s_logger.error((Object)I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label1", "\u6ca1\u6709\u627e\u5230InfoView\u7684\u914d\u7f6e\u6587\u4ef6"));
            return null;
        }
        return (InfoViewConfig)list.get(0);
    }

    public void delete(InfoView infoView) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label2", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        String string = infoView.getInfoPathFile();
        String string2 = infoView.getInfoViewPath();
        this.m_oIVEmployMgr.clearByInfoView(infoView);
        this.clearFields(infoView);
        this.clearGroups(infoView);
        this.clearViews(infoView);
        infoView.delete(this.getLoginUser());
        String string3 = this.m_oFilesManMgr.mapFilePath(string, 0);
        CMyFile.deleteFile(string3 + File.separatorChar + string);
        CMyFile.deleteDir(string3 + File.separatorChar + string2);
    }

    private int clearFields(InfoView infoView) throws WCMException {
        if (infoView == null) {
            return 0;
        }
        List list = infoView.allFields();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (InfoViewField infoViewField : list) {
            if (infoViewField == null) continue;
            this.delete(infoViewField);
            ++n;
        }
        return n;
    }

    private int clearGroups(InfoView infoView) throws WCMException {
        if (infoView == null) {
            return 0;
        }
        InfoViewGroups infoViewGroups = InfoViewGroups.findBy(infoView);
        if (infoViewGroups == null) {
            return 0;
        }
        int n = infoViewGroups.size();
        infoViewGroups.removeAll(true);
        return n;
    }

    private int clearViews(InfoView infoView) throws WCMException {
        if (infoView == null) {
            return 0;
        }
        InfoViewViews infoViewViews = InfoViewViews.findBy(infoView);
        if (infoViewViews == null) {
            return 0;
        }
        int n = infoViewViews.size();
        infoViewViews.removeAll(true);
        return n;
    }

    public void delete(InfoViewView infoViewView) throws WCMException {
        if (infoViewView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label3", "\u65e0\u6548\u7684\u8868\u5355\u89c6\u56fe[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        if (infoViewView.isSpecialRight()) {
            RightHostInfoViewView rightHostInfoViewView = new RightHostInfoViewView(infoViewView);
            RightSet rightSet = new RightSet();
            rightSet.setRights(ContextHelper.getLoginUser(), rightHostInfoViewView, null, false);
        }
        infoViewView.delete();
    }

    public void delete(InfoViewGroup infoViewGroup) throws WCMException {
        if (infoViewGroup == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label4", "\u65e0\u6548\u7684\u8868\u5355\u6570\u636e\u8282[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        if (infoViewGroup.isSpecialRight()) {
            RightHostInfoViewGroup rightHostInfoViewGroup = new RightHostInfoViewGroup(infoViewGroup);
            RightSet rightSet = new RightSet();
            rightSet.setRights(ContextHelper.getLoginUser(), rightHostInfoViewGroup, null, false);
        }
        infoViewGroup.delete();
    }

    public void delete(InfoViewField infoViewField) throws WCMException {
        if (infoViewField == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label5", "\u65e0\u6548\u7684\u8868\u5355\u6570\u636e\u9879[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        if (infoViewField.isSpecialRight()) {
            RightHostInfoViewField rightHostInfoViewField = new RightHostInfoViewField(infoViewField);
            RightSet rightSet = new RightSet();
            rightSet.setRights(ContextHelper.getLoginUser(), rightHostInfoViewField, null, false);
        }
        infoViewField.delete(ContextHelper.getLoginUser());
    }

    public InfoViews getInfoViews(WCMFilter wCMFilter) throws WCMException {
        InfoViews infoViews = new InfoViews(ContextHelper.getLoginUser());
        infoViews.open(wCMFilter);
        return infoViews;
    }

    public InfoViewViews filterByFlow(InfoViewViews infoViewViews, int n) throws Throwable {
        FlowNode flowNode = this.getCurrFlowNode(n);
        if (flowNode.isStartNode()) {
            return infoViewViews;
        }
        HashMap hashMap = new HashMap();
        this.renderViewsInFlow(n, hashMap);
        for (int i = infoViewViews.size() - 1; i >= 0; --i) {
            InfoViewView infoViewView = (InfoViewView)infoViewViews.getAt(i);
            String string = "InfoViewView_" + infoViewView.getId();
            if (hashMap.get(string) == null) continue;
            infoViewViews.removeAt(i, false);
        }
        return infoViewViews;
    }

    public String getAbsolutePath(InfoView infoView, String string) throws WCMException {
        String string2 = infoView.getInfoViewPath();
        String string3 = this.m_oFilesManMgr.mapFilePath(string2, 0);
        return string3 + File.separatorChar + string2 + File.separatorChar + string;
    }

    /*
     * Loose catch block
     */
    public String forFillOut(InfoView infoView, InfoViewView infoViewView) throws WCMException {
        String string;
        block17: {
            Exception exception2222;
            Reader reader;
            Reader reader2;
            block16: {
                if (infoView == null) {
                    throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
                }
                if (infoViewView == null) {
                    throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label7", "\u65e0\u6548\u7684\u89c6\u56fe\u5bf9\u8c61[null],\u65e0\u6cd5\u9884\u89c8!"));
                }
                if (infoViewView.getInfoViewID() != infoView.getId()) {
                    throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label8", "\u8868\u5355\u5bf9\u8c61\u548c\u89c6\u56fe\u5bf9\u8c61\u4e0d\u5339\u914d,\u65e0\u6cd5\u9884\u89c8!"));
                }
                reader2 = null;
                reader = null;
                string = null;
                String string2 = null;
                string2 = this.getAbsolutePath(infoView, infoViewView.getNewFile());
                FileInputStream fileInputStream = new FileInputStream(string2);
                reader2 = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                StreamSource streamSource = new StreamSource(reader2);
                string2 = this.getAbsolutePath(infoView, infoView.getTemplateFile());
                FileInputStream fileInputStream2 = new FileInputStream(string2);
                reader = new InputStreamReader((InputStream)fileInputStream2, "UTF-8");
                StreamSource streamSource2 = new StreamSource(reader);
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                StreamResult streamResult = new StreamResult(charArrayWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(streamSource);
                transformer.transform(streamSource2, streamResult);
                string = charArrayWriter.toString();
                Object var16_16 = null;
                if (reader2 == null) break block16;
                try {
                    reader2.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception2222) {}
            }
            break block17;
            {
                catch (Exception exception3) {
                    throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label9", "\u9884\u89c8\u81ea\u5b9a\u4e49\u8868\u5355\u65f6\u53d1\u751f\u9519\u8bef!"), exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var16_17 = null;
                if (reader2 != null) {
                    try {
                        reader2.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return string;
    }

    public String forFillOutInner(InfoView infoView, InfoViewView infoViewView) throws WCMException {
        return this.forFillOutInner(infoView, infoViewView, false);
    }

    public String forFillOutInner(InfoView infoView, InfoViewView infoViewView, boolean bl) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (infoViewView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label7", "\u65e0\u6548\u7684\u89c6\u56fe\u5bf9\u8c61[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (infoViewView.getInfoViewID() != infoView.getId()) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label8", "\u8868\u5355\u5bf9\u8c61\u548c\u89c6\u56fe\u5bf9\u8c61\u4e0d\u5339\u914d,\u65e0\u6cd5\u9884\u89c8!"));
        }
        String string = this.getAbsolutePath(infoView, infoViewView.getNewFile());
        Document document = InfoViewHelper.buildDOM4JDocument(string);
        if (bl) {
            this.removeCanotPublish(document);
        }
        this.removeUnWriteableForGateWay(document);
        return this.filteredFillOut(infoView, document);
    }

    public String forFillOutInFlow(InfoView infoView, InfoViewView infoViewView, int n) throws WCMException, Throwable {
        FlowNode flowNode = this.getCurrFlowNode(n);
        if (flowNode.isStartNode()) {
            return this.forFillOut(infoView, infoViewView);
        }
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (infoViewView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label7", "\u65e0\u6548\u7684\u89c6\u56fe\u5bf9\u8c61[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (infoViewView.getInfoViewID() != infoView.getId()) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label8", "\u8868\u5355\u5bf9\u8c61\u548c\u89c6\u56fe\u5bf9\u8c61\u4e0d\u5339\u914d,\u65e0\u6cd5\u9884\u89c8!"));
        }
        String string = this.getAbsolutePath(infoView, infoViewView.getNewFile());
        Document document = InfoViewHelper.buildDOM4JDocument(string);
        ArrayList arrayList = new ArrayList();
        this.renderGroupsInFlow(n, arrayList);
        this.removeUnReadable(document, arrayList, true);
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        HashMap hashMap = new HashMap();
        this.renderFieldsInFlow(n, arrayList2, arrayList3, hashMap);
        this.reformUnWriteable(document, arrayList3);
        this.removeUnReadable(document, arrayList2, false);
        return this.filteredFillOut(infoView, document);
    }

    public String filterContentInFlow(InfoView infoView, String string, int n) throws WCMException, Throwable {
        FlowNode flowNode = this.getCurrFlowNode(n);
        if (flowNode.isStartNode()) {
            return string;
        }
        Document document = InfoViewHelper.parseToDocument(string);
        if (document != null) {
            try {
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                HashMap hashMap = new HashMap();
                this.renderFieldsInFlow(n, arrayList, arrayList2, hashMap);
                for (String string2 : arrayList) {
                    for (Element element : document.selectNodes("//" + string2)) {
                        element.detach();
                    }
                }
                for (String string2 : hashMap.keySet()) {
                    for (Element element : document.selectNodes("//" + string2)) {
                        if (!element.isTextOnly() || !CMyString.isEmpty(element.getText())) continue;
                        element.setText((String)hashMap.get(string2));
                    }
                }
                return document.asXML();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    public String initTemplateInFlow(InfoView infoView, int n) throws WCMException, Throwable {
        FlowNode flowNode = this.getCurrFlowNode(n);
        if (flowNode.isStartNode()) {
            return infoView.getTemplateFileContent();
        }
        String string = this.getAbsolutePath(infoView, infoView.getTemplateFile());
        Document document = InfoViewHelper.buildDOM4JDocument(string);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        HashMap hashMap = new HashMap();
        this.renderFieldsInFlow(n, arrayList, arrayList2, hashMap);
        for (String string2 : hashMap.keySet()) {
            for (Element element : document.selectNodes("//" + string2)) {
                short s = element.getNodeType();
                if (s != 3 && s != 4) continue;
                element.addText((String)hashMap.get(string2));
            }
        }
        return document.asXML();
    }

    /*
     * Loose catch block
     */
    private String filteredFillOut(InfoView infoView, Document document) throws TransformerFactoryConfigurationError, WCMException {
        String string;
        block14: {
            Exception exception2222;
            Reader reader;
            StringReader stringReader;
            block13: {
                stringReader = null;
                reader = null;
                string = null;
                stringReader = new StringReader(document.asXML());
                StreamSource streamSource = new StreamSource(stringReader);
                String string2 = this.getAbsolutePath(infoView, infoView.getTemplateFile());
                FileInputStream fileInputStream = new FileInputStream(string2);
                reader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                StreamSource streamSource2 = new StreamSource(reader);
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                StreamResult streamResult = new StreamResult(charArrayWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(streamSource);
                transformer.transform(streamSource2, streamResult);
                string = charArrayWriter.toString();
                Object var15_15 = null;
                if (stringReader == null) break block13;
                try {
                    ((Reader)stringReader).close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception2222) {}
            }
            break block14;
            {
                catch (Exception exception3) {
                    throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label10", "\u81ea\u5b9a\u4e49\u8868\u5355\u5728\u5de5\u4f5c\u6d41\u6d41\u8f6c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef!"), exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var15_16 = null;
                if (stringReader != null) {
                    try {
                        ((Reader)stringReader).close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return string;
    }

    private void renderViewsInFlow(int n, HashMap hashMap) throws Throwable {
        FlowNodeFields flowNodeFields = this.getFieldsInfoInFlow(n, 2);
        for (int i = 0; i < flowNodeFields.size(); ++i) {
            FlowNodeField flowNodeField = (FlowNodeField)flowNodeFields.getAt(i);
            if (flowNodeField.getFieldType() != 2) continue;
            String string = flowNodeField.getFieldName();
            if (flowNodeField.isReadField()) continue;
            hashMap.put(string, "");
        }
    }

    private void renderGroupsInFlow(int n, ArrayList arrayList) throws Throwable {
        FlowNodeFields flowNodeFields = this.getFieldsInfoInFlow(n, 1);
        for (int i = 0; i < flowNodeFields.size(); ++i) {
            FlowNodeField flowNodeField = (FlowNodeField)flowNodeFields.getAt(i);
            if (flowNodeField.getFieldType() != 1) continue;
            String string = flowNodeField.getFieldName();
            if (flowNodeField.isReadField()) continue;
            arrayList.add(string);
        }
    }

    private void renderFieldsInFlow(int n, ArrayList arrayList, ArrayList arrayList2, HashMap hashMap) throws Throwable {
        FlowNodeFields flowNodeFields = this.getFieldsInfoInFlow(n, 0);
        for (int i = 0; i < flowNodeFields.size(); ++i) {
            String string;
            FlowNodeField flowNodeField = (FlowNodeField)flowNodeFields.getAt(i);
            if (flowNodeField.getFieldType() != 0) continue;
            String string2 = flowNodeField.getFieldName();
            if (!flowNodeField.isReadField()) {
                arrayList.add(string2);
            }
            if (!flowNodeField.isWriteField()) {
                arrayList2.add(string2);
            }
            if (CMyString.isEmpty(string = (String)flowNodeField.getProperties().get("INITVALUE"))) continue;
            hashMap.put(string2, string);
        }
    }

    private void removeUnReadable(Document document, List list, boolean bl) {
        for (String string : list) {
            for (Element element : document.selectNodes("//*[@trs_temp_id=\"" + string + "\"]")) {
                if (element.getParent() == null) continue;
                if (!bl) {
                    element.clearContent();
                    if (element.attribute("trs_temp_id") != null) {
                        element.remove(element.attribute("trs_temp_id"));
                    }
                    if (element.attribute("xctname") != null) {
                        element.remove(element.attribute("xctname"));
                    }
                    if (element.attribute("binding") != null) {
                        element.remove(element.attribute("binding"));
                    }
                    if (element.attribute("contentEditable") == null) continue;
                    element.remove(element.attribute("contentEditable"));
                    continue;
                }
                element.detach();
            }
        }
    }

    private void reformUnWriteable(Document document, List list) {
        Object object;
        Iterator iterator = document.selectNodes("//*[@trs_readonly_field=\"1\"]").iterator();
        Iterator iterator2 = document.selectNodes("//*[@trs_backreadonly_field=\"1\"]").iterator();
        while (iterator.hasNext()) {
            object = (Element)iterator.next();
            if (object.attribute("trs_readonly_field") == null) continue;
            object.remove(object.attribute("trs_readonly_field"));
        }
        while (iterator2.hasNext()) {
            object = (Element)iterator2.next();
            if (object.attribute("trs_backreadonly_field") == null) continue;
            object.remove(object.attribute("trs_backreadonly_field"));
        }
        for (String string : list) {
            for (Element element : document.selectNodes("//*[@trs_temp_id=\"" + string + "\"]")) {
                element.addAttribute("trs_readonly_field", "1");
                if (element.attribute("contentEditable") == null) continue;
                element.remove(element.attribute("contentEditable"));
            }
        }
    }

    private void removeUnWriteableForGateWay(Document document) {
        for (Element element : document.selectNodes("//*[@trs_readonly_field=\"1\"]")) {
            if (element.attribute("trs_readonly_field") == null) continue;
            element.remove(element.attribute("trs_readonly_field"));
        }
    }

    private FlowNodeFields getFieldsInfoInFlow(int n, int n2) throws Throwable {
        User user = this.getLoginUser();
        FlowDoc flowDoc = FlowDoc.findById(n);
        FlowNode flowNode = this.getCurrFlowNode(n);
        WCMFilter wCMFilter = new WCMFilter("", "NodeId=? and FieldType=?", "");
        wCMFilter.addSearchValues(flowNode.getId());
        wCMFilter.addSearchValues(n2);
        FlowNodeFields flowNodeFields = FlowNodeFields.openWCMObjs(user, wCMFilter);
        flowNodeFields.setMaxBufferSize(flowNodeFields.size());
        int n3 = flowNodeFields.size();
        FlowContext flowContext = new FlowContext();
        flowContext.setCurrUser(user);
        flowContext.setPostUser(user);
        flowContext.setCurrFlowDoc(flowDoc);
        for (int i = 0; i < n3; ++i) {
            String string;
            FlowNodeField flowNodeField = (FlowNodeField)flowNodeFields.getAt(i);
            if (flowNodeField == null || CMyString.isEmpty(string = flowNodeField.getPropertyAsString("InitValueCreator"))) continue;
            IInitValueCreator iInitValueCreator = (IInitValueCreator)Class.forName(string).newInstance();
            flowNodeField.getProperties().put("INITVALUE", iInitValueCreator.createInitValue(flowContext));
        }
        return flowNodeFields;
    }

    private FlowNode getCurrFlowNode(int n) throws WCMException {
        User user = this.getLoginUser();
        FlowDoc flowDoc = FlowDoc.findById(n);
        if (flowDoc == null) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label11", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u8f68\u8ff9\uff01[ID=") + n + "]");
        }
        if (!user.isAdministrator() && !flowDoc.getPostUserName().equalsIgnoreCase(user.getName()) && flowDoc.getToUserId() != user.getId()) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label12", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u6b64\u8f68\u8ff9\uff01[FlowDocId=") + n + "]");
        }
        FlowNode flowNode = null;
        flowNode = flowDoc.isWorked() && flowDoc.getPostUserName().equalsIgnoreCase(user.getName()) ? flowDoc.getPreNode() : flowDoc.getNode();
        return flowNode;
    }

    private InfoPathFileData prepareSave(InfoView infoView) throws WCMException {
        Object object;
        String string = infoView.getDesc();
        if (string == null || string.length() == 0) {
            infoView.setDesc(infoView.getName());
        }
        String string2 = "";
        if (infoView.isAddMode()) {
            string2 = infoView.getInfoPathFile();
            if (string2 == null) {
                throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label13", "\u5fc5\u987b\u5148\u8bbe\u7f6eInfoPath\u6587\u4ef6\u624d\u80fd\u7ee7\u7eed\u4fdd\u5b58\uff01"));
            }
        } else {
            string2 = infoView.getNewInfoPathFile();
            if (!infoView.isChangeProperty("INFOPATHFILE") || string2 == null) {
                InfoPathFileData infoPathFileData = this.analyzeFile(infoView, infoView.getInfoPathFile());
                return infoPathFileData;
            }
        }
        if (string2 == null) {
            return null;
        }
        if (!"XSN".equalsIgnoreCase(CMyFile.extractFileExt(string2))) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label14", "\u76ee\u524d\u53ea\u63a5\u53d7InfoPath\u7684XSN\u6587\u4ef6\uff0c\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\uff08") + string2 + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label15", "\uff09\u683c\u5f0f\u65e0\u6548\uff01"));
        }
        if (CMyFile.fileExists(string2)) {
            object = this.m_oFilesManMgr.getNextFileName("IV", "xsn", null, true);
            try {
                CMyFile.copyFile(string2, (String)object);
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label16", "\u62f7\u8d1dXSN\u6587\u4ef6[") + string2 + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label17", "]\u5230[") + (String)object + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label18", "]\u5931\u8d25\uff01"), exception);
            }
            string2 = CMyFile.extractFileName((String)object);
        } else {
            object = this.m_oFilesManMgr;
            if (!((FilesMan)object).fileExists(string2)) {
                throw new WCMException(50, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label19", "InfoPath\u6587\u4ef6\uff08") + string2 + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label20", "\uff09\u5728\u670d\u52a1\u5668\u4e0a\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u5148\u4e0a\u4f20\u5230\u670d\u52a1\u5668\u4e0a\u518d\u4fdd\u5b58\uff01"));
            }
            if (((FilesMan)object).getFileFlag(string2) != "U0") {
                return null;
            }
            string2 = ((FilesMan)object).copyWCMFile(string2, "IV");
        }
        object = this.analyzeFile(infoView, string2);
        return object;
    }

    private InfoPathFileData analyzeFile(InfoView infoView, String string) throws WCMException {
        FilesMan filesMan = this.m_oFilesManMgr;
        String string2 = filesMan.mapFilePath(string, 0);
        String string3 = CMyFile.extractMainFileName(string);
        String string4 = string3 + ".DIR";
        String string5 = string2 + string;
        String string6 = string2 + string4;
        infoView.setInfoPathFile(string);
        infoView.setInfoViewPath(string4);
        HashMap hashMap = null;
        try {
            hashMap = this.m_CABExtractor.extract(string5, string6);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label21", "\u5206\u89e3InfoPath\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef:") + exception.getMessage(), exception);
        }
        InfoPathFileData infoPathFileData = new InfoPathFileData();
        try {
            infoPathFileData.build(string6, hashMap, this.m_oInfoViewCfg);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label22", "\u5206\u6790InfoPath\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef:") + exception.getMessage(), exception);
        }
        if (infoView.isAddMode() || infoView.getId() >= InfoViewMgr.getNewRuleFromInfoViewId()) {
            this.validateRepeatField(infoPathFileData);
        }
        infoView.setSchemaFile(infoPathFileData.getSchemaFile());
        infoView.setAllFileList(infoPathFileData.getAllFileList());
        infoView.setTemplateFile(infoPathFileData.getTemplateFile());
        return infoPathFileData;
    }

    private void validateRepeatField(InfoPathFileData infoPathFileData) throws WCMException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        ArrayList arrayList = infoPathFileData.getFieldList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            object = (DataType)arrayList.get(i);
            String string = ((DataType)object).getName().trim();
            if ((string = LetterConvertor.convertToFirstLetter(string).toUpperCase()).length() >= 30) {
                stringBuffer.append(((DataType)object).getName());
                stringBuffer.append("\u7684\u957f\u5ea6\u8d85\u8fc730\uff0c\u6570\u636e\u5e93\u521b\u5efa\u5b57\u6bb5\u65f6\u5019\u53ef\u80fd\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u5728InfoPath\u4e2d\u4fee\u6539\u5b57\u6bb5\u540d\u79f0\uff01[\u6570\u636e\u5e93\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + string + "]\n");
            }
            if (bl = DBManager.getDBManager().getDBKeywords().contains(string)) {
                stringBuffer.append(((DataType)object).getName());
                stringBuffer.append("\u662f\u6570\u636e\u5e93\u4fdd\u7559\u5173\u952e\u5b57\u8bf7\u91cd\u65b0\u5728InfoPath\u4e2d\u4fee\u6539\u5b57\u6bb5\u540d\u79f0\uff01[\u6570\u636e\u5e93\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + string + "]\n");
            }
            if (string.indexOf(".") > 0) {
                stringBuffer.append(((DataType)object).getName());
                stringBuffer.append("\u4e2d\u5305\u542b\u4e0d\u5408\u6cd5\u7684\u5b57\u7b26[.]\u8bf7\u91cd\u65b0\u5728InfoPath\u4e2d\u4fee\u6539\u5b57\u6bb5\u540d\u79f0\uff01[\u6570\u636e\u5e93\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + string + "]\n");
            }
            if (hashtable2.containsKey(string)) {
                String string2 = null;
                string2 = !hashtable.containsKey(string) ? (String)hashtable2.get(string) : (String)hashtable.get(string);
                hashtable.put(string, string2 + "," + ((DataType)object).getName());
                continue;
            }
            hashtable2.put(string, ((DataType)object).getName());
        }
        if (hashtable.size() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label23", "\u5728\u60a8\u5f53\u524d\u5bfc\u5165\u7684\u8868\u5355\u4e2d\uff0c\u547d\u540d\u7684\u4e2d\u6587\u5b57\u6bb5\u8f6c\u6362\u6210\u4ee5\u9996\u5b57\u6bcd\u7ec4\u5408\u7684\u82f1\u6587\u5b57\u6bb5\u65f6\u53ef\u80fd\u5b58\u5728\u91cd\u590d\uff0c") + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label24", "\u8fd9\u6837\u4f1a\u5bfc\u81f4\u7cfb\u7edf\u4e0d\u80fd\u521b\u5efa\u8868\uff01") + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label25", "\u6211\u4eec\u5efa\u8bae\u60a8\u4fee\u6539\u4e00\u4e0b\u8868\u5355\u518d\u5bfc\u5165\uff0c\u5728\u540d\u79f0\u540e\u52a0\u4e00\u4e9b\u6570\u5b57\u6216\u8005\u6587\u5b57\u533a\u5206\uff0c\u91cd\u590d\u7684\u5b57\u6bb5\u5982\u4e0b\u6240\u793a\uff1a\n"));
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                stringBuffer2.append("\n===========================\n");
                stringBuffer2.append(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label26", "\u8f6c\u6362\u540e\u7684\u82f1\u6587\u540d\u79f0\uff1a"));
                stringBuffer2.append((String)object);
                stringBuffer2.append("\n");
                stringBuffer2.append(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label27", "\u76f8\u5173\u7684\u4e2d\u6587\u540d\u79f0\uff1a"));
                stringBuffer2.append(hashtable.get(object));
            }
            if (stringBuffer.length() > 0) {
                stringBuffer2.append("\n");
                stringBuffer2.append(stringBuffer);
            }
            throw new WCMException(stringBuffer2.toString());
        }
        if (stringBuffer.length() > 0) {
            throw new WCMException(stringBuffer.toString());
        }
    }

    public void save(InfoView infoView) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label28", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        boolean bl = infoView.isAddMode();
        User user = this.getLoginUser();
        if (!bl && !infoView.canEdit(user)) {
            throw new WCMException(1012, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label29", "\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539!\u5f53\u524d\u7528\u6237:[") + user.getName() + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label30", "] \u9501\u5b9a\u7528\u6237:[") + infoView.getLockerUserName() + "]");
        }
        InfoPathFileData infoPathFileData = this.prepareSave(infoView);
        if (infoPathFileData == null) {
            infoView.save(user);
            return;
        }
        boolean bl2 = infoView.isAddMode() || infoView.isChangeProperty("INFOPATHFILE");
        String string = null;
        String string2 = null;
        if (bl2 && !infoView.isAddMode()) {
            string = infoView.getInfoPathFile();
            string2 = infoView.getInfoViewPath();
        }
        infoView.save(user);
        this.m_oIVDBMgr.createDBTable(user, infoView.getId());
        this.saveViews(infoView, infoPathFileData.getViewList());
        this.saveGroups(infoView, infoPathFileData.getGroupList());
        this.saveFields(infoView, infoPathFileData.getFieldList());
        if (string != null) {
            String string3 = this.m_oFilesManMgr.mapFilePath(string, 0);
            CMyFile.deleteFile(string3 + File.separator + string);
            CMyFile.deleteDir(string3 + File.separator + string2);
        }
        try {
            infoPathFileData.reform(infoView.getId());
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label31", "\u683c\u5f0f\u5316XSLT\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef:") + exception.getMessage(), exception);
        }
        try {
            infoPathFileData.reformTemplateXml();
            this.rebuildXSLT(infoView);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label32", "\u683c\u5f0f\u5316Template.xml\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef:") + exception.getMessage(), exception);
        }
    }

    private void saveViews(InfoView infoView, List list) throws WCMException {
        Object object2;
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        InfoViewViews infoViewViews = null;
        if (!infoView.isAddMode()) {
            infoViewViews = InfoViewViews.findBy(infoView);
        }
        if (infoViewViews != null && infoViewViews.size() > 0) {
            for (n = infoViewViews.size() - 1; n >= 0; --n) {
                object2 = (InfoViewView)infoViewViews.getAt(n);
                if (object2 == null) continue;
                hashMap.put(((InfoViewView)object2).getName(), object2);
            }
        }
        for (n = 0; n < list.size(); ++n) {
            object2 = (View)list.get(n);
            String string = ((View)object2).getName();
            InfoViewView infoViewView = (InfoViewView)hashMap.get(string);
            if (infoViewView == null) {
                infoViewView = new InfoViewView();
                infoViewView.setInfoViewID(infoView.getId());
                infoViewView.setName(string);
                infoViewView.setDesc(((View)object2).getCaption());
            } else {
                hashMap.remove(string);
            }
            infoViewView.setNewFile(((View)object2).getNewTransform());
            infoViewView.setOldFile(((View)object2).getTransform());
            infoViewView.setViewWidth(((View)object2).getViewWidth());
            infoViewView.setDefaultView(((View)object2).isDefaultView());
            infoViewView.setXSLPrefix(((View)object2).getXSLPrefix());
            this.save(infoViewView);
            ((View)object2).setTRSObjectID(infoViewView.getId());
        }
        if (hashMap.size() > 0) {
            for (Object object2 : hashMap.values()) {
                if (object2 == null) continue;
                this.delete((InfoViewView)object2);
            }
            hashMap.clear();
        }
    }

    private void saveGroups(InfoView infoView, List list) throws WCMException {
        Object object2;
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        InfoViewGroups infoViewGroups = null;
        if (!infoView.isAddMode()) {
            infoViewGroups = InfoViewGroups.findBy(infoView);
        }
        if (infoViewGroups != null && infoViewGroups.size() > 0) {
            for (n = infoViewGroups.size() - 1; n >= 0; --n) {
                object2 = (InfoViewGroup)infoViewGroups.getAt(n);
                if (object2 == null) continue;
                hashMap.put(((InfoViewGroup)object2).getName(), object2);
            }
        }
        for (n = 0; n < list.size(); ++n) {
            object2 = (DataGroup)list.get(n);
            String string = ((DataGroup)object2).getName();
            InfoViewGroup infoViewGroup = (InfoViewGroup)hashMap.get(string);
            if (infoViewGroup == null) {
                infoViewGroup = new InfoViewGroup();
                infoViewGroup.setInfoViewID(infoView.getId());
                infoViewGroup.setName(string);
                infoViewGroup.setDesc(((DataGroup)object2).getBindname());
                ((DataGroup)object2).enablePublish(true);
            } else {
                ((DataGroup)object2).enablePublish(infoViewGroup.isPublicFill());
                hashMap.remove(string);
            }
            infoViewGroup.setViewID(((DataGroup)object2).getViewID());
            this.save(infoViewGroup);
            ((DataGroup)object2).setTRSObjectID(infoViewGroup.getId());
        }
        if (hashMap.size() > 0) {
            for (Object object2 : hashMap.values()) {
                if (object2 == null) continue;
                this.delete((InfoViewGroup)object2);
            }
            hashMap.clear();
        }
    }

    private void saveFields(InfoView infoView, List list) throws WCMException {
        HashMap<String, InfoViewField> hashMap = new HashMap<String, InfoViewField>();
        List list2 = infoView.allFields();
        if (list2 != null && list2.size() > 0) {
            for (int i = list2.size() - 1; i >= 0; --i) {
                InfoViewField infoViewField = (InfoViewField)list2.get(i);
                if (infoViewField == null) continue;
                hashMap.put(infoViewField.getName(), infoViewField);
            }
        }
        User user = this.getLoginUser();
        for (int i = 0; i < list.size(); ++i) {
            Cloneable cloneable = (DataType)list.get(i);
            String string = ((DataType)cloneable).getNewBindName();
            InfoViewField infoViewField = (InfoViewField)hashMap.get(string);
            if (infoViewField == null) {
                infoViewField = new InfoViewField();
                infoView.addField(infoViewField);
            } else {
                hashMap.remove(string);
            }
            infoViewField.setXPath(((DataType)cloneable).getBindName());
            infoViewField.setName(string);
            infoViewField.setDesc(((DataType)cloneable).getDisplayName());
            infoViewField.setDataType(((DataType)cloneable).getDataTypeAsInt());
            infoViewField.setFieldType(((DataType)cloneable).getDisplayFieldType());
            infoViewField.setNillable(((DataType)cloneable).isNillable());
            infoViewField.setMaxLength(((DataType)cloneable).getMaxLength());
            infoViewField.setMinLength(((DataType)cloneable).getMinLength());
            this.save(infoViewField);
            this.m_oIVDBMgr.createDBField(user, infoView, infoViewField);
            ((DataType)cloneable).setTRSObjectID(infoViewField.getId());
        }
        if (hashMap.size() > 0) {
            for (Cloneable cloneable : hashMap.values()) {
                if (cloneable == null) continue;
                infoView.removeField((InfoViewField)cloneable);
                this.delete((InfoViewField)cloneable);
            }
            hashMap.clear();
        }
    }

    public void save(InfoViewView infoViewView) throws WCMException {
        if (infoViewView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label33", "\u65e0\u6548\u7684\u8868\u5355\u89c6\u56fe[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        if (!infoViewView.isAddMode() && !infoViewView.canEdit(this.getLoginUser())) {
            throw new WCMException(1012, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label29", "\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539!\u5f53\u524d\u7528\u6237:[") + this.getLoginUser().getName() + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label30", "] \u9501\u5b9a\u7528\u6237:[") + infoViewView.getLockerUserName() + "]");
        }
        infoViewView.save(this.getLoginUser());
    }

    public void save(InfoViewGroup infoViewGroup) throws WCMException {
        if (infoViewGroup == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label34", "\u65e0\u6548\u7684\u8868\u5355\u6570\u636e\u8282[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        if (!infoViewGroup.isAddMode() && !infoViewGroup.canEdit(this.getLoginUser())) {
            throw new WCMException(1012, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label29", "\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539!\u5f53\u524d\u7528\u6237:[") + this.getLoginUser().getName() + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label30", "] \u9501\u5b9a\u7528\u6237:[") + infoViewGroup.getLockerUserName() + "]");
        }
        boolean bl = infoViewGroup.isChangeProperty("PUBLICFILL");
        infoViewGroup.save(this.getLoginUser());
        if (bl) {
            this.changeDataGroupPublishFlag(infoViewGroup);
        }
    }

    private void changeDataGroupPublishFlag(InfoViewGroup infoViewGroup) throws WCMException {
        String string;
        InfoView infoView = infoViewGroup.getInfoView();
        if (infoView == null) {
            s_logger.error((Object)I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label35", "\u6570\u636e\u8282\u6240\u5c5e\u8868\u5355\u5bf9\u8c61\u4e0d\u5b58\u5728"));
            return;
        }
        InfoViewView infoViewView = infoViewGroup.getView();
        if (infoViewView == null) {
            s_logger.error((Object)I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label36", "\u6570\u636e\u8282\u6240\u5c5e\u8868\u5355\u89c6\u56fe\u4e0d\u5b58\u5728"));
            return;
        }
        String string2 = this.getAbsolutePath(infoView, infoViewView.getNewFile());
        Document document = InfoViewHelper.buildDOM4JDocument(string2);
        List list = document.selectNodes(string = "//*/@trs_obj_type");
        if (list == null) {
            return;
        }
        String string3 = String.valueOf(infoViewGroup.getId());
        boolean bl = false;
        for (Attribute attribute : list) {
            Element element;
            String string4;
            if (!XSLTViewBuilder.TYPE_DATA_SECTION.equals(attribute.getValue()) || !string3.equals(string4 = (element = attribute.getParent()).attributeValue("trs_obj_id"))) continue;
            String string5 = infoViewGroup.isPublicFill() ? "1" : "0";
            element.addAttribute("trs_obj_publish", string5);
            bl = true;
            break;
        }
        if (bl) {
            InfoViewHelper.writeDOM4JDocument(document, string2);
        }
    }

    public void save(InfoViewField infoViewField) throws WCMException {
        if (infoViewField == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label37", "\u65e0\u6548\u7684\u8868\u5355\u6570\u636e\u9879[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        if (!infoViewField.isAddMode() && !infoViewField.canEdit(this.getLoginUser())) {
            throw new WCMException(1012, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label29", "\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539!\u5f53\u524d\u7528\u6237:[") + this.getLoginUser().getName() + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label30", "] \u9501\u5b9a\u7528\u6237:[") + infoViewField.getLockerUserName() + "]");
        }
        infoViewField.save(this.getLoginUser());
    }

    public void setFieldsReadOnly(InfoView infoView, InfoViewFields infoViewFields, boolean bl) throws WCMException {
        ArrayList<InfoViewField> arrayList = new ArrayList<InfoViewField>();
        for (int i = 0; i < infoViewFields.size(); ++i) {
            InfoViewField infoViewField = (InfoViewField)infoViewFields.getAt(i);
            infoViewField.setReadOnly(bl);
            infoViewField.setBackReadOnly(bl);
            this.save(infoViewField);
            arrayList.add(infoViewField);
        }
        this.rebuildXSLTByFields(infoView, arrayList);
    }

    public void saveViewByFields(InfoView infoView, List list) throws WCMException {
        ArrayList arrayList = this.split2List(infoView.getSearchFields());
        ArrayList arrayList2 = this.split2List(infoView.getOutlineFields());
        boolean bl = false;
        for (InfoViewField infoViewField : list) {
            String string = infoViewField.getXPath();
            if (infoViewField.isSearchField()) {
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                    bl = true;
                }
            } else if (arrayList.contains(string)) {
                arrayList.remove(string);
                bl = true;
            }
            if (infoViewField.isOutlineField()) {
                if (arrayList2.contains(string)) continue;
                arrayList2.add(string);
                bl = true;
                continue;
            }
            if (!arrayList2.contains(string)) continue;
            arrayList2.remove(string);
            bl = true;
        }
        if (!bl) {
            return;
        }
        infoView.setSearchFields(this.join2String(arrayList));
        infoView.setOutlineFields(this.join2String(arrayList2));
        infoView.save(this.getLoginUser());
    }

    private String join2String(ArrayList arrayList) {
        String string = "";
        Iterator iterator = arrayList.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string2;
            if (!bl) {
                string = string + ",";
            }
            if ((string2 = (String)iterator.next()).trim().length() <= 0) continue;
            string = string + string2.trim();
            bl = false;
        }
        return string;
    }

    private ArrayList split2List(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().length() <= 0) continue;
            arrayList.add(stringArray[i].trim());
        }
        return arrayList;
    }

    public void rebuildXSLT(InfoView infoView) throws WCMException {
        InfoViewViews infoViewViews = InfoViewViews.findBy(infoView);
        for (int i = 0; i < infoViewViews.size(); ++i) {
            InfoViewView infoViewView = (InfoViewView)infoViewViews.getAt(i);
            String string = this.getAbsolutePath(infoView, infoViewView.getNewFile());
            Document document = InfoViewHelper.buildDOM4JDocument(string);
            XSLTViewConstrainter xSLTViewConstrainter = new XSLTViewConstrainter();
            xSLTViewConstrainter.init(infoView, infoViewView, null, null);
            boolean bl = xSLTViewConstrainter.rebuild(document);
            if (!bl) continue;
            InfoViewHelper.writeDOM4JDocument(document, string);
        }
    }

    public void rebuildXSLTByGroups(InfoView infoView, List list) throws WCMException {
        InfoViewViews infoViewViews = InfoViewViews.findBy(infoView);
        for (int i = 0; i < infoViewViews.size(); ++i) {
            InfoViewView infoViewView = (InfoViewView)infoViewViews.getAt(i);
            String string = this.getAbsolutePath(infoView, infoViewView.getNewFile());
            Document document = InfoViewHelper.buildDOM4JDocument(string);
            boolean bl = this.reformGroupsConstraint(document, infoView, infoViewView, list);
            if (!bl) continue;
            InfoViewHelper.writeDOM4JDocument(document, string);
        }
    }

    private boolean reformGroupsConstraint(Document document, InfoView infoView, InfoViewView infoViewView, List list) throws WCMException {
        XSLTViewConstrainter xSLTViewConstrainter = new XSLTViewConstrainter();
        xSLTViewConstrainter.init(infoView, infoViewView, list, null);
        return xSLTViewConstrainter.rebuild(document);
    }

    public void rebuildXSLTByFields(InfoView infoView, List list) throws WCMException {
        InfoViewViews infoViewViews = InfoViewViews.findBy(infoView);
        for (int i = 0; i < infoViewViews.size(); ++i) {
            InfoViewView infoViewView = (InfoViewView)infoViewViews.getAt(i);
            String string = this.getAbsolutePath(infoView, infoViewView.getNewFile());
            Document document = InfoViewHelper.buildDOM4JDocument(string);
            boolean bl = this.reformFieldsConstraint(document, infoView, infoViewView, list);
            if (!bl) continue;
            InfoViewHelper.writeDOM4JDocument(document, string);
        }
    }

    private boolean reformFieldsConstraint(Document document, InfoView infoView, InfoViewView infoViewView, List list) throws WCMException {
        XSLTViewConstrainter xSLTViewConstrainter = new XSLTViewConstrainter();
        xSLTViewConstrainter.init(infoView, infoViewView, null, list);
        return xSLTViewConstrainter.rebuild(document);
    }

    public String forPreviewMultiView(InfoView infoView, InfoViewView infoViewView, FormProperty formProperty, List list) throws WCMException {
        if (infoViewView == null) {
            return this.forPreview(infoView, formProperty, list);
        }
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        String string = this.getAbsolutePath(infoView, infoViewView.getNewFile());
        Document document = InfoViewHelper.buildDOM4JDocument(string);
        String string2 = this.getTemplateFileContent(infoView);
        this.addDataFormAndSubmit(document, formProperty, infoViewView, string2);
        this.reformCharEncoding(document, formProperty.getFormEncoding());
        this.reformScriptAndCSS(document);
        this.reformForm4Publish(document, formProperty);
        this.removeCanotPublish(document);
        this.getAllHTMImageFile(infoView, document, list);
        StringReader stringReader = new StringReader(document.asXML());
        StreamSource streamSource = new StreamSource(stringReader);
        return this.transformTemplate(infoView, streamSource);
    }

    public String forPreview(InfoView infoView, FormProperty formProperty, List list) throws WCMException {
        Object object;
        int n;
        Object object2;
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        this.buildPropertyForGateway(formProperty);
        formProperty.normalize();
        boolean bl = formProperty.isPublishAllViews();
        if (bl) {
            return null;
        }
        Object object3 = null;
        String string = formProperty.getInfoViewViewName();
        if (string == null || CMyString.isEmpty(string)) {
            object2 = InfoViewViews.findDefaultBy(infoView);
            for (n = 0; n < ((BaseObjs)object2).size(); ++n) {
                object = (InfoViewView)((BaseObjs)object2).getAt(n);
                if (!((InfoViewView)object).isPublicFill()) continue;
                object3 = object;
                break;
            }
        } else {
            object2 = InfoViewViews.findBy(infoView);
            for (n = 0; n < ((BaseObjs)object2).size(); ++n) {
                object = (InfoViewView)((BaseObjs)object2).getAt(n);
                if (!((InfoViewView)object).isPublicFill() || !string.equals(((InfoViewView)object).getName())) continue;
                object3 = object;
                break;
            }
        }
        if (object3 == null) {
            object2 = InfoViewViews.findBy(infoView);
            for (n = 0; n < ((BaseObjs)object2).size(); ++n) {
                object = (InfoViewView)((BaseObjs)object2).getAt(n);
                if (!((InfoViewView)object).isPublicFill()) continue;
                object3 = object;
                break;
            }
        }
        if (object3 == null) {
            return null;
        }
        object2 = this.getAbsolutePath(infoView, ((InfoViewView)object3).getNewFile());
        Document document = InfoViewHelper.buildDOM4JDocument((String)object2);
        object = this.getTemplateFileContent(infoView);
        this.addDataFormAndSubmit(document, formProperty, (InfoViewView)object3, (String)object);
        this.reformCharEncoding(document, formProperty.getFormEncoding());
        this.reformScriptAndCSS(document);
        this.reformForm4Publish(document, formProperty);
        this.removeCanotPublish(document);
        this.getAllHTMImageFile(infoView, document, list);
        StringReader stringReader = new StringReader(document.asXML());
        StreamSource streamSource = new StreamSource(stringReader);
        return this.transformTemplate(infoView, streamSource);
    }

    public static Map split2AttrMap(String string) {
        Pattern pattern = Pattern.compile("([^\\s=]*)\\s*=(([^\\s'\"]+\\s)|(\\s*(['\"]?)(.*?)\\5))");
        Matcher matcher = pattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            String string2 = CMyString.showNull(CMyString.showNull(matcher.group(6), matcher.group(3))).trim();
            hashMap.put(matcher.group(1), string2);
        }
        return hashMap;
    }

    private void addDataFormAndSubmit(Document document, FormProperty formProperty, InfoViewView infoViewView, String string) {
        Element element;
        String string22;
        Object object;
        Object object2;
        Element element2 = (Element)document.selectSingleNode(".//body");
        Element element3 = element2.addElement("form");
        element3.addAttribute("id", "frmData");
        element3.addAttribute("name", "frmData");
        List list = element2.elements();
        for (int i = 0; i < list.size(); ++i) {
            object2 = (Node)list.get(i);
            if (object2 == element3) continue;
            element3.add(object2.detach());
        }
        Element element4 = element2.addElement("form");
        element2.add(element3.detach());
        element4.addAttribute("id", "frmAction");
        element4.addAttribute("name", "frmAction");
        if (!CMyString.isEmpty(formProperty.getFormExtra())) {
            object2 = formProperty.getFormExtra();
            object = InfoViewMgr.split2AttrMap((String)object2);
            for (String string22 : object.keySet()) {
                element4.addAttribute(string22, (String)object.get(string22));
            }
        }
        object2 = element4.addElement("input");
        object2.addAttribute("type", "hidden");
        object2.addAttribute("name", "SiteId");
        object = String.valueOf(formProperty.getSiteID());
        object2.addAttribute("value", (String)object);
        Element element5 = element4.addElement("input");
        element5.addAttribute("type", "hidden");
        element5.addAttribute("name", "ChannelId");
        object = String.valueOf(formProperty.getChannelID());
        element5.addAttribute("value", (String)object);
        string22 = element4.addElement("input");
        string22.addAttribute("type", "hidden");
        string22.addAttribute("name", "InfoViewId");
        object = String.valueOf(infoViewView.getInfoViewID());
        string22.addAttribute("value", (String)object);
        Element element6 = element4.addElement("input");
        element6.addAttribute("type", "hidden");
        element6.addAttribute("name", "DocumentId");
        object = String.valueOf(formProperty.getSelectFields());
        if (!CMyString.isEmpty((String)object) && !((String)object).equals("null")) {
            element = element4.addElement("input");
            element.addAttribute("type", "hidden");
            element.addAttribute("name", "SelectFields");
            element.addAttribute("value", (String)object);
        }
        element = element4.addElement("input");
        element.addAttribute("type", "hidden");
        element.addAttribute("name", "NeedInit");
        object = String.valueOf(formProperty.getNeedInit());
        element.addAttribute("value", (String)object);
        Element element7 = element4.addElement("input");
        element7.addAttribute("type", "hidden");
        element7.addAttribute("name", "OnlyCached");
        object = String.valueOf(formProperty.isOnlyCached());
        element7.addAttribute("value", (String)object);
        Element element8 = element4.addElement("textarea");
        element8.addAttribute("name", "ObjectXML");
        element8.addAttribute("style", "display:none");
        element8.setText(string);
        String string3 = infoViewView.getViewWidth();
        Element element9 = element2.addElement("div");
        element9.addAttribute("align", "center");
        if (string3 != null) {
            element9.addAttribute("style", "width:" + string3);
        }
        if (formProperty.getSubmitButtonHTML() != null) {
            Element element10 = element9.addElement("xsl:text", NS_XSL_URI);
            element10.addAttribute("disable-output-escaping", "yes");
            element10.addText(formProperty.getSubmitButtonHTML());
        } else {
            Element element11 = element9.addElement("input");
            element11.addAttribute("id", "SubmitButton");
            element11.addAttribute("name", "SubmitButton");
            element11.addAttribute("type", "button");
            element11.addAttribute("value", I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label38", "\u63d0\u4ea4"));
            if (formProperty.isResetButton()) {
                Element element12 = element9.addElement("input");
                element12.addAttribute("id", "ResetButton");
                element12.addAttribute("name", "ResetButton");
                element12.addAttribute("type", "reset");
                element12.addAttribute("value", I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label39", "\u91cd\u7f6e"));
            }
        }
    }

    public String appendJsAndCsses(String string) {
        int n = string.indexOf("</head>");
        int n2 = string.indexOf("</body>");
        String string2 = "${ROOT_PATH}images/infoview/";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String[] stringArray = CMyString.split(this.getInfoViewConfig().getPubStyleURI(), ",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("<link href=\"" + string2 + stringArray[i] + "\" rel=\"stylesheet\" type=\"text/css\" />");
        }
        String[] stringArray2 = CMyString.split(this.getInfoViewConfig().getPubScriptURI(), ",");
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer2.append("<script src=\"" + string2 + stringArray2[i] + "\"></script>");
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        if (n == -1 || n2 == -1) {
            stringBuffer3.append(string);
            stringBuffer3.append(stringBuffer);
            stringBuffer3.append(stringBuffer2);
            return stringBuffer3.toString();
        }
        stringBuffer3.append(string.substring(0, n));
        stringBuffer3.append(stringBuffer);
        stringBuffer3.append(string.substring(n, n2));
        stringBuffer3.append(stringBuffer2);
        stringBuffer3.append(string.substring(n2));
        return stringBuffer3.toString();
    }

    private void reformScriptAndCSS(Document document) {
        Attribute attribute;
        int n;
        String string = "${ROOT_PATH}images/infoview/";
        string = CMyString.replaceStr(string, "{", "{{");
        string = CMyString.replaceStr(string, "}", "}}");
        string = CMyString.setStrEndWith(string, '/');
        List list = document.selectNodes("//script/@src");
        for (n = list.size() - 1; n >= 0; --n) {
            attribute = (Attribute)list.get(n);
            attribute.setValue(string + attribute.getValue());
        }
        list = document.selectNodes("//link/@href");
        for (n = list.size() - 1; n >= 0; --n) {
            attribute = (Attribute)list.get(n);
            attribute.setValue(string + attribute.getValue());
        }
        list = document.selectNodes("//img/@src");
        for (n = list.size() - 1; n >= 0; --n) {
            attribute = (Attribute)list.get(n);
            if (!attribute.getValue().equals("TRSCalendar.gif")) continue;
            attribute.setValue(string + attribute.getValue());
        }
    }

    private void reformFormProperty(Document document, String string) {
        Element element = (Element)document.selectSingleNode("//form");
        if (string != null) {
            element.addAttribute("action", string);
        }
        if (CMyString.isEmpty(element.attributeValue("target"))) {
            element.addAttribute("target", "_top");
        }
    }

    private void reformForm4Publish(Document document, FormProperty formProperty) {
        Element element = (Element)document.selectSingleNode("//form");
        if (element == null) {
            s_logger.error((Object)I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label40", "\u8868\u5355\u4e2d\u6ca1\u6709\u627e\u5230:form"));
            return;
        }
        this.appendHiddenField(element, "encoding", formProperty.getFormEncoding());
        String string = "0";
        if (formProperty.isVerifyCodeEnable()) {
            string = "1";
        }
        this.appendHiddenField(element, "verifycode", string);
        this.appendHiddenField(element, "verifycodeurl", formProperty.getVerifyCodeURL());
        this.appendHiddenField(element, "ValidVerifycodeUrl", formProperty.getValidVerifycodeUrl());
        String string2 = formProperty.getGateWayInitPage();
        if (string2 != null) {
            this.appendHiddenField(element, "GateWayInit", string2);
        }
        this.appendHiddenField(element, "fileuploadurl", formProperty.getFileAction());
        this.appendHiddenField(element, "readfileurl", formProperty.getReadFileURL());
        Map map = formProperty.getNonReservedGatewayPageProps();
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                this.appendHiddenField(element, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        Object object = "${ROOT_PATH}images/infoview/";
        object = CMyString.replaceStr((String)object, "{", "{{");
        object = CMyString.replaceStr((String)object, "}", "}}");
        object = CMyString.setStrEndWith((String)object, '/');
        this.appendHiddenField(element, "resourcebase", (String)object);
        this.appendHiddenField(element, "InfoviewTitle", CMyString.filterForXsltValue(formProperty.getInfoviewTitle()));
        this.appendHiddenField(element, "CachedInfoviewId", "");
        this.appendHiddenField(element, "JustCached", "");
    }

    private void appendHiddenField(Element element, String string, String string2) {
        if (element == null || string == null) {
            return;
        }
        Element element2 = element.addElement("input");
        element2.addAttribute("type", "hidden");
        element2.addAttribute("name", string);
        element2.addAttribute("value", string2);
    }

    private void reformCharEncoding(Document document, String string) {
        Element element = (Element)document.selectSingleNode("//xsl:output");
        if (element != null) {
            element.addAttribute("encoding", string);
        }
    }

    private void removeCanotPublish(Document document) {
        String string = "//div/@trs_obj_publish";
        List list = document.selectNodes(string);
        if (list == null) {
            return;
        }
        for (Attribute attribute : list) {
            if ("1".equals(attribute.getValue())) continue;
            Element element = attribute.getParent();
            element.detach();
        }
    }

    private void getAllHTMImageFile(InfoView infoView, Document document, List list) throws WCMException {
        Object object;
        Object object2;
        Attribute attribute = null;
        attribute = (Attribute)document.selectSingleNode("//body/@old_src");
        if (attribute != null) {
            object2 = attribute.getValue();
            object = this.getAbsolutePath(infoView, (String)object2);
            if ((attribute = attribute.getParent().attribute("background")) != null) {
                attribute.setValue((String)object2);
                list.add(object);
            }
        }
        if ((object2 = document.selectNodes("//img/@old_src")) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                attribute = (Attribute)object.next();
                Element element = attribute.getParent();
                if (element.attribute("CtrlId") != null) continue;
                String string = attribute.getValue();
                String string2 = this.getAbsolutePath(infoView, string);
                if ((attribute = attribute.getParent().attribute("src")) == null) continue;
                attribute.setValue(string);
                list.add(string2);
            }
        }
    }

    public String forInfoGate(InfoView infoView, FormProperty formProperty) throws WCMException {
        InfoViewView infoViewView;
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label41", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        if (formProperty.getChannelID() <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label42", "\u65e0\u6548\u7684\u9891\u9053ID[<=0],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        this.buildPropertyForGateway(formProperty);
        formProperty.normalize();
        InfoViewView infoViewView2 = null;
        InfoViewViews infoViewViews = InfoViewViews.findBy(infoView);
        for (int i = 0; i < infoViewViews.size(); ++i) {
            infoViewView = (InfoViewView)infoViewViews.getAt(i);
            if (!infoViewView.isPublicFill()) continue;
            infoViewView2 = infoViewView;
            break;
        }
        if (infoViewView2 == null) {
            return null;
        }
        String string = this.getAbsolutePath(infoView, infoViewView2.getNewFile());
        infoViewView = InfoViewHelper.buildDOM4JDocument(string);
        String string2 = this.getTemplateFileContent(infoView);
        this.addDataFormAndSubmit((Document)infoViewView, formProperty, infoViewView2, string2);
        this.reformFormProperty((Document)infoViewView, formProperty.getFormAction());
        this.reformCharEncoding((Document)infoViewView, "UTF-8");
        this.reformForm4Publish((Document)infoViewView, formProperty);
        DocumentSource documentSource = new DocumentSource((Document)infoViewView);
        return this.transformTemplate(infoView, (Source)documentSource);
    }

    private void buildPropertyForGateway(FormProperty formProperty) {
        GatewayConfig gatewayConfig = this.m_oInfoViewCfg.getGatewayConfig();
        formProperty.setGatewayPageProperties(gatewayConfig.getGatewayPageProperties());
    }

    public String forPublishMultiView(InfoView infoView, InfoViewView infoViewView, FormProperty formProperty, List list) throws WCMException {
        if (infoViewView == null) {
            return this.forPublish(infoView, formProperty, list);
        }
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label41", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        if (formProperty.getChannelID() <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label42", "\u65e0\u6548\u7684\u9891\u9053ID[<=0],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        this.buildPropertyForGateway(formProperty);
        formProperty.normalize();
        String string = this.getAbsolutePath(infoView, infoViewView.getNewFile());
        Document document = InfoViewHelper.buildDOM4JDocument(string);
        String string2 = this.getTemplateFileContent(infoView);
        this.addDataFormAndSubmit(document, formProperty, infoViewView, string2);
        this.reformCharEncoding(document, formProperty.getFormEncoding());
        this.reformScriptAndCSS(document);
        this.reformFormProperty(document, formProperty.getFormAction());
        this.reformForm4Publish(document, formProperty);
        this.removeCanotPublish(document);
        this.getAllHTMImageFile(infoView, document, list);
        DocumentSource documentSource = new DocumentSource(document);
        return this.transformTemplate(infoView, (Source)documentSource);
    }

    public String forMultiView(InfoView infoView, InfoViewView infoViewView, List list) throws WCMException {
        if (infoViewView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label43", "\u65e0\u6548\u7684\u8868\u5355\u89c6\u56fe[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        String string = this.getAbsolutePath(infoView, infoViewView.getNewFile());
        Document document = InfoViewHelper.buildDOM4JDocument(string);
        this.reformScriptAndCSS(document);
        this.removeCanotPublish(document);
        this.getAllHTMImageFile(infoView, document, list);
        StringReader stringReader = new StringReader(document.asXML());
        StreamSource streamSource = new StreamSource(stringReader);
        return this.transformTemplate(infoView, streamSource);
    }

    public String forPublish(InfoView infoView, FormProperty formProperty, List list) throws WCMException {
        InfoViewView infoViewView;
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label41", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        if (formProperty.getChannelID() <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label42", "\u65e0\u6548\u7684\u9891\u9053ID[<=0],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        this.buildPropertyForGateway(formProperty);
        formProperty.normalize();
        InfoViewView infoViewView2 = null;
        InfoViewViews infoViewViews = InfoViewViews.findBy(infoView);
        for (int i = 0; i < infoViewViews.size(); ++i) {
            infoViewView = (InfoViewView)infoViewViews.getAt(i);
            if (!infoViewView.isPublicFill()) continue;
            infoViewView2 = infoViewView;
            break;
        }
        if (infoViewView2 == null) {
            return null;
        }
        String string = this.getAbsolutePath(infoView, infoViewView2.getNewFile());
        infoViewView = InfoViewHelper.buildDOM4JDocument(string);
        String string2 = this.getTemplateFileContent(infoView);
        this.addDataFormAndSubmit((Document)infoViewView, formProperty, infoViewView2, string2);
        this.reformCharEncoding((Document)infoViewView, formProperty.getFormEncoding());
        this.reformScriptAndCSS((Document)infoViewView);
        this.reformFormProperty((Document)infoViewView, formProperty.getFormAction());
        this.reformForm4Publish((Document)infoViewView, formProperty);
        this.removeCanotPublish((Document)infoViewView);
        this.getAllHTMImageFile(infoView, (Document)infoViewView, list);
        DocumentSource documentSource = new DocumentSource((Document)infoViewView);
        return this.transformTemplate(infoView, (Source)documentSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String transformTemplate(InfoView infoView, Source source) throws WCMException {
        Reader reader = null;
        String string = null;
        String string2 = null;
        try {
            try {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                StreamResult streamResult = new StreamResult(charArrayWriter);
                string2 = this.getAbsolutePath(infoView, infoView.getTemplateFile());
                FileInputStream fileInputStream = new FileInputStream(string2);
                reader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                StreamSource streamSource = new StreamSource(reader);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(source);
                transformer.transform(streamSource, streamResult);
                string = charArrayWriter.toString();
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label9", "\u9884\u89c8\u81ea\u5b9a\u4e49\u8868\u5355\u65f6\u53d1\u751f\u9519\u8bef!"), exception);
            }
            Object var13_13 = null;
            if (reader == null) return string;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        reader.close();
        return string;
    }

    public String getInfoViewSerial(int n) throws WCMException {
        InfoView infoView = InfoView.findById(n);
        if (infoView == null) {
            throw new WCMException(200006, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label44", "\u6ca1\u6709\u627e\u5230[Id=") + n + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label45", "]\u7684\u8868\u5355!"));
        }
        return this.getInfoViewSerial(infoView);
    }

    public String getInfoViewSerial(InfoView infoView) throws WCMException {
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label46", "\u65e0\u6548\u7684\u8868\u5355\u5bf9\u8c61[null],\u65e0\u6cd5\u83b7\u5f97\u5176\u7f16\u53f7!"));
        }
        if (!infoView.hasDocSerial()) {
            return "";
        }
        int n = infoView.getId();
        int n2 = infoView.getSerialPeriod();
        InfoViewSerialGenerator infoViewSerialGenerator = InfoViewSerialGenerator.getInstance();
        Object[] objectArray = infoViewSerialGenerator.getNextSerial(n, n2, 1);
        String string = infoView.getSerialPattern();
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    public String getTemplateFileContent(InfoView infoView) throws WCMException {
        String string = this.getAbsolutePath(infoView, infoView.getTemplateFile());
        try {
            return InfoViewMgr.getFileContent(string);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label47", "\u83b7\u53d6\u6570\u636e\u6a21\u677f\u6587\u4ef6\u5185\u5bb9\u65f6\u53d1\u751fIO\u9519\u8bef"), exception);
        }
    }

    public String getDocumentTitle(InfoView infoView, Document document) throws WCMException {
        String string = "";
        try {
            string = this.getDocumentTitleForUserName(infoView, document, null);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label52", "\u83b7\u53d6\u6587\u6863\u6807\u9898\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u8bbe\u7f6e\u7684\u8868\u5355\u6587\u6863\u6807\u9898\u662f\u5426\u6709\u4e0d\u5408\u6cd5\u7684\u683c\u5f0f\uff01"), exception);
        }
        DBManager dBManager = DBManager.getDBManager();
        FieldInfo fieldInfo = dBManager.getFieldInfo("WCMDOCUMENT", "docTitle");
        int n = this.getCompressLength(fieldInfo.getDataLength());
        if (CMyString.getBytesLength(string) > n) {
            string = CMyString.truncateStr(string, n);
        }
        return string;
    }

    public String getDocumentTitle(InfoView infoView, Document document, String string) throws WCMException {
        String string2 = this.getDocumentTitleForUserName(infoView, document, string);
        DBManager dBManager = DBManager.getDBManager();
        FieldInfo fieldInfo = dBManager.getFieldInfo("WCMDOCUMENT", "docTitle");
        int n = this.getCompressLength(fieldInfo.getDataLength());
        if (CMyString.getBytesLength(string2) > n) {
            string2 = CMyString.truncateStr(string2, n);
        }
        return string2;
    }

    public String getDocumentTitleForUserName(InfoView infoView, Document document, String string) throws WCMException {
        String string2;
        if (infoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label48", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u62bd\u53d6\u6587\u6863\u6807\u9898!"));
        }
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label49", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61[null],\u65e0\u6cd5\u62bd\u53d6\u6587\u6863\u6807\u9898!"));
        }
        String string3 = infoView.getTitlePattern();
        PatternAnalyzer patternAnalyzer = new PatternAnalyzer(string3);
        patternAnalyzer.setDocument(document);
        patternAnalyzer.setCurrentUser(this.getLoginUser());
        if (string != null) {
            patternAnalyzer.setInfogateUserName(string);
        }
        if (CMyString.isEmpty(string2 = patternAnalyzer.getAnalyzedResult())) {
            string2 = I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label50", "\u81ea\u5b9a\u4e49\u8868\u5355\u6570\u636e");
        }
        return string2;
    }

    public String getRandomSerial() {
        String string;
        String string2 = "";
        if (this.m_oInfoViewCfg.getPublicRandomSerialRequired() && !CMyString.isEmpty(string = this.m_oInfoViewCfg.getPublicRandomSerialPattern())) {
            MessageFormat messageFormat = new MessageFormat(string);
            Format[] formatArray = messageFormat.getFormatsByArgumentIndex();
            NumberFormat numberFormat = (NumberFormat)formatArray[1];
            int n = numberFormat.getMinimumIntegerDigits();
            Integer n2 = this.makeRandNumber(n);
            Object[] objectArray = new Object[]{Calendar.getInstance().getTime(), n2};
            string2 = messageFormat.format(objectArray);
        }
        return string2;
    }

    public String[] getPublicPassword() {
        String string;
        if (this.m_oInfoViewCfg.isPublicPasswordRequired() && !CMyString.isEmpty(string = this.m_oInfoViewCfg.getPublicPasswordPattern())) {
            String string2 = "";
            String string3 = this.m_oInfoViewCfg.getPublicPasswordField();
            MessageFormat messageFormat = new MessageFormat(string);
            Format[] formatArray = messageFormat.getFormatsByArgumentIndex();
            NumberFormat numberFormat = (NumberFormat)formatArray[0];
            int n = numberFormat.getMinimumIntegerDigits();
            Integer n2 = this.makeRandNumber(n);
            Object[] objectArray = new Object[]{n2};
            string2 = messageFormat.format(objectArray);
            return new String[]{string3, string2};
        }
        return new String[0];
    }

    private Integer makeRandNumber(int n) {
        int n2 = (int)Math.pow(10.0, n);
        int n3 = this.m_oRandomMaker.nextInt(n2) & Integer.MAX_VALUE;
        return new Integer(n3);
    }

    private static int getNewRuleFromInfoViewId() throws WCMException {
        int n = -1;
        String string = ConfigServer.getServer().getSysConfigValue("NEWRULE_FROM_INFOVIEWID", "-1");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            s_logger.error((Object)(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label51", "\u65b0\u89c4\u5219\u8d77\u59cb\u7684ID\u914d\u7f6e\u9519\u8bef![") + string + "]"), (Throwable)numberFormatException);
            n = -1;
        }
        return n;
    }

    private int getCompressLength(int n) {
        return (int)Math.floor((float)n / 1.5f);
    }
}

