/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.db.InfoViewDataType;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.components.infoview.helper.ComplexFieldData;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class InfoViewHelper {
    private static Logger logger = Logger.getLogger(InfoViewHelper.class);
    private static InfoViewEmployMgr m_oIVEmployMgr = null;

    private InfoViewHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Document buildDOM4JDocument(String var0) throws WCMException {
        block12: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            try {
                var4_4 = new FileInputStream(var0);
                var3_3 = new InputStreamReader((InputStream)var4_4, "UTF-8");
                var5_6 = new SAXReader();
                var2_2 = var5_6.read((Reader)var3_3);
                var7_7 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var6_13) {
                var7_9 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (Exception var8_12) {
                        // empty catch block
                    }
                }
                throw var6_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (Exception var8_10) {}
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (Exception var4_5) {
                    var1_1 = new WCMException(var4_5.getMessage());
                    var7_8 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (Exception var8_11) {}
                    }
                }
            }
        }
        if (var1_1 != null) {
            throw var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Document parseToDocument(String string) throws WCMException {
        Document document;
        WCMException wCMException;
        block21: {
            Exception exception2222;
            ByteArrayInputStream byteArrayInputStream;
            InputStreamReader inputStreamReader;
            block19: {
                if (string == null) {
                    return null;
                }
                wCMException = null;
                document = null;
                inputStreamReader = null;
                byteArrayInputStream = null;
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, "UTF-8");
                SAXReader sAXReader = new SAXReader();
                document = sAXReader.read((Reader)inputStreamReader);
                Object var7_7 = null;
                if (byteArrayInputStream == null) break block19;
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception2222) {}
            }
            break block21;
            {
                catch (Exception exception3) {
                    Exception exception42222;
                    wCMException = new WCMException(exception3.getMessage());
                    Object var7_8 = null;
                    if (byteArrayInputStream != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (Exception exception42222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception52222;
                Object var7_9 = null;
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (wCMException != null) {
            throw wCMException;
        }
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDOM4JDocument(Document document, String string) throws WCMException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(string);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                XMLWriter xMLWriter = new XMLWriter((Writer)outputStreamWriter);
                xMLWriter.write(document);
                xMLWriter.close();
            }
            catch (Exception exception) {
                throw new WCMException(exception.getMessage());
            }
            Object var6_6 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        fileOutputStream.close();
        return;
    }

    private static StringBuffer parseList2Json(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        boolean bl = true;
        for (Object e : list) {
            if (!bl) {
                stringBuffer.append(",\n");
            }
            bl = false;
            stringBuffer.append(InfoViewHelper.parse2Json(e));
        }
        stringBuffer.append("\n]");
        return stringBuffer;
    }

    public static StringBuffer parse2Json(Object object) {
        if (object instanceof List) {
            return InfoViewHelper.parseList2Json((List)object);
        }
        if (object instanceof Map) {
            return InfoViewHelper.parseMap2Json((Map)object);
        }
        if (object instanceof String) {
            return InfoViewHelper.parseString2Json((String)object);
        }
        return InfoViewHelper.parseString2Json(object.toString());
    }

    private static StringBuffer parseString2Json(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        stringBuffer.append(CMyString.filterForJs(string));
        stringBuffer.append("\"");
        return stringBuffer;
    }

    private static StringBuffer parseMap2Json(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        boolean bl = true;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!bl) {
                stringBuffer.append(",\n");
            }
            bl = false;
            stringBuffer.append("\"");
            stringBuffer.append(CMyString.filterForJs(string));
            stringBuffer.append("\":");
            stringBuffer.append(InfoViewHelper.parse2Json(map.get(string)));
        }
        stringBuffer.append("\n}");
        return stringBuffer;
    }

    public static String getDBFieldsByFields(InfoView infoView, String string, boolean bl) {
        if (!CMyString.isEmpty(string)) {
            String[] stringArray = string.split(",");
            Object[] objectArray = InfoViewHelper.getDBFieldsByFields(infoView, stringArray, bl);
            return CMyString.join(objectArray, ",");
        }
        return string;
    }

    public static String[] getDBFieldsByFields(InfoView infoView, String[] stringArray, boolean bl) {
        String string = infoView.getTrueTableName();
        if (stringArray != null && stringArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                infoView.allFields();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (InfoViewHelper.isInfoViewDefaultField(string2)) {
                        arrayList.add(bl ? string + "." + string2 : string2);
                        continue;
                    }
                    if (InfoViewHelper.isSystemField(string2)) {
                        arrayList.add(string2);
                        continue;
                    }
                    InfoViewField infoViewField = infoView.getField(string2 = InfoViewHelper.infoPathToFieldName(string2));
                    if (infoViewField != null) {
                        String string3 = null;
                        int n = InfoViewHelper.getNewRuleFromInfoViewId();
                        if (infoViewField.getInfoViewID() < n) {
                            string3 = InfoViewConstants.makeTrueFieldName(infoViewField.getId());
                        } else {
                            string3 = infoViewField.getDesc();
                            string3 = LetterConvertor.convertToFirstLetter(string3);
                        }
                        if (DBManager.getDBManager().getFieldInfo(string, string3) == null) continue;
                        arrayList.add(bl ? string + "." + string3 : string3);
                        continue;
                    }
                    arrayList.add(stringArray[i]);
                }
                String[] stringArray2 = new String[arrayList.size()];
                arrayList.toArray(stringArray2);
                return stringArray2;
            }
            catch (WCMException wCMException) {
                return null;
            }
        }
        return stringArray;
    }

    public static String getDBFieldByField(int n, String string, boolean bl) {
        String string2 = InfoViewConstants.makeTrueTableName(n);
        if (!CMyString.isEmpty(string)) {
            if (InfoViewHelper.isInfoViewDefaultField(string)) {
                return bl ? string2 + "." + string : string;
            }
            if (InfoViewHelper.isSystemField(string)) {
                return string;
            }
            try {
                Map map = InfoViewHelper.loadFieldsMap(n);
                String string3 = string;
                string = InfoViewHelper.infoPathToFieldName(string);
                InfoViewField infoViewField = (InfoViewField)map.get(string.toLowerCase());
                if (infoViewField != null) {
                    String string4 = null;
                    int n2 = InfoViewHelper.getNewRuleFromInfoViewId();
                    if (infoViewField.getInfoViewID() < n2) {
                        string4 = InfoViewConstants.makeTrueFieldName(infoViewField.getId());
                    } else {
                        string4 = infoViewField.getDesc();
                        string4 = LetterConvertor.convertToFirstLetter(string4);
                    }
                    return bl ? string2 + "." + string4 : string4;
                }
                return string3;
            }
            catch (WCMException wCMException) {
                return null;
            }
        }
        return string;
    }

    public static String infoPathToFieldName(String string) {
        String[] stringArray = string.split("/");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (CMyString.isEmpty(stringArray[i])) continue;
            arrayList.add(stringArray[i].replaceAll("[^:]*:", ""));
        }
        return CMyString.join(arrayList, "_");
    }

    private static Map loadFieldsMap(int n) throws WCMException {
        HashMap<String, InfoViewField> hashMap = new HashMap<String, InfoViewField>();
        WCMFilter wCMFilter = new WCMFilter("", "INFOVIEWID=" + n, "");
        try {
            InfoViewFields infoViewFields = new InfoViewFields(ContextHelper.getLoginUser());
            infoViewFields.open(wCMFilter);
            for (int i = 0; i < infoViewFields.size(); ++i) {
                InfoViewField infoViewField = (InfoViewField)infoViewFields.getAt(i);
                hashMap.put(infoViewField.getName().toLowerCase(), infoViewField);
            }
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(InfoViewHelper.class, "InfoViewHelper.label1", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u9879\u96c6\u5408\u51fa\u9519"), wCMException);
        }
        return hashMap;
    }

    public static boolean isSystemField(String string) {
        for (int i = 0; i < InfoViewConstants.SYSTEM_FIELD_NAMES.length; ++i) {
            if (!InfoViewConstants.SYSTEM_FIELD_NAMES[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInfoViewDefaultField(String string) {
        for (int i = 0; i < InfoViewConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            InfoViewDataType infoViewDataType = InfoViewConstants.DEFAULT_FIELDS.getDataTypeAt(i);
            String string2 = infoViewDataType.getKey();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static InfoViewEmployMgr getInfoViewEmployMgr() {
        if (m_oIVEmployMgr == null) {
            m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
        }
        return m_oIVEmployMgr;
    }

    public static InfoView getInfoView(Channel channel) throws WCMException {
        if (channel.getType() != 13) {
            return null;
        }
        List list = InfoViewHelper.getInfoViewEmployMgr().getEmployedInfoViews(channel);
        if (list != null && list.size() > 0) {
            return (InfoView)list.get(0);
        }
        return null;
    }

    public static String[] splitSelectFields(String string, String string2) throws WCMException {
        logger.debug((Object)("sOutlineDBFields:" + string));
        String[] stringArray = new String[]{"", ""};
        string2 = string2.toUpperCase();
        if (!CMyString.isEmpty(string)) {
            String[] stringArray2 = string.split(",");
            DBManager dBManager = DBManager.getDBManager();
            for (int i = 0; i < stringArray2.length; ++i) {
                boolean bl;
                String string3 = stringArray2[i].trim();
                if (CMyString.isEmpty(string3) || string3.startsWith("_")) continue;
                logger.debug((Object)(string2 + ".FieldName[" + i + "]:" + string3));
                boolean bl2 = bl = string3.toUpperCase().startsWith(string2 + ".") || dBManager.getFieldInfo(string2, string3) != null;
                if (bl) {
                    if (!CMyString.isEmpty(stringArray[1])) {
                        stringArray[1] = stringArray[1] + ',';
                    }
                    stringArray[1] = stringArray[1] + string3;
                    continue;
                }
                if (dBManager.getFieldInfo("WCMDOCUMENT", string3) == null && dBManager.getFieldInfo("WCMCHNLDOC", string3) == null) continue;
                if (!CMyString.isEmpty(stringArray[0])) {
                    stringArray[0] = stringArray[0] + ',';
                }
                stringArray[0] = stringArray[0] + string3;
            }
        }
        return stringArray;
    }

    public static ComplexFieldData makeComplexFieldData(String string, String string2, String string3, String string4, InfoViewData infoViewData) {
        if (CMyString.isEmpty(string) || CMyString.isEmpty(string2) || infoViewData == null) {
            return null;
        }
        ComplexFieldData complexFieldData = new ComplexFieldData();
        try {
            complexFieldData.setFieldId(string);
            complexFieldData.setFieldName(string2);
            complexFieldData.setFieldValue(string3);
            complexFieldData.setParentFlag(string4);
            complexFieldData.setInfoviewId(infoViewData.getInfoViewId());
            complexFieldData.setInfoviewDataId(infoViewData.getId());
            complexFieldData.setDocumentId(infoViewData.getDocumentId());
            complexFieldData.setPostTime(infoViewData.getCrTime());
        }
        catch (WCMException wCMException) {
            logger.warn((Object)(I18NMessage.get(InfoViewHelper.class, "InfoViewHelper.label2", "\u7531\u4e8e\u4ee5\u4e0b\u539f\u56e0\u5bfc\u81f4\u521b\u5efa[ComplexFieldData]\u5bf9\u8c61\u5931\u8d25\uff1a") + wCMException.getMessage()));
            return null;
        }
        return complexFieldData;
    }

    public static void restoreComplexFields(List list, int n, int n2) throws WCMException {
        InfoViewHelper.buildComplexFields(list, n, n2, true);
    }

    public static void buildComplexFields(List list, int n, int n2) throws WCMException {
        InfoViewHelper.buildComplexFields(list, n, n2, false);
    }

    public static void buildComplexFields(List list, int n, int n2, boolean bl) throws WCMException {
        if (n <= 0) {
            return;
        }
        if (bl) {
            InfoViewHelper.clearComplexFieldDatas(n);
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        String string = null;
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            String string2;
            ComplexFieldData complexFieldData = (ComplexFieldData)list.get(i);
            if (complexFieldData == null) continue;
            if (!bl) {
                complexFieldData.setInfoviewDataId(n);
                complexFieldData.setDocumentId(n2);
            }
            if (!(string2 = CMyString.showEmpty(complexFieldData.getParentFlag())).equals(string)) {
                ++n3;
                string = string2;
            }
            complexFieldData.setFieldOrder(n3);
            complexFieldData.save(InfoViewHelper.getLoginUser());
        }
    }

    public static void clearComplexFieldDatas(int n) throws WCMException {
        if (n <= 0) {
            return;
        }
        DBManager.getDBManager().sqlExecuteUpdate("delete from XWCMCOMPLEXFIELDDATA where InfoviewDataId=" + n);
    }

    private static User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private static int getNewRuleFromInfoViewId() throws WCMException {
        int n = -1;
        String string = ConfigServer.getServer().getSysConfigValue("NEWRULE_FROM_INFOVIEWID", "-1");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)(I18NMessage.get(InfoViewHelper.class, "InfoViewHelper.label3", "\u65b0\u89c4\u5219\u8d77\u59cb\u7684ID\u914d\u7f6e\u9519\u8bef![") + string + "]"), (Throwable)numberFormatException);
            n = -1;
        }
        return n;
    }
}

