/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.trsvote;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.trsvote.JVoteConstant;
import com.trs.components.common.trsvote.Vote;
import com.trs.components.common.trsvote.VoteOptions;
import com.trs.components.common.trsvote.Votes;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class VoteItem
extends CMSObj {
    public static final int OBJ_TYPE = 2100;
    public static final String DB_TABLE_NAME = "XWCMVOTEITEM";
    public static final String DB_ID_NAME = "ITEMID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 2100;
    }

    public int getItemId() {
        return this.getId();
    }

    public String getTitle() {
        return this.getPropertyAsString("TITLE");
    }

    public boolean setTitle(String string) throws WCMException {
        return this.setProperty("TITLE", string);
    }

    public int getStyle() {
        return this.getPropertyAsInt("STYLE", 0);
    }

    public boolean setStyle(int n) throws WCMException {
        return this.setProperty("STYLE", n);
    }

    public int getVoteId() {
        return this.getPropertyAsInt("VOTEID", 0);
    }

    public boolean setVoteId(int n) throws WCMException {
        return this.setProperty("VOTEID", n);
    }

    public boolean isValid() throws WCMException {
        if (!this.isAddMode() && !this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(VoteItem.class, "VoteItem.label1", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(VoteItem.isValid)"));
        }
        return true;
    }

    public VoteOptions getVoteOptions(User user) throws WCMException {
        VoteOptions voteOptions = null;
        try {
            voteOptions = new VoteOptions(user, 3, 3);
            voteOptions.setMaxBufferSize(20);
            voteOptions.setPageSize(20);
            WCMFilter wCMFilter = new WCMFilter(JVoteConstant.DB_TABLE_OPTION, "ITEMID=" + this.getId(), "", "");
            voteOptions.open(wCMFilter);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(VoteItem.class, "VoteItem.label2", "\u6253\u5f00\u8c03\u67e5\u4e8b\u9879\u6240\u62e5\u6709\u7684\u8c03\u67e5\u9009\u9879\u65f6\u51fa\u9519\uff01"), exception);
        }
        if (voteOptions.isEmpty()) {
            throw new WCMException(1100, I18NMessage.get(VoteItem.class, "VoteItem.label3", "\u8be5\u8c03\u67e5\u4e8b\u9879\u7f3a\u5c11\u6240\u5fc5\u9700\u62e5\u6709\u7684\u8c03\u67e5\u9009\u9879\uff01"));
        }
        return voteOptions;
    }

    public Vote getVote(User user) throws WCMException {
        Votes votes = null;
        Vote vote = null;
        try {
            votes = new Votes(user, 1, 1);
            votes.setMaxSize(1);
            votes.open(new WCMFilter("", votes.getIdFieldName() + "=" + this.getVoteId(), "", ""));
            vote = (Vote)votes.getAt(0);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(VoteItem.class, "VoteItem.label4", "\u6253\u5f00\u8c03\u67e5\u4e8b\u9879\u6240\u5c5e\u7684\u8c03\u67e5\u65f6\u51fa\u9519"), exception);
        }
        if (vote == null) {
            throw new WCMException(1100, I18NMessage.get(VoteItem.class, "VoteItem.label5", "\u4e8b\u9879\u6240\u5c5e\u7684\u8c03\u67e5\u4e3a\u7a7a\u6216\u5df2\u88ab\u5220\u9664"));
        }
        return vote;
    }
}

