/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.reminder;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.BaseScheduleWorker;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import org.apache.log4j.Logger;

public class Reminder
extends BaseScheduleWorker {
    private static Logger s_logger = Logger.getLogger(Reminder.class);

    protected int getMessageId() {
        return Integer.parseInt(this.getArgAsString("MESSAGEID"));
    }

    protected void execute() {
        try {
            ContextHelper.initContext(User.getSystem());
            MessageServer.send(Message.findById(this.getMessageId()));
        }
        catch (WCMException wCMException) {
            s_logger.error((Object)(I18NMessage.get(Reminder.class, "Reminder.label1", "\u5b9a\u65f6\u53d1\u9001\u6d88\u606f[") + this.getMessageId() + I18NMessage.get(Reminder.class, "Reminder.label2", "]\u5931\u8d25\uff01")), (Throwable)wCMException);
            return;
        }
    }

    public static void createSchedule(Message message, CMyDateTime cMyDateTime) throws WCMException {
        if (message == null || cMyDateTime == null) {
            throw new WCMException(10, I18NMessage.get(Reminder.class, "Reminder.label3", "\u65e0\u6548\u7684\u5bf9\u8c61\u53c2\u6570(Reminder.createJob)"));
        }
        User user = message.getCrUser();
        try {
            Schedule schedule = new Schedule();
            schedule.setWorkerType(1);
            schedule.setOperArgs("MESSAGEID=" + message.getId());
            schedule.setExeTime(cMyDateTime);
            schedule.setSender(message);
            schedule.setMode(3);
            schedule.setName(I18NMessage.get(Reminder.class, "Reminder.label1", "\u5b9a\u65f6\u53d1\u9001\u6d88\u606f[") + message.getId() + "]");
            schedule.insert(user);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(Reminder.class, "Reminder.label4", "\u521b\u5efaJob\u5931\u8d25(Reminder.createJob)"), exception);
        }
    }

    public static void main(String[] stringArray) {
    }
}

