/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.widget.ILayoutGenerator;
import com.trs.components.common.publish.widget.ILayoutMgr;
import com.trs.components.common.publish.widget.Layout;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;

public class WCMTagParserLayout
extends BaseTagParser {
    ILayoutMgr m_oLayoutMgr = (ILayoutMgr)DreamFactory.createObjectById("ILayoutMgr");
    private ILayoutGenerator m_oLayoutGenerator = (ILayoutGenerator)DreamFactory.createObjectById("ILayoutGenerator");
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TBI tBI = new TBI();
            tBI.setName("TRS_Layout");
            tBI.setDesc("TRS_Layout");
            tBI.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NAME");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("RATIO");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("RATIOTYPE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue(String.valueOf(Layout.RATIO_TYPE_FIXED));
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        Layout layout = this.findLayout(publishTagContext);
        String[] stringArray = new String[layout.getColumns()];
        String[] stringArray2 = this.getChildrenHtml(publishTagContext);
        System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        for (int i = stringArray2.length; i < stringArray.length; ++i) {
            stringArray[i] = "<div class='c-empty-column'>\u70b9\u51fb\u6dfb\u52a0\u8d44\u6e90</div>";
        }
        String string = this.m_oLayoutGenerator.generateHtml(layout, true, true);
        return new String[]{CMyString.format(string, stringArray)};
    }

    private String[] getChildrenHtml(PublishTagContext publishTagContext) throws WCMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = publishTagContext.getTagItem().getChildren();
        if (list == null || list.size() == 0) {
            return new String[0];
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e instanceof String) continue;
            String[] stringArray = TagParseHelper.parseItem((TagItem)e, publishTagContext);
            arrayList.add(stringArray != null ? stringArray[0] : null);
        }
        return arrayList.toArray(new String[0]);
    }

    private Layout findLayout(PublishTagContext publishTagContext) throws WCMException {
        Layout layout;
        int n = publishTagContext.getAttribute("id", 0);
        if (n != 0 && (layout = Layout.findById(n)) != null) {
            return layout;
        }
        String string = publishTagContext.getAttribute("name");
        if (!CMyString.isEmpty(string) && (layout = this.m_oLayoutMgr.findLayoutByName(ContextHelper.getLoginUser(), string)) != null) {
            return layout;
        }
        String string2 = publishTagContext.getAttribute("Ratio");
        if (CMyString.isEmpty(string2)) {
            throw new WCMException("\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684\u5e03\u5c40id[" + n + "]\u6216name[" + CMyString.showNull(string) + "]\u6216Ratio[" + CMyString.showEmpty(string2) + "]\u5c5e\u6027");
        }
        int n2 = publishTagContext.getAttribute("RatioType", Layout.RATIO_TYPE_FIXED);
        int n3 = string2.split(Layout.RATIO_SEPERATE).length;
        layout = Layout.createNewInstance();
        layout.setColumns(n3);
        layout.setRatio(string2);
        layout.setRatioType(n2);
        this.m_oLayoutMgr.validate(layout);
        return layout;
    }

    private class TBI
    extends TagBeanInfo {
        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
        }
    }
}

