/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.fieldtype;

import com.trs.components.common.publish.widget.fieldtype.IFieldTypesCreator;
import com.trs.infra.common.WCMException;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldTypesCreatorFactory {
    private static Logger logger = Logger.getLogger(FieldTypesCreatorFactory.class);
    private static Map mFieldTypeMapping = new HashMap();
    private static boolean mIsLoaded = false;

    private static void load() throws WCMException {
        if (mIsLoaded) {
            return;
        }
        mIsLoaded = true;
        IDiscovery iDiscovery = WCMDiscoveryFactory.getDiscovery();
        Iterator iterator = iDiscovery.getImplementors(IFieldTypesCreator.class.getName());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class<?> clazz = Class.forName(string);
                IFieldTypesCreator iFieldTypesCreator = (IFieldTypesCreator)clazz.newInstance();
                int n = iFieldTypesCreator.getTypeId();
                FieldTypesCreatorFactory.register(n, clazz);
            }
            catch (Exception exception) {
                logger.error((Object)"\u52a0\u8f7dIFieldTypesCreator\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)exception);
            }
        }
    }

    public static void register(int n, Class clazz) throws WCMException {
        if (mFieldTypeMapping.get(new Integer(n)) != null) {
            throw new WCMException("\u5b57\u6bb5\u7c7b\u578b\u3010Id=" + n + "\u3011\u5df2\u7ecf\u88ab\u4f7f\u7528\u4e86\uff0c\u8bf7\u4f7f\u75281000\u4ee5\u4e0a\u7684\u6570\u5b57\u3002");
        }
        mFieldTypeMapping.put(new Integer(n), clazz);
    }

    public static IFieldTypesCreator getTypeCreator(int n) throws WCMException {
        FieldTypesCreatorFactory.load();
        Class clazz = (Class)mFieldTypeMapping.get(new Integer(n));
        try {
            return (IFieldTypesCreator)clazz.newInstance();
        }
        catch (Exception exception) {
            logger.debug((Object)("\u521b\u5efaIFieldTypesCreator\u51fa\u73b0\u9519\u8bef[" + clazz + "]"), (Throwable)exception);
            return null;
        }
    }

    public static List getFieldTypes() throws WCMException {
        FieldTypesCreatorFactory.load();
        ArrayList<IFieldTypesCreator> arrayList = new ArrayList<IFieldTypesCreator>();
        for (Object k : mFieldTypeMapping.keySet()) {
            Class clazz = (Class)mFieldTypeMapping.get(k);
            try {
                IFieldTypesCreator iFieldTypesCreator = (IFieldTypesCreator)clazz.newInstance();
                arrayList.add(iFieldTypesCreator);
            }
            catch (Exception exception) {
                logger.error((Object)"\u5c06\u5b57\u6bb5\u7c7b\u578b\u7531map\u7ed3\u6784\u8f6c\u6210list\u7ed3\u6784\u51fa\u9519\u3002", (Throwable)exception);
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    IFieldTypesCreator iFieldTypesCreator = (IFieldTypesCreator)object;
                    int n = iFieldTypesCreator.getTypeOrder();
                    IFieldTypesCreator iFieldTypesCreator2 = (IFieldTypesCreator)object2;
                    int n2 = iFieldTypesCreator2.getTypeOrder();
                    return n - n2;
                }
                catch (Exception exception) {
                    logger.error((Object)"\u6267\u884c\u6392\u5e8f\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)exception);
                    return 0;
                }
            }
        });
        return arrayList;
    }
}

