/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IMasterMgr;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.IWidgetServer;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.special.Special;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.HTMLUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WidgetServer
implements IWidgetServer {
    private static Logger logger = Logger.getLogger(WidgetServer.class);
    private static Pattern m_oInstancePattern = Pattern.compile("(?im)<div[^>]*>@!@--(\\d+)--@!@</div>");
    private static String m_oInstanceInTemplate = "(?is)<TRS_Widget\\s+id=(['\"]){0}\\1\\s*>.*?</TRS_Widget>";
    private static Pattern m_oBackgroundImagePattern = Pattern.compile("(?im)(<[^>]*?url\\((?:'|\"|&quot;)?)[^>]*?\\/([A-Z]{1,2}\\d+\\.[^>]+?)((?:'|\"|&quot;)?\\)[^>]*?>)");
    IWidgetInstParameterMgr m_oWidgetInstParameterMgr = (IWidgetInstParameterMgr)DreamFactory.createObjectById("IWidgetInstParameterMgr");
    private TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");

    private String getNewTempName(String string, IPublishFolder iPublishFolder) throws WCMException {
        String string2 = string;
        int n = 1;
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        while (templateCacheMgr.lookupByName(iPublishFolder.getRoot(), string2) != null) {
            string2 = string + "_" + n;
            ++n;
        }
        return string2;
    }

    public Template createTemplateFromMaster(IPublishFolder iPublishFolder, Master master, int n) throws WCMException {
        IMasterMgr iMasterMgr = (IMasterMgr)DreamFactory.createObjectById("IMasterMgr");
        String string = iMasterMgr.getMasterFileContent(master, n);
        if (CMyString.isEmpty(string)) {
            return null;
        }
        Template template = Template.createNewInstance();
        String string2 = "template";
        switch (n) {
            case 3: {
                string2 = "\u6587\u6863\u9875\u9762\u6a21\u677f";
                break;
            }
            case 1: {
                string2 = "\u9996\u9875\u57fa\u51c6\u6a21\u677f";
                break;
            }
            case 2: {
                string2 = "\u5206\u7c7b\u9996\u9875\u6a21\u677f";
                break;
            }
        }
        template.setName(this.getNewTempName(string2 + iPublishFolder.getId(), iPublishFolder.getFolder()));
        template.setFolder(iPublishFolder);
        template.setType(n == 3 ? 2 : 1);
        template.setProperty("Visual", true);
        try {
            template.setText(TagParseHelper.parseContent(iPublishFolder, string, "EDIT")[0]);
        }
        catch (Exception exception) {
            logger.error((Object)"\u89e3\u6790\u6bcd\u7248\u51fa\u73b0\u9519\u8bef", (Throwable)exception);
            throw new WCMException("\u89e3\u6790\u6bcd\u7248\u51fa\u73b0\u9519\u8bef", exception);
        }
        return template;
    }

    public String parseToEditContent(IPublishElement iPublishElement, String string) throws Exception {
        return TagParseHelper.parseContent(iPublishElement, string, "EDIT")[0];
    }

    public String parseToEditContent(IPublishElement iPublishElement, Template template) throws Exception {
        String string = FilesMan.getFilesMan().getTemplateAppendixPath(template.getRootType(), template.getRootId(), 1, true);
        return TagParseHelper.parseContent(iPublishElement, template.getTextWithImgFilter(string, true), "EDIT")[0];
    }

    public String parseToEditContent(IPublishElement iPublishElement, WidgetInstance widgetInstance) throws Exception {
        String string = this.replaceWidgetInstParameters(widgetInstance);
        if (CMyString.isEmpty(string)) {
            return "";
        }
        return TagParseHelper.parseContent(iPublishElement, string, "EDIT")[0];
    }

    public String replaceWidgetInstParameters(WidgetInstance widgetInstance) throws WCMException {
        Widget widget = widgetInstance.getWidget();
        String string = widget.getWidgetcontent();
        Map map = this.m_oWidgetInstParameterMgr.getParameters(widgetInstance);
        string = CMyString.parsePageVariables(string, map, WidgetParameter.PARAMETER_FLAG);
        return string;
    }

    public String parseToTemplate(String string) throws WCMException {
        Matcher matcher = m_oInstancePattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (matcher.find()) {
            n2 = matcher.start();
            stringBuffer.append(string.substring(n3, n2));
            n3 = matcher.end();
            n = Integer.parseInt(matcher.group(1));
            WidgetInstance widgetInstance = WidgetInstance.findById(n);
            stringBuffer.append("<TRS_Widget id='").append(n).append("'>");
            stringBuffer.append(this.replaceWidgetInstParameters(widgetInstance));
            stringBuffer.append("</TRS_Widget>");
        }
        if (n3 < string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        return this.formatBackgroundImage(stringBuffer.toString());
    }

    private String formatBackgroundImage(String string) {
        return m_oBackgroundImagePattern.matcher(string).replaceAll("$1<TRS_StyleImage fileName=\"$2\"/>$3");
    }

    public void synchronizeWidgetInstances(Template template) throws WCMException {
        Object object;
        TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        TagDocument tagDocument = null;
        try {
            tagDocument = templateParseMgr.parse(template);
        }
        catch (Exception exception) {
            throw new WCMException("\u540c\u6b65\u53ef\u89c6\u5316\u6a21\u677f\u4e2d\u7684\u8d44\u6e90\u5b9e\u4f8b\u8fc7\u7a0b\u4e2d\uff0c\u51fa\u73b0\u5f02\u5e38", exception);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = template.getText();
        Pattern pattern = Pattern.compile("(?is)id=trs-widget-(\\d+?)\\s");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            stringBuffer.append("?,");
            stringBuffer2.append(Integer.parseInt(matcher.group(1).trim())).append(",");
        }
        Iterator iterator = tagDocument.findItems("TRS_WIDGET");
        while (iterator.hasNext()) {
            object = (TagItem)iterator.next();
            stringBuffer.append("?,");
            stringBuffer2.append(((TagItem)object).getIntAttribute("id", 0)).append(",");
        }
        if (stringBuffer.length() <= 0) {
            stringBuffer.append("?,");
            stringBuffer2.append("0,");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer2.setLength(stringBuffer2.length() - 1);
        object = new StringBuffer();
        ((StringBuffer)object).append("delete from ");
        ((StringBuffer)object).append("XWCMWIDGETINSTPARAMETER");
        ((StringBuffer)object).append(" where WidgetInstId in ( select WidgetInstanceId from ");
        ((StringBuffer)object).append("XWCMWIDGETINSTANCE");
        ((StringBuffer)object).append(" where templateid=?");
        ((StringBuffer)object).append(")");
        ((StringBuffer)object).append(" and WidgetInstId not in (");
        ((StringBuffer)object).append(stringBuffer);
        ((StringBuffer)object).append(")");
        stringBuffer2.insert(0, template.getId() + ",");
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{((StringBuffer)object).toString()}, CMyString.splitToInt(stringBuffer2.toString(), ","));
        ((StringBuffer)object).setLength(0);
        ((StringBuffer)object).append("delete from ");
        ((StringBuffer)object).append("XWCMWIDGETINSTANCE");
        ((StringBuffer)object).append(" where templateid=? and ");
        ((StringBuffer)object).append("WIDGETINSTANCEID");
        ((StringBuffer)object).append(" not in(");
        ((StringBuffer)object).append(stringBuffer);
        ((StringBuffer)object).append(")");
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{((StringBuffer)object).toString()}, CMyString.splitToInt(stringBuffer2.toString(), ","));
    }

    public void insertStyleTag(Special special, Template template) throws WCMException, Exception {
        Object object;
        String string;
        PageStyle pageStyle;
        String string2 = template.getText();
        TagDocument tagDocument = TagDocumentReader.read(string2);
        Iterator iterator = tagDocument.findItems("TRS_PAGESTYLE");
        boolean bl = false;
        if (iterator.hasNext()) {
            bl = true;
        }
        if ((pageStyle = PageStyle.findByName(string = special.getStyleName())) == null) {
            throw new WCMException("\u4e13\u9898\u5173\u8054\u7684\u98ce\u683c\u4e0d\u5b58\u5728\uff01[StyleName=" + string + "]");
        }
        String string3 = "<TRS_PAGESTYLE id=\"" + pageStyle.getId() + "\" name=\"" + string + "\"/>";
        if (!bl) {
            object = HTMLUtil.findTagOuterHTML(string2, "HEAD");
            if (object.size() > 0) {
                int[] nArray = (int[])object.get(0);
                String string4 = HTMLUtil.getEleInnerHTML(string2, nArray);
                template.setText(string2.substring(0, nArray[2]) + string4 + string3 + string2.substring(nArray[3]));
            } else {
                string2 = string3 + string2;
                template.setText(string2);
            }
        } else {
            string2 = string2.replaceAll("(?i)<TRS_PAGESTYLE [^>]*(?:/>|></TRS_PAGESTYLE>)", string3);
            template.setText(string2);
        }
        object = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        ((TemplateMgr)object).save(template, null, true, 2);
    }

    public void refreshWidgetForTemplate(WidgetInstance widgetInstance) throws WCMException {
        int n = widgetInstance.getTemplateId();
        Template template = Template.findById(n);
        if (template == null) {
            return;
        }
        String string = template.getText();
        String string2 = CMyString.format(m_oInstanceInTemplate, new int[]{widgetInstance.getId()});
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("<TRS_Widget id='").append(widgetInstance.getId()).append("'>");
        stringBuffer.append(this.replaceWidgetInstParameters(widgetInstance));
        stringBuffer.append("</TRS_Widget>");
        template.setText(string.replaceAll(string2, stringBuffer.toString()));
        this.m_oTemplateMgr.save(template, null, true, 2);
    }

    public static void main(String[] stringArray) {
        try {
            Template template = Template.findById(53);
            System.out.println("-----------------------");
            System.out.println(template.getText());
            System.out.println("-----------------------");
        }
        catch (WCMException wCMException) {
            wCMException.printStackTrace();
        }
    }
}

