/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.IWidgetParameterServiceProvider;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.WidgetParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;

public class WidgetParameterServiceProvider
implements IWidgetParameterServiceProvider {
    private IWidgetParameterMgr m_oIWidgetParameterMgr = (IWidgetParameterMgr)DreamFactory.createObjectById("IWidgetParameterMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(MethodContext methodContext) throws Exception {
        String string;
        User user = this.getLoginUser();
        WidgetParameters widgetParameters = WidgetParameters.findByIds(user, string = methodContext.getObjectIds());
        if (widgetParameters == null || widgetParameters.size() == 0) {
            throw new WCMException(200006, "\u6ca1\u6709\u8981\u5220\u9664\u7684\u8d44\u6e90\u53d8\u91cf.");
        }
        int n = widgetParameters.size();
        for (int i = 0; i < n; ++i) {
            WidgetParameter widgetParameter = (WidgetParameter)widgetParameters.getAt(i);
            if (widgetParameter == null) continue;
            boolean bl = SpecialAuthServer.hasRight(user, widgetParameter, 23);
            if (!bl) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8d44\u6e90\u53d8\u91cf[" + widgetParameter.getWidgetParamDesc() + "]\u3002");
            }
            this.m_oIWidgetParameterMgr.delete(user, widgetParameter);
        }
    }

    public Object query(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        int n = methodContext.getValue("WidgetId", 0);
        if (n <= 0) {
            return WidgetParameters.createNewInstance(user);
        }
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        WidgetParameters widgetParameters = this.m_oIWidgetParameterMgr.query(user, wCMFilter);
        for (int i = widgetParameters.size() - 1; i >= 0; --i) {
            boolean bl;
            WidgetParameter widgetParameter = (WidgetParameter)widgetParameters.getAt(i);
            if (widgetParameter == null || (bl = SpecialAuthServer.hasRight(user, widgetParameter, 24))) continue;
            widgetParameters.remove(widgetParameter, false);
        }
        return widgetParameters;
    }

    public int save(MethodContext methodContext) throws Exception {
        int n;
        User user = this.getLoginUser();
        int n2 = methodContext.getObjectId();
        WidgetParameter widgetParameter = null;
        if (n2 > 0) {
            widgetParameter = WidgetParameter.findById(n2);
        } else {
            widgetParameter = new WidgetParameter();
            n = methodContext.getValue("WidgetId", 0);
            widgetParameter.setWidgetId(n);
        }
        n = n2 > 0 ? 22 : 21;
        boolean bl = SpecialAuthServer.hasRight(user, widgetParameter, n);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (n2 > 0 ? "\u4fee\u6539\u8d44\u6e90\u53d8\u91cf[" + widgetParameter.getWidgetParamDesc() + "]\u3002" : "\u65b0\u5efa\u8d44\u6e90\u53d8\u91cf\uff01"));
        }
        String[] stringArray = new String[]{"WidgetParameterId", "WidgetId"};
        widgetParameter = (WidgetParameter)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, widgetParameter, stringArray);
        this.m_oIWidgetParameterMgr.saveWidgetParameter(user, widgetParameter);
        return widgetParameter.getId();
    }

    public boolean existsSimilarName(MethodContext methodContext) throws Exception {
        WCMFilter wCMFilter = new WCMFilter("XWCMWIDGETPARAMETER", "WIDGETID=? AND WIDGETPARAMNAME=? and WIDGETPARAMETERID<>?", "", "WIDGETPARAMETERID");
        String string = CMyString.showNull(methodContext.getValue("widgetParamName"));
        wCMFilter.addSearchValues(methodContext.getValue("widgetId"));
        wCMFilter.addSearchValues(string.toUpperCase());
        wCMFilter.addSearchValues(methodContext.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    public void changeOrder(MethodContext methodContext) throws Exception {
        Widget widget;
        int n = methodContext.getValue("srcObjectId", 0);
        WidgetParameter widgetParameter = WidgetParameter.findById(n);
        if (widgetParameter == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u8d44\u6e90[id=" + n + "]\u7684\u8d44\u6e90\u53d8\u91cf");
        }
        User user = this.getLoginUser();
        if (!SpecialAuthServer.hasRight(user, widget = Widget.findById(widgetParameter.getWidgetId()), 22)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u8d44\u6e90\u53d8\u91cf[" + widgetParameter.getWidgetParamDesc() + "]");
        }
        int n2 = methodContext.getValue("dstObjectId", 0);
        WidgetParameter widgetParameter2 = null;
        if (n2 > 0) {
            widgetParameter2 = WidgetParameter.findById(n2);
        }
        int n3 = widgetParameter2 == null ? -1 : widgetParameter2.getOrder();
        widgetParameter.setOrder(n3);
        this.m_oIWidgetParameterMgr.saveWidgetParameter(user, widgetParameter);
    }
}

