/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetInstParameter;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.WidgetParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class WidgetParameterMgr
implements IWidgetParameterMgr {
    public WidgetParameter saveWidgetParameter(User user, WidgetParameter widgetParameter) throws WCMException {
        if (widgetParameter == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684WidgetParameter\u5bf9\u8c61\uff0c\u65e0\u6cd5\u4fdd\u5b58.");
        }
        int n = widgetParameter.getWidgetId();
        Widget widget = Widget.findById(n);
        if (widget == null) {
            throw new WCMException(20, "\u6ca1\u6709\u627e\u5230\u8d44\u6e90\u53d8\u91cf\u6240\u5c5e\u7684\u8d44\u6e90.");
        }
        String string = widgetParameter.getFinalPropertyAsString("WIDGETPARAMNAME");
        if (this.existWidgetParameter(widget, widgetParameter)) {
            throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a[" + string + "]\u7684\u8d44\u6e90\u53d8\u91cf.");
        }
        widgetParameter.save(user);
        return widgetParameter;
    }

    public boolean delete(User user, WidgetParameter widgetParameter) throws WCMException {
        if (widgetParameter == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684WidgetParameter\u5bf9\u8c61\uff0c\u65e0\u6cd5\u5220\u9664.");
        }
        return widgetParameter.delete(user) == 1;
    }

    public WidgetParameters query(User user, WCMFilter wCMFilter) throws WCMException {
        WidgetParameters widgetParameters = WidgetParameters.openWCMObjs(user, wCMFilter);
        return widgetParameters;
    }

    public boolean existWidgetParameter(Widget widget, WidgetParameter widgetParameter) throws WCMException {
        WidgetParameters widgetParameters;
        boolean bl = widgetParameter.isAddMode();
        String string = null;
        string = bl ? widgetParameter.getPropertyAsString("WIDGETPARAMNAME") : widgetParameter.getNewPropertyAsString("WIDGETPARAMNAME");
        if (CMyString.isEmpty(string)) {
            return false;
        }
        String string2 = "WIDGETID=? AND WIDGETPARAMNAME=?";
        if (!bl) {
            string2 = string2 + " AND WIDGETPARAMETERID<>?";
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMWIDGETPARAMETER", string2, "", "WIDGETPARAMETERID");
        int n = widget.getId();
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string.toUpperCase());
        if (!bl) {
            wCMFilter.addSearchValues(widgetParameter.getId());
        }
        return (widgetParameters = WidgetParameters.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter)).size() > 0;
    }

    public WidgetParameters query(Widget widget) throws WCMException {
        if (widget == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684widget\u5bf9\u8c61.");
        }
        int n = widget.getId();
        String string = "WIDGETID=?";
        WCMFilter wCMFilter = new WCMFilter("XWCMWIDGETPARAMETER", string, "");
        wCMFilter.addSearchValues(n);
        WidgetParameters widgetParameters = WidgetParameters.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        return widgetParameters;
    }

    public WidgetParameter findParameterByName(Widget widget, String string) throws WCMException {
        String string2 = "WIDGETID=? AND WIDGETPARAMNAME=?";
        WCMFilter wCMFilter = new WCMFilter("XWCMWIDGETPARAMETER", string2, "");
        wCMFilter.addSearchValues(widget.getId());
        wCMFilter.addSearchValues(string);
        WidgetParameters widgetParameters = WidgetParameters.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        return widgetParameters.size() > 0 ? (WidgetParameter)widgetParameters.getAt(0) : null;
    }

    public WidgetParameter findParameter(WidgetInstParameter widgetInstParameter) throws WCMException {
        int n = widgetInstParameter.getWidgetInstId();
        WidgetInstance widgetInstance = WidgetInstance.findById(n);
        return this.findParameterByName(widgetInstance.getWidget(), widgetInstParameter.getParamName());
    }
}

