/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IWidgetMgr;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetConstants;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.WidgetParameters;
import com.trs.components.common.publish.widget.WidgetPathHelper;
import com.trs.components.common.publish.widget.WidgetXmlConverter;
import com.trs.components.common.publish.widget.Widgets;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.Reports;
import java.io.File;
import java.util.ArrayList;

public class WidgetMgr
implements IWidgetMgr {
    private Reports m_importReports;
    private static WidgetXmlConverter m_WidgetXmlConverter = null;
    private XmlToObjConverter m_converter = null;
    private IWidgetParameterMgr m_oIWidgetParameterMgr = null;
    private static final String Tag_WidgetParameters = "XWCMWIDGETPARAMETERS";
    private ThreadLocal m_oThreadLocal4ExistSimilarWidget = new ThreadLocal();

    public WidgetMgr() {
        m_WidgetXmlConverter = new WidgetXmlConverter();
        this.m_converter = new XmlToObjConverter(1);
        this.m_oIWidgetParameterMgr = (IWidgetParameterMgr)DreamFactory.createObjectById("IWidgetParameterMgr");
        this.registerConverter();
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("XWCMWIDGET", Widget.class);
        this.m_converter.registPersistentObj("XWCMWIDGETPARAMETER", WidgetParameter.class);
        this.m_converter.registPersistentObj(Tag_WidgetParameters, WidgetParameters.class);
    }

    public boolean delete(User user, Widget widget) throws Exception {
        WidgetParameters widgetParameters = this.m_oIWidgetParameterMgr.query(widget);
        int n = widgetParameters.size();
        for (int i = 0; i < n; ++i) {
            WidgetParameter widgetParameter = (WidgetParameter)widgetParameters.getAt(i);
            if (widgetParameter == null) continue;
            this.m_oIWidgetParameterMgr.delete(user, widgetParameter);
        }
        return widget.delete(user) == 1;
    }

    public Widgets query(User user, WCMFilter wCMFilter) throws Exception {
        Widgets widgets = Widgets.openWCMObjs(user, wCMFilter);
        return widgets;
    }

    public Widget saveWidget(User user, Widget widget) throws Exception {
        String string;
        String string2;
        if (widget == null) {
            throw new WCMException(200006, "\u65e0\u6548\u7684Widget\u5bf9\u8c61\uff0c\u65e0\u6cd5\u4fdd\u5b58.");
        }
        boolean bl = widget.isAddMode();
        String string3 = string2 = widget.isAddMode() ? widget.getPropertyAsString("WNAME") : widget.getNewPropertyAsString("WNAME");
        if (this.existSimilarWidget(widget)) {
            throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a[" + string2 + "]\u7684\u8d44\u6e90.");
        }
        if (bl) {
            String string4 = widget.getWidgetpic();
            if (!CMyString.isEmpty(string4)) {
                widget.setWidgetpic(this.copyFileToWebpic(string4));
            }
        } else if (widget.isChangeProperty("WIDGETPIC") && !CMyString.isEmpty(string = widget.getNewPropertyAsString("WIDGETPIC"))) {
            widget.setWidgetpic(this.copyFileToWebpic(string));
        }
        widget.save(user);
        this.saveInherentParam(user, widget, bl);
        return widget;
    }

    private void saveInherentParam(User user, Widget widget, boolean bl) throws WCMException {
        if (widget == null) {
            throw new WCMException(200006, "\u65e0\u6548\u7684Widget\u5bf9\u8c61\uff0c\u65e0\u6cd5\u4fdd\u5b58.");
        }
        for (int i = 0; i < WidgetConstants.FIEXED_PARAMETERS.length; ++i) {
            String string;
            String string2;
            WidgetParameter widgetParameter;
            String string3 = WidgetConstants.FIEXED_PARAMETERS[i][0];
            if (bl) {
                widgetParameter = new WidgetParameter();
                widgetParameter.setWidgetId(widget.getId());
                widgetParameter.setWidgetParamName(string3);
                widgetParameter.setWidgetParamDesc(WidgetConstants.FIEXED_PARAMETERS[i][1]);
                widgetParameter.setWidgetParamType(Integer.parseInt(WidgetConstants.FIEXED_PARAMETERS[i][2]));
                widgetParameter.setNotnull(Integer.parseInt(WidgetConstants.FIEXED_PARAMETERS[i][3]));
            } else {
                widgetParameter = this.m_oIWidgetParameterMgr.findParameterByName(widget, string3);
            }
            if (widgetParameter == null) {
                widgetParameter = new WidgetParameter();
                widgetParameter.setWidgetId(widget.getId());
                widgetParameter.setWidgetParamName(string3);
                widgetParameter.setWidgetParamDesc(WidgetConstants.FIEXED_PARAMETERS[i][1]);
                widgetParameter.setWidgetParamType(Integer.parseInt(WidgetConstants.FIEXED_PARAMETERS[i][2]));
                widgetParameter.setNotnull(Integer.parseInt(WidgetConstants.FIEXED_PARAMETERS[i][3]));
            }
            if (CMyString.isEmpty(string2 = WidgetConstants.FIEXED_PARAMETERS[i][4]) && !CMyString.isEmpty(string = WidgetConstants.FIEXED_PARAMETERS[i][5])) {
                string2 = widget.getPropertyAsString(string);
            }
            widgetParameter.setDefaultValue(CMyString.showNull(string2));
            this.m_oIWidgetParameterMgr.saveWidgetParameter(user, widgetParameter);
        }
    }

    public boolean existSimilarWidget(Widget widget) throws WCMException {
        Widgets widgets;
        boolean bl = widget.isAddMode();
        String string = null;
        string = bl ? widget.getPropertyAsString("WNAME") : widget.getNewPropertyAsString("WNAME");
        if (CMyString.isEmpty(string)) {
            return false;
        }
        String string2 = "WNAME=?";
        if (!bl) {
            string2 = string2 + " AND WIDGETID<>?";
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMWIDGET", string2, "", "WIDGETID");
        int n = widget.getId();
        wCMFilter.addSearchValues(string);
        if (!bl) {
            wCMFilter.addSearchValues(n);
        }
        return (widgets = Widgets.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter)).size() > 0;
    }

    private String copyFileToWebpic(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getFileFlag(string);
        String string3 = string;
        if (string2 != "W0") {
            string3 = filesMan.copyWCMFile(string, "W0");
        }
        return string3;
    }

    /*
     * Loose catch block
     */
    public String export(Widgets widgets) throws WCMException {
        String string;
        block8: {
            FilesMan filesMan = FilesMan.getFilesMan();
            string = filesMan.getNextFilePathName("ST", "zip");
            CMyZip cMyZip = new CMyZip();
            String string2 = null;
            cMyZip.setEncoding("UTF-8");
            cMyZip.setZipFileName(string);
            string2 = filesMan.getNextFileName("ST", "xml", null, true);
            m_WidgetXmlConverter.toXMLFile(widgets, string2);
            cMyZip.addToZip(string2, false);
            int n = widgets.size();
            for (int i = 0; i < n; ++i) {
                String string3;
                Widget widget = (Widget)widgets.getAt(i);
                if (widget == null || CMyString.isEmpty(string3 = CMyString.showNull(widget.getWidgetpic()))) continue;
                String string4 = this.getFullName(string3);
                cMyZip.addToZip(string4, false);
                String string5 = widget.getIdentityFlag(widget.getWname());
                String string6 = WidgetPathHelper.getPath();
                String string7 = string6 + string5 + ".js";
                if (!CMyFile.fileExists(string7)) continue;
                cMyZip.addToZip(string7, false);
            }
            cMyZip.done();
            Object var15_15 = null;
            try {
                CMyFile.deleteFile(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block8;
            {
                catch (CMyException cMyException) {
                    filesMan.deleteFile(string);
                    throw new WCMException(1100, "\u5bfc\u51fa\u8d44\u6e90\u65f6\uff0c\u538b\u7f29\u6587\u4ef6\u5931\u8d25.", cMyException);
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                try {
                    CMyFile.deleteFile(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return CMyFile.extractFileName(string);
    }

    public Reports importWidgets(String string, int n) throws WCMException {
        this.m_importReports = new Reports("");
        if (CMyString.isEmpty(string)) {
            throw new WCMException(10, "\u6587\u4ef6\u4e3a\u7a7a.");
        }
        String string2 = this.getFullName(string);
        String string3 = CMyFile.extractFilePath(string2) + "unzip" + System.currentTimeMillis();
        string3 = CMyString.setStrEndWith(string3, File.separatorChar);
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string2, string3);
        cMyUnZipFile.addFileExtFilters("xml");
        try {
            cMyUnZipFile.doUnZipAnd();
        }
        catch (CMyException cMyException) {
            throw new WCMException(200, "\u89e3\u538b\u7f29\u6587\u4ef6\u5931\u8d25.", cMyException);
        }
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        if (arrayList == null) {
            throw new WCMException(10, "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u8d44\u6e90\u4fe1\u606f\u7684xml\u6587\u4ef6.");
        }
        String string4 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            string4 = (String)arrayList.get(i);
            XmlObject[] xmlObjectArray = this.convertXmlFile(string4);
            this.importWidgets(xmlObjectArray, string3, n);
        }
        this.m_importReports.setTitle("\u4eceZip\u6587\u4ef6\u4e2d\u5bfc\u5165\u8d44\u6e90");
        CMyFile.deleteDir(string3);
        return this.m_importReports;
    }

    private void importWidgets(XmlObject[] xmlObjectArray, String string, int n) throws WCMException {
        int[] nArray = new int[xmlObjectArray.length];
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            Widget widget = this.importWidgetInfo(xmlObjectArray[i], string, n);
            if (widget == null) continue;
            nArray[i] = widget.getId();
        }
        this.m_importReports.setResultIds(nArray);
    }

    private Widget importWidgetInfo(XmlObject xmlObject, String string, int n) throws WCMException {
        if (xmlObject == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684\u8d44\u6e90\u63cf\u8ff0xml\u6587\u4ef6.");
        }
        BaseObj baseObj = xmlObject.getCurrentObj();
        Widget widget = null;
        try {
            widget = (Widget)baseObj;
            String string2 = widget.getWname();
            widget.setNextId();
            this.m_oThreadLocal4ExistSimilarWidget.set(Boolean.FALSE);
            if (this.existSimilarWidget(widget)) {
                this.m_oThreadLocal4ExistSimilarWidget.set(Boolean.TRUE);
                if (n == 1) {
                    this.WidgetThumbsHandler(widget, string);
                    this.WidgetOwnerJsHandler(widget, string);
                    Widget widget2 = this.findWidgetByName(ContextHelper.getLoginUser(), string2);
                    int n2 = widget2.getId();
                    widget2.setNewProperties(widget.getAllProperty());
                    widget2.setProperty("WIDGETID", n2);
                    widget2.setProperty("CrUser", ContextHelper.getLoginUser().getName());
                    widget2.setProperty("CrTime", CMyDateTime.now());
                    widget2.save(ContextHelper.getLoginUser());
                    this.importWidgetParameters(widget2, xmlObject, n);
                    this.m_importReports.addSucessedReport("\u5bfc\u5165\u8d44\u6e90[" + widget2.getWname() + "]\u6210\u529f.");
                    return widget2;
                }
                if (n == 3) {
                    this.changeWidgetName(widget, string);
                } else if (n == 2) {
                    WCMException wCMException = new WCMException("\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[" + string2 + "]\u7684\u8d44\u6e90,\u5ffd\u7565\u8be5\u5bfc\u5165");
                    this.m_importReports.addFailedReport("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u8d44\u6e90\uff0c\u60a8\u9009\u62e9\u4e86\u5ffd\u7565\u5904\u7406\uff0c\u6240\u4ee5\u5ffd\u7565\u8be5\u8d44\u6e90[" + string2 + "]\u7684\u5bfc\u5165", wCMException);
                    return null;
                }
            }
            this.WidgetThumbsHandler(widget, string);
            this.WidgetOwnerJsHandler(widget, string);
        }
        catch (Exception exception) {
            this.m_importReports.addFailedReport("\u5bfc\u5165\u8d44\u6e90\u5931\u8d25.", exception);
            return null;
        }
        try {
            widget.setCrUser(ContextHelper.getLoginUser());
            widget.setProperty("CrTime", CMyDateTime.now());
            this.saveWidget(ContextHelper.getLoginUser(), widget);
        }
        catch (Exception exception) {
            this.m_importReports.addFailedReport("\u5bfc\u5165\u8d44\u6e90[" + widget.getWname() + "]\u5931\u8d25.", exception);
            return null;
        }
        try {
            this.importWidgetParameters(widget, xmlObject, n);
        }
        catch (Exception exception) {
            this.m_importReports.addFailedReport("\u5bfc\u5165\u8d44\u6e90[" + widget.getWname() + "]\u5931\u8d25.", exception);
            return null;
        }
        this.m_importReports.addSucessedReport("\u5bfc\u5165\u8d44\u6e90[" + widget.getWname() + "]\u6210\u529f.");
        return widget;
    }

    private void WidgetOwnerJsHandler(Widget widget, String string) throws WCMException {
        try {
            String string2 = widget.getIdentityFlag(widget.getWname());
            String string3 = WidgetPathHelper.getPath();
            String string4 = string + string2 + ".js";
            String string5 = string3 + string2 + ".js";
            if (CMyFile.fileExists(string4)) {
                CMyFile.copyFile(string4, string5);
            }
        }
        catch (Exception exception) {
            this.m_importReports.addFailedReport("\u62f7\u8d1d\u8d44\u6e90\u7684\u9644\u52a0\u5904\u7406Js\u65f6\u5931\u8d25.", exception);
        }
    }

    private void WidgetThumbsHandler(Widget widget, String string) throws WCMException {
        String string2 = CMyString.showNull(widget.getWidgetpic());
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyString.isEmpty(string2)) {
            String string3 = string + string2;
            String string4 = this.getFullName(string2);
            String string5 = CMyFile.extractFileExt(string4);
            try {
                if (CMyFile.fileExists(string4)) {
                    String string6 = filesMan.getNextFilePathName("W0", string5);
                    CMyFile.copyFile(string3, string6);
                    widget.setWidgetpic(CMyFile.extractFileName(string6));
                } else {
                    CMyFile.copyFile(string3, string4);
                }
            }
            catch (Exception exception) {
                this.m_importReports.addFailedReport("\u62f7\u8d1d\u8d44\u6e90\u7684\u7f29\u7565\u56fe\u5931\u8d25.", exception);
            }
        }
    }

    private void importWidgetParameters(Widget widget, XmlObject xmlObject, int n) throws WCMException {
        XmlObject[] xmlObjectArray = xmlObject.getChild(Tag_WidgetParameters);
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importWidgetParameterInfo(widget, xmlObjectArray[i], n);
        }
    }

    private void importWidgetParameterInfo(Widget widget, XmlObject xmlObject, int n) throws WCMException {
        BaseObj baseObj = xmlObject.getCurrentObj();
        int n2 = widget.getId();
        WidgetParameter widgetParameter = (WidgetParameter)baseObj;
        if (widgetParameter == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684\u8d44\u6e90\u53d8\u91cf\u5bf9\u8c61.");
        }
        String string = widgetParameter.getDefaultValue();
        String string2 = widgetParameter.getWidgetParamName();
        boolean bl = WidgetConstants.FIEXED_PARAMETERS[2][0].equalsIgnoreCase(string2);
        if (bl) {
            boolean bl2;
            widgetParameter = this.findWidgetParamByName(n2, string2);
            boolean bl3 = bl2 = this.m_oThreadLocal4ExistSimilarWidget.get() == Boolean.TRUE;
            if (n != 1 || !bl2) {
                widgetParameter.setDefaultValue(string);
            }
        } else {
            widgetParameter.setNextId();
            if (this.m_oIWidgetParameterMgr.existWidgetParameter(widget, widgetParameter)) {
                if (n == 1) {
                    WidgetParameter widgetParameter2 = this.findWidgetParamByName(n2, string2);
                    if (widgetParameter2 != null) {
                        String string3 = widgetParameter2.getDefaultValue();
                        int n3 = widgetParameter2.getWidgetParamType();
                        boolean bl4 = n3 == widgetParameter.getWidgetParamType();
                        int n4 = widgetParameter2.getId();
                        widgetParameter2.setNewProperties(widgetParameter.getAllProperty());
                        if (bl4) {
                            widgetParameter2.setPropertyWithString("DEFAULTVALUE", string3);
                        }
                        widgetParameter2.setProperty("WIDGETPARAMETERID", n4);
                        widgetParameter2.setWidgetId(n2);
                        widgetParameter2.save();
                    }
                    return;
                }
                if (n == 3) {
                    this.changeNameIfNescessary(widget, widgetParameter);
                } else if (n == 2) {
                    WCMException wCMException = new WCMException("\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[" + string2 + "]\u7684\u8d44\u6e90\u53d8\u91cf,\u5ffd\u7565\u8be5\u5bfc\u5165");
                    this.m_importReports.addFailedReport("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u8d44\u6e90\u53d8\u91cf\uff0c\u60a8\u9009\u62e9\u4e86\u5ffd\u7565\u5904\u7406\uff0c\u6240\u4ee5\u5ffd\u7565\u8be5\u8d44\u6e90\u53d8\u91cf[" + string2 + "]\u7684\u5bfc\u5165", wCMException);
                    return;
                }
            }
            widgetParameter.setWidgetId(n2);
        }
        try {
            this.m_oIWidgetParameterMgr.saveWidgetParameter(ContextHelper.getLoginUser(), widgetParameter);
        }
        catch (Exception exception) {
            this.m_importReports.addWarnedReport("\u5bfc\u5165\u8d44\u6e90\u53d8\u91cf[" + widgetParameter.getWidgetParamName() + "]\u5931\u8d25.", exception);
        }
    }

    private WidgetParameter findWidgetParamByName(int n, String string) throws WCMException {
        String string2 = "WIDGETID =? and WIDGETPARAMNAME=?";
        WCMFilter wCMFilter = new WCMFilter("XWCMWIDGETPARAMETER", string2, "", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        WidgetParameters widgetParameters = WidgetParameters.openWCMObjs(null, wCMFilter);
        WidgetParameter widgetParameter = (WidgetParameter)widgetParameters.getAt(0);
        return widgetParameter;
    }

    private void changeNameIfNescessary(Widget widget, WidgetParameter widgetParameter) throws WCMException {
        boolean bl = this.m_oIWidgetParameterMgr.existWidgetParameter(widget, widgetParameter);
        if (!bl) {
            return;
        }
        int n = 0;
        while (bl) {
            String string = widgetParameter.getWidgetParamName();
            string = string + n;
            widgetParameter.setWidgetParamName(string);
            ++n;
            bl = this.m_oIWidgetParameterMgr.existWidgetParameter(widget, widgetParameter);
        }
    }

    private void changeWidgetName(Widget widget, String string) throws WCMException {
        int n = 1;
        boolean bl = this.existSimilarWidget(widget);
        String string2 = widget.getWname();
        while (bl) {
            String string3 = widget.getIdentityFlag(widget.getWname());
            String string4 = string + string3 + ".js";
            string2 = string2 + "_" + widget.getId();
            widget.setPropertyWithString("Wname", string2);
            String string5 = string + widget.getIdentityFlag(string2) + ".js";
            File file = new File(string4);
            if (file.exists()) {
                File file2 = new File(string5);
                file.renameTo(file2);
            }
            ++n;
            bl = this.existSimilarWidget(widget);
            if (!bl) continue;
            this.changeWidgetName(widget, string);
        }
    }

    private XmlObject[] convertXmlFile(String string) throws WCMException {
        try {
            XmlObject[] xmlObjectArray = this.m_converter.convertXml(string, null, null);
            return xmlObjectArray;
        }
        catch (Throwable throwable) {
            throw new WCMException(150, "\u8f6c\u6362XML\u6587\u4ef6\u5931\u8d25!\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u8d44\u6e90\u63cf\u8ff0xml\u6587\u4ef6", throwable);
        }
    }

    private String getFullName(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(string)) {
            String string2 = filesMan.mapFilePath(string, 0);
            string = string2 + string;
        }
        return string;
    }

    public Widget findWidgetByName(User user, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter(null, "WNAME=?", "WIDGETID desc");
        wCMFilter.addSearchValues(string);
        Widgets widgets = Widgets.openWCMObjs(user, wCMFilter);
        return widgets.size() > 0 ? (Widget)widgets.getAt(0) : null;
    }
}

