/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IStyleAndResourceMgr;
import com.trs.components.common.publish.widget.StyleAndResource;
import com.trs.components.common.publish.widget.StyleAndResources;
import com.trs.components.common.publish.widget.Widget;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.HashMap;

public class StyleAndResourceMgr
implements IStyleAndResourceMgr {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(User user, StyleAndResource styleAndResource) throws WCMException {
        if (styleAndResource == null) {
            return;
        }
        styleAndResource.delete();
    }

    public ContentStyles getContentStyles(Widget widget, WCMFilter wCMFilter) throws WCMException {
        if (widget == null) {
            throw new WCMException("\u4f20\u5165\u7684\u7cfb\u7edf\u8d44\u6e90\u4e3anull\uff01");
        }
        int n = widget.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "EXISTS(SELECT StyleObjId FROM XWCMSTYLEANDRESOURCE WHERE ResourceId=? AND XWCMSTYLEANDRESOURCE.StyleObjId=XWCMCONTENTSTYLE.CONTENTSTYLEID)", "CONTENTSTYLEID");
        wCMFilter2.addSearchValues(n);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        return ContentStyles.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public StyleAndResource save(User user, StyleAndResource styleAndResource) throws WCMException {
        if (styleAndResource == null) {
            throw new WCMException("\u8981\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a!StyleAndResource=[" + styleAndResource + "]");
        }
        if (styleAndResource.isAddMode()) {
            styleAndResource.insert();
        } else {
            styleAndResource.update();
        }
        return styleAndResource;
    }

    public void deleteUnuseCSRItems(Widget widget, String string) throws WCMException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (widget == null) {
            throw new WCMException(20, "\u8d44\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u8d44\u6e90\u4e0e\u98ce\u683c\u7684\u5173\u8054\u9879\uff01");
        }
        String string2 = "styleobjid not in (" + string + ")";
        WCMFilter wCMFilter = new WCMFilter("", string2, "", "");
        StyleAndResources styleAndResources = this.getContentStyleAndResource(widget, wCMFilter);
        for (int i = 0; i < styleAndResources.size(); ++i) {
            this.delete(this.getLoginUser(), (StyleAndResource)styleAndResources.getAt(i));
        }
    }

    public StyleAndResources getContentStyleAndResource(Widget widget, WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        if (widget == null) {
            throw new WCMException("\u4f20\u5165\u7684\u8d44\u6e90\u4e3anull \uff01");
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "ResourceId=? and STYLEOBJTYPE=?  ", "");
        wCMFilter2.addSearchValues(widget.getId());
        wCMFilter2.addSearchValues(1791765043);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        return StyleAndResources.openWCMObjs(user, wCMFilter2);
    }

    public HashMap getContentStyleAndResourceMap(Widget widget, WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        if (widget == null) {
            throw new WCMException("\u4f20\u5165\u7684\u8d44\u6e90\u4e3anull \uff01");
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "ResourceId=? and STYLEOBJTYPE=?  ", "");
        wCMFilter2.addSearchValues(widget.getId());
        wCMFilter2.addSearchValues(1791765043);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        StyleAndResources styleAndResources = StyleAndResources.openWCMObjs(user, wCMFilter2);
        HashMap<String, StyleAndResource> hashMap = new HashMap<String, StyleAndResource>();
        if (styleAndResources == null || styleAndResources.size() < 1) {
            return hashMap;
        }
        for (int i = 0; i < styleAndResources.size(); ++i) {
            StyleAndResource styleAndResource = (StyleAndResource)styleAndResources.getAt(i);
            if (styleAndResource == null) continue;
            hashMap.put(styleAndResource.getCssFlag(), styleAndResource);
        }
        return hashMap;
    }
}

