/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleHelper;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StyleRepeatNameHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;

public class ResourceStyleMgr
implements IResourceStyleMgr {
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(User user, ResourceStyle resourceStyle) throws WCMException {
        if (resourceStyle == null) {
            return;
        }
        this.m_oStyleItemMgr.delete(user, resourceStyle);
        resourceStyle.delete(user);
    }

    public String makeCssContent(ResourceStyle resourceStyle) throws WCMException {
        if (resourceStyle == null) {
            return "";
        }
        String string = resourceStyle.getCustomStyle();
        if (string != null && !string.trim().equals("")) {
            return StyleHelper.makeCustomCssContent(resourceStyle.getCssFlag(), string);
        }
        String string2 = resourceStyle.getTemplate();
        if (string2 == null || string2.equals("")) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u53ef\u7528\u98ce\u683c\u6a21\u677f\u540d\u79f0\u5931\u8d25\uff01sTemplateName=[" + string2 + "]");
        }
        String string3 = StyleHelper.getCssTemplateFilePath() + string2;
        String string4 = "";
        try {
            string4 = CMyFile.readFile(string3, "UTF-8");
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
        if (string4 == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + string2);
        }
        if (string4.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + string2);
        }
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(resourceStyle, null);
        return StyleHelper.makeCSSContent(resourceStyle.getCssFlag(), string4, styleItems);
    }

    public ResourceStyles query(PageStyle pageStyle, WCMFilter wCMFilter) throws WCMException {
        int n = pageStyle == null ? 0 : pageStyle.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "PageStyleId=?", "");
        wCMFilter2.addSearchValues(n);
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        return ResourceStyles.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public ResourceStyle save(User user, ResourceStyle resourceStyle) throws WCMException {
        if (resourceStyle == null) {
            throw new WCMException("\u8981\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a!ResourceStyle=[" + resourceStyle + "]");
        }
        if (resourceStyle.isAddMode()) {
            resourceStyle.insert(user);
        } else {
            resourceStyle.update(user);
        }
        return resourceStyle;
    }

    public ResourceStyle copy(User user, PageStyle pageStyle, ResourceStyle resourceStyle) throws WCMException {
        if (resourceStyle == null) {
            return null;
        }
        int n = 0;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        ResourceStyle resourceStyle2 = (ResourceStyle)resourceStyle.cloneToNewObj();
        resourceStyle2.setPageStyleId(n);
        resourceStyle2.setSrcResourceStyleId(resourceStyle.getId());
        if (resourceStyle.getPageStyleId() == 0 || n == 0) {
            resourceStyle2.setIsPrivate(0);
        } else {
            resourceStyle2.setIsPrivate(1);
        }
        if (n == resourceStyle.getPageStyleId()) {
            resourceStyle2.setCssFlag(this.makeCssFlag(pageStyle));
        }
        this.save(user, resourceStyle2);
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(resourceStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            StyleItem styleItem2 = (StyleItem)styleItem.cloneToNewObj();
            this.m_oStyleItemMgr.save(user, resourceStyle2, styleItem2);
        }
        return resourceStyle2;
    }

    public ResourceStyle copy(User user, PageStyle pageStyle, ResourceStyle resourceStyle, int n, Reports reports) throws WCMException {
        Object object;
        Object object2;
        Object object3;
        if (resourceStyle == null) {
            return null;
        }
        int n2 = 0;
        if (pageStyle != null) {
            n2 = pageStyle.getId();
        }
        ResourceStyle resourceStyle2 = (ResourceStyle)resourceStyle.cloneToNewObj();
        String string = pageStyle == null ? "\u7cfb\u7edf\u8d44\u6e90\u98ce\u683c" : "\u9875\u9762\u98ce\u683c\u3010" + pageStyle.getStyleDesc() + "\u3011";
        ResourceStyle resourceStyle3 = ResourceStyles.findByCssFlagAndPageStyle(user, resourceStyle2.getCssFlag(), n2);
        if (resourceStyle3 != null) {
            object3 = resourceStyle3.getCssFlag();
            String string2 = resourceStyle3.getStyleName();
            object2 = StyleRepeatNameHelper.processCssFlag((String)object3, n, 2);
            object = StyleRepeatNameHelper.processStyleName(string2, n, 2);
            if (object2 == null) {
                reports.addSucessedReport(CMyString.format("\u5ffd\u7565\u5c06\u8d44\u6e90\u98ce\u683c{0}\u590d\u5236\u5230{1}!", new String[]{object3, string}));
                return null;
            }
            if (((String)object2).equals(object3)) {
                this.delete(this.getLoginUser(), resourceStyle3);
                reports.addSucessedReport(CMyString.format("\u8986\u76d6\u4e86{0}\u4e0b\u540c\u540d\u7684\u8d44\u6e90\u98ce\u683c!", new String[]{string}));
            } else {
                resourceStyle2.setCssFlag((String)object2);
                resourceStyle2.setStyleName((String)object);
                resourceStyle2.setStyleDesc((String)object);
                reports.addSucessedReport(CMyString.format("\u590d\u5236\u8d44\u6e90\u98ce\u683c\u5230{0}\u6210\u529f!", new String[]{string}));
            }
        }
        resourceStyle2.setPageStyleId(n2);
        resourceStyle2.setSrcResourceStyleId(resourceStyle.getId());
        if (resourceStyle.getPageStyleId() == 0 || n2 == 0) {
            resourceStyle2.setIsPrivate(0);
        } else {
            resourceStyle2.setIsPrivate(1);
        }
        if (n2 == resourceStyle.getPageStyleId()) {
            resourceStyle2.setCssFlag(this.makeCssFlag(pageStyle));
        }
        this.save(user, resourceStyle2);
        object3 = this.m_oStyleItemMgr.queryStyleItems(resourceStyle, null);
        for (int i = 0; i < ((BaseObjs)object3).size(); ++i) {
            object2 = (StyleItem)((BaseObjs)object3).getAt(i);
            if (object2 == null) continue;
            object = (StyleItem)((BaseObj)object2).cloneToNewObj();
            this.m_oStyleItemMgr.save(user, resourceStyle2, (StyleItem)object);
        }
        if (resourceStyle3 == null) {
            reports.addSucessedReport(CMyString.format("\u590d\u5236\u8d44\u6e90\u98ce\u683c\u5230{0}\u6210\u529f!", new String[]{string}));
        }
        return resourceStyle2;
    }

    private String makeCssFlag(PageStyle pageStyle) throws WCMException {
        ResourceStyles resourceStyles = this.getResourceStyles(pageStyle);
        if (resourceStyles.size() < 10) {
            return "f0" + resourceStyles.size();
        }
        return "f" + resourceStyles.size();
    }

    public ResourceStyles getResourceStyles(PageStyle pageStyle) throws WCMException {
        int n = pageStyle == null ? 0 : pageStyle.getId();
        WCMFilter wCMFilter = new WCMFilter("", "PageStyleId=?", "");
        wCMFilter.addSearchValues(n);
        return ResourceStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    public boolean checkCssFlag(PageStyle pageStyle, ResourceStyle resourceStyle, String string) throws WCMException {
        int n = 0;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        WCMFilter wCMFilter = new WCMFilter("", "PageStyleId=? and CssFlag='" + string + "'", "");
        wCMFilter.addSearchValues(n);
        ResourceStyles resourceStyles = ResourceStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (resourceStyle != null) {
            resourceStyles.remove(resourceStyle, false);
        }
        return resourceStyles == null || resourceStyles.isEmpty();
    }

    public boolean checkStyleName(PageStyle pageStyle, ResourceStyle resourceStyle, String string) throws WCMException {
        int n = 0;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        WCMFilter wCMFilter = new WCMFilter("", "PageStyleId=? and StyleName='" + string + "'", "");
        wCMFilter.addSearchValues(n);
        ResourceStyles resourceStyles = ResourceStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (resourceStyle != null) {
            resourceStyles.remove(resourceStyle, false);
        }
        return resourceStyles == null || resourceStyles.isEmpty();
    }

    public ResourceStyles findByCssFlagAndPageStyle(String string, PageStyle pageStyle) throws WCMException {
        int n = 0;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        String string2 = "CssFlag='" + string + "'";
        if (n > 0) {
            string2 = string2 + " and PageStyleId=" + n;
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        ResourceStyles resourceStyles = ResourceStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
        return resourceStyles;
    }

    public ResourceStyles findByStyleNameAndPageStyle(String string, PageStyle pageStyle) throws WCMException {
        int n = 0;
        if (pageStyle != null) {
            n = pageStyle.getId();
        }
        String string2 = "StyleName='" + string + "'";
        if (n > 0) {
            string2 = string2 + " and PageStyleId=" + n;
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        ResourceStyles resourceStyles = ResourceStyles.openWCMObjs(this.getLoginUser(), wCMFilter);
        return resourceStyles;
    }
}

