/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.components.common.publish.widget.StyleRepeatNameHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResourceStyleImporter {
    private static Logger s_logger = Logger.getLogger(ResourceStyleImporter.class);
    private XmlToObjConverter m_converter = null;
    private final Map m_ResourceStyleIds = new HashMap();
    private static final String PROPERTY_CRUSER = "CRUSER";
    private static final String PROPERTY_CRTIME = "CRTIME";
    private static final char CHAR_S = 'S';
    private static final String TAG_STYLE_ITEMS = "XWCMSTYLEITEMS";
    private IStyleItemMgr m_oStyleItemMgr = null;
    private IResourceStyleMgr m_oResourceStyleMgr = null;
    private Reports m_reports;
    private ArrayList m_successIdList;

    public ResourceStyleImporter() {
        this.m_converter = new XmlToObjConverter(1);
        this.registerConverter();
        this.m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
        this.m_oResourceStyleMgr = (IResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
    }

    public Reports importFromFile(String string, int n, int n2) throws Exception {
        this.checkFile(string);
        String string2 = this.getFullName(string);
        this.m_reports = new Reports("");
        this.m_successIdList = new ArrayList();
        return this.importFromZip(string2, n, n2);
    }

    private Reports importFromZip(String string, int n, int n2) throws Exception {
        Object object;
        String string2 = CMyFile.extractFilePath(string) + "unzip" + System.currentTimeMillis();
        string2 = CMyString.setStrEndWith(string2, File.separatorChar);
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, string2);
        try {
            cMyUnZipFile.doUnZipAnd();
        }
        catch (CMyException cMyException) {
            this.m_reports.setTitle("\u89e3\u538b\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01");
            this.m_reports.addFailedReport("\u89e3\u538b\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", cMyException);
            return this.m_reports;
        }
        File[] fileArray = CMyFile.listSubDirectories(string2);
        if (fileArray == null || fileArray.length == 0) {
            this.m_reports.setTitle("\u5f85\u5bfc\u5165\u7684zip\u6587\u4ef6\u4e2d\u6ca1\u6709\u5305\u542b\u4efb\u4f55\u9875\u9762\u98ce\u683c\u4e0b\u7684\u8d44\u6e90\u98ce\u683c\uff01");
            return this.m_reports;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File[] fileArray2;
            object = fileArray[i];
            if (!((File)object).exists()) continue;
            String string3 = ((File)object).getAbsolutePath();
            String string4 = CMyFile.extractFileName(string3);
            PageStyle pageStyle = PageStyle.findByName(string4);
            if (pageStyle == null) {
                this.copyImportResourceStylesImgs(string4, string3);
                continue;
            }
            int n3 = pageStyle.getId();
            if (n2 > 0 && n3 != n2 || (fileArray2 = CMyFile.listFiles(string3, ".xml")) == null || fileArray2.length == 0) continue;
            File file = fileArray2[0];
            String string5 = file.getAbsolutePath();
            XmlObject[] xmlObjectArray = this.convertXmlFile(string5, null);
            string3 = CMyString.setStrEndWith(string3, File.separatorChar);
            this.importResourceStyles(xmlObjectArray, string3, n, n3);
            this.copyImportResourceStylesImgs(string4, string3);
            IStyleCenterMgr iStyleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
            iStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
        }
        CMyFile.deleteDir(string2);
        this.m_reports.setTitle("\u4eceZip\u6587\u4ef6\u4e2d\u5bfc\u5165\u8d44\u6e90\u98ce\u683c");
        Object[] objectArray = this.m_successIdList.toArray();
        if (objectArray.length == 0 && n2 > 0) {
            this.m_reports.setTitle("\u6ca1\u6709\u627e\u5230\u5f53\u524d\u9875\u9762\u98ce\u683c\u5bf9\u5e94\u7684\u8d44\u6e90\u98ce\u683c\uff01");
            return this.m_reports;
        }
        object = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            object[i] = Integer.parseInt(objectArray[i].toString());
        }
        this.m_reports.setResultIds((int[])object);
        return this.m_reports;
    }

    private void copyImportResourceStylesImgs(String string, String string2) throws CMyException {
        String string3 = StylePathHelper.getStyleCommonDir(string);
        if (!CMyFile.fileExists(string3)) {
            CMyFile.makeDir(string3, true);
        }
        string3 = CMyString.setStrEndWith(string3, File.separatorChar);
        File file = new File(string2 = CMyString.setStrEndWith(string2, File.separatorChar) + "resource");
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.exists()) continue;
            CMyFile.copyFile(file2.getAbsolutePath(), string3 + file2.getName());
        }
    }

    private void importResourceStyles(XmlObject[] xmlObjectArray, String string, int n, int n2) throws Exception {
        int[] nArray = new int[xmlObjectArray.length];
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            ResourceStyle resourceStyle = this.importOneResourceStyle(xmlObjectArray[i], string, n, n2);
            if (resourceStyle == null) continue;
            nArray[i] = resourceStyle.getId();
        }
        this.m_reports.setResultIds(nArray);
    }

    private ResourceStyle importOneResourceStyle(XmlObject xmlObject, String string, int n, int n2) throws Exception {
        if (xmlObject == null) {
            return null;
        }
        this.validateXmlObject(xmlObject);
        ResourceStyle resourceStyle = (ResourceStyle)xmlObject.getCurrentObj();
        if (resourceStyle == null) {
            return null;
        }
        String string2 = resourceStyle.getStyleName();
        resourceStyle = this.importResourceStyleToPageStyle(resourceStyle, xmlObject.getChild(TAG_STYLE_ITEMS), n, string, n2);
        String string3 = PageStyle.findById(n2).getStyleDesc();
        if (resourceStyle == null) {
            if (n == 2) {
                this.m_reports.addWarnedReport("\u5bfc\u5165\u9875\u9762\u98ce\u683c(" + string3 + ")\u4e0b\u7684\u8d44\u6e90\u98ce\u683c\u3010" + string2 + "\u3011\u5931\u8d25\uff0c\u56e0\u4e3a\u5df2\u7ecf\u5b58\u5728\u4e86\u540c\u540d\u7684\u98ce\u683c", null);
                return null;
            }
            this.m_reports.addFailedReport("\u5bfc\u5165\u3010" + string2 + "\u3011\u5931\u8d25", new WCMException("\u5bfc\u5165\u98ce\u683c\u5bf9\u8c61\u5931\u8d25\uff01"));
            throw new WCMException("\u5bfc\u5165\u98ce\u683c\u5bf9\u8c61\u5931\u8d25\uff01");
        }
        this.m_reports.addSucessedReport("\u5bfc\u5165\u9875\u9762\u98ce\u683c(" + string3 + ")\u4e0b\u7684\u8d44\u6e90\u98ce\u683c\u3010" + resourceStyle.getStyleName() + "\u3011\u6210\u529f\uff01");
        this.m_successIdList.add(resourceStyle.getId() + "");
        return resourceStyle;
    }

    private void validateXmlObject(XmlObject xmlObject) throws WCMException {
        BaseObj baseObj = xmlObject.getCurrentObj();
        if (baseObj == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684\u8d44\u6e90\u98ce\u683c\u63cf\u8ff0xml\u6587\u4ef6.");
        }
        if (!(baseObj instanceof ResourceStyle)) {
            throw new WCMException("\u5bf9\u8c61\u4e0d\u662f[currObj" + baseObj.getClass().getName() + "]\u4e0d\u662fResourceStyle\u5bf9\u8c61\u7c7b\u578b\uff01");
        }
    }

    public ResourceStyle importResourceStyleToPageStyle(ResourceStyle resourceStyle, XmlObject[] xmlObjectArray, int n, String string, int n2) throws WCMException {
        String string2;
        Object object;
        Object object2;
        if (resourceStyle == null || xmlObjectArray == null) {
            return null;
        }
        int n3 = resourceStyle.getPropertyAsInt("RESOURCESTYLEID", 0);
        ResourceStyle resourceStyle2 = ResourceStyles.findByCssFlagAndPageStyle(this.getLoginUser(), resourceStyle.getCssFlag(), 0);
        int n4 = -1;
        if (resourceStyle2 != null) {
            n4 = resourceStyle2.getId();
        }
        ResourceStyle resourceStyle3 = ResourceStyles.findByCssFlagAndPageStyle(this.getLoginUser(), resourceStyle.getCssFlag(), n2);
        boolean bl = false;
        String string3 = resourceStyle.getStyleThumb();
        if (resourceStyle3 != null) {
            bl = true;
            switch (n) {
                case 2: {
                    return null;
                }
                case 1: {
                    this.m_oStyleItemMgr.delete(this.getLoginUser(), resourceStyle3);
                    object2 = resourceStyle.getAllProperty();
                    ((Hashtable)object2).remove("RESOURCESTYLEID");
                    ((Hashtable)object2).remove("SrcResourceStyleId");
                    ((Hashtable)object2).remove("STYLETHUMB");
                    resourceStyle = resourceStyle3;
                    resourceStyle.setNewProperties((Hashtable)object2);
                    break;
                }
                case 3: {
                    object = StyleRepeatNameHelper.getNewCssFlag(resourceStyle.getCssFlag(), 2, n2);
                    string2 = StyleRepeatNameHelper.getNewName(resourceStyle.getStyleName(), 2, n2);
                    resourceStyle.setCssFlag((String)object);
                    resourceStyle.setStyleName(string2);
                    resourceStyle.setStyleDesc(string2);
                    resourceStyle.setNextId();
                }
            }
        } else {
            resourceStyle.setNextId();
            resourceStyle.setSrcResourceStyleId(n4);
        }
        resourceStyle.setStyleThumb(string3);
        if (!CMyString.isEmpty(string3) && ((File)(object = new File((String)(object2 = string + "thumb" + File.separator + string3)))).exists()) {
            string2 = this.copyFileIfNeed((String)object2, true);
            resourceStyle.setStyleThumb(string2);
        }
        resourceStyle.setPageStyleId(n2);
        object2 = this.getLoginUser();
        resourceStyle.setProperty(PROPERTY_CRUSER, ((User)object2).getName());
        resourceStyle.setProperty(PROPERTY_CRTIME, CMyDateTime.now());
        resourceStyle.save((User)object2);
        this.m_ResourceStyleIds.put(this.makeResourceStyleIdMapKey(1004807208, String.valueOf(n3)), new Integer(resourceStyle.getId()));
        this.importStyleItems(xmlObjectArray, this.m_ResourceStyleIds, n, bl, n2);
        resourceStyle2 = ResourceStyles.findByCssFlagAndPageStyle(this.getLoginUser(), resourceStyle.getCssFlag(), 0);
        if (resourceStyle2 == null) {
            this.m_oResourceStyleMgr.copy(ContextHelper.getLoginUser(), null, resourceStyle);
        } else {
            object = resourceStyle.getStyleThumb();
            if (!CMyString.isEmpty((String)object)) {
                resourceStyle2.setStyleThumb((String)object);
                resourceStyle2.save((User)object2);
            }
        }
        return resourceStyle;
    }

    private void importStyleItems(XmlObject[] xmlObjectArray, Map map, int n, boolean bl, int n2) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importOneStyleItem(xmlObjectArray[i], map, n, bl, n2);
        }
    }

    private void importOneStyleItem(XmlObject xmlObject, Map map, int n, boolean bl, int n2) throws WCMException {
        if (xmlObject == null) {
            return;
        }
        if (map == null) {
            throw new WCMException("\u4f20\u5165\u7684ids\u6620\u5c04\u5173\u7cfbmap\u4e3anull\uff01");
        }
        if (bl && n == 2) {
            return;
        }
        StyleItem styleItem = null;
        int n3 = 0;
        try {
            styleItem = (StyleItem)xmlObject.getCurrentObj();
            n3 = styleItem.getPropertyAsInt("STYLEITEMID", 0);
            int n4 = styleItem.getStyleObjType();
            int n5 = styleItem.getStyleObjId();
            String string = this.makeResourceStyleIdMapKey(n4, String.valueOf(n5));
            Integer n6 = (Integer)map.get(string);
            if (n6 == null) {
                throw new WCMException("Map\u4e2d[key=" + string + "]\u5bf9\u5e94\u7684\u98ce\u683cid\u4e0d\u5b58\u5728\uff01");
            }
            styleItem.setStyleObjId(n6);
            styleItem.setNextId();
            styleItem.removeProperty(PROPERTY_CRTIME);
            styleItem.removeProperty(PROPERTY_CRUSER);
            styleItem.save(this.getLoginUser());
        }
        catch (Throwable throwable) {
            String string = "\u5bfc\u5165StyleItem\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25";
            if (styleItem != null) {
                string = string + "[\u6e90Id=" + n3 + "]\uff01";
            }
            s_logger.debug((Object)string, throwable);
            this.m_reports.addWarnedReport(string, throwable);
        }
    }

    private String getFullName(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(string)) {
            String string2 = filesMan.mapFilePath(string, 0);
            string = string2 + string;
        }
        return string;
    }

    private XmlObject[] convertXmlFile(String string, String string2) throws WCMException {
        try {
            XmlObject[] xmlObjectArray = this.m_converter.convertXml(string, string2, null);
            return xmlObjectArray;
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)"failed to convert xml to object!", throwable);
            throw new WCMException("\u8f6c\u6362XML\u6587\u4ef6\u5931\u8d25!\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u9875\u9762\u98ce\u683c\u63cf\u8ff0xml\u6587\u4ef6", throwable);
        }
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("XWCMPAGESTYLE", PageStyle.class);
        this.m_converter.registPersistentObj("XWCMRESOURCESTYLE", ResourceStyle.class);
        this.m_converter.registPersistentObj("XWCMCONTENTSTYLE", ContentStyle.class);
        this.m_converter.registPersistentObj("XWCMSTYLEITEM", StyleItem.class);
    }

    private String makeResourceStyleIdMapKey(int n, String string) {
        return n + ":" + string;
    }

    private void checkFile(String string) throws WCMException {
        if (string == null || string.length() == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u6587\u4ef6\u540d\u65e0\u6548\uff01");
        }
        String string2 = CMyFile.extractFileExt(string);
        if (!"zip".equalsIgnoreCase(string2)) {
            throw new WCMException("\u53ea\u652f\u6301\u4eceZIP\u6587\u4ef6\u4e2d\u5bfc\u5165!");
        }
    }

    private String copyFileIfNeed(String string, boolean bl) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!bl) {
            String string2 = filesMan.getFileFlag(string);
            String string3 = string;
            if (string2 != "W0") {
                string3 = filesMan.copyWCMFile(string, "W0");
            }
            return string3;
        }
        return CMyFile.extractFileName(filesMan.copyFile(string, "W0", true));
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public static void main(String[] stringArray) throws Exception {
        ContextHelper.initContext(User.findByName("admin"));
        String string = "D:\\TRS\\TRSWCMV61\\WCMData\\upload\\U0201103\\U020110318\\U020110318473705563421.zip";
        ResourceStyleImporter resourceStyleImporter = new ResourceStyleImporter();
        resourceStyleImporter.importFromFile("U020110322488147345883.zip", 3, 0);
    }
}

