/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleXmlConverter;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ResourceStyleExporter {
    private static Logger logger = Logger.getLogger(ResourceStyleExporter.class);
    private String m_sXMLEncoding = "UTF-8";
    private String[] m_aImageClassNameStyleItems = new String[]{"p_w_head_background", "p_w_more_background", "p_w_body_background", "p_w_body_bg_background", "p_w_foot_background", "p_w_foot_bg_background", "p_w_content_background"};
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");

    public String export(ResourceStyles resourceStyles, int n) throws Exception {
        if (resourceStyles == null) {
            throw new WCMException("\u5bfc\u51fa\u7684ResourceStyle\u5bf9\u8c61\u4e3anull!");
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", "zip", null, true);
        CMyZip cMyZip = new CMyZip();
        cMyZip.setZipFileName(string);
        String string2 = CMyFile.extractFilePath(string);
        CMyDateTime cMyDateTime = CMyDateTime.now();
        String string3 = string2 + cMyDateTime.toString("yyyy-MM-dd") + "_" + System.currentTimeMillis() + "_temp";
        CMyFile.makeDir(string3, true);
        try {
            try {
                Object object;
                int n2;
                File[] fileArray;
                if (n > 0) {
                    fileArray = PageStyle.findById(n);
                    this.exportResourceStylesForOnePageStyle(resourceStyles, (PageStyle)fileArray, string3);
                } else {
                    fileArray = this.m_oPageStyleMgr.query(null);
                    int n3 = fileArray.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        object = (PageStyle)fileArray.getAt(n2);
                        if (object == null) continue;
                        int n4 = ((BaseObj)object).getId();
                        ResourceStyles resourceStyles2 = new ResourceStyles(this.getLoginUser());
                        int n5 = resourceStyles.size();
                        for (int i = 0; i < n5; ++i) {
                            String string4;
                            ResourceStyles resourceStyles3;
                            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
                            if (resourceStyle == null || (resourceStyles3 = ResourceStyles.findSameCssFlagStyles(string4 = resourceStyle.getCssFlag(), n4)) == null || resourceStyles3.size() == 0) continue;
                            resourceStyles2.addElement(resourceStyles3.getAt(0));
                        }
                        this.exportResourceStylesForOnePageStyle(resourceStyles2, (PageStyle)object, string3);
                    }
                }
                cMyZip.setZipWithChildDirPath(true);
                fileArray = CMyFile.listSubDirectories(string3);
                for (n2 = 0; n2 < fileArray.length; ++n2) {
                    File file = fileArray[n2];
                    object = file.getAbsolutePath();
                    cMyZip.addToZip((String)object, false);
                }
                cMyZip.done();
            }
            catch (Exception exception) {
                logger.error((Object)"failed to zip files!", (Throwable)exception);
                CMyFile.deleteFile(string);
                throw new WCMException(1100, "\u538b\u7f29\u6587\u4ef6\u5931\u8d25!", exception);
            }
            Object var21_22 = null;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            CMyFile.deleteDir(string3);
            throw throwable;
        }
        CMyFile.deleteDir(string3);
        return CMyFile.extractFileName(string);
    }

    private void exportResourceStylesForOnePageStyle(ResourceStyles resourceStyles, PageStyle pageStyle, String string) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFileName("ST", "xml", null, true);
        ResourceStyleXmlConverter resourceStyleXmlConverter = new ResourceStyleXmlConverter();
        resourceStyleXmlConverter.setXmlEncoding(this.m_sXMLEncoding);
        resourceStyleXmlConverter.toXMLFile(resourceStyles, string2);
        String string3 = pageStyle.getStyleName();
        String string4 = string + File.separator + string3 + File.separator;
        CMyFile.makeDir(string4, true);
        String string5 = CMyFile.extractFileName(string2);
        CMyFile.copyFile(string2, string4 + string5);
        CMyFile.deleteFile(string2);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null) continue;
            String string6 = string4 + "thumb" + File.separator;
            if (!CMyFile.fileExists(string6)) {
                CMyFile.makeDir(string6, true);
            }
            this.addResourceStyleThumbFolder(resourceStyle, string6);
            String string7 = StylePathHelper.getStyleCommonDir();
            this.addStyleItemImagesFolder(resourceStyle, string7, string);
        }
    }

    private void addStyleItemImagesFolder(ResourceStyle resourceStyle, String string, String string2) throws Exception {
        if (resourceStyle == null) {
            return;
        }
        ArrayList arrayList = this.getResourceStyleItemImages(resourceStyle, string);
        for (int i = 0; i < arrayList.size(); ++i) {
            File file;
            String string3 = (String)arrayList.get(i);
            if (CMyString.isEmpty(string3) || !(file = new File(string3)).exists()) continue;
            String string4 = file.getName();
            String string5 = CMyFile.extractFilePath(string3);
            string5 = string5.substring(0, string5.length() - 1);
            int n = string5.lastIndexOf(File.separatorChar);
            String string6 = CMyString.setStrEndWith(string2, File.separatorChar);
            String string7 = string5.substring(n + 1);
            if (!CMyFile.fileExists(string6 = string6 + string7 + File.separatorChar + "resource" + File.separatorChar)) {
                CMyFile.makeDir(string6, true);
            }
            CMyFile.copyFile(string3, string6 + string4, false);
        }
    }

    private void addResourceStyleThumbFolder(ResourceStyle resourceStyle, String string) throws Exception {
        if (resourceStyle == null) {
            return;
        }
        String string2 = resourceStyle.getStyleThumb();
        if (CMyString.isEmpty(string2)) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string3 = filesMan.mapFilePath(string2, 0) + string2;
        CMyFile.copyFile(string3, string + string2);
    }

    public ArrayList getResourceStyleItemImages(ResourceStyle resourceStyle, String string) throws WCMException {
        if (resourceStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684\u5185\u5bb9\u6837\u5f0f\u5bf9\u8c61\u4e3anull\uff01");
        }
        if (string == null) {
            throw new WCMException("\u8bf7\u4f20\u5165\u5f53\u524d\u5185\u5bb9\u6837\u5f0f\u7f29\u7565\u56fe\u5b58\u653e\u7684\u8def\u5f84\uff01");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        WCMFilter wCMFilter = new WCMFilter("", "StyleObjType=? and StyleObjId=?", "");
        wCMFilter.addSearchValues(0, resourceStyle.getWCMType());
        wCMFilter.addSearchValues(1, resourceStyle.getId());
        StyleItems styleItems = StyleItems.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (CMyString.isEmpty(string)) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u98ce\u683c[Id=" + resourceStyle.getId() + "]\u7684styleItem\u7684\u8def\u5f84\u5931\u8d25\uff01");
        }
        for (int i = 0; i < styleItems.size(); ++i) {
            String string2;
            String string3;
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null || !this.isImageStyleItem(styleItem) || CMyString.isEmpty(string3 = styleItem.getClassValue()) || CMyString.isEmpty(string2 = this.calculteStyleItemImage(string, string3)) || !CMyFile.fileExists(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String calculteStyleItemImage(String string, String string2) {
        if (CMyString.isEmpty(string) || CMyString.isEmpty(string2)) {
            return null;
        }
        string2 = string2.replace('\\', File.separatorChar);
        string2 = string2.replace('/', File.separatorChar);
        String string3 = CMyFile.extractFileName(string2);
        String string4 = CMyFile.extractFilePath(string2);
        int n = (string4 = string4.substring(0, string4.length() - 1)).lastIndexOf(File.separatorChar);
        if (n < 0 || n + 1 >= string2.length()) {
            return null;
        }
        String string5 = string4.substring(n + 1);
        return CMyString.setStrEndWith(string, File.separatorChar) + string5 + File.separatorChar + string3;
    }

    private boolean isImageStyleItem(StyleItem styleItem) {
        if (styleItem == null) {
            return false;
        }
        for (int i = 0; i < this.m_aImageClassNameStyleItems.length; ++i) {
            if (!this.m_aImageClassNameStyleItems[i].equalsIgnoreCase(styleItem.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void setXMLEncoding(String string) {
        this.m_sXMLEncoding = string;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public static void main(String[] stringArray) throws Exception {
        ContextHelper.initContext(User.findByName("admin"));
        ResourceStyleExporter resourceStyleExporter = new ResourceStyleExporter();
        ResourceStyles resourceStyles = ResourceStyles.findByIds(ContextHelper.getLoginUser(), "20065,20067");
        String string = resourceStyleExporter.export(resourceStyles, 0);
        System.out.println("------------" + string);
    }
}

