/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleImporter;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleImporter;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItemMgr;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PageStyleImporter {
    private static Logger s_logger = Logger.getLogger(PageStyleImporter.class);
    private XmlToObjConverter m_converter = null;
    private final Map m_PageStyleIds = new HashMap();
    private static final String PROPERTY_CRUSER = "CRUSER";
    private static final String PROPERTY_CRTIME = "CRTIME";
    private static final char CHAR_S = 'S';
    private static final String TAG_STYLE_ITEMS = "XWCMSTYLEITEMS";
    private static final String TAG_CONTENT_STYLES = "XWCMCONTENTSTYLES";
    private static final String TAG_RESOURCE_STYLES = "XWCMRESOURCESTYLES";
    private static String m_sUnzipFilePath = "";
    private Reports m_reports;
    private ArrayList m_successReportList;

    public PageStyleImporter() {
        this.m_converter = new XmlToObjConverter(1);
        this.registerConverter();
    }

    public Reports importFromFile(String string, int n, int n2) throws Exception {
        this.checkFile(string);
        String string2 = this.getFullName(string);
        this.m_reports = new Reports("");
        this.m_successReportList = new ArrayList();
        return this.importFromZip(string2, n, n2);
    }

    public String checkPageStyleNameExists(String string) throws Exception {
        this.checkFile(string);
        String string2 = this.getFullName(string);
        String string3 = CMyFile.extractFilePath(string2) + "unzip" + System.currentTimeMillis();
        string3 = CMyString.setStrEndWith(string3, File.separatorChar);
        List list = this.extractXmlFiles(string2, string3);
        StringBuffer stringBuffer = new StringBuffer("\u9875\u9762\u98ce\u683c");
        boolean bl = true;
        String string4 = null;
        for (int i = 0; i < list.size(); ++i) {
            string4 = (String)list.get(i);
            XmlObject[] xmlObjectArray = this.convertXmlFile(string4, null);
            String string5 = this.checkPageStyleNames(xmlObjectArray, string3);
            if (string5 == null) continue;
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string5);
            bl = false;
        }
        if (bl) {
            return null;
        }
        return stringBuffer.append("\u5df2\u7ecf\u5b58\u5728\uff01").toString();
    }

    private String checkPageStyleNames(XmlObject[] xmlObjectArray, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = true;
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            boolean bl2;
            XmlObject xmlObject = xmlObjectArray[i];
            if (xmlObject == null) continue;
            this.validateXmlObject(xmlObject);
            PageStyle pageStyle = (PageStyle)xmlObject.getCurrentObj();
            if (pageStyle == null || !(bl2 = this.existStyleName(pageStyle))) continue;
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append("[ \u540d\u79f0=" + pageStyle.getStyleDesc() + "(" + pageStyle.getStyleName() + ") ]");
            bl = false;
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    private Reports importFromZip(String string, int n, int n2) throws Exception {
        String string2 = CMyFile.extractFilePath(string) + "unzip" + System.currentTimeMillis();
        string2 = CMyString.setStrEndWith(string2, File.separatorChar);
        List list = this.extractXmlFiles(string, string2);
        String string3 = null;
        for (int i = 0; i < list.size(); ++i) {
            string3 = (String)list.get(i);
            XmlObject[] xmlObjectArray = this.convertXmlFile(string3, null);
            this.importPageStyles(xmlObjectArray, string2, n, n2);
        }
        CMyFile.deleteDir(string2);
        this.m_reports.setTitle("\u4eceZip\u6587\u4ef6\u4e2d\u5bfc\u5165\u9875\u9762\u98ce\u683c");
        this.m_reports.setExtraData(this.m_successReportList);
        return this.m_reports;
    }

    private void importPageStyles(XmlObject[] xmlObjectArray, String string, int n, int n2) throws Exception {
        Object object;
        int[] nArray = new int[xmlObjectArray.length];
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            object = this.importOnePageStyle(xmlObjectArray[i], string, n, n2);
            if (object == null) continue;
            nArray[i] = ((BaseObj)object).getId();
        }
        String string2 = StylePathHelper.getStyleCommonDir() + "default";
        if (!CMyFile.fileExists(string2)) {
            CMyFile.makeDir(string2, true);
        }
        object = CMyString.setStrEndWith(string, File.separatorChar) + "default";
        CMyFile.copyFileDir((String)object, string2, false);
        this.m_reports.setResultIds(nArray);
    }

    private BaseObj importOnePageStyle(XmlObject xmlObject, String string, int n, int n2) throws Exception {
        Object object;
        Object object2;
        m_sUnzipFilePath = string;
        if (xmlObject == null) {
            return null;
        }
        this.validateXmlObject(xmlObject);
        PageStyle pageStyle = (PageStyle)xmlObject.getCurrentObj();
        if (pageStyle == null) {
            return null;
        }
        String string2 = pageStyle.getPropertyAsString("PAGESTYLEID");
        boolean bl = false;
        PageStyle pageStyle2 = this.getSameNamePageStyle(pageStyle);
        String string3 = pageStyle.getStyleThumb();
        if (pageStyle2 != null) {
            bl = true;
            switch (n) {
                case 1: {
                    this.deletePageStyleBasicInfos(this.getLoginUser(), pageStyle2);
                    object2 = pageStyle.getAllProperty();
                    ((Hashtable)object2).remove("PAGESTYLEID");
                    ((Hashtable)object2).remove("STYLETHUMB");
                    pageStyle = pageStyle2;
                    pageStyle.setNewProperties((Hashtable)object2);
                    break;
                }
                case 2: {
                    return null;
                }
            }
        } else {
            pageStyle.setNextId();
        }
        pageStyle.setIsPublish(0);
        pageStyle.setProperty(PROPERTY_CRUSER, this.getLoginUser().getName());
        pageStyle.setProperty(PROPERTY_CRTIME, CMyDateTime.now());
        pageStyle.setStyleThumb(string3);
        if (!CMyString.isEmpty(string3) && ((File)(object = new File((String)(object2 = m_sUnzipFilePath + "thumb" + File.separator + string3)))).exists()) {
            String string4 = this.copyFileIfNeed((String)object2, true);
            pageStyle.setStyleThumb(string4);
        }
        object2 = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
        object2.save(this.getLoginUser(), pageStyle);
        if (pageStyle == null) {
            throw new WCMException("\u5bfc\u5165PageStyle\u5bf9\u8c61\u5931\u8d25\uff01");
        }
        this.m_PageStyleIds.put(this.makePageStyleIdMapKey(368170809, string2), new Integer(pageStyle.getId()));
        this.importStyleItems(xmlObject.getChild(TAG_STYLE_ITEMS), this.m_PageStyleIds, n, bl);
        this.importPageResourceStyles(xmlObject.getChild(TAG_RESOURCE_STYLES), pageStyle.getId(), n2);
        this.importPageContentStyles(xmlObject.getChild(TAG_CONTENT_STYLES), pageStyle.getId(), n2);
        this.copyThumbCustomFiles(pageStyle, string);
        object = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
        object.createStyleFile(this.getLoginUser(), pageStyle);
        this.m_successReportList.add("[ \u540d\u79f0=" + pageStyle.getStyleDesc() + "(" + pageStyle.getStyleName() + ") ]");
        return pageStyle;
    }

    private void validateXmlObject(XmlObject xmlObject) throws WCMException {
        BaseObj baseObj = xmlObject.getCurrentObj();
        if (baseObj == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684\u9875\u9762\u98ce\u683c\u63cf\u8ff0xml\u6587\u4ef6.");
        }
        if (!(baseObj instanceof PageStyle)) {
            throw new WCMException("\u5bf9\u8c61\u4e0d\u662f[currObj" + baseObj.getClass().getName() + "]\u4e0d\u662fPageStyle\u5bf9\u8c61\u7c7b\u578b\uff01");
        }
    }

    private void importPageResourceStyles(XmlObject[] xmlObjectArray, int n, int n2) throws WCMException {
        if (xmlObjectArray == null || n == 0) {
            return;
        }
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            ResourceStyle resourceStyle;
            XmlObject xmlObject = xmlObjectArray[i];
            if (xmlObject == null || (resourceStyle = (ResourceStyle)xmlObject.getCurrentObj()) == null) continue;
            ResourceStyleImporter resourceStyleImporter = (ResourceStyleImporter)DreamFactory.createObjectById("ResourceStyleImporter");
            try {
                resourceStyleImporter.importResourceStyleToPageStyle(resourceStyle, xmlObject.getChild(TAG_STYLE_ITEMS), n2, m_sUnzipFilePath, n);
                continue;
            }
            catch (Throwable throwable) {
                String string = "\u5bfc\u5165ResourceStyle\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25";
                s_logger.debug((Object)string, throwable);
                this.m_reports.addWarnedReport(string, throwable);
            }
        }
    }

    private void importPageContentStyles(XmlObject[] xmlObjectArray, int n, int n2) throws WCMException {
        if (xmlObjectArray == null || n == 0) {
            return;
        }
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            ContentStyle contentStyle;
            XmlObject xmlObject = xmlObjectArray[i];
            if (xmlObject == null || (contentStyle = (ContentStyle)xmlObject.getCurrentObj()) == null) continue;
            ContentStyleImporter contentStyleImporter = (ContentStyleImporter)DreamFactory.createObjectById("ContentStyleImporter");
            try {
                contentStyleImporter.importContentStyleToPageStyle(contentStyle, xmlObject.getChild(TAG_STYLE_ITEMS), n2, m_sUnzipFilePath, n);
                continue;
            }
            catch (Throwable throwable) {
                String string = "\u5bfc\u5165ContentStyle\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25";
                s_logger.debug((Object)string, throwable);
                this.m_reports.addWarnedReport(string, throwable);
            }
        }
    }

    private void importStyleItems(XmlObject[] xmlObjectArray, Map map, int n, boolean bl) throws WCMException {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importOneStyleItem(xmlObjectArray[i], map, n, bl);
        }
    }

    private void importOneStyleItem(XmlObject xmlObject, Map map, int n, boolean bl) throws WCMException {
        if (xmlObject == null) {
            return;
        }
        if (map == null) {
            throw new WCMException("\u4f20\u5165\u7684ids\u6620\u5c04\u5173\u7cfbmap\u4e3anull\uff01");
        }
        if (bl && n == 2) {
            return;
        }
        StyleItem styleItem = null;
        int n2 = 0;
        try {
            styleItem = (StyleItem)xmlObject.getCurrentObj();
            n2 = styleItem.getPropertyAsInt("STYLEITEMID", 0);
            int n3 = styleItem.getStyleObjType();
            int n4 = styleItem.getStyleObjId();
            String string = this.makePageStyleIdMapKey(n3, String.valueOf(n4));
            Integer n5 = (Integer)map.get(string);
            if (n5 == null) {
                throw new WCMException("Map\u4e2d[key=" + string + "]\u5bf9\u5e94\u7684\u98ce\u683cid\u4e0d\u5b58\u5728\uff01");
            }
            styleItem.setStyleObjId(n5);
            styleItem.setNextId();
            styleItem.removeProperty(PROPERTY_CRTIME);
            styleItem.removeProperty(PROPERTY_CRUSER);
            styleItem.save(this.getLoginUser());
        }
        catch (Throwable throwable) {
            String string = "\u5bfc\u5165StyleItem\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25";
            if (styleItem != null) {
                string = string + "[\u6e90Id=" + n2 + "]\uff01";
            }
            s_logger.debug((Object)string, throwable);
            this.m_reports.addWarnedReport(string, throwable);
        }
    }

    private PageStyles querySameNamePageStyles(PageStyle pageStyle) throws WCMException {
        WCMFilter wCMFilter;
        if (pageStyle == null) {
            return null;
        }
        IPageStyleMgr iPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
        PageStyles pageStyles = iPageStyleMgr.query(wCMFilter = new WCMFilter("", "StyleName='" + pageStyle.getStyleName() + "'", "", "PageStyleId"));
        if (pageStyles.isEmpty()) {
            return null;
        }
        return pageStyles;
    }

    private PageStyle getSameNamePageStyle(PageStyle pageStyle) throws WCMException {
        PageStyles pageStyles = this.querySameNamePageStyles(pageStyle);
        if (pageStyles == null || pageStyles.size() == 0) {
            return null;
        }
        return (PageStyle)pageStyles.getAt(0);
    }

    private boolean existStyleName(PageStyle pageStyle) throws WCMException {
        PageStyles pageStyles = this.querySameNamePageStyles(pageStyle);
        return pageStyles != null && pageStyles.size() > 0;
    }

    private String getFullName(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(string)) {
            String string2 = filesMan.mapFilePath(string, 0);
            string = string2 + string;
        }
        return string;
    }

    private XmlObject[] convertXmlFile(String string, String string2) throws WCMException {
        try {
            XmlObject[] xmlObjectArray = this.m_converter.convertXml(string, string2, null);
            return xmlObjectArray;
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)"failed to convert xml to object!", throwable);
            throw new WCMException("\u8f6c\u6362XML\u6587\u4ef6\u5931\u8d25!\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u9875\u9762\u98ce\u683c\u63cf\u8ff0xml\u6587\u4ef6", throwable);
        }
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("XWCMPAGESTYLE", PageStyle.class);
        this.m_converter.registPersistentObj("XWCMRESOURCESTYLE", ResourceStyle.class);
        this.m_converter.registPersistentObj("XWCMCONTENTSTYLE", ContentStyle.class);
        this.m_converter.registPersistentObj("XWCMSTYLEITEM", StyleItem.class);
    }

    private String makePageStyleIdMapKey(int n, String string) {
        return n + ":" + string;
    }

    private void copyThumbCustomFiles(PageStyle pageStyle, String string) throws Exception {
        if (pageStyle == null || string == null || "".equals(string)) {
            return;
        }
        string = CMyString.setStrEndWith(string, File.separatorChar);
        String string2 = string + pageStyle.getStyleName();
        string2 = CMyString.setStrEndWith(string2, File.separatorChar);
        String string3 = StylePathHelper.getStyleCommonDir();
        string3 = CMyString.setStrEndWith(string3, File.separatorChar);
        CMyFile.copyFileDir(string2, string3, true);
    }

    private void checkFile(String string) throws WCMException {
        if (string == null || string.length() == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u6587\u4ef6\u540d\u65e0\u6548\uff01");
        }
        String string2 = CMyFile.extractFileExt(string);
        if (!"zip".equalsIgnoreCase(string2)) {
            throw new WCMException("\u53ea\u652f\u6301\u4eceZIP\u6587\u4ef6\u4e2d\u5bfc\u5165!");
        }
    }

    private List extractXmlFiles(String string, String string2) throws WCMException {
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, string2);
        cMyUnZipFile.addFileExtFilters("xml");
        try {
            cMyUnZipFile.doUnZipAnd();
        }
        catch (CMyException cMyException) {
            s_logger.error((Object)"failed to unzip the file!", (Throwable)cMyException);
            throw new WCMException(200, "\u89e3\u538b\u7f29\u6587\u4ef6[" + string + "]\u5931\u8d25!", cMyException);
        }
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        if (arrayList == null) {
            throw new WCMException(10, "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u9875\u9762\u98ce\u683c\u4fe1\u606f\u7684xml\u6587\u4ef6!");
        }
        return arrayList;
    }

    private void deletePageStyleBasicInfos(User user, PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            return;
        }
        StyleItemMgr styleItemMgr = (StyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
        styleItemMgr.delete(user, pageStyle);
    }

    private String copyFileIfNeed(String string, boolean bl) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!bl) {
            String string2 = filesMan.getFileFlag(string);
            String string3 = string;
            if (string2 != "W0") {
                string3 = filesMan.copyWCMFile(string, "W0");
            }
            return string3;
        }
        return CMyFile.extractFileName(filesMan.copyFile(string, "W0", true));
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

