/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IMasterMgr;
import com.trs.components.common.publish.widget.IMasterServiceProvider;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.Masters;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;

public class MasterServiceProvider
implements IMasterServiceProvider {
    private IMasterMgr m_oMasterMgr = (IMasterMgr)DreamFactory.createObjectById("IMasterMgr");

    public String export(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        if (CMyString.isEmpty(string)) {
            throw new WCMException(I18NMessage.get(MasterServiceProvider.class, "MasterServiceProvider.label1", "\u8981\u5bfc\u51fa\u7684\u6bcd\u677f\u7684Id\u4e3a\u7a7a"));
        }
        Masters masters = Masters.findByIds(user, string);
        int n = masters.size();
        for (int i = 0; i < n; ++i) {
            Master master = (Master)masters.getAt(i);
            if (master == null || SpecialAuthServer.hasRight(user, master, 24)) continue;
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u6bcd\u677f\u3010" + master.getMName() + "\u3011");
        }
        String string2 = this.m_oMasterMgr.export(masters);
        return string2;
    }

    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        Master master = null;
        if (n == 0) {
            master = new Master();
        } else {
            master = Master.findById(n);
            if (master == null) {
                throw new WCMException(CMyString.format(I18NMessage.get(MasterServiceProvider.class, "MasterServiceProvider.label2", "\u6307\u5b9aId\u4e3a[{0}]\u7684\u6bcd\u677f\u4e0d\u5b58\u5728"), new int[]{n}));
            }
        }
        if (master.isAddMode()) {
            if (!SpecialAuthServer.hasRight(user, master, 21)) {
                throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u6bcd\u677f");
            }
        } else if (!SpecialAuthServer.hasRight(user, master, 22)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u6bcd\u677f\u3010" + master.getMName() + "\u3011");
        }
        String[] stringArray = new String[]{"ObjectId"};
        master = (Master)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, master, stringArray);
        Master master2 = this.m_oMasterMgr.save(user, master);
        return master2.getId();
    }

    public Master save(String string, String string2) throws WCMException {
        User user = this.getLoginUser();
        String string3 = CMyFile.extractFileName(string2);
        String string4 = this.validateMasterFile(string3);
        if (string4 != null) {
            throw new WCMException(string4);
        }
        Master master = this.m_oMasterMgr.save(user, string, string2);
        return master;
    }

    public String validateMasterFile(MethodContext methodContext) throws Exception {
        String string = methodContext.getValue("FileName");
        String string2 = this.validateMasterFile(string);
        return string2;
    }

    public String validateMasterFile(String string) throws WCMException {
        String string2 = CMyFile.extractFileName(string);
        String string3 = this.m_oMasterMgr.validateMasterFile(string2);
        return string3;
    }

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        Masters masters = Masters.findByIds(user, string);
        int n = masters.size();
        for (int i = 0; i < n; ++i) {
            Master master = (Master)masters.getAt(i);
            if (master == null || SpecialAuthServer.hasRight(user, master, 23)) continue;
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u6bcd\u677f\u3010" + master.getMName() + "\u3011");
        }
        this.m_oMasterMgr.delete(user, masters);
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        Masters masters = this.m_oMasterMgr.query(user, wCMFilter);
        for (int i = masters.size() - 1; i >= 0; --i) {
            Master master = (Master)masters.getAt(i);
            if (master == null || SpecialAuthServer.hasRight(user, master, 24)) continue;
            masters.remove(master, false);
        }
        return masters;
    }

    public Object queryMasterByContentType(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("MasterFileType", 0);
        if (n == 0) {
            throw new WCMException("\u60a8\u5fc5\u4f20\u5165\u6bcd\u7248\u7684\u6587\u4ef6\u7c7b\u578b\u53c2\u6570\uff01");
        }
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        Masters masters = this.m_oMasterMgr.query(user, wCMFilter);
        for (int i = masters.size() - 1; i >= 0; --i) {
            String string;
            Master master = (Master)masters.getAt(i);
            if (master == null || !CMyString.isEmpty(string = this.m_oMasterMgr.getMasterFileContent(master, n))) continue;
            masters.removeAt(i, false);
        }
        return masters;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        return Master.findById(n);
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        String string = methodContext.getObjectIds();
        return Masters.findByIds(this.getLoginUser(), string);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public String importMasters(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        if (!SpecialAuthServer.hasRight(user, Master.createNewInstance(), 21)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u65b0\u5efa\u6bcd\u677f\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u5bfc\u5165\u6bcd\u677f");
        }
        String string = methodContext.getValue("FileName");
        int n = methodContext.getValue("ImportMode", 1);
        Reports reports = this.m_oMasterMgr.importMasters(user, string, n);
        return reports.toJSONXML();
    }

    public boolean existsMName(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        String string = methodContext.getValue("MNAME");
        return this.m_oMasterMgr.existsMName(n, string);
    }
}

