/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IMasterMgr;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.Masters;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.ObjToXmlConverterByDOM4j;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.Reports;
import com.trs.infra.util.jazzlib.ZipEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MasterMgr
implements IMasterMgr {
    private static Logger s_logger = Logger.getLogger(MasterMgr.class);
    private static XmlToObjConverter m_converter = new XmlToObjConverter(1);
    private Reports m_importReports;

    private void registerConverter() {
        m_converter.registPersistentObj("XWCMMASTER", Master.class);
    }

    public Master save(User user, String string, String string2) throws WCMException {
        Master master;
        WCMFilter wCMFilter = new WCMFilter("", "MName=?", "", "");
        wCMFilter.addSearchValues(string);
        Masters masters = Masters.openWCMObjs(user, wCMFilter);
        if (masters.isEmpty()) {
            master = Master.createNewInstance();
        } else {
            master = (Master)masters.getAt(0);
            if (master == null) {
                master = Master.createNewInstance();
            }
        }
        String string3 = this.validateMasterFile(string2);
        if (!CMyString.isEmpty(string3)) {
            throw new WCMException(string3);
        }
        String string4 = this.copyFileIfNeed(string2, false);
        if (master.isAddMode()) {
            master.setMName(string);
            String string5 = master.getPicFileName();
            if (CMyString.isEmpty(string5)) {
                master.setPicFileName("0");
            } else {
                master.setPicFileName(this.copyFileIfNeed(string5, false));
            }
        }
        master.setFileName(string4);
        master.save(user);
        return master;
    }

    private String copyFileIfNeed(String string, boolean bl) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!bl) {
            String string2 = filesMan.getFileFlag(string);
            String string3 = string;
            if (string2 != "W0") {
                string3 = filesMan.copyWCMFile(string, "W0");
            }
            return string3;
        }
        return CMyFile.extractFileName(filesMan.copyFile(string, "W0", true));
    }

    public Master save(User user, Master master) throws WCMException {
        if (master == null) {
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label1", "\u9700\u8981\u4fdd\u5b58\u7684\u6bcd\u677f\u4e3a\u7a7a\uff01"));
        }
        String string = master.getFinalPropertyAsString("FILENAME");
        String string2 = this.validateMasterFile(string, master.getMasterType());
        if (!CMyString.isEmpty(string2)) {
            throw new WCMException(string2);
        }
        String string3 = this.copyFileIfNeed(string, false);
        if (master.isAddMode()) {
            String string4 = master.getPicFileName();
            if (!CMyString.isEmpty(string4)) {
                master.setPicFileName(this.copyFileIfNeed(string4, false));
            } else {
                master.setPicFileName("0");
            }
        } else if (master.isChangeProperty("PicFileName")) {
            String string5 = (String)master.getNewProperty("PicFileName");
            if (CMyString.isEmpty(string5)) {
                master.setPicFileName("0");
            } else {
                master.setPicFileName(this.copyFileIfNeed(string5, false));
            }
        }
        master.setFileName(string3);
        master.save(user);
        return master;
    }

    public boolean delete(User user, Masters masters) throws WCMException {
        if (masters == null) {
            return true;
        }
        for (int i = 0; i < masters.size(); ++i) {
            Master master = (Master)masters.getAt(i);
            if (master == null) continue;
            String string = master.getFileName();
            master.delete(user);
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = filesMan.mapFilePath(string, 0);
            CMyFile.deleteFile(string2 + string);
            String string3 = master.getPicFileName();
            if (CMyString.isEmpty(string3) || string3.equals("0")) continue;
            CMyFile.deleteFile(filesMan.mapFilePath(string3, 0) + string3);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String export(Masters var1_1) throws WCMException {
        if (var1_1 == null) {
            return null;
        }
        var3_2 = FilesMan.getFilesMan();
        var4_3 = var3_2.getNextFilePathName("ST", "zip");
        var5_4 = new CMyZip();
        try {
            var5_4.setZipFileName(var4_3);
        }
        catch (CMyException var6_5) {
            throw new WCMException("\u521b\u5efazip\u6587\u4ef6\u5931\u8d25", var6_5);
        }
        var6_6 = "";
        var7_7 = new ObjToXmlConverterByDOM4j();
        for (var8_8 = 0; var8_8 < var1_1.size(); ++var8_8) {
            var2_10 = (Master)var1_1.getAt(var8_8);
            if (var2_10 == null) continue;
            try {
                block14: {
                    var6_6 = var3_2.getNextFileName("ST", "xml", null, true);
                    var7_7.toXMLFile(var2_10, var6_6);
                    var5_4.addToZip(var6_6, false);
                    var9_11 = var2_10.getFileName();
                    var10_13 = var3_2.mapFilePath(var9_11, 0);
                    var5_4.addToZip(var10_13 + var9_11, false);
                    var11_14 = var2_10.getPicFileName();
                    if (CMyString.isEmpty(var11_14) || var11_14.equals("0")) ** GOTO lbl53
                    if (CMyFile.fileExists(var11_14 = var3_2.mapFilePath(var11_14, 0) + var11_14)) break block14;
                    MasterMgr.s_logger.info((Object)("\u627e\u4e0d\u5230\u6bcd\u677f\u7f29\u7565\u56fe\uff1a" + var11_14));
                    var13_15 = null;
                    ** GOTO lbl46
                }
                var5_4.addToZip(var11_14, false);
                ** GOTO lbl53
            }
            catch (CMyException var9_12) {
                throw new WCMException("\u6dfb\u52a0\u6bcd\u677f\u76f8\u5173\u8d44\u6e90\u5230zip\u6587\u4ef6\u5931\u8d25", var9_12);
            }
            {
                catch (Throwable var12_17) {
                    var13_15 = null;
                    try {
                        var3_2.deleteFile(var6_6);
                        throw var12_17;
                    }
                    catch (Exception var14_16) {
                        MasterMgr.s_logger.error((Object)"\u5220\u9664\u539f\u6bcd\u677f\u7f29\u7565\u56fe\u65f6\u51fa\u9519", (Throwable)var14_16);
                    }
                    throw var12_17;
                }
lbl46:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [6 : 293->303)] { 
lbl47:
                // 1 sources

                var3_2.deleteFile(var6_6);
                continue;
lbl50:
                // 1 sources

                catch (Exception var14_16) {
                    MasterMgr.s_logger.error((Object)"\u5220\u9664\u539f\u6bcd\u677f\u7f29\u7565\u56fe\u65f6\u51fa\u9519", (Throwable)var14_16);
                }
                continue;
lbl53:
                // 2 sources

                var13_15 = null;
                try {}
                catch (Exception var14_16) {}
                MasterMgr.s_logger.error((Object)"\u5220\u9664\u539f\u6bcd\u677f\u7f29\u7565\u56fe\u65f6\u51fa\u9519", (Throwable)var14_16);
                continue;
                var3_2.deleteFile(var6_6);
                continue;
            }
        }
        try {
            var8_8 = (int)var5_4.done();
            if (var8_8 == 0) return null;
            return CMyFile.extractFileName(var4_3);
        }
        catch (CMyException var8_9) {
            throw new WCMException("\u5bfc\u51fa\u6bcd\u677f\u65f6\u51fa\u73b0\u9519\u8bef", var8_9);
        }
    }

    public Reports importMasters(User user, String string) throws WCMException {
        this.m_importReports = new Reports("");
        if (CMyString.isEmpty(string)) {
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label3", "\u6307\u5b9a\u6587\u4ef6\u540d\u4e3a\u7a7a"));
        }
        String string2 = CMyFile.extractFileExt(string);
        if (!string2.equalsIgnoreCase("zip")) {
            throw new WCMException(1200, I18NMessage.get(MasterMgr.class, "MasterMgr.label4", "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u662fzip\u6587\u4ef6"));
        }
        String string3 = this.getFullFileName(string);
        String string4 = CMyFile.extractFilePath(string3);
        string4 = string4 + CMyFile.extractMainFileName(string3) + File.separator;
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string3, string4);
        try {
            cMyUnZipFile.addFileExtFilters("xml");
            cMyUnZipFile.doUnZipAnd();
        }
        catch (Exception exception) {
            throw new WCMException("\u89e3\u538b\u6587\u4ef6\u5931\u8d25", exception);
        }
        this.registerConverter();
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        if (arrayList == null) {
            throw new WCMException(10, "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u6bcd\u677f\u4fe1\u606f\u7684xml\u6587\u4ef6.");
        }
        String string5 = null;
        XmlObject[] xmlObjectArray = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            string5 = (String)arrayList.get(i);
            xmlObjectArray = m_converter.convertXml(string5, null, null);
            this.importMasters(xmlObjectArray, string4, 3);
        }
        CMyFile.deleteDir(string4);
        this.m_importReports.setTitle("\u5bfc\u5165\u6bcd\u677f\u6587\u4ef6");
        return this.m_importReports;
    }

    public Reports importMasters(User user, String string, int n) throws WCMException {
        this.m_importReports = new Reports("");
        if (CMyString.isEmpty(string)) {
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label3", "\u6307\u5b9a\u6587\u4ef6\u540d\u4e3a\u7a7a"));
        }
        String string2 = CMyFile.extractFileExt(string);
        if (!string2.equalsIgnoreCase("zip")) {
            throw new WCMException(1200, I18NMessage.get(MasterMgr.class, "MasterMgr.label4", "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u662fzip\u6587\u4ef6"));
        }
        String string3 = this.getFullFileName(string);
        String string4 = CMyFile.extractFilePath(string3);
        string4 = string4 + CMyFile.extractMainFileName(string3) + File.separator;
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string3, string4);
        try {
            cMyUnZipFile.addFileExtFilters("xml");
            cMyUnZipFile.doUnZipAnd();
        }
        catch (Exception exception) {
            throw new WCMException("\u89e3\u538b\u6587\u4ef6\u5931\u8d25", exception);
        }
        this.registerConverter();
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        if (arrayList == null) {
            throw new WCMException(10, "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u6bcd\u677f\u4fe1\u606f\u7684xml\u6587\u4ef6.");
        }
        String string5 = null;
        XmlObject[] xmlObjectArray = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            string5 = (String)arrayList.get(i);
            xmlObjectArray = m_converter.convertXml(string5, null, null);
            this.importMasters(xmlObjectArray, string4, n);
        }
        CMyFile.deleteDir(string4);
        this.m_importReports.setTitle("\u5bfc\u5165\u6bcd\u677f\u6587\u4ef6");
        return this.m_importReports;
    }

    private void importMasters(XmlObject[] xmlObjectArray, String string, int n) throws WCMException {
        int[] nArray = new int[xmlObjectArray.length];
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            Master master = this.importMaster(xmlObjectArray[i], string, n);
            if (master == null) continue;
            nArray[i] = master.getId();
        }
        this.m_importReports.setResultIds(nArray);
    }

    private Master importMaster(XmlObject xmlObject, String string, int n) throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (xmlObject == null) {
            throw new WCMException(20, "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e\uff0cxml\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6bcd\u677f\u63cf\u8ff0\u6587\u4ef6");
        }
        BaseObj baseObj = xmlObject.getCurrentObj();
        try {
            Master master = (Master)baseObj;
            master.setNextId();
            String string2 = master.getMName();
            if (this.existsMName(master.getId(), string2)) {
                switch (n) {
                    case 1: {
                        this.masterFileHandler(master, string);
                        this.masterPicFileHandler(master, string);
                        Master master2 = this.findMasterByName(user, string2);
                        int n2 = master2.getId();
                        master2.setNewProperties(master.getAllProperty());
                        master2.setId(n2);
                        master2.setProperty("CRUSER", user.getName());
                        master2.setProperty("CRTIME", CMyDateTime.now());
                        master2.save(user);
                        this.m_importReports.addSucessedReport("\u5bfc\u5165\u6bcd\u677f\u3010" + string2 + "\u3011\u6210\u529f.");
                        return master2;
                    }
                    case 3: {
                        this.changeMasterName(master);
                        break;
                    }
                    case 2: {
                        WCMException wCMException = new WCMException("\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[" + string2 + "]\u7684\u6bcd\u677f,\u5ffd\u7565\u8be5\u5bfc\u5165");
                        this.m_importReports.addFailedReport("\u5df2\u5b58\u5728\u540c\u540d\u7684\u6bcd\u677f\uff0c\u60a8\u9009\u62e9\u4e86\u5ffd\u7565\u5904\u7406\uff0c\u6240\u4ee5\u5ffd\u7565\u6bcd\u677f[" + string2 + "]\u7684\u5bfc\u5165", wCMException);
                        return null;
                    }
                }
            }
            this.masterFileHandler(master, string);
            this.masterPicFileHandler(master, string);
            master.setCrUser(user);
            master.setProperty("CRTIME", CMyDateTime.now());
            master.save(user);
            this.m_importReports.addSucessedReport("\u5bfc\u5165\u6bcd\u677f\u3010" + master.getMName() + "\u3011\u6210\u529f.");
            return master;
        }
        catch (Exception exception) {
            this.m_importReports.addFailedReport("\u5bfc\u5165\u6bcd\u677f\u5931\u8d25", exception);
            return null;
        }
    }

    private void masterFileHandler(Master master, String string) throws WCMException {
        String string2 = this.copyFileIfNeed(string + master.getFileName(), true);
        String string3 = this.validateMasterFile(string2, master.getMasterType());
        if (string3 != null) {
            throw new WCMException(string3);
        }
        master.setFileName(string2);
    }

    private void masterPicFileHandler(Master master, String string) throws WCMException {
        String string2 = master.getPicFileName();
        if (!CMyString.isEmpty(string2)) {
            if (!string2.equals("0")) {
                master.setPicFileName(this.copyFileIfNeed(string + string2, true));
            }
        } else {
            master.setPicFileName("0");
        }
    }

    private void changeMasterName(Master master) throws WCMException {
        String string = master.getMName();
        int n = master.getId();
        try {
            if (!this.existsMName(n, string)) {
                return;
            }
            String string2 = string = string.replaceAll("(_\\d+)+", "");
            int n2 = n;
            while (this.existsMName(n, string2)) {
                string2 = string + "_" + n2;
                ++n2;
            }
            master.setMName(string2);
        }
        catch (Exception exception) {
            throw new WCMException("\u6821\u9a8c\u6bcd\u677f\u91cd\u540d\u65f6\u51fa\u9519", exception);
        }
    }

    public boolean existsMName(int n, String string) throws Exception {
        WCMFilter wCMFilter = new WCMFilter("XWCMMASTER", "MasterId!=? and MName=?", "", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        return DBManager.getDBManager().sqlExecuteCountQuery(wCMFilter) > 0;
    }

    public Masters query(User user, WCMFilter wCMFilter) throws WCMException {
        return Masters.openWCMObjs(user, wCMFilter);
    }

    public String validateMasterFile(String string) throws WCMException {
        String string2 = I18NMessage.get(MasterMgr.class, "MasterMgr.label6", "\u6bcd\u677f\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c");
        if (CMyString.isEmpty(string)) {
            return string2 + I18NMessage.get(MasterMgr.class, "MasterMgr.label3", "\u6307\u5b9a\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a");
        }
        String string3 = CMyFile.extractFileExt(string);
        if (!string3.equalsIgnoreCase("zip")) {
            return string2 + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label8", "\u6307\u5b9a\u7684\u6587\u4ef6[{0}]\u4e0d\u662fzip\u6587\u4ef6"), new String[]{string});
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string4 = filesMan.mapFilePath(string, 0);
        if (!CMyFile.fileExists(string4 + string)) {
            return string2 + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label9", "\u6307\u5b9a\u7684\u6587\u4ef6[{0}]\u4e0d\u5b58\u5728"), new String[]{string});
        }
        CMyUnzip cMyUnzip = new CMyUnzip();
        String string5 = filesMan.mapFilePath(string, 0) + "unZip" + CMyFile.extractMainFileName(string) + "\\";
        try {
            Object object;
            cMyUnzip.setZipFile(string4 + string);
            Enumeration enumeration = cMyUnzip.getItems();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                object = (ZipEntry)enumeration.nextElement();
                if (!((ZipEntry)object).getName().equalsIgnoreCase("index.html")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return string2 + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label10", "[{0}]\u4e2d\u6ca1\u6709\u5305\u542b\u6307\u5b9a\u6587\u4ef6index.html"), new String[]{string});
            }
            cMyUnzip.unzip(string5, true);
            object = this.checkFile(string5, "index.html");
            if (!CMyString.isEmpty((String)object)) {
                return string2 + (String)object;
            }
            ZipEntry zipEntry = cMyUnzip.getItem("detail.html");
            if (zipEntry != null && !CMyString.isEmpty((String)(object = this.checkFile(string5, "detail.html")))) {
                return string2 + (String)object;
            }
            zipEntry = cMyUnzip.getItem("outline.html");
            if (zipEntry != null && !CMyString.isEmpty((String)(object = this.checkFile(string5, "outline.html")))) {
                return string2 + (String)object;
            }
            CMyFile.deleteDir(string5);
        }
        catch (Throwable throwable) {
            CMyFile.deleteDir(string5);
            return I18NMessage.get(MasterMgr.class, "MasterMgr.label7", "\u6821\u9a8c\u6bcd\u677f\u65f6\u51fa\u9519") + CMyException.getStackTraceText(throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String validateMasterFile(String string, int n) throws WCMException {
        String string2;
        String string3;
        block23: {
            String string4 = I18NMessage.get(MasterMgr.class, "MasterMgr.label6", "\u6bcd\u677f\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c");
            if (CMyString.isEmpty(string)) {
                return string4 + I18NMessage.get(MasterMgr.class, "MasterMgr.label3", "\u6307\u5b9a\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a");
            }
            String string5 = CMyFile.extractFileExt(string);
            if (!string5.equalsIgnoreCase("zip")) {
                return string4 + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label8", "\u6307\u5b9a\u7684\u6587\u4ef6[{0}]\u4e0d\u662fzip\u6587\u4ef6"), new String[]{string});
            }
            FilesMan filesMan = FilesMan.getFilesMan();
            String string6 = filesMan.mapFilePath(string, 0);
            if (!CMyFile.fileExists(string6 + string)) {
                return string4 + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label9", "\u6307\u5b9a\u7684\u6587\u4ef6[{0}]\u4e0d\u5b58\u5728"), new String[]{string});
            }
            CMyUnzip cMyUnzip = new CMyUnzip();
            string3 = filesMan.mapFilePath(string, 0) + "unZip" + CMyFile.extractMainFileName(string) + "\\";
            try {
                block24: {
                    String string7;
                    try {
                        Object object;
                        cMyUnzip.setZipFile(string6 + string);
                        Enumeration enumeration = cMyUnzip.getItems();
                        boolean bl = false;
                        int n2 = 0;
                        String string8 = null;
                        if (n == 1) {
                            while (enumeration.hasMoreElements()) {
                                object = (ZipEntry)enumeration.nextElement();
                                if (((ZipEntry)object).getName().equalsIgnoreCase("index.html")) {
                                    bl = true;
                                    break;
                                }
                                if (((ZipEntry)object).getName().indexOf(".html") == -1) continue;
                                ++n2;
                                string8 = ((ZipEntry)object).getName();
                            }
                        } else {
                            if (n != 2) {
                                string2 = this.validateMasterFile(string);
                                Object var16_17 = null;
                                break block23;
                            }
                            while (enumeration.hasMoreElements()) {
                                object = (ZipEntry)enumeration.nextElement();
                                if (((ZipEntry)object).getName().equalsIgnoreCase("detail.html")) {
                                    bl = true;
                                    break;
                                }
                                if (((ZipEntry)object).getName().indexOf(".html") == -1) continue;
                                ++n2;
                                string8 = ((ZipEntry)object).getName();
                            }
                        }
                        if (!bl) {
                            if (n2 < 1) {
                                object = string4 + CMyString.format("[{0}\u4e2d\u6ca1\u6709\u5305\u542b\u6bcd\u677fhtml\u6587\u4ef6]", new String[]{string});
                                Object var16_18 = null;
                                CMyFile.deleteDir(string3);
                                return object;
                            }
                            if (n2 > 1) {
                                object = string4 + CMyString.format("[{0}]\u4e2d\u5305\u542b\u591a\u4e2ahtml\u6587\u4ef6\uff0c\u6bcd\u677f\u6587\u4ef6\u540d\u79f0\u5fc5\u987b\u6307\u5b9a\uff1a\u6982\u89c8\u6bcd\u677f\u6587\u4ef6\u540d\u79f0index.html\uff0c\u7ec6\u7f06\u6bcd\u677f\u6587\u4ef6\u540d\u79f0detail.html\uff0c\u6bcd\u677f\u7c7b\u578b\u4e0e\u6587\u4ef6\u540d\u79f0\u9700\u8981\u4e00\u81f4", new String[]{string});
                                Object var16_19 = null;
                                CMyFile.deleteDir(string3);
                                return object;
                            }
                        }
                        cMyUnzip.unzip(string3, true);
                        object = null;
                        if (bl && n == 1) {
                            object = this.checkFile(string3, "index.html");
                        } else if (bl && n == 2) {
                            object = this.checkFile(string3, "detail.html");
                        } else if (!bl && n2 == 1) {
                            object = this.checkFile(string3, string8);
                        }
                        if (CMyString.isEmpty((String)object)) break block24;
                        string7 = string4 + (String)object;
                        Object var16_20 = null;
                    }
                    catch (Throwable throwable) {
                        String string9 = I18NMessage.get(MasterMgr.class, "MasterMgr.label7", "\u6821\u9a8c\u6bcd\u677f\u65f6\u51fa\u9519") + CMyException.getStackTraceText(throwable);
                        Object var16_22 = null;
                        CMyFile.deleteDir(string3);
                        return string9;
                    }
                    CMyFile.deleteDir(string3);
                    return string7;
                }
                Object var16_21 = null;
                CMyFile.deleteDir(string3);
                return null;
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                CMyFile.deleteDir(string3);
                throw throwable;
            }
        }
        CMyFile.deleteDir(string3);
        return string2;
    }

    private String checkFile(String string, String string2) throws Exception {
        String string3 = string + string2;
        if (CMyString.isEmpty(string3)) {
            return "\u6587\u4ef6\u3010" + string3 + "\u3011\u4e0d\u5b58\u5728";
        }
        String string4 = CharsetDetector.detect(string3);
        String string5 = CMyFile.readFile(string3, string4);
        String string6 = "(?is)<html[^>]*>.*<head>.*(?:<TRS_TagCreator\\s*tag\\s*=\\s*(?:'|\")?TRS_Resources(?:'|\")?[^/]*/>|<TRS_TagCreator\\s*tag\\s*=\\s*(?:'|\")?TRS_Resources(?:'|\")?[^>]*>\\s*</TRS_TagCreator>).*</head>.*<body[^>]*>.*</body>.*</html>";
        Matcher matcher = Pattern.compile(string6).matcher(string5);
        boolean bl = matcher.find();
        if (!bl) {
            return "\u6587\u4ef6\u3010" + string2 + "\u3011\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u6ca1\u6709\u5305\u542b\u6b63\u786e\u7684html\u3001head\u3001body\u6807\u7b7e\u6216\u8005\u6ca1\u6709\u5728head\u4e2d\u5305\u542b\u6307\u5b9atag\u7b49\u4e8eTRS_Resources\u7684TRS_TagCreator\u6807\u8bb0";
        }
        return null;
    }

    public String getMasterFileContent(Master master, int n) throws WCMException {
        int n2 = master.getId();
        String string = master.getFileName();
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.mapFilePath(string, 0);
        if (!CMyFile.fileExists(string2 + string)) {
            throw new WCMException(CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label14", "\u6307\u5b9a\u7684\u6bcd\u677f[Id={0}]\u7684\u6bcd\u677f\u6587\u4ef6[{1}]\u4e0d\u5b58\u5728"), new String[]{CMyString.numberToStr(n2), string}));
        }
        String string3 = string2 + "unZip" + CMyFile.extractMainFileName(string) + "\\";
        try {
            CMyUnzip cMyUnzip = new CMyUnzip();
            cMyUnzip.setZipFile(string2 + string);
            cMyUnzip.unzip(string3, true);
            Enumeration enumeration = cMyUnzip.getItems();
            ZipEntry zipEntry = null;
            String string4 = null;
            block1 : switch (n) {
                case 1: 
                case 2: {
                    while (enumeration.hasMoreElements()) {
                        zipEntry = (ZipEntry)enumeration.nextElement();
                        if (zipEntry.getName().toLowerCase().indexOf(".html") == -1) continue;
                        string4 = zipEntry.getName();
                        if (!zipEntry.getName().equalsIgnoreCase("index.html")) continue;
                        break block1;
                    }
                    break;
                }
                case 3: {
                    while (enumeration.hasMoreElements()) {
                        zipEntry = (ZipEntry)enumeration.nextElement();
                        if (zipEntry.getName().toLowerCase().indexOf(".html") == -1) continue;
                        string4 = zipEntry.getName();
                        if (!zipEntry.getName().equalsIgnoreCase("detail.html")) continue;
                        break block1;
                    }
                    break;
                }
            }
            if (string4 == null) {
                CMyFile.deleteDir(string3);
                return null;
            }
            String string5 = string3 + string4;
            String string6 = CharsetDetector.detect(string5);
            String string7 = CMyFile.readFile(string5, string6);
            CMyFile.deleteDir(string3);
            return string7;
        }
        catch (CMyException cMyException) {
            CMyFile.deleteDir(string3);
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label15", "\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25"), cMyException);
        }
    }

    private String getFullFileName(String string) throws WCMException {
        String string2 = string;
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(string)) {
            String string3 = filesMan.mapFilePath(string, 0);
            string2 = string3 + string;
        }
        return string2;
    }

    private Master findMasterByName(User user, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter(null, "MNAME=?", "MASTERID desc");
        wCMFilter.addSearchValues(string);
        Masters masters = Masters.openWCMObjs(user, wCMFilter);
        return masters.size() > 0 ? (Master)masters.getAt(0) : null;
    }
}

